# System.Windows.Forms.Design

``` diff
 namespace System.Windows.Forms.Design {
     [ToolboxItemAttribute(false)]
     public class ComponentEditorForm : Form {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? AutoSizeChanged;
-        protected virtual void OnSelChangeSelector(object source, TreeViewEventArgs e);
+        protected virtual void OnSelChangeSelector(object? source, TreeViewEventArgs e);
-        public virtual DialogResult ShowForm(IWin32Window owner);
+        public virtual DialogResult ShowForm(IWin32Window? owner);
-        public virtual DialogResult ShowForm(IWin32Window owner, int page);
+        public virtual DialogResult ShowForm(IWin32Window? owner, int page);
     }
     public abstract class ComponentEditorPage : Panel {
-        public Icon Icon { get; set; }
+        [AllowNullAttribute]
+        public Icon Icon { get; set; }
     }
     public interface IWindowsFormsEditorService {
-        void DropDownControl(Control control);
+        void DropDownControl(Control? control);
     }
     public abstract class PropertyTab : IExtenderProvider {
-        public virtual PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object component, Attribute[]? attributes);
+        public virtual PropertyDescriptorCollection? GetProperties(ITypeDescriptorContext? context, object component, Attribute[]? attributes);
-        public virtual PropertyDescriptorCollection GetProperties(object component);
+        public virtual PropertyDescriptorCollection? GetProperties(object component);
-        public abstract PropertyDescriptorCollection GetProperties(object component, Attribute[]? attributes);
+        public abstract PropertyDescriptorCollection? GetProperties(object component, Attribute[]? attributes);
     }
     [AttributeUsageAttribute(4)]
     public sealed class ToolStripItemDesignerAvailabilityAttribute : Attribute {
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     public abstract class WindowsFormsComponentEditor : ComponentEditor {
-        public override bool EditComponent(ITypeDescriptorContext context, object component);
+        public override bool EditComponent(ITypeDescriptorContext? context, object component);
-        public virtual bool EditComponent(ITypeDescriptorContext context, object component, IWin32Window owner);
+        public virtual bool EditComponent(ITypeDescriptorContext? context, object component, IWin32Window? owner);
-        public bool EditComponent(object component, IWin32Window owner);
+        public bool EditComponent(object component, IWin32Window? owner);
-        protected virtual Type[] GetComponentEditorPages();
+        protected virtual Type[]? GetComponentEditorPages();
     }
 }
```

