# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     [DefaultEventAttribute("Enter")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.AxHostDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class AxHost : Control, ICustomTypeDescriptor, ISupportInitialize {
-        [EditorBrowsableAttribute(2)]
-        TypeConverter ICustomTypeDescriptor.GetConverter();
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All.")]
+        TypeConverter ICustomTypeDescriptor.GetConverter();
-        [EditorBrowsableAttribute(2)]
-        EventDescriptor ICustomTypeDescriptor.GetDefaultEvent();
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("The built-in EventDescriptor implementation uses Reflection which requires unreferenced code.")]
+        EventDescriptor ICustomTypeDescriptor.GetDefaultEvent();
-        [EditorBrowsableAttribute(2)]
-        PropertyDescriptor ICustomTypeDescriptor.GetDefaultProperty();
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered.")]
+        PropertyDescriptor ICustomTypeDescriptor.GetDefaultProperty();
-        [EditorBrowsableAttribute(2)]
-        object ICustomTypeDescriptor.GetEditor(Type editorBaseType);
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("Editors registered in TypeDescriptor.AddEditorTable may be trimmed.")]
+        object ICustomTypeDescriptor.GetEditor(Type editorBaseType);
-        [EditorBrowsableAttribute(2)]
-        EventDescriptorCollection ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        EventDescriptorCollection ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
-        [EditorBrowsableAttribute(2)]
-        PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties();
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered.")]
+        PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties();
-        [EditorBrowsableAttribute(2)]
-        PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
+        [EditorBrowsableAttribute(2)]
+        [RequiresUnreferencedCodeAttribute("PropertyDescriptor's PropertyType cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
         public class AxComponentEditor : WindowsFormsComponentEditor {
-            public override bool EditComponent(ITypeDescriptorContext context, object obj, IWin32Window parent);
+            public override bool EditComponent(ITypeDescriptorContext? context, object obj, IWin32Window? parent);
         }
         [TypeConverterAttribute(typeof(TypeConverter))]
         public class State : ISerializable {
-            public State(Stream ms, int storageType, bool manualUpdate, string licKey);
+            public State(Stream ms, int storageType, bool manualUpdate, string? licKey);
         }
         public class StateConverter : TypeConverter {
-            public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+            public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
         }
     }
+    [RequiresPreviewFeaturesAttribute]
+    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable {
+        protected BindableComponent();
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("BindingComponentBindingContextDescr")]
+        public BindingContext? BindingContext { get; set; }
+        [DesignerSerializationVisibilityAttribute(2)]
+        [ParenthesizePropertyNameAttribute(true)]
+        [RefreshPropertiesAttribute(1)]
+        public ControlBindingsCollection DataBindings { get; }
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("BindableComponentBindingContextChangedDescr")]
+        public event EventHandler BindingContextChanged;
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnBindingContextChanged(EventArgs e);
+    }
     public abstract class BindingManagerBase {
-        protected EventHandler onCurrentChangedHandler;
+        protected EventHandler? onCurrentChangedHandler;
-        protected EventHandler onPositionChangedHandler;
+        protected EventHandler? onPositionChangedHandler;
-        protected internal virtual PropertyDescriptorCollection GetItemProperties(ArrayList dataSources, ArrayList listAccessors);
+        protected internal virtual PropertyDescriptorCollection? GetItemProperties(ArrayList dataSources, ArrayList listAccessors);
-        protected virtual PropertyDescriptorCollection GetItemProperties(Type listType, int offset, ArrayList dataSources, ArrayList listAccessors);
+        protected virtual PropertyDescriptorCollection? GetItemProperties(Type listType, int offset, ArrayList dataSources, ArrayList listAccessors);
-        protected internal abstract string GetListName(ArrayList listAccessors);
+        protected internal abstract string GetListName(ArrayList? listAccessors);
     }
-    public struct BindingMemberInfo {
+    public struct BindingMemberInfo : IEquatable<BindingMemberInfo> {
+        public bool Equals(BindingMemberInfo other);
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [DefaultEventAttribute("CurrentChanged")]
     [DefaultPropertyAttribute("DataSource")]
     [DesignerAttribute("System.Windows.Forms.Design.BindingSourceDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionBindingSource")]
     public class BindingSource : Component, IBindingList, IBindingListView, ICancelAddNew, ICollection, ICurrencyManagerProvider, IEnumerable, IList, ISupportInitialize, ISupportInitializeNotification, ITypedList {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("BindingSourceFilterDescr")]
-        public virtual string Filter { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("BindingSourceFilterDescr")]
+        public virtual string Filter { get; [RequiresUnreferencedCodeAttribute("Members of types used in the filter expression might be trimmed.")] set; }
     }
     [DesignerAttribute("System.Windows.Forms.Design.ButtonBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionButton")]
     public class Button : ButtonBase, IButtonControl {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        public new event EventHandler? DoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        public new event MouseEventHandler MouseDoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        public new event MouseEventHandler? MouseDoubleClick;
     }
     [DesignerAttribute("System.Windows.Forms.Design.ButtonBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ButtonBase : Control {
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand? Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object? CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ButtonImageDescr")]
-        public Image Image { get; set; }
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ButtonImageDescr")]
+        public Image? Image { get; set; }
-        [DefaultValueAttribute(null)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ButtonImageListDescr")]
-        public ImageList ImageList { get; set; }
+        [DefaultValueAttribute(null)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ButtonImageListDescr")]
+        public ImageList? ImageList { get; set; }
-        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [SettingsBindableAttribute(true)]
-        public override string Text { get; set; }
+        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [SettingsBindableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
+        public new event EventHandler? AutoSizeChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler? CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler? CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler? CommandParameterChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ImeModeChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ImeModeChanged;
+        protected override void OnClick(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     public static class ButtonRenderer {
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, TextFormatFlags flags, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, TextFormatFlags flags, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
     }
     [DefaultBindingPropertyAttribute("CheckState")]
     [DefaultEventAttribute("CheckedChanged")]
     [DefaultPropertyAttribute("Checked")]
     [SRDescriptionAttribute("DescriptionCheckBox")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class CheckBox : ButtonBase {
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("CheckBoxOnAppearanceChangedDescr")]
-        public event EventHandler AppearanceChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("CheckBoxOnAppearanceChangedDescr")]
+        public event EventHandler? AppearanceChanged;
-        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
-        public event EventHandler CheckedChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
+        public event EventHandler? CheckedChanged;
-        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
-        public event EventHandler CheckStateChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
+        public event EventHandler? CheckStateChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseDoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseDoubleClick;
     }
     public static class CheckBoxRenderer {
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, TextFormatFlags flags, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, TextFormatFlags flags, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
     }
     [LookupBindingPropertiesAttribute]
     [SRDescriptionAttribute("DescriptionCheckedListBox")]
     public class CheckedListBox : ListBox {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new object DataSource { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new object? DataSource { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler Click;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? Click;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DataSourceChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DataSourceChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DisplayMemberChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DisplayMemberChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event DrawItemEventHandler DrawItem;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event DrawItemEventHandler? DrawItem;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("CheckedListBoxItemCheckDescr")]
-        public event ItemCheckEventHandler ItemCheck;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("CheckedListBoxItemCheckDescr")]
+        public event ItemCheckEventHandler? ItemCheck;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MeasureItemEventHandler MeasureItem;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MeasureItemEventHandler? MeasureItem;
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event MouseEventHandler MouseClick;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event MouseEventHandler? MouseClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ValueMemberChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ValueMemberChanged;
         public class CheckedIndexCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object index);
+            bool IList.Contains(object? index);
-            int IList.IndexOf(object index);
+            int IList.IndexOf(object? index);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
         public class CheckedItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            [BrowsableAttribute(false)]
-            [DesignerSerializationVisibilityAttribute(0)]
-            public object this[int index] { get; set; }
+            [BrowsableAttribute(false)]
+            [DesignerSerializationVisibilityAttribute(0)]
+            public object? this[int index] { get; set; }
-            public bool Contains(object item);
+            public bool Contains(object? item);
-            public int IndexOf(object item);
+            public int IndexOf(object? item);
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     public static class Clipboard {
-        public static bool ContainsData(string format);
+        public static bool ContainsData(string? format);
-        public static Stream GetAudioStream();
+        public static Stream? GetAudioStream();
-        public static object GetData(string format);
+        public static object? GetData(string format);
-        public static IDataObject GetDataObject();
+        public static IDataObject? GetDataObject();
-        public static Image GetImage();
+        public static Image? GetImage();
     }
     [DefaultPropertyAttribute("Color")]
     [SRDescriptionAttribute("DescriptionColorDialog")]
     public class ColorDialog : CommonDialog {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("CDcustomColorsDescr")]
-        public int[] CustomColors { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("CDcustomColorsDescr")]
+        [AllowNullAttribute]
+        public int[] CustomColors { get; set; }
     }
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     [TypeConverterAttribute(typeof(ColumnHeaderConverter))]
     public class ColumnHeader : Component, ICloneable {
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("ColumnCaption")]
-        public string Text { get; set; }
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("ColumnCaption")]
+        [AllowNullAttribute]
+        public string Text { get; set; }
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ComboBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionComboBox")]
     public class ComboBox : ListControl {
         public class ChildAccessibleObject : AccessibleObject {
-            public override string Name { get; }
+            public override string? Name { get; }
         }
     }
     public static class ComboBoxRenderer {
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, Rectangle textBounds, TextFormatFlags flags, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, Rectangle textBounds, TextFormatFlags flags, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, Rectangle textBounds, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, Rectangle textBounds, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, TextFormatFlags flags, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, TextFormatFlags flags, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, ComboBoxState state);
     }
     public class ContainerControl : ScrollableControl, IContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ContainerControlActiveControlDescr")]
-        public Control ActiveControl { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ContainerControlActiveControlDescr")]
+        public Control? ActiveControl { get; set; }
-        [BrowsableAttribute(false)]
-        [SRDescriptionAttribute("ContainerControlBindingContextDescr")]
-        public override BindingContext BindingContext { get; set; }
+        [BrowsableAttribute(false)]
+        [SRDescriptionAttribute("ContainerControlBindingContextDescr")]
+        public override BindingContext? BindingContext { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ContainerControlParentFormDescr")]
-        public Form ParentForm { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ContainerControlParentFormDescr")]
+        public Form? ParentForm { get; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ContainerControlOnAutoValidateChangedDescr")]
-        public event EventHandler AutoValidateChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ContainerControlOnAutoValidateChangedDescr")]
+        public event EventHandler? AutoValidateChanged;
+        protected override void OnMove(EventArgs e);
+        protected override void OnResize(EventArgs e);
+        protected virtual void ScaleMinMaxSize(float xScaleFactor, float yScaleFactor, bool updateContainerSize = true);
     }
     [DefaultEventAttribute("Opening")]
     [SRDescriptionAttribute("DescriptionContextMenuStrip")]
     public class ContextMenuStrip : ToolStripDropDownMenu {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ContextMenuStripSourceControlDescr")]
-        public Control SourceControl { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ContextMenuStripSourceControlDescr")]
+        public Control? SourceControl { get; }
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
-        [AmbientValueAttribute(null)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ControlCursorDescr")]
-        public virtual Cursor Cursor { get; set; }
+        [AmbientValueAttribute(null)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ControlCursorDescr")]
+        [AllowNullAttribute]
+        public virtual Cursor Cursor { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        public virtual object DataContext { get; set; }
-        [AmbientValueAttribute(null)]
-        [DispIdAttribute(-512)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ControlFontDescr")]
-        public virtual Font Font { get; set; }
+        [AmbientValueAttribute(null)]
+        [DispIdAttribute(-512)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ControlFontDescr")]
+        [AllowNullAttribute]
+        public virtual Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        public string Name { get; set; }
+        [BrowsableAttribute(false)]
+        [AllowNullAttribute]
+        public string Name { get; set; }
-        [BindableAttribute(true)]
-        [DispIdAttribute(-517)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ControlTextDescr")]
-        public virtual string Text { get; set; }
+        [BindableAttribute(true)]
+        [DispIdAttribute(-517)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ControlTextDescr")]
+        [AllowNullAttribute]
+        public virtual string Text { get; set; }
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlDataContextChangedDescr")]
+        public event EventHandler DataContextChanged;
-        [EditorBrowsableAttribute(2)]
-        public IAsyncResult BeginInvoke(Delegate method, params object[] args);
+        [EditorBrowsableAttribute(2)]
+        public IAsyncResult BeginInvoke(Delegate method, params object?[]? args);
+        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap? dragImage, Point cursorOffset, bool useDefaultDragImage);
-        [EditorBrowsableAttribute(2)]
-        public object EndInvoke(IAsyncResult asyncResult);
+        [EditorBrowsableAttribute(2)]
+        public object? EndInvoke(IAsyncResult asyncResult);
-        public object Invoke(Delegate method, params object[] args);
+        public object Invoke(Delegate method, params object?[]? args);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnDataContextChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnParentDataContextChanged(EventArgs e);
         [ListBindableAttribute(false)]
         public class ControlCollection : ArrangedElementCollection, ICloneable, ICollection, IEnumerable, IList {
-            public virtual Control this[string key] { get; }
+            public virtual Control? this[string? key] { get; }
-            public virtual void Add(Control value);
+            public virtual void Add(Control? value);
-            public bool Contains(Control control);
+            public bool Contains(Control? control);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public int IndexOf(Control control);
+            public int IndexOf(Control? control);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public virtual void Remove(Control value);
+            public virtual void Remove(Control? value);
-            public virtual void RemoveByKey(string key);
+            public virtual void RemoveByKey(string? key);
-            int IList.Add(object control);
+            int IList.Add(object? control);
-            void IList.Remove(object control);
+            void IList.Remove(object? control);
         }
     }
     [EditorAttribute("System.Drawing.Design.CursorEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     [TypeConverterAttribute(typeof(CursorConverter))]
     public sealed class Cursor : IDisposable, IHandle, ISerializable {
-        public static Cursor? Current { get; set; }
+        public static Cursor Current { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object? Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object Tag { get; set; }
-        public override bool Equals(object? obj);
+        public override bool Equals(object obj);
     }
     public class CursorConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [DefaultEventAttribute("CellContentClick")]
     [DesignerAttribute("System.Windows.Forms.Design.DataGridViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [EditorAttribute("System.Windows.Forms.Design.DataGridViewComponentEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(ComponentEditor))]
     [SRDescriptionAttribute("DescriptionDataGridView")]
     public class DataGridView : Control, ISupportInitialize {
         protected class DataGridViewTopRowAccessibleObject : AccessibleObject {
-            public DataGridView Owner { get; set; }
+            public DataGridView? Owner { get; set; }
-            public override AccessibleObject GetChild(int index);
+            public override AccessibleObject? GetChild(int index);
-            public override AccessibleObject Navigate(AccessibleNavigation navigationDirection);
+            public override AccessibleObject? Navigate(AccessibleNavigation navigationDirection);
         }
     }
     public sealed class DataGridViewAdvancedBorderStyle : ICloneable {
-        public override bool Equals(object other);
+        public override bool Equals(object? other);
     }
     public class DataGridViewTextBoxEditingControl : TextBox, IDataGridViewEditingControl {
-        public virtual DataGridView EditingControlDataGridView { get; set; }
+        public virtual DataGridView? EditingControlDataGridView { get; set; }
     }
     [ClassInterfaceAttribute(0)]
     public class DataObject : IDataObject, IDataObject {
-        public virtual Stream GetAudioStream();
+        public virtual Stream? GetAudioStream();
-        public virtual object GetData(string format);
+        public virtual object? GetData(string format);
-        public virtual object GetData(string format, bool autoConvert);
+        public virtual object? GetData(string format, bool autoConvert);
-        public virtual object GetData(Type format);
+        public virtual object? GetData(Type format);
-        public virtual Image GetImage();
+        public virtual Image? GetImage();
-        public virtual void SetData(object data);
+        public virtual void SetData(object? data);
-        public virtual void SetData(string format, bool autoConvert, object data);
+        public virtual void SetData(string format, bool autoConvert, object? data);
-        public virtual void SetData(string format, object data);
+        public virtual void SetData(string format, object? data);
-        public virtual void SetData(Type format, object data);
+        public virtual void SetData(Type format, object? data);
-        int IDataObject.EnumDAdvise(out IEnumSTATDATA enumAdvise);
+        int IDataObject.EnumDAdvise(out IEnumSTATDATA? enumAdvise);
     }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultEventAttribute("ValueChanged")]
     [DefaultPropertyAttribute("Value")]
     [DesignerAttribute("System.Windows.Forms.Design.DateTimePickerDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionDateTimePicker")]
     public class DateTimePicker : Control {
-        [AmbientValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("DateTimePickerCalendarFontDescr")]
-        public Font CalendarFont { get; set; }
+        [AmbientValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("DateTimePickerCalendarFontDescr")]
+        [AllowNullAttribute]
+        public Font CalendarFont { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(2)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(2)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
+        protected override void OnGotFocus(EventArgs e);
         public class DateTimePickerAccessibleObject : Control.ControlAccessibleObject {
+            public override string DefaultAction { get; }
-            public override string KeyboardShortcut { get; }
+            public override string? KeyboardShortcut { get; }
+            public override string Name { get; }
+            public override void DoDefaultAction();
         }
     }
     [AttributeUsageAttribute(4)]
     public sealed class DockingAttribute : Attribute {
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     [DefaultBindingPropertyAttribute("SelectedItem")]
     [DefaultEventAttribute("SelectedItemChanged")]
     [DefaultPropertyAttribute("Items")]
     [SRDescriptionAttribute("DescriptionDomainUpDown")]
     public class DomainUpDown : UpDownBase {
-        protected override void OnChanged(object source, EventArgs e);
+        protected override void OnChanged(object? source, EventArgs e);
-        protected void OnSelectedItemChanged(object source, EventArgs e);
+        protected void OnSelectedItemChanged(object? source, EventArgs e);
-        protected override void OnTextBoxKeyPress(object source, KeyPressEventArgs e);
+        protected override void OnTextBoxKeyPress(object? source, KeyPressEventArgs e);
-        public class DomainItemAccessibleObject : AccessibleObject {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainItemAccessibleObject is no longer used to provide accessible support for DomainUpDown items.", false, DiagnosticId="WFDEV003", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainItemAccessibleObject : AccessibleObject {
-            public DomainItemAccessibleObject(string name, AccessibleObject parent);
+            public DomainItemAccessibleObject(string? name, AccessibleObject parent);
         }
-        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls.", false, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject {
-            public override AccessibleObject GetChild(int index);
+            public override AccessibleObject? GetChild(int index);
         }
     }
     public class DragEventArgs : EventArgs {
+        public DragEventArgs(IDataObject? data, int keyState, int x, int y, DragDropEffects allowedEffect, DragDropEffects effect, DropImageType dropImageType, string message, string messageReplacementToken);
+        public DropImageType DropImageType { get; set; }
+        public string Message { get; set; }
+        public string MessageReplacementToken { get; set; }
     }
+    public enum DropImageType {
+        Copy = 1,
+        Invalid = -1,
+        Label = 6,
+        Link = 4,
+        Move = 2,
+        NoImage = 8,
+        None = 0,
+        Warning = 7,
+    }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [ProvidePropertyAttribute("Error", typeof(Control))]
     [ProvidePropertyAttribute("IconAlignment", typeof(Control))]
     [ProvidePropertyAttribute("IconPadding", typeof(Control))]
     [SRDescriptionAttribute("DescriptionErrorProvider")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ErrorProvider : Component, IExtenderProvider, ISupportInitialize {
+        public bool HasErrors { get; }
     }
     public abstract class FeatureSupport : IFeatureSupport {
-        public abstract Version GetVersionPresent(object feature);
+        public abstract Version? GetVersionPresent(object feature);
-        public static Version GetVersionPresent(string featureClassName, string featureConstName);
+        public static Version? GetVersionPresent(string featureClassName, string featureConstName);
     }
     [DefaultEventAttribute("FileOk")]
     [DefaultPropertyAttribute("FileName")]
     public abstract class FileDialog : CommonDialog {
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FileDialogAddToRecentDescr")]
+        public bool AddToRecent { get; set; }
-        [DefaultValueAttribute("")]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("FDdefaultExtDescr")]
-        public string DefaultExt { get; set; }
+        [DefaultValueAttribute("")]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FDdefaultExtDescr")]
+        [AllowNullAttribute]
+        public string DefaultExt { get; set; }
-        [DefaultValueAttribute("")]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("FDfileNameDescr")]
-        public string FileName { get; set; }
+        [DefaultValueAttribute("")]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("FDfileNameDescr")]
+        [AllowNullAttribute]
+        public string FileName { get; set; }
-        [DefaultValueAttribute("")]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("FDfilterDescr")]
-        public string Filter { get; set; }
+        [DefaultValueAttribute("")]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FDfilterDescr")]
+        [AllowNullAttribute]
+        public string Filter { get; set; }
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.Windows.Forms.Design.InitialDirectoryEditor, System.Windows.Forms.Design, Version=6.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089", typeof(UITypeEditor))]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("FDinitialDirDescr")]
-        public string InitialDirectory { get; set; }
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.Windows.Forms.Design.InitialDirectoryEditor, System.Windows.Forms.Design, Version=6.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089", typeof(UITypeEditor))]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("FDinitialDirDescr")]
+        [AllowNullAttribute]
+        public string InitialDirectory { get; set; }
+        [DefaultValueAttribute(false)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FileDialogOkRequiresInteractionDescr")]
+        public bool OkRequiresInteraction { get; set; }
+        [DefaultValueAttribute(false)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FileDialogShowHiddenFilesDescr")]
+        public bool ShowHiddenFiles { get; set; }
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FileDialogShowPinnedPlacesDescr")]
+        public bool ShowPinnedPlaces { get; set; }
-        [DefaultValueAttribute("")]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("FDtitleDescr")]
-        public string Title { get; set; }
+        [DefaultValueAttribute("")]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("FDtitleDescr")]
+        [AllowNullAttribute]
+        public string Title { get; set; }
     }
     [DefaultEventAttribute("HelpRequest")]
     [DefaultPropertyAttribute("SelectedPath")]
     [DesignerAttribute("System.Windows.Forms.Design.FolderBrowserDialogDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionFolderBrowserDialog")]
     public sealed class FolderBrowserDialog : CommonDialog {
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FolderBrowserDialogAddToRecent")]
+        public bool AddToRecent { get; set; }
+        [DefaultValueAttribute(false)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FolderBrowserDialogOkRequiresInteraction")]
+        public bool OkRequiresInteraction { get; set; }
+        [DefaultValueAttribute(false)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FolderBrowserDialogShowHiddenFiles")]
+        public bool ShowHiddenFiles { get; set; }
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("FolderBrowserDialogShowPinnedPlaces")]
+        public bool ShowPinnedPlaces { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler HelpRequest;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? HelpRequest;
-        public override void Reset();
+        [MemberNotNullAttribute("_descriptionText")]
+        [MemberNotNullAttribute("_initialDirectory")]
+        [MemberNotNullAttribute("_selectedPath")]
+        public override void Reset();
     }
     [DefaultEventAttribute("Apply")]
     [DefaultPropertyAttribute("Font")]
     [SRDescriptionAttribute("DescriptionFontDialog")]
     public class FontDialog : CommonDialog {
-        [SRDescriptionAttribute("FnDapplyDescr")]
-        public event EventHandler Apply;
+        [SRDescriptionAttribute("FnDapplyDescr")]
+        public event EventHandler? Apply;
     }
     [DefaultEventAttribute("Load")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.FormDocumentDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(IRootDesigner))]
     [DesignerCategoryAttribute("Form")]
     [InitializationEventAttribute("Load")]
     [ToolboxItemAttribute(false)]
     [ToolboxItemFilterAttribute("System.Windows.Forms.Control.TopLevel")]
     public class Form : ContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatWindowStyle")]
-        [SRDescriptionAttribute("FormIsMDIChildDescr")]
-        public bool IsMdiChild { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [MemberNotNullWhenAttribute(true, "MdiParentInternal")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormIsMDIChildDescr")]
+        public bool IsMdiChild { [MemberNotNullWhenAttribute(true, "MdiParentInternal")] get; }
-        [DefaultValueAttribute(false)]
-        [SRCategoryAttribute("CatWindowStyle")]
-        [SRDescriptionAttribute("FormIsMDIContainerDescr")]
-        public bool IsMdiContainer { get; set; }
+        [DefaultValueAttribute(false)]
+        [MemberNotNullWhenAttribute(true, "MdiClient")]
+        [SRCategoryAttribute("CatWindowStyle")]
+        [SRDescriptionAttribute("FormIsMDIContainerDescr")]
+        public bool IsMdiContainer { [MemberNotNullWhenAttribute(true, "MdiClient")] get; [MemberNotNullWhenAttribute(true, "MdiClient")] set; }
-        [SettingsBindableAttribute(true)]
-        public override string Text { get; set; }
+        [SettingsBindableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
+        protected override void OnGotFocus(EventArgs e);
+        protected override void ScaleMinMaxSize(float xScaleFactor, float yScaleFactor, bool updateContainerSize = true);
         public new class ControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     public class FormCollection : ReadOnlyCollectionBase {
-        public virtual Form this[int index] { get; }
+        public virtual Form? this[int index] { get; }
-        public virtual Form this[string name] { get; }
+        public virtual Form? this[string? name] { get; }
     }
     public class GiveFeedbackEventArgs : EventArgs {
+        public GiveFeedbackEventArgs(DragDropEffects effect, bool useDefaultCursors, Bitmap dragImage, Point cursorOffset, bool useDefaultDragImage);
+        public Point CursorOffset { get; set; }
+        public Bitmap DragImage { get; set; }
+        public bool UseDefaultDragImage { get; set; }
     }
     [DefaultEventAttribute("Enter")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.GroupBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionGroupBox")]
     public class GroupBox : Control {
-        [LocalizableAttribute(true)]
-        public override string Text { get; set; }
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     public interface IDataGridViewEditingControl {
-        DataGridView EditingControlDataGridView { get; set; }
+        DataGridView? EditingControlDataGridView { get; set; }
     }
     public interface IDataObject {
-        object GetData(string format);
+        object? GetData(string format);
-        object GetData(string format, bool autoConvert);
+        object? GetData(string format, bool autoConvert);
-        object GetData(Type format);
+        object? GetData(Type format);
-        void SetData(object data);
+        void SetData(object? data);
-        void SetData(string format, bool autoConvert, object data);
+        void SetData(string format, bool autoConvert, object? data);
-        void SetData(string format, object data);
+        void SetData(string format, object? data);
-        void SetData(Type format, object data);
+        void SetData(Type format, object? data);
     }
     public interface IFeatureSupport {
-        Version GetVersionPresent(object feature);
+        Version? GetVersionPresent(object feature);
     }
     public class ImageIndexConverter : Int32Converter {
-        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext? context);
     }
     public class ImageKeyConverter : StringConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext? context);
     }
     [DefaultPropertyAttribute("Images")]
     [DesignerAttribute("System.Windows.Forms.Design.ImageListDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ImageListCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionImageList")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     [TypeConverterAttribute(typeof(ImageListConverter))]
     public sealed class ImageList : Component, IHandle {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(2)]
-        [SRDescriptionAttribute("ImageListHandleCreatedDescr")]
-        public bool HandleCreated { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(2)]
+        [MemberNotNullWhenAttribute(true, "_nativeImageList")]
+        [SRDescriptionAttribute("ImageListHandleCreatedDescr")]
+        public bool HandleCreated { [MemberNotNullWhenAttribute(true, "_nativeImageList")] get; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [EditorBrowsableAttribute(2)]
-        [SRDescriptionAttribute("ImageListImageStreamDescr")]
-        public ImageListStreamer ImageStream { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [EditorBrowsableAttribute(2)]
+        [SRDescriptionAttribute("ImageListImageStreamDescr")]
+        public ImageListStreamer? ImageStream { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        [SRDescriptionAttribute("ImageListOnRecreateHandleDescr")]
-        public event EventHandler RecreateHandle;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        [SRDescriptionAttribute("ImageListOnRecreateHandleDescr")]
+        public event EventHandler? RecreateHandle;
         [EditorAttribute("System.Windows.Forms.Design.ImageCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
         public sealed class ImageCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public Image this[string key] { get; }
+            public Image? this[string key] { get; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object value);
+            bool IList.Contains(object? value);
-            int IList.IndexOf(object value);
+            int IList.IndexOf(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     public class KeysConverter : TypeConverter, IComparer {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.LabelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionLabel")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class Label : Control, IAutomationLiveRegion {
-        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [SettingsBindableAttribute(true)]
-        public override string Text { get; set; }
+        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [SettingsBindableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
-    [TypeConverterAttribute(typeof(LinkArea.LinkAreaConverter))]
-    public struct LinkArea {
+    [TypeConverterAttribute(typeof(LinkArea.LinkAreaConverter))]
+    public struct LinkArea : IEquatable<LinkArea> {
-        public override bool Equals(object o);
+        public override bool Equals(object? o);
+        public bool Equals(LinkArea other);
         public class LinkAreaConverter : TypeConverter {
-            public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+            public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-            public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+            public override object CreateInstance(ITypeDescriptorContext? context, IDictionary propertyValues);
-            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+            [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
         }
     }
     public class LinkConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
     }
-    public delegate void LinkLabelLinkClickedEventHandler(object sender, LinkLabelLinkClickedEventArgs e);
+    public delegate void LinkLabelLinkClickedEventHandler(object? sender, LinkLabelLinkClickedEventArgs e);
     public class ListBindingConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext? context, Type? destinationType);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+        public override object CreateInstance(ITypeDescriptorContext? context, IDictionary propertyValues);
-        public override bool GetCreateInstanceSupported(ITypeDescriptorContext context);
+        public override bool GetCreateInstanceSupported(ITypeDescriptorContext? context);
     }
     [DefaultBindingPropertyAttribute("SelectedValue")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionListBox")]
     public class ListBox : ListControl {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ListBoxSelectedItemDescr")]
-        public object SelectedItem { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ListBoxSelectedItemDescr")]
+        public object? SelectedItem { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(2)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(2)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler Click;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? Click;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("drawItemEventDescr")]
-        public event DrawItemEventHandler DrawItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("drawItemEventDescr")]
+        public event DrawItemEventHandler? DrawItem;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("measureItemEventDescr")]
-        public event MeasureItemEventHandler MeasureItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("measureItemEventDescr")]
+        public event MeasureItemEventHandler? MeasureItem;
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event MouseEventHandler MouseClick;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event MouseEventHandler? MouseClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? PaddingChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        public new event EventHandler? TextChanged;
         public class IntegerCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            bool System.Collections.IList.IsReadOnly { get; }
+            bool IList.IsReadOnly { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object item);
+            int IList.Add(object? item);
-            bool IList.Contains(object item);
+            bool IList.Contains(object? item);
-            int IList.IndexOf(object item);
+            int IList.IndexOf(object? item);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
         public class SelectedIndexCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object selectedIndex);
+            bool IList.Contains(object? selectedIndex);
-            int IList.IndexOf(object selectedIndex);
+            int IList.IndexOf(object? selectedIndex);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
         public class SelectedObjectCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            [BrowsableAttribute(false)]
-            [DesignerSerializationVisibilityAttribute(0)]
-            public object this[int index] { get; set; }
+            [BrowsableAttribute(false)]
+            [DesignerSerializationVisibilityAttribute(0)]
+            public object? this[int index] { get; set; }
-            public bool Contains(object selectedObject);
+            public bool Contains(object? selectedObject);
-            public int IndexOf(object selectedObject);
+            public int IndexOf(object? selectedObject);
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionListView")]
     public class ListView : Control {
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ListViewGroupCollapsedStateChangedDescr")]
-        public event EventHandler<ListViewGroupEventArgs> GroupCollapsedStateChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ListViewGroupCollapsedStateChangedDescr")]
+        public event EventHandler<ListViewGroupEventArgs>? GroupCollapsedStateChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ListViewGroupTaskLinkClickDescr")]
-        public event EventHandler<ListViewGroupEventArgs> GroupTaskLinkClick;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ListViewGroupTaskLinkClickDescr")]
+        public event EventHandler<ListViewGroupEventArgs>? GroupTaskLinkClick;
-        public ListViewItem FindItemWithText(string text);
+        public ListViewItem? FindItemWithText(string text);
-        public ListViewItem FindItemWithText(string text, bool includeSubItemsInSearch, int startIndex);
+        public ListViewItem? FindItemWithText(string text, bool includeSubItemsInSearch, int startIndex);
-        public ListViewItem FindItemWithText(string text, bool includeSubItemsInSearch, int startIndex, bool isPrefixSearch);
+        public ListViewItem? FindItemWithText(string text, bool includeSubItemsInSearch, int startIndex, bool isPrefixSearch);
         [ListBindableAttribute(false)]
         public class CheckedIndexCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object checkedIndex);
+            bool IList.Contains(object? checkedIndex);
-            int IList.IndexOf(object checkedIndex);
+            int IList.IndexOf(object? checkedIndex);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
         [ListBindableAttribute(false)]
         public class CheckedListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
         [ListBindableAttribute(false)]
         public class ColumnHeaderCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
-            public virtual ColumnHeader Add(string text);
+            public virtual ColumnHeader Add(string? text);
-            public virtual ColumnHeader Add(string text, int width);
+            public virtual ColumnHeader Add(string? text, int width);
-            public virtual ColumnHeader Add(string text, int width, HorizontalAlignment textAlign);
+            public virtual ColumnHeader Add(string? text, int width, HorizontalAlignment textAlign);
-            public virtual ColumnHeader Add(string key, string text, int width, HorizontalAlignment textAlign, string imageKey);
+            public virtual ColumnHeader Add(string? key, string? text, int width, HorizontalAlignment textAlign, string imageKey);
         }
         [ListBindableAttribute(false)]
         public class SelectedIndexCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object selectedIndex);
+            bool IList.Contains(object? selectedIndex);
-            int IList.IndexOf(object selectedIndex);
+            int IList.IndexOf(object? selectedIndex);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
         [ListBindableAttribute(false)]
         public class SelectedListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
     }
     [ListBindableAttribute(false)]
     public class ListViewGroupCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        public ListViewGroup this[string key] { get; set; }
+        public ListViewGroup? this[string key] { get; set; }
-        public ListViewGroup Add(string key, string headerText);
+        public ListViewGroup Add(string? key, string? headerText);
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     [TypeConverterAttribute(typeof(ListViewItemConverter))]
     public class ListViewItem : ICloneable, IKeyboardToolTip, ISerializable {
         [DefaultPropertyAttribute("Text")]
         [DesignTimeVisibleAttribute(false)]
         [ToolboxItemAttribute(false)]
         [TypeConverterAttribute(typeof(ListViewSubItemConverter))]
         public class ListViewSubItem {
-            public ListViewSubItem(ListViewItem owner, string text);
+            public ListViewSubItem(ListViewItem owner, string? text);
-            public ListViewSubItem(ListViewItem owner, string text, Color foreColor, Color backColor, Font font);
+            public ListViewSubItem(ListViewItem owner, string? text, Color foreColor, Color backColor, Font font);
-            [LocalizableAttribute(true)]
-            public string Name { get; set; }
+            [LocalizableAttribute(true)]
+            [AllowNullAttribute]
+            public string Name { get; set; }
-            [BindableAttribute(true)]
-            [DefaultValueAttribute(null)]
-            [LocalizableAttribute(false)]
-            [SRCategoryAttribute("CatData")]
-            [SRDescriptionAttribute("ControlTagDescr")]
-            [TypeConverterAttribute(typeof(StringConverter))]
-            public object Tag { get; set; }
+            [BindableAttribute(true)]
+            [DefaultValueAttribute(null)]
+            [LocalizableAttribute(false)]
+            [SRCategoryAttribute("CatData")]
+            [SRDescriptionAttribute("ControlTagDescr")]
+            [TypeConverterAttribute(typeof(StringConverter))]
+            public object? Tag { get; set; }
-            [LocalizableAttribute(true)]
-            public string Text { get; set; }
+            [LocalizableAttribute(true)]
+            [AllowNullAttribute]
+            public string Text { get; set; }
         }
         public class ListViewSubItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public virtual ListViewItem.ListViewSubItem this[string key] { get; }
+            public virtual ListViewItem.ListViewSubItem? this[string key] { get; }
-            public ListViewItem.ListViewSubItem Add(string text);
+            public ListViewItem.ListViewSubItem Add(string? text);
-            public ListViewItem.ListViewSubItem Add(string text, Color foreColor, Color backColor, Font font);
+            public ListViewItem.ListViewSubItem Add(string? text, Color foreColor, Color backColor, Font font);
-            public bool Contains(ListViewItem.ListViewSubItem subItem);
+            public bool Contains(ListViewItem.ListViewSubItem? subItem);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public int IndexOf(ListViewItem.ListViewSubItem subItem);
+            public int IndexOf(ListViewItem.ListViewSubItem? subItem);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public void Remove(ListViewItem.ListViewSubItem item);
+            public void Remove(ListViewItem.ListViewSubItem? item);
-            public virtual void RemoveByKey(string key);
+            public virtual void RemoveByKey(string? key);
-            int IList.Add(object item);
+            int IList.Add(object? item);
-            bool IList.Contains(object item);
+            bool IList.Contains(object? item);
-            int IList.IndexOf(object subItem);
+            int IList.IndexOf(object? subItem);
-            void IList.Insert(int index, object item);
+            void IList.Insert(int index, object? item);
-            void IList.Remove(object item);
+            void IList.Remove(object? item);
         }
     }
     public class ListViewItemStateImageIndexConverter : ImageIndexConverter {
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("MaskInputRejected")]
     [DefaultPropertyAttribute("Mask")]
     [DesignerAttribute("System.Windows.Forms.Design.MaskedTextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMaskedTextBox")]
     public class MaskedTextBox : TextBoxBase {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public IFormatProvider FormatProvider { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public IFormatProvider? FormatProvider { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new string[] Lines { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public new string[] Lines { get; set; }
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.Windows.Forms.Design.MaskPropertyEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [MergablePropertyAttribute(false)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("MaskedTextBoxMaskDescr")]
-        public string Mask { get; set; }
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.Windows.Forms.Design.MaskPropertyEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [MergablePropertyAttribute(false)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("MaskedTextBoxMaskDescr")]
+        [AllowNullAttribute]
+        public string Mask { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public MaskedTextProvider MaskedTextProvider { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public MaskedTextProvider? MaskedTextProvider { get; }
-        public override string SelectedText { get; set; }
+        [AllowNullAttribute]
+        public override string SelectedText { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.Windows.Forms.Design.MaskedTextBoxTextEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatAppearance")]
-        public override string Text { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.Windows.Forms.Design.MaskedTextBoxTextEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        public Type ValidatingType { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        public Type? ValidatingType { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler AcceptsTabChanged;
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? AcceptsTabChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("MaskedTextBoxIsOverwriteModeChangedDescr")]
-        public event EventHandler IsOverwriteModeChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("MaskedTextBoxIsOverwriteModeChangedDescr")]
+        public event EventHandler? IsOverwriteModeChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("MaskedTextBoxMaskChangedDescr")]
-        public event EventHandler MaskChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("MaskedTextBoxMaskChangedDescr")]
+        public event EventHandler? MaskChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("MaskedTextBoxMaskInputRejectedDescr")]
-        public event MaskInputRejectedEventHandler MaskInputRejected;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("MaskedTextBoxMaskInputRejectedDescr")]
+        public event MaskInputRejectedEventHandler? MaskInputRejected;
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler MultilineChanged;
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? MultilineChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnTextAlignChangedDescr")]
-        public event EventHandler TextAlignChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnTextAlignChangedDescr")]
+        public event EventHandler? TextAlignChanged;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("MaskedTextBoxTypeValidationCompletedDescr")]
-        public event TypeValidationEventHandler TypeValidationCompleted;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("MaskedTextBoxTypeValidationCompletedDescr")]
+        public event TypeValidationEventHandler? TypeValidationCompleted;
-        public object ValidateText();
+        public object? ValidateText();
     }
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     public sealed class MdiClient : Control {
-        [LocalizableAttribute(true)]
-        public override Image BackgroundImage { get; set; }
+        [LocalizableAttribute(true)]
+        public override Image? BackgroundImage { get; set; }
     }
-    public struct Message {
+    public struct Message : IEquatable<Message> {
+        public bool Equals(Message other);
     }
     [DefaultBindingPropertyAttribute("SelectionRange")]
     [DefaultEventAttribute("DateChanged")]
     [DefaultPropertyAttribute("SelectionRange")]
     [DesignerAttribute("System.Windows.Forms.Design.MonthCalendarDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMonthCalendar")]
     public class MonthCalendar : Control {
-        protected override void Dispose(bool disposing);
     }
     public class NativeWindow : MarshalByRefObject, IHandle, IWin32Window {
-        public static NativeWindow FromHandle(IntPtr handle);
+        public static NativeWindow? FromHandle(IntPtr handle);
     }
     [DefaultEventAttribute("MouseDoubleClick")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.NotifyIconDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionNotifyIcon")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public sealed class NotifyIcon : Component {
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("NotifyIconTextDescr")]
-        public string Text { get; set; }
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("NotifyIconTextDescr")]
+        [AllowNullAttribute]
+        public string Text { get; set; }
     }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultEventAttribute("ValueChanged")]
     [DefaultPropertyAttribute("Value")]
     [SRDescriptionAttribute("DescriptionNumericUpDown")]
     public class NumericUpDown : UpDownBase, ISupportInitialize {
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? PaddingChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("NumericUpDownOnValueChangedDescr")]
-        public event EventHandler ValueChanged;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("NumericUpDownOnValueChangedDescr")]
+        public event EventHandler? ValueChanged;
-        protected override AccessibleObject CreateAccessibilityInstance();
-        protected override void OnTextBoxKeyPress(object source, KeyPressEventArgs e);
+        protected override void OnTextBoxKeyPress(object? source, KeyPressEventArgs e);
     }
     public class OpacityConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
     }
     [SRDescriptionAttribute("DescriptionOpenFileDialog")]
     public sealed class OpenFileDialog : FileDialog {
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("OpenFileDialogSelectReadOnlyDescr")]
+        public bool SelectReadOnly { get; set; }
+        [DefaultValueAttribute(false)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("OpenFileDialogShowPreviewDescr")]
+        public bool ShowPreview { get; set; }
     }
     public class OSFeature : FeatureSupport {
-        public override Version GetVersionPresent(object feature);
+        public override Version? GetVersionPresent(object feature);
     }
-    [TypeConverterAttribute(typeof(PaddingConverter))]
-    [TypeForwardedFromAttribute("System.Windows.Forms, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089")]
-    public struct Padding {
+    [TypeConverterAttribute(typeof(PaddingConverter))]
+    [TypeForwardedFromAttribute("System.Windows.Forms, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089")]
+    public struct Padding : IEquatable<Padding> {
+        public bool Equals(Padding other);
     }
     public class PaddingConverter : TypeConverter {
-        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
+        [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
     }
     [DefaultEventAttribute("Paint")]
     [DefaultPropertyAttribute("BorderStyle")]
     [DesignerAttribute("System.Windows.Forms.Design.PanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionPanel")]
     public class Panel : ScrollableControl {
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     public class PrintControllerWithStatusDialog : PrintController {
-        public override Graphics OnStartPage(PrintDocument document, PrintPageEventArgs e);
+        public override Graphics? OnStartPage(PrintDocument document, PrintPageEventArgs e);
     }
     [DefaultPropertyAttribute("Document")]
     [DesignerAttribute("System.Windows.Forms.Design.PrintDialogDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionPrintDialog")]
     public sealed class PrintDialog : CommonDialog {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("PDdocumentDescr")]
-        public PrintDocument Document { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("PDdocumentDescr")]
+        public PrintDocument? Document { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("PDprinterSettingsDescr")]
-        public PrinterSettings PrinterSettings { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("PDprinterSettingsDescr")]
+        [AllowNullAttribute]
+        public PrinterSettings PrinterSettings { get; set; }
     }
     [DefaultPropertyAttribute("Document")]
     [SRDescriptionAttribute("DescriptionPrintPreviewControl")]
     public class PrintPreviewControl : Control {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
-        public PrintDocument Document { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
+        public PrintDocument? Document { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
-        public event EventHandler StartPageChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
+        public event EventHandler? StartPageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DefaultPropertyAttribute("Document")]
     [DesignTimeVisibleAttribute(true)]
     [DesignerAttribute("System.ComponentModel.Design.ComponentDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionPrintPreviewDialog")]
     [ToolboxItemAttribute(true)]
     [ToolboxItemFilterAttribute("System.Windows.Forms.Control.TopLevel")]
     public class PrintPreviewDialog : Form {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultPropertyAttribute("Value")]
     [SRDescriptionAttribute("DescriptionProgressBar")]
     public class ProgressBar : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionPropertyGrid")]
     public class PropertyGrid : ContainerControl, IComPropertyBrowser, Interop.Ole32.IPropertyNotifySink {
-        void IComPropertyBrowser.LoadState(RegistryKey optRoot);
+        void IComPropertyBrowser.LoadState(RegistryKey key);
-        void IComPropertyBrowser.SaveState(RegistryKey optRoot);
+        void IComPropertyBrowser.SaveState(RegistryKey key);
     }
     [DefaultBindingPropertyAttribute("Checked")]
     [DefaultEventAttribute("CheckedChanged")]
     [DefaultPropertyAttribute("Checked")]
     [DesignerAttribute("System.Windows.Forms.Design.RadioButtonDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionRadioButton")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class RadioButton : ButtonBase {
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnAppearanceChangedDescr")]
-        public event EventHandler AppearanceChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnAppearanceChangedDescr")]
+        public event EventHandler? AppearanceChanged;
-        [SRDescriptionAttribute("RadioButtonOnCheckedChangedDescr")]
-        public event EventHandler CheckedChanged;
+        [SRDescriptionAttribute("RadioButtonOnCheckedChangedDescr")]
+        public event EventHandler? CheckedChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseDoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseDoubleClick;
     }
     public static class RadioButtonRenderer {
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, TextFormatFlags flags, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, TextFormatFlags flags, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
     }
     [DesignerAttribute("System.Windows.Forms.Design.SaveFileDialogDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionSaveFileDialog")]
     public sealed class SaveFileDialog : FileDialog {
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("SaveFileDialogCheckWriteAccess")]
+        public bool CheckWriteAccess { get; set; }
+        [DefaultValueAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("SaveFileDialogExpandedMode")]
+        public bool ExpandedMode { get; set; }
     }
     public class Screen {
-        public static Screen PrimaryScreen { get; }
+        public static Screen? PrimaryScreen { get; }
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ScrollableControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ScrollableControl : Control, IArrangedElement, IComponent, IDisposable {
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ScrollBarOnScrollDescr")]
-        public event ScrollEventHandler Scroll;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ScrollBarOnScrollDescr")]
+        public event ScrollEventHandler? Scroll;
-        public void ScrollControlIntoView(Control activeControl);
+        public void ScrollControlIntoView(Control? activeControl);
         [TypeConverterAttribute(typeof(ScrollableControl.DockPaddingEdgesConverter))]
         public class DockPaddingEdges : ICloneable {
-            public override bool Equals(object other);
+            public override bool Equals(object? other);
         }
         public class DockPaddingEdgesConverter : TypeConverter {
-            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+            [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
-            public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+            public override bool GetPropertiesSupported(ITypeDescriptorContext? context);
         }
     }
     [DefaultEventAttribute("Scroll")]
     [DefaultPropertyAttribute("Value")]
     public abstract class ScrollBar : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     public class SelectionRangeConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-        public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+        public override object CreateInstance(ITypeDescriptorContext? context, IDictionary propertyValues);
-        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
     }
     [DefaultEventAttribute("SplitterMoved")]
     [DesignerAttribute("System.Windows.Forms.Design.SplitContainerDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.AutoDock)]
     [SRDescriptionAttribute("DescriptionSplitContainer")]
     public class SplitContainer : ContainerControl, ISupportInitialize {
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DefaultEventAttribute("SplitterMoved")]
     [DefaultPropertyAttribute("Dock")]
     [DesignerAttribute("System.Windows.Forms.Design.SplitterDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionSplitter")]
     public class Splitter : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [DesignerAttribute("System.Windows.Forms.Design.SplitterPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Never)]
     [ToolboxItemAttribute(false)]
     public sealed class SplitterPanel : Panel {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new string Name { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public new string Name { get; set; }
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("TabPages")]
     [DesignerAttribute("System.Windows.Forms.Design.TabControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTabControl")]
     public class TabControl : Control {
         public class TabPageCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
     }
     [DefaultPropertyAttribute("ColumnCount")]
     [DesignerAttribute("System.Windows.Forms.Design.TableLayoutPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.TableLayoutPanelCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Never)]
     [ProvidePropertyAttribute("CellPosition", typeof(Control))]
     [ProvidePropertyAttribute("Column", typeof(Control))]
     [ProvidePropertyAttribute("ColumnSpan", typeof(Control))]
     [ProvidePropertyAttribute("Row", typeof(Control))]
     [ProvidePropertyAttribute("RowSpan", typeof(Control))]
     [SRDescriptionAttribute("DescriptionTableLayoutPanel")]
     public class TableLayoutPanel : Panel, IExtenderProvider {
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TableLayoutPanelOnPaintCellDescr")]
-        public event TableLayoutCellPaintEventHandler CellPaint;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TableLayoutPanelOnPaintCellDescr")]
+        public event TableLayoutCellPaintEventHandler? CellPaint;
-        public Control GetControlFromPosition(int column, int row);
+        public Control? GetControlFromPosition(int column, int row);
-        public TableLayoutPanelCellPosition GetPositionFromControl(Control control);
+        public TableLayoutPanelCellPosition GetPositionFromControl(Control? control);
     }
-    [TypeConverterAttribute(typeof(TableLayoutPanelCellPositionTypeConverter))]
-    public struct TableLayoutPanelCellPosition {
+    [TypeConverterAttribute(typeof(TableLayoutPanelCellPositionTypeConverter))]
+    public struct TableLayoutPanelCellPosition : IEquatable<TableLayoutPanelCellPosition> {
+        public bool Equals(TableLayoutPanelCellPosition other);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.TabPageDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public class TabPage : Panel {
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.Windows.Forms.Design.ImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [SRDescriptionAttribute("TabItemImageIndexDescr")]
-        [TypeConverterAttribute(typeof(ImageKeyConverter))]
-        public string ImageKey { get; set; }
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.Windows.Forms.Design.ImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [SRDescriptionAttribute("TabItemImageIndexDescr")]
+        [TypeConverterAttribute(typeof(ImageKeyConverter))]
+        [AllowNullAttribute]
+        public string ImageKey { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        [LocalizableAttribute(true)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [DefaultValueAttribute("")]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("TabItemToolTipTextDescr")]
-        public string ToolTipText { get; set; }
+        [DefaultValueAttribute("")]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("TabItemToolTipTextDescr")]
+        [AllowNullAttribute]
+        public string ToolTipText { get; set; }
         public class TabPageControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
         }
     }
     public static class TabRenderer {
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TextFormatFlags flags, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TextFormatFlags flags, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TextFormatFlags flags, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TextFormatFlags flags, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TabItemState state);
     }
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTextBox")]
     public class TextBox : TextBoxBase {
-        [BrowsableAttribute(true)]
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [EditorBrowsableAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
-        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
+        [BrowsableAttribute(true)]
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [EditorBrowsableAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
+        [AllowNullAttribute]
+        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
-        [DefaultValueAttribute("")]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("TextBoxPlaceholderTextDescr")]
-        public virtual string PlaceholderText { get; set; }
+        [DefaultValueAttribute("")]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("TextBoxPlaceholderTextDescr")]
+        [AllowNullAttribute]
+        public virtual string PlaceholderText { get; set; }
-        public override string Text { get; set; }
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnTextAlignChangedDescr")]
-        public event EventHandler TextAlignChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnTextAlignChangedDescr")]
+        public event EventHandler? TextAlignChanged;
-        public void Paste(string text);
+        public void Paste(string? text);
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("TextChanged")]
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class TextBoxBase : Control {
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [MergablePropertyAttribute(false)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxLinesDescr")]
-        public string[] Lines { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [MergablePropertyAttribute(false)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxLinesDescr")]
+        [AllowNullAttribute]
+        public string[] Lines { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
-        public virtual string SelectedText { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
+        [AllowNullAttribute]
+        public virtual string SelectedText { get; set; }
-        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        public override string Text { get; set; }
+        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     public class ThreadExceptionDialog : Form {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? AutoSizeChanged;
     }
     [DefaultEventAttribute("Tick")]
     [DefaultPropertyAttribute("Interval")]
     [SRDescriptionAttribute("DescriptionTimer")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class Timer : Component {
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
     }
     [DefaultEventAttribute("ItemClicked")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionToolStrip")]
     public class ToolStrip : ScrollableControl, IArrangedElement, IComponent, IDisposable, ISupportToolStripPanel {
         public class ToolStripAccessibleObject : Control.ControlAccessibleObject {
-            public override AccessibleObject GetChild(int index);
+            public override AccessibleObject? GetChild(int index);
-            public override AccessibleObject HitTest(int x, int y);
+            public override AccessibleObject? HitTest(int x, int y);
         }
     }
     public class ToolStripArrowRenderEventArgs : EventArgs {
-        public ToolStripArrowRenderEventArgs(Graphics g, ToolStripItem toolStripItem, Rectangle arrowRectangle, Color arrowColor, ArrowDirection arrowDirection);
+        public ToolStripArrowRenderEventArgs(Graphics g, ToolStripItem? toolStripItem, Rectangle arrowRectangle, Color arrowColor, ArrowDirection arrowDirection);
-        public ToolStripItem Item { get; }
+        public ToolStripItem? Item { get; }
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripContainerDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("ToolStripContainerDesc")]
     public class ToolStripContainer : ContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DefaultEventAttribute("Load")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripContentPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Never)]
     [InitializationEventAttribute("Load")]
     [ToolboxItemAttribute(false)]
     public class ToolStripContentPanel : Panel {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new string Name { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public new string Name { get; set; }
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDropDownDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripDropDownMenu : ToolStripDropDown {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
-    [DefaultEventAttribute("Click")]
-    [DefaultPropertyAttribute("Text")]
-    [DesignTimeVisibleAttribute(false)]
-    [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [ToolboxItemAttribute(false)]
-    public abstract class ToolStripItem : Component, IArrangedElement, IComponent, IDisposable, IDropTarget, IKeyboardToolTip, ISupportOleDropSource {
+    [DefaultEventAttribute("Click")]
+    [DefaultPropertyAttribute("Text")]
+    [DesignTimeVisibleAttribute(false)]
+    [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [ToolboxItemAttribute(false)]
+    public abstract class ToolStripItem : BindableComponent, IArrangedElement, ICommandBindingTargetProvider, IComponent, IDisposable, IDropTarget, IKeyboardToolTip, ISupportOleDropSource {
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap dragImage, Point cursorOffset, bool useDefaultDragImage);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     public class ToolStripItemImageRenderEventArgs : ToolStripItemRenderEventArgs {
-        public ToolStripItemImageRenderEventArgs(Graphics g, ToolStripItem item, Image image, Rectangle imageRectangle);
+        public ToolStripItemImageRenderEventArgs(Graphics g, ToolStripItem item, Image? image, Rectangle imageRectangle);
     }
     public class ToolStripItemRenderEventArgs : EventArgs {
-        public ToolStrip ToolStrip { get; }
+        public ToolStrip? ToolStrip { get; }
     }
     public class ToolStripItemTextRenderEventArgs : ToolStripItemRenderEventArgs {
-        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string text, Rectangle textRectangle, Color textColor, Font textFont, ContentAlignment textAlign);
+        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string? text, Rectangle textRectangle, Color textColor, Font? textFont, ContentAlignment textAlign);
-        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string text, Rectangle textRectangle, Color textColor, Font textFont, TextFormatFlags format);
+        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string? text, Rectangle textRectangle, Color textColor, Font? textFont, TextFormatFlags format);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxBitmapAttribute(typeof(ToolStripPanel), "ToolStripPanel_standalone")]
     public class ToolStripPanel : ContainerControl, IArrangedElement, IComponent, IDisposable {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? AutoSizeChanged;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripRendererChanged")]
-        public event EventHandler RendererChanged;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripRendererChanged")]
+        public event EventHandler? RendererChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TabIndexChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TabIndexChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TabStopChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TabStopChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
+        protected override AccessibleObject CreateAccessibilityInstance();
-        public ToolStripPanelRow PointToRow(Point clientLocation);
+        public ToolStripPanelRow? PointToRow(Point clientLocation);
     }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultEventAttribute("Scroll")]
     [DefaultPropertyAttribute("Value")]
     [DesignerAttribute("System.Windows.Forms.Design.TrackBarDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTrackBar")]
     public class TrackBar : Control, ISupportInitialize {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [DefaultEventAttribute("AfterSelect")]
     [DefaultPropertyAttribute("Nodes")]
     [DesignerAttribute("System.Windows.Forms.Design.TreeViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionTreeView")]
     public class TreeView : Control {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     public class TreeViewImageIndexConverter : ImageIndexConverter {
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     public class TreeViewImageKeyConverter : ImageKeyConverter {
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
     }
     [DesignerAttribute("System.Windows.Forms.Design.UpDownBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class UpDownBase : ContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        public override ContextMenuStrip ContextMenuStrip { get; set; }
+        public override ContextMenuStrip? ContextMenuStrip { get; set; }
-        [LocalizableAttribute(true)]
-        public override string Text { get; set; }
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
+        public new event EventHandler? AutoSizeChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler MouseEnter;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? MouseEnter;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler MouseHover;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? MouseHover;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler MouseLeave;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? MouseLeave;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseMove;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseMove;
+        protected override AccessibleObject CreateAccessibilityInstance();
-        protected virtual void OnChanged(object source, EventArgs e);
+        protected virtual void OnChanged(object? source, EventArgs e);
-        protected virtual void OnTextBoxKeyDown(object source, KeyEventArgs e);
+        protected virtual void OnTextBoxKeyDown(object? source, KeyEventArgs e);
-        protected virtual void OnTextBoxKeyPress(object source, KeyPressEventArgs e);
+        protected virtual void OnTextBoxKeyPress(object? source, KeyPressEventArgs e);
-        protected virtual void OnTextBoxLostFocus(object source, EventArgs e);
+        protected virtual void OnTextBoxLostFocus(object? source, EventArgs e);
-        protected virtual void OnTextBoxResize(object source, EventArgs e);
+        protected virtual void OnTextBoxResize(object? source, EventArgs e);
-        protected virtual void OnTextBoxTextChanged(object source, EventArgs e);
+        protected virtual void OnTextBoxTextChanged(object? source, EventArgs e);
     }
     [DefaultEventAttribute("Load")]
     [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerAttribute("System.Windows.Forms.Design.UserControlDocumentDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(IRootDesigner))]
     [DesignerCategoryAttribute("UserControl")]
     public class UserControl : ContainerControl {
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [DefaultEventAttribute("DocumentCompleted")]
     [DefaultPropertyAttribute("Url")]
     [DesignerAttribute("System.Windows.Forms.Design.WebBrowserDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.AutoDock)]
     [SRDescriptionAttribute("DescriptionWebBrowser")]
     public class WebBrowser : WebBrowserBase {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
 }
```

