# .NET 7.0.1  - December 13, 2022

The .NET 7.0.1 and .NET SDK 7.0.101 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7

.NET 7 is the next major release of .NET following .NET 6.0. You can see [What's new in .NET 7.0](https://learn.microsoft.com/dotnet/core/whats-new/dotnet-7) for more details.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.101
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.1 release carries security fixes.

# Microsoft Security Advisory CVE-2022-41089 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 3.1, .NET 6.0., and .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists in .NET Core 3.1, .NET 6.0, and .NET 7.0, where a malicious actor could cause a user to run arbitrary code as a result of parsing maliciously crafted xps files.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

### Additional fixes in this release
* [Aspnetcore](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A7.0.1+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.1+is%3Aclosed+label%3Aservicing-approved+)
* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A7.0.1+is%3Aclosed+label%3Aservicing-approved+)
* [Templating](https://github.com/dotnet/templating/issues?q=milestone%3A7.0.1+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A7.0.1+is%3Aclosed+label%3Aservicing-approved+)
## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8037](https://github.com/dotnet/core/issues/8037) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.1-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/december-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.1+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.1+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 7.0.1
Microsoft.WindowsDesktop.App.Runtime.win-x64| 7.0.1
Microsoft.WindowsDesktop.App.Ref| 7.0.1
Microsoft.WindowsDesktop.App.Runtime.win-x86| 7.0.1
Microsoft.NETCore.App.Crossgen2.win-arm| 7.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk| 7.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Templates| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 7.0.1
Microsoft.NETCore.App.Host.linux-musl-arm| 7.0.1
Microsoft.NETCore.App.Host.linux-x64| 7.0.1
Microsoft.NETCore.App.Host.win-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.linux-arm| 7.0.1
Microsoft.NETCore.App.Runtime.linux-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.win-x64| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 7.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-x64.Microsoft.DotNet.ILCompiler| 7.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.wasm.Sample.Mono| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.NETCore.App.Host.linux-musl-x64| 7.0.1
Microsoft.NETCore.App.Ref| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.osx-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.win-x86| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 7.0.1
Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler| 7.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 7.0.1
System.Text.Json| 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 7.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-x64| 7.0.1
Microsoft.NETCore.App.Crossgen2.win-arm64| 7.0.1
Microsoft.NETCore.App.Host.linux-bionic-arm64| 7.0.1
Microsoft.NETCore.App.Host.win-x64| 7.0.1
Microsoft.NETCore.App.Host.win-x86| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64| 7.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.win-arm64.Microsoft.DotNet.ILCompiler| 7.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
Microsoft.Extensions.Configuration.Binder| 7.0.1
Microsoft.NET.Runtime.Android.Sample.Mono| 7.0.1
Microsoft.NET.Runtime.iOS.Sample.Mono| 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-arm| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-arm64| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 7.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.osx-x64.Microsoft.DotNet.ILCompiler| 7.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
Microsoft.NETCore.App.Crossgen2.osx-arm64| 7.0.1
Microsoft.NETCore.App.Crossgen2.win-x86| 7.0.1
Microsoft.NETCore.App.Crossgen2.win-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 7.0.1
Microsoft.NETCore.App.Host.linux-arm| 7.0.1
Microsoft.NETCore.App.Host.linux-bionic-x64| 7.0.1
Microsoft.NETCore.App.Host.linux-musl-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-bionic-x64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-musl-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.win-x64| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.DotNetAppHost| 7.0.1
Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler| 7.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.win-arm.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHost| 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 7.0.1
Microsoft.NETCore.App.Composite| 7.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-musl-arm| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.linux-bionic-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 7.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.win-x86| 7.0.1
runtime.linux-arm64.Microsoft.DotNet.ILCompiler| 7.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 7.0.1
Microsoft.DotNet.ILCompiler| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64| 7.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100| 7.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 7.0.1
Microsoft.NETCore.App.Crossgen2.osx-x64| 7.0.1
Microsoft.NETCore.App.Host.osx-arm64| 7.0.1
Microsoft.NETCore.App.Host.linux-arm64| 7.0.1
Microsoft.NETCore.App.Host.osx-x64| 7.0.1
Microsoft.NETCore.App.Host.win-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86| 7.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 7.0.1
Microsoft.NETCore.App.Runtime.osx-arm64| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm| 7.0.1
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 7.0.1
Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost| 7.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 7.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.1
runtime.win-x64.Microsoft.DotNet.ILCompiler| 7.0.1
AspNetCoreRuntime.7.0.x64| 7.0.1
Microsoft.AspNetCore.App.Runtime.win-x64| 7.0.1
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 7.0.1
Microsoft.AspNetCore.App.Ref| 7.0.1
Microsoft.AspNetCore.App.Runtime.win-arm64| 7.0.1
Microsoft.AspNetCore.Authentication.Google| 7.0.1
Microsoft.AspNetCore.Authentication.JwtBearer| 7.0.1
Microsoft.AspNetCore.Authentication.Negotiate| 7.0.1
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 7.0.1
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 7.0.1
Microsoft.AspNetCore.Authentication.Twitter| 7.0.1
Microsoft.AspNetCore.Authentication.OpenIdConnect| 7.0.1
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 7.0.1
Microsoft.AspNetCore.Components.WebAssembly.Server| 7.0.1
Microsoft.AspNetCore.Components.Forms| 7.0.1
Microsoft.AspNetCore.Components.Authorization| 7.0.1
Microsoft.AspNetCore.Components.Analyzers| 7.0.1
Microsoft.AspNetCore.Components.Web| 7.0.1
Microsoft.AspNetCore.Components.WebAssembly| 7.0.1
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 7.0.1
Microsoft.AspNetCore.DataProtection.Abstractions| 7.0.1
Microsoft.AspNetCore.Components.WebView| 7.0.1
Microsoft.AspNetCore.Cryptography.Internal| 7.0.1
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 7.0.1
Microsoft.AspNetCore.OpenApi| 7.0.1
Microsoft.AspNetCore.SignalR.Common| 7.0.1
Microsoft.AspNetCore.SignalR.Client| 7.0.1
Microsoft.AspNetCore.SignalR.Client.Core| 7.0.1
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 7.0.1
Microsoft.Extensions.Caching.SqlServer| 7.0.1
Microsoft.Extensions.Localization| 7.0.1
Microsoft.JSInterop.WebAssembly| 7.0.1
Microsoft.Extensions.Localization.Abstractions| 7.0.1
Microsoft.Extensions.Logging.AzureAppServices| 7.0.1
Microsoft.Extensions.ObjectPool| 7.0.1
Microsoft.JSInterop| 7.0.1
Microsoft.AspNetCore.App.Runtime.osx-arm64| 7.0.1
Microsoft.AspNetCore.App.Runtime.win-arm| 7.0.1
Microsoft.AspNetCore.Authentication.Certificate| 7.0.1
Microsoft.AspNetCore.Authentication.Facebook| 7.0.1
Microsoft.AspNetCore.Authentication.WsFederation| 7.0.1
Microsoft.AspNetCore.Authorization| 7.0.1
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 7.0.1
Microsoft.AspNetCore.ConcurrencyLimiter| 7.0.1
Microsoft.DotNet.Web.ItemTemplates.7.0| 7.0.1
Microsoft.Extensions.FileProviders.Embedded| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-arm| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-arm64| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 7.0.1
Microsoft.AspNetCore.AzureAppServicesIntegration| 7.0.1
Microsoft.AspNetCore.Components.CustomElements| 7.0.1
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 7.0.1
Microsoft.AspNetCore.Grpc.JsonTranscoding| 7.0.1
Microsoft.AspNetCore.Hosting.WindowsServices| 7.0.1
Microsoft.AspNetCore.HeaderPropagation| 7.0.1
Microsoft.AspNetCore.Http.Connections.Common| 7.0.1
Microsoft.AspNetCore.Identity.UI| 7.0.1
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 7.0.1
Microsoft.AspNetCore.Metadata| 7.0.1
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 7.0.1
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 7.0.1
Microsoft.DotNet.Web.Client.ItemTemplates| 7.0.1
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 7.0.1
Microsoft.Extensions.Caching.StackExchangeRedis| 7.0.1
Microsoft.Extensions.Configuration.KeyPerFile| 7.0.1
Microsoft.Extensions.Diagnostics.HealthChecks| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 7.0.1
Microsoft.AspNetCore.App.Runtime.osx-x64| 7.0.1
AspNetCoreRuntime.7.0.x86| 7.0.1
dotnet-sql-cache| 7.0.1
Microsoft.AspNetCore.Components| 7.0.1
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 7.0.1
Microsoft.AspNetCore.Cryptography.KeyDerivation| 7.0.1
Microsoft.AspNetCore.DataProtection| 7.0.1
Microsoft.AspNetCore.Grpc.Swagger| 0.3.1
Microsoft.AspNetCore.MiddlewareAnalysis| 7.0.1
Microsoft.AspNetCore.Mvc.Testing| 7.0.1
Microsoft.AspNetCore.Owin| 7.0.1
Microsoft.AspNetCore.App.Runtime.linux-x64| 7.0.1
Microsoft.AspNetCore.App.Runtime.win-x86| 7.0.1
Microsoft.AspNetCore.Connections.Abstractions| 7.0.1
Microsoft.AspNetCore.DataProtection.Extensions| 7.0.1
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 7.0.1
Microsoft.AspNetCore.Http.Connections.Client| 7.0.1
Microsoft.AspNetCore.JsonPatch| 7.0.1
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 7.0.1
Microsoft.AspNetCore.SignalR.Protocols.Json| 7.0.1
Microsoft.AspNetCore.SignalR.Specification.Tests| 7.0.1
Microsoft.AspNetCore.SpaProxy| 7.0.1
Microsoft.AspNetCore.SpaServices.Extensions| 7.0.1
Microsoft.AspNetCore.TestHost| 7.0.1
Microsoft.Authentication.WebAssembly.Msal| 7.0.1
Microsoft.dotnet-openapi| 7.0.1
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0| 7.0.1
Microsoft.DotNet.Web.ProjectTemplates.7.0| 7.0.1
Microsoft.Extensions.ApiDescription.Server| 7.0.1
Microsoft.Extensions.ApiDescription.Client| 7.0.1
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 7.0.1
Microsoft.Extensions.Features| 7.0.1
Microsoft.Extensions.Http.Polly| 7.0.1
Microsoft.Extensions.Identity.Core| 7.0.1
Microsoft.Extensions.Identity.Stores| 7.0.1
Microsoft.Extensions.WebEncoders| 7.0.1
FSharp.Core| 7.0.0
Microsoft.DotNet.Common.ItemTemplates| 7.0.101
Microsoft.DotNet.Common.ProjectTemplates.7.0| 7.0.101
Microsoft.DotNet.ApiCompat.Task| 7.0.101
Microsoft.DotNet.ApiCompat.Tool| 7.0.101
FSharp.Compiler.Service| 42.7.101
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64| 7.0.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64| 7.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86| 7.0.1
Microsoft.EntityFrameworkCore.Templates| 7.0.1
Microsoft.EntityFrameworkCore.SqlServer| 7.0.1
Microsoft.EntityFrameworkCore.Specification.Tests| 7.0.1
Microsoft.EntityFrameworkCore| 7.0.1
dotnet-ef| 7.0.1
Microsoft.EntityFrameworkCore.Abstractions| 7.0.1
Microsoft.EntityFrameworkCore.InMemory| 7.0.1
Microsoft.EntityFrameworkCore.Sqlite.Core| 7.0.1
Microsoft.Data.Sqlite| 7.0.1
Microsoft.Data.Sqlite.Core| 7.0.1
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 7.0.1
Microsoft.EntityFrameworkCore.Analyzers| 7.0.1
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 7.0.1
Microsoft.EntityFrameworkCore.Cosmos| 7.0.1
Microsoft.EntityFrameworkCore.Design| 7.0.1
Microsoft.EntityFrameworkCore.Proxies| 7.0.1
Microsoft.EntityFrameworkCore.Relational| 7.0.1
Microsoft.EntityFrameworkCore.Sqlite| 7.0.1
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 7.0.1
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 7.0.1
Microsoft.EntityFrameworkCore.Tools| 7.0.1
Microsoft.TemplateEngine.Abstractions| 7.0.101
Microsoft.TemplateSearch.Common| 7.0.101
Microsoft.TemplateEngine.Utils| 7.0.101
Microsoft.TemplateEngine.TemplateLocalizer.Core| 7.0.101
Microsoft.TemplateEngine.Tasks| 7.0.101
Microsoft.TemplateEngine.Core| 7.0.101
Microsoft.TemplateEngine.Edge| 7.0.101
Microsoft.TemplateEngine.Core.Contracts| 7.0.101
Microsoft.TemplateEngine.IDE| 7.0.101
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 7.0.101
Microsoft.TemplateEngine.TemplateLocalizer| 7.0.101
Microsoft.CodeAnalysis.NetAnalyzers| 7.0.0-preview1.22559.1
Microsoft.CodeAnalysis.PublicApiAnalyzers| 3.3.4-beta1.22559.1
Microsoft.CodeAnalysis.AnalyzerUtilities| 3.3.4-beta1.22559.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter| 3.3.4-beta1.22559.1
Microsoft.CodeAnalysis.Metrics| 3.3.4-beta1.22559.1
Text.Analyzers| 3.3.4-beta1.22559.1
Microsoft.CodeAnalysis.Analyzers| 3.3.4-beta1.22559.1
Microsoft.CodeAnalysis.BannedApiAnalyzers| 3.3.4-beta1.22559.1
Roslyn.Diagnostics.Analyzers| 3.3.4-beta1.22559.1


[//]: # ( Runtime 7.0.1)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b9171b7-40cd-434f-89f4-d5cb4a7b2611/ff32fed2bbffab1661914d469afaea85/dotnet-runtime-7.0.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/038c1cc9-fcd5-4a0e-9547-acab08b0a4ee/c56e6ec6012bc6e9f52897166d543872/dotnet-runtime-7.0.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d699241f-5d19-4d95-b89f-663f74b1b00c/9ddc1099c11e7352be43c1521765ae37/dotnet-runtime-7.0.1-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70c08eee-b8d7-40df-9f6a-6378ba3c29d5/88c83fe52589b3c12d1b79c944d2dfb0/dotnet-runtime-7.0.1-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2591505f-76cc-4fb1-95a3-a988d87314c3/4a5051de9f5677771fcf91e6cb31810a/dotnet-runtime-7.0.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b330412-234f-48c5-957c-c3c8c854a400/8d9a07cc153fd16a828d78c136b47e6f/dotnet-runtime-7.0.1-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3213306c-79a0-48a0-838b-c3df84e53832/742b1fc902f5cdb4d50b966957cb29e3/dotnet-runtime-7.0.1-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14304a5c-0fb7-42c4-b838-e5e9c9dc9d16/7da30cc174d04e0e5d3de1a3bb134eb7/dotnet-runtime-7.0.1-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7f711bc0-aeea-41a0-b5fe-070305902f54/1d3703a0476e12d9b6ac96677c29e34d/dotnet-runtime-7.0.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45a4345a-ed55-49a9-ab5b-4e85e94f489f/54011a3f9000b22ecb3a823f8f1a6f7a/dotnet-runtime-7.0.1-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f738e58-6436-44e1-ac07-3e2aad62dd24/21a125f04fca616b3cac0eb83cf7bda7/dotnet-runtime-7.0.1-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2931bfa7-1c2f-4cc0-b3fe-30cf7f07d3bf/797778c09d866ddc58c755cadb30cdf0/dotnet-runtime-7.0.1-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/31036f6e-2dfd-4468-bd24-81b0c3bef0c2/364a812be1b32e22a16f911fa32b7a62/dotnet-runtime-7.0.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6f54d642-c177-427c-a7a1-026e63cc2ac9/bcd79d98b9e56fc339507ac802051efb/dotnet-runtime-7.0.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/84313d3e-457a-482e-824c-9f1a4ee5260e/65b74b1137f0923e11372521ed595151/dotnet-runtime-7.0.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dd4fcb66-f054-46b6-b874-4ee2221144bb/47174b5a2e1c26cb5391cfadf01c2115/dotnet-runtime-7.0.1-win-x86.zip

[//]: # ( WindowsDesktop 7.0.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/310cb8eb-5672-4b92-bbbf-ecc80993f0f1/c85f4064aae422d1940982aa1812d8e0/windowsdesktop-runtime-7.0.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b0cc5325-ebc4-4eea-939e-0af1c834f392/9e1b35bf2b9496a75c84a0c216486119/windowsdesktop-runtime-7.0.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/04f1126b-2f97-45b8-838d-1844484af007/f9e892ad558abd3db479e16f65c762f3/windowsdesktop-runtime-7.0.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c8e1d5c7-9134-4602-82d0-1a432bb85a31/d6ea5d12d114016756321ae9c77971bf/windowsdesktop-runtime-7.0.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ccdf433a-4112-49d5-8ade-183dac308ac6/eec9e7b2843844a78d34c9c9916a63e5/windowsdesktop-runtime-7.0.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/652cb6bc-656c-47fc-ba47-fbc690267717/1f2ceb2e999b5dcb60725857b70d3fb7/windowsdesktop-runtime-7.0.1-win-x86.zip

[//]: # ( ASP 7.0.1)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e353b69-78d7-4223-86e9-77bd08c751a1/253e8781ea13f02cb25d64ac0119ceff/aspnetcore-runtime-7.0.1-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3d97ec5-f36c-45e5-bd0f-c58b0c468ec2/0b97b0983d826f854d9328165393bf1e/aspnetcore-runtime-7.0.1-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/404ea979-baca-4013-a269-0977d3d5b244/8a35cc5ddc772c3c116883b510c751c1/aspnetcore-runtime-7.0.1-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/690c4e78-c977-4dd6-bda0-a29a43725ef5/8879713201ec0c197b3e843a12cbd43d/aspnetcore-runtime-7.0.1-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/94c8bcf8-2bbf-40a7-b5b5-bc312b465095/55cbcba3871c0174caff1352d5a8981a/aspnetcore-runtime-7.0.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f0e5e7f-cf41-4ece-a728-eab7894157cc/b043910ee98786617d99cef8e8914c23/aspnetcore-runtime-7.0.1-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c8fce04-9135-4e2d-af4f-ef8b23a1e467/67493d21915b734225ded1ac7c311005/aspnetcore-runtime-7.0.1-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d8f8533-29b6-44b4-9b12-12dd99e8380a/70eda23293055dfa566386c4b6e71ebc/aspnetcore-runtime-7.0.1-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/156f4ded-c658-490a-b5a4-9964d0a60582/90d974aeed5cdaddf0fa1c23b8579142/aspnetcore-runtime-7.0.1-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aeb10637-cad6-4012-9d07-d1d5c99b0ed3/b7d16e58e43d05fb9490b47a23062604/aspnetcore-runtime-7.0.1-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5fa10f19-3c28-48f5-80d7-ad3fa3c7c8f6/2792440586b3ad7198b175a420d2f5ac/aspnetcore-runtime-7.0.1-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/97aa4501-7ce1-44a6-82bf-dd163af6dc68/39205a30b68f0f302ad5959d4734ff7b/aspnetcore-runtime-7.0.1-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/803d89f6-7e2c-4af0-9908-05ffeef3e158/e45d67f632709286e046759545e9f87f/aspnetcore-runtime-7.0.1-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/352e02d2-66be-48d5-b9bf-959a9a02982d/e29621ccbdb41d69b06bb29b4434b13a/dotnet-hosting-7.0.1-win.exe

[//]: # ( SDK 7.0.101)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47ad40b2-9def-407d-bc2e-9aaee72d7aff/49b0efe2a12409e3577b6bf07cf22413/dotnet-sdk-7.0.101-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/caa0e6fb-770c-4b21-ba55-30154a7a9e11/3231af451861147352aaf43cf23b16ea/dotnet-sdk-7.0.101-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bde0b4e5-2b2c-4046-a74f-6618bfa8ab8a/3170cd4312552c2eba2a0de3acd85337/dotnet-sdk-7.0.101-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99a7ae17-a6a6-4685-b56c-aa16725d4b09/44d53b4831cfc08b4b489cca8cc32726/dotnet-sdk-7.0.101-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0505e23d-d976-4f2b-bf7f-6dda8e367434/05db9742841f8ad46f2e7d8e5eeafb5e/dotnet-sdk-7.0.101-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fe73a07-575d-4cb4-b2d3-c23d89e5085f/d8b2b7e1c0ed99c1144638d907c6d152/dotnet-sdk-7.0.101-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ea9de698-864c-4ddb-8ff3-1bf068c6b1a7/cf5d147f2c167317394058deb4d4b0a7/dotnet-sdk-7.0.101-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9df94f7-3ea2-41b6-abde-dcb9caa87056/9df759093dcdbc1a1b98feede2da8aaa/dotnet-sdk-7.0.101-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/937c147f-28e2-4f09-b775-c3e3f910fa92/d44e678722d66d028061cd3cf09bfebd/dotnet-sdk-7.0.101-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58c27f9f-f988-4a42-be1a-0747657952f0/32c855c8c0ff149e4b3662ff3bc3e632/dotnet-sdk-7.0.101-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e954c7e-1458-41d8-8d12-1b8dbd48267c/70ec09dd21f4e889660ff91b6a7af2c5/dotnet-sdk-7.0.101-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6ce04a7f-c96a-40f2-93ee-7054ceff00c6/4a4dd2950f3de9f053ffd5a99bd6a19c/dotnet-sdk-7.0.101-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/35660869-0942-4c5d-8692-6e0d4040137a/4921a36b578d8358dac4c27598519832/dotnet-sdk-7.0.101-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/25a8e07d-21fb-46fe-a21e-33c7972d4683/50ba527abe01a9619ace5d8cc2450b70/dotnet-sdk-7.0.101-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5ef833cd-af50-4be1-ab11-6568fd1d5df0/c194ec2852c740f3bee21a6cedc1f96c/dotnet-sdk-7.0.101-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5bf770d9-ed64-4185-abdb-e0d966c563cb/5a46d049f46f28dd753aeb7a3a292af8/dotnet-sdk-7.0.101-win-x86.zip
