# .NET 7.0.10  - August 08, 2023

The .NET 7.0.10 and .NET SDK 7.0.400 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.400
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.10 release carries security fixes.

[CVE-2023-38178 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38178)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET Kestrel where a malicious client can bypass QUIC stream limit in HTTP/3 in both ASP.NET  and .NET runtimes resulting in denial of service.

[CVE-2023-35390 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-35390)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists when some dotnet commands are used in directories with weaker permissions which can result in remote code execution.

[CVE-2023-38180 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38180)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1, .NET 6.0, and .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Kestrel where, on detecting a potentially malicious client, Kestrel will sometimes fail to disconnect it, resulting in denial of service.

[CVE-2023-35391 - .NET Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-35391)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET core 2.1, .NET 6.0 and, .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in ASP.NET Core 2.1, .NET 6.0 and, .NET 7.0 applications using SignalR when redis backplane use might result in information disclosure.

### Additional fixes in this release

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.10+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8673](https://github.com/dotnet/core/issues/8673) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.10.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.10-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.10-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.10+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.10+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.10+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.10+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.10+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.10+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.10xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.10
Microsoft.WindowsDesktop.App.Ref | 7.0.10
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.10
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.10
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.10
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.10
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.10
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.10
Microsoft.NETCore.App.Ref | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.10
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.10
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.10
Microsoft.NETCore.App.Host.win-x64 | 7.0.10
Microsoft.NETCore.App.Host.win-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.10
Microsoft.NETCore.App.Host.win-arm | 7.0.10
Microsoft.NETCore.App.Host.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.10
Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.10
Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.10
Microsoft.DotNet.ILCompiler | 7.0.10
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.10
Microsoft.NETCore.App.Composite | 7.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.10
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.10
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.10
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.10
Microsoft.NETCore.App.Host.linux-x64 | 7.0.10
Microsoft.NETCore.App.Host.win-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.10
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.10
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.10
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.10
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.10
Microsoft.NETCore.App.Host.linux-arm | 7.0.10
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm | 7.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.10
Microsoft.NETCore.DotNetHost | 7.0.10
Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.10
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.10
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.10
Microsoft.AspNetCore.Authentication.Certificate | 7.0.10
Microsoft.AspNetCore.Authorization | 7.0.10
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.10
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.10
Microsoft.AspNetCore.Components | 7.0.10
Microsoft.AspNetCore.Components.Analyzers | 7.0.10
Microsoft.AspNetCore.Components.Authorization | 7.0.10
Microsoft.AspNetCore.Components.CustomElements | 7.0.10
Microsoft.AspNetCore.Components.Forms | 7.0.10
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.10
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.10
Microsoft.AspNetCore.Connections.Abstractions | 7.0.10
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.10
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.10
Microsoft.dotnet-openapi | 7.0.10
AspNetCoreRuntime.7.0.x86 | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.10
AspNetCoreRuntime.7.0.x64 | 7.0.10
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.10
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.10
Microsoft.AspNetCore.Authentication.Twitter | 7.0.10
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.10
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.10
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.10
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.10
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.10
Microsoft.AspNetCore.Grpc.Swagger | 0.3.10
Microsoft.AspNetCore.HeaderPropagation | 7.0.10
Microsoft.AspNetCore.Http.Connections.Common | 7.0.10
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.10
Microsoft.AspNetCore.Http.Connections.Client | 7.0.10
Microsoft.AspNetCore.Identity.UI | 7.0.10
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.10
Microsoft.AspNetCore.Mvc.Testing | 7.0.10
Microsoft.AspNetCore.OpenApi | 7.0.10
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.10
Microsoft.AspNetCore.Owin | 7.0.10
Microsoft.AspNetCore.SignalR.Client | 7.0.10
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.10
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.10
Microsoft.AspNetCore.SignalR.Common | 7.0.10
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.10
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.10
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.10
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.10
Microsoft.AspNetCore.SpaProxy | 7.0.10
Microsoft.Authentication.WebAssembly.Msal | 7.0.10
Microsoft.AspNetCore.TestHost | 7.0.10
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.10
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.10
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.10
Microsoft.AspNetCore.Cryptography.Internal | 7.0.10
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.10
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.10
Microsoft.AspNetCore.Metadata | 7.0.10
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.10
Microsoft.Extensions.Identity.Core | 7.0.10
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.10
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.10
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.10
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.10
Microsoft.Extensions.FileProviders.Embedded | 7.0.10
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.10
Microsoft.Extensions.Http.Polly | 7.0.10
Microsoft.Extensions.Features | 7.0.10
Microsoft.Extensions.Localization.Abstractions | 7.0.10
Microsoft.Extensions.Identity.Stores | 7.0.10
Microsoft.JSInterop | 7.0.10
Microsoft.JSInterop.WebAssembly | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.10
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.10
Microsoft.AspNetCore.Authentication.Facebook | 7.0.10
Microsoft.AspNetCore.Authentication.Google | 7.0.10
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.10
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.10
Microsoft.AspNetCore.Components.Web | 7.0.10
Microsoft.AspNetCore.Components.WebAssembly | 7.0.10
Microsoft.AspNetCore.Components.WebView | 7.0.10
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.10
Microsoft.AspNetCore.DataProtection | 7.0.10
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.10
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.10
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.10
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.10
Microsoft.AspNetCore.JsonPatch | 7.0.10
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.10
Microsoft.Extensions.ObjectPool | 7.0.10
Microsoft.Extensions.WebEncoders | 7.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.10
dotnet-sql-cache | 7.0.10
Microsoft.AspNetCore.App.Ref | 7.0.10
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.10
Microsoft.Extensions.ApiDescription.Client | 7.0.10
Microsoft.Extensions.ApiDescription.Server | 7.0.10
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.10
Microsoft.Extensions.Caching.SqlServer | 7.0.10
Microsoft.Extensions.Logging.AzureAppServices | 7.0.10
Microsoft.Extensions.Localization | 7.0.10
FSharp.Core | 7.0.400
Microsoft.DotNet.Common.ItemTemplates | 7.0.400
Microsoft.DotNet.ApiCompat.Task | 7.0.400
Microsoft.DotNet.ApiCompat.Tool | 7.0.400
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.400
FSharp.Compiler.Service | 43.7.400
Microsoft.NET.Build.Containers | 7.0.400
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.10
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.10
Microsoft.EntityFrameworkCore | 7.0.10
dotnet-ef | 7.0.10
Microsoft.EntityFrameworkCore.Proxies | 7.0.10
Microsoft.EntityFrameworkCore.Sqlite | 7.0.10
Microsoft.EntityFrameworkCore.Design | 7.0.10
Microsoft.EntityFrameworkCore.Relational | 7.0.10
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.10
Microsoft.Data.Sqlite.Core | 7.0.10
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.10
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.10
Microsoft.EntityFrameworkCore.SqlServer | 7.0.10
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.10
Microsoft.EntityFrameworkCore.Templates | 7.0.10
Microsoft.EntityFrameworkCore.Tools | 7.0.10
Microsoft.Data.Sqlite | 7.0.10
Microsoft.EntityFrameworkCore.Analyzers | 7.0.10
Microsoft.EntityFrameworkCore.Cosmos | 7.0.10
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.10
Microsoft.EntityFrameworkCore.Abstractions | 7.0.10
Microsoft.EntityFrameworkCore.InMemory | 7.0.10
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.10
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.301
Microsoft.TemplateEngine.Utils | 7.0.301
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.301
Microsoft.TemplateEngine.Edge | 7.0.301
Microsoft.TemplateEngine.Core.Contracts | 7.0.301
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.301
Microsoft.TemplateSearch.Common | 7.0.301
Microsoft.TemplateEngine.Authoring.CLI | 7.0.301
Microsoft.TemplateEngine.Abstractions | 7.0.301
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.301
Microsoft.TemplateEngine.Core | 7.0.301
Microsoft.TemplateEngine.IDE | 7.0.301
Microsoft.CodeAnalysis.Metrics | 3.3.4-beta1.23354.4
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.3.4-beta1.23354.4
Microsoft.CodeAnalysis.NetAnalyzers | 7.0.4-preview1.23354.4
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.3.4-beta1.23354.4
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.3.4-beta1.23354.4
Text.Analyzers | 3.3.4-beta1.23354.4
Microsoft.CodeAnalysis.Analyzers | 3.3.4-beta1.23354.4
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.3.4-beta1.23354.4
Roslyn.Diagnostics.Analyzers | 3.3.4-beta1.23354.4
Microsoft.NET.Build.Containers | 7.0.307
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.307
Microsoft.DotNet.ApiCompat.Task | 7.0.307
Microsoft.DotNet.ApiCompat.Tool | 7.0.307
Microsoft.DotNet.Common.ItemTemplates | 7.0.307
Microsoft.TemplateEngine.Authoring.CLI | 7.0.307
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.307
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.307
Microsoft.TemplateEngine.Abstractions | 7.0.307
Microsoft.TemplateEngine.Core.Contracts | 7.0.307
Microsoft.TemplateEngine.Core | 7.0.307
Microsoft.TemplateEngine.IDE | 7.0.307
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.307
Microsoft.TemplateEngine.Edge | 7.0.307
Microsoft.TemplateSearch.Common | 7.0.307
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.307
Microsoft.TemplateEngine.Utils | 7.0.307
Microsoft.DotNet.Common.ItemTemplates | 7.0.110
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.110
Microsoft.DotNet.ApiCompat.Task | 7.0.110
Microsoft.DotNet.ApiCompat.Tool | 7.0.110
Microsoft.TemplateEngine.Utils | 7.0.110
Microsoft.TemplateEngine.Core | 7.0.110
Microsoft.TemplateEngine.Edge | 7.0.110
Microsoft.TemplateEngine.IDE | 7.0.110
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.110
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.110
Microsoft.TemplateEngine.Abstractions | 7.0.110
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.110
Microsoft.TemplateEngine.Tasks | 7.0.110
Microsoft.TemplateEngine.Core.Contracts | 7.0.110
Microsoft.TemplateSearch.Common | 7.0.110

[//]: # ( Runtime 7.0.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d70ffd70-bab7-40aa-987d-54212f4df58a/990979ce74fb400a2873830474425894/dotnet-runtime-7.0.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/023e4544-e6f6-4d2a-ab91-ff63eff97db5/26c02c09fe3a5d57248caa0a0d9e8254/dotnet-runtime-7.0.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a85110ae-0d9c-4455-ae7f-8380cd0c3141/86a51af60b7ada18d87ff4f3959d9c4f/dotnet-runtime-7.0.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5a36ca9-7b07-48bc-85a5-620362838412/8d06152abacd7e66e4a5816be11cd67a/dotnet-runtime-7.0.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86aa22a6-8d59-47fc-81e8-8ed6d6f50112/e30f903f73f6574d638b6a04572818ec/dotnet-runtime-7.0.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9cd1834-1370-4458-98f6-d0d035dcd41e/6d2ca4b900398e717287ad0e75eb9a3e/dotnet-runtime-7.0.10-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/024bc4f5-660a-4e35-ad1b-5ce1c7bfcdcd/f960bd590ef4d9610272b21182ad0590/dotnet-runtime-7.0.10-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd4660d9-e747-42b7-abe9-eaedff0356ca/8a6f41f5ee23ed510c442d1350bda8d3/dotnet-runtime-7.0.10-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/01f15ec6-0c10-4e0a-bd10-efd247c78223/95cad690b8ed83850a4355c043964925/dotnet-runtime-7.0.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6caa3ca-cb18-4891-b188-aa661741ec01/5df34b59b10e79714bac97cfdd6e86db/dotnet-runtime-7.0.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/52f12459-47c0-42f3-9349-92fcf8afccf4/f7d83bc27b315abe00c45e6adf73ea9b/dotnet-runtime-7.0.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/004bf2c6-32e3-438a-b817-95b31c1c8203/a367d16dc03a322884e06eb35eedd5e1/dotnet-runtime-7.0.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3811bb07-e655-45c7-9817-7faaba076977/6bdd137ea2e7f9c42e427a5216539fbc/dotnet-runtime-7.0.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/38697826-dd4f-4f91-be6e-a5e1e474d86f/92d07240629a05531ea686798d9f0565/dotnet-runtime-7.0.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/254a93dc-9249-4160-be48-b0500a0eb8f1/24718e72d2ad7835073cdc9f22bb3a59/dotnet-runtime-7.0.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8a1b5ce5-9a74-4f53-9495-b7feb08f7438/9bebefc3a987b64296561f4369c034de/dotnet-runtime-7.0.10-win-x86.zip

[//]: # ( WindowsDesktop 7.0.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c8a46c7f-effb-4ed1-8066-67a6623a915a/18d58ff2a47fb0d9bbd347efe873d503/windowsdesktop-runtime-7.0.10-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/04cd3803-7788-4d81-ad8e-629c4bd836e7/a714cdb92cd4a3ecbaa4440dee39d1e9/windowsdesktop-runtime-7.0.10-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/747f4a98-2586-4bc6-b828-34f35e384a7d/44225cfd9d365855ec77d00c4812133c/windowsdesktop-runtime-7.0.10-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b6e7c764-750b-471e-bcd1-3780f19b10bd/087fbd1e845e956daf3aef4d5e8dd798/windowsdesktop-runtime-7.0.10-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9812249d-fc42-41ab-bd2e-6e858d5dd5a7/95fa5a1a77eace4482bcb98ede190003/windowsdesktop-runtime-7.0.10-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ae1a8159-1995-4aa0-ac8b-9657d19d9fa6/621029185f8132804e49be94b17aafd2/windowsdesktop-runtime-7.0.10-win-x86.zip

[//]: # ( ASP 7.0.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1302c30-5719-413a-9090-56a8725cabe9/4f505eba5fb19dd85a5c837475579ef2/aspnetcore-runtime-7.0.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/712946ec-0b43-436c-abfb-3abab81f6cad/c83ba8df4dab39957ffa5e93604f0b32/aspnetcore-runtime-7.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e192ba1-6a8d-4c68-9de4-9dfc42ac34c1/ab8ecfba5a745ec0b8aa28c6d6c47d37/aspnetcore-runtime-7.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/363c0cec-1428-48dc-b3ff-6a7b0c6b83c4/ae5e86bcbb885e9cd07f71f3f93f2935/aspnetcore-runtime-7.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b584b5a-03b2-4369-b3ac-7498b031fc02/ec1848ba5f9715f4c1d93c10f47d11f2/aspnetcore-runtime-7.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08af0433-9ec3-4604-9d1c-85e3922a4524/396b340b4ee38765d7462e2fc61a5e3c/aspnetcore-runtime-7.0.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/516a672c-9216-4592-be66-a628a166b583/fec0aa593bc700a5f5d3860abf1a4af8/aspnetcore-runtime-7.0.10-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d10c9d59-a624-4175-9069-4a13fcf9a1c4/427bb8da02c7907bc2f3115144c1515f/aspnetcore-runtime-7.0.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ee5b7a0c-3929-4a0f-abdd-9a1db8eaddf1/f5d7aebceed2058a19de3fa7d0f25be6/aspnetcore-runtime-7.0.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f1777e79-21d8-4ed8-a529-3f212f4b5262/e685f2224f7140dc10bc0e0b47827e3a/aspnetcore-runtime-7.0.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5c7f3e9c-d821-4162-8aec-cb0bc93e8c78/094f59a8a28adbba90dd197071aefae5/aspnetcore-runtime-7.0.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/71f8f5e4-8e6d-493b-b16f-96c6fa34336a/8be06fb14a04a1c1383161c64e7e359b/aspnetcore-runtime-7.0.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/df741b79-8ecb-4a08-b333-c63bbc473dbc/01ca8bcc9f5e50c9c4fcd4b1d981d297/aspnetcore-runtime-7.0.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d489c5d0-4d0f-4622-ab93-b0f2a3e92eed/101a2fae29a291956d402377b941f401/dotnet-hosting-7.0.10-win.exe

[//]: # ( SDK 7.0.400)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59aac694-6949-44c1-960b-2b6feca7c36c/d670fb92396fb5bdb0173b9114611841/dotnet-sdk-7.0.400-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16b0b1af-6eab-4f9e-b9a4-9b29f6a1d681/4624e54b61cae05b1025211482f9c5e9/dotnet-sdk-7.0.400-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4decd815-754e-43cd-aede-a236aea67632/f3aee01741cd415712a5ff72fc7117c9/dotnet-sdk-7.0.400-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5de7b44-ee45-4b50-a228-f2fec03ddff4/465d5506ce8ff1eee0c928ac40b341bf/dotnet-sdk-7.0.400-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0eb99e8-ee6e-46f4-a6cb-b567c7f2ce74/b00825310f757b64361d8974926d1c5c/dotnet-sdk-7.0.400-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbfe6cc7-dd82-4cec-b267-31ed988b1652/c60ab4793c3714be878abcb9aa834b63/dotnet-sdk-7.0.400-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/006fcd0f-5c39-462b-8425-8af5c66915d0/de20d3b86725a79b7d0de0f3f9c86b05/dotnet-sdk-7.0.400-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3df92af2-c066-403b-ae65-10b7ec879b32/a4a5a807d92510d5b74ee8fef9b2babd/dotnet-sdk-7.0.400-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f4c17ae1-56c5-4d79-8ce2-31c46a861a96/e39ebd96c092d4acb394c864aa0c8eaa/dotnet-sdk-7.0.400-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a603c4a-7e79-44ef-8e09-426a2c1c6e60/eb3dea0e50d73fbf28edf88aa8378e38/dotnet-sdk-7.0.400-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/86c5f14d-7245-4c89-8737-061e84b19b82/088a48f302c5e24d10f7003901743947/dotnet-sdk-7.0.400-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f698d70d-4812-4f76-8476-2aba916f389a/945653a9d68b40571024d0b3430f694e/dotnet-sdk-7.0.400-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e3f91c3f-dbcc-44cb-a319-9cb15c9b61b9/6c87d96b2294afed74ccf414e7747b5a/dotnet-sdk-7.0.400-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/fe18f87e-e319-4042-8ed4-307629293bec/9b35c7b563b4800403d17797b25e0b06/dotnet-sdk-7.0.400-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1944fd55-45c7-4570-b31d-2ebe36a32858/0625a9cee80fff3d1b388e25ed132e83/dotnet-sdk-7.0.400-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0f17575a-a6b0-4365-9b79-64db70022d23/56e0da10678e4b2cad0cba0a83a561af/dotnet-sdk-7.0.400-win-x86.zip
