# .NET 7.0.11  - September 12, 2023

The .NET 7.0.11 and .NET SDK 7.0.401 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.401
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.11 release carries security fixes.

**Note:** The vulnerabilities [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36792), [CVE-2023-36793]( https://www.cve.org/CVERecord?id=CVE-2023-36793), [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36794), [CVE-2023-36796]( https://www.cve.org/CVERecord?id=CVE-2023-36796) are all resolved by a single patch. Get this update to resolve all of them.

[CVE-2023-36792 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36792)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36793 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36793)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36794 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36794)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36796 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36796)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36799 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36799)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET where reading a maliciously crafted X.509 certificate may result in Denial of Service. This issue only affects Linux systems.

### Additional fixes in this release

* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A7.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.11+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8758](https://github.com/dotnet/core/issues/8758) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.11.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.11-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.11-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/september-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.11+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.11+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.11+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.11+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.11+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.11+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.11xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.11
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.11
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.11
Microsoft.WindowsDesktop.App.Ref | 7.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.11
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.11
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.11
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.11
Microsoft.NETCore.App.Host.osx-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm | 7.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.11
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.11
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.11
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.11
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.11
Microsoft.NETCore.App.Host.win-arm | 7.0.11
Microsoft.NETCore.App.Host.win-arm64 | 7.0.11
Microsoft.NETCore.App.Host.win-x64 | 7.0.11
Microsoft.NETCore.App.Host.win-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.11
Microsoft.DotNet.ILCompiler | 7.0.11
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Composite | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.11
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.11
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.11
Microsoft.NETCore.App.Host.linux-arm | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.11
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.11
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.11
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.11
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.11
Microsoft.NETCore.App.Host.linux-x64 | 7.0.11
Microsoft.NETCore.App.Ref | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.11
Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.11
System.Threading.RateLimiting | 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.11
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.11
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.11
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.11
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.11
Microsoft.NETCore.DotNetHost | 7.0.11
Microsoft.NETCore.DotNetHostPolicy | 7.0.11
Microsoft.NETCore.DotNetAppHost | 7.0.11
Microsoft.Windows.Compatibility | 7.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.11
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.11
System.DirectoryServices.AccountManagement | 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.11
AspNetCoreRuntime.7.0.x86 | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.11
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.11
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.11
Microsoft.AspNetCore.Components.Analyzers | 7.0.11
Microsoft.AspNetCore.Components.CustomElements | 7.0.11
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.11
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.11
Microsoft.AspNetCore.Cryptography.Internal | 7.0.11
Microsoft.AspNetCore.Http.Connections.Client | 7.0.11
Microsoft.AspNetCore.Mvc.Testing | 7.0.11
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.11
Microsoft.AspNetCore.SignalR.Common | 7.0.11
Microsoft.AspNetCore.SpaProxy | 7.0.11
Microsoft.Extensions.ApiDescription.Server | 7.0.11
Microsoft.dotnet-openapi | 7.0.11
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.11
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.11
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.11
Microsoft.Extensions.Features | 7.0.11
Microsoft.Extensions.FileProviders.Embedded | 7.0.11
Microsoft.Extensions.ObjectPool | 7.0.11
Microsoft.Extensions.WebEncoders | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.11
Microsoft.AspNetCore.Components.Authorization | 7.0.11
Microsoft.AspNetCore.Connections.Abstractions | 7.0.11
Microsoft.AspNetCore.OpenApi | 7.0.11
Microsoft.AspNetCore.SignalR.Client | 7.0.11
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.11
dotnet-sql-cache | 7.0.11
Microsoft.AspNetCore.App.Ref | 7.0.11
Microsoft.AspNetCore.Authentication.Certificate | 7.0.11
Microsoft.AspNetCore.Authentication.Google | 7.0.11
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.11
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.11
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.11
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.11
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.11
Microsoft.AspNetCore.Authentication.Twitter | 7.0.11
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.11
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.11
Microsoft.AspNetCore.Components | 7.0.11
Microsoft.AspNetCore.DataProtection | 7.0.11
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.11
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.11
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.11
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.11
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.11
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.11
Microsoft.AspNetCore.Metadata | 7.0.11
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.11
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.11
Microsoft.AspNetCore.Owin | 7.0.11
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.11
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.11
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.11
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.11
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.11
Microsoft.AspNetCore.TestHost | 7.0.11
Microsoft.Authentication.WebAssembly.Msal | 7.0.11
Microsoft.Extensions.Caching.SqlServer | 7.0.11
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.11
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.11
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.11
Microsoft.Extensions.Identity.Stores | 7.0.11
Microsoft.Extensions.Localization.Abstractions | 7.0.11
Microsoft.Extensions.Logging.AzureAppServices | 7.0.11
Microsoft.AspNetCore.Authorization | 7.0.11
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.11
Microsoft.AspNetCore.Components.Forms | 7.0.11
Microsoft.AspNetCore.Components.Web | 7.0.11
Microsoft.AspNetCore.Components.WebAssembly | 7.0.11
Microsoft.AspNetCore.Components.WebView | 7.0.11
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.11
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.11
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.11
Microsoft.AspNetCore.Identity.UI | 7.0.11
Microsoft.AspNetCore.Grpc.Swagger | 0.3.11
Microsoft.AspNetCore.HeaderPropagation | 7.0.11
Microsoft.AspNetCore.Http.Connections.Common | 7.0.11
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.11
Microsoft.AspNetCore.JsonPatch | 7.0.11
Microsoft.Extensions.ApiDescription.Client | 7.0.11
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.11
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.11
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.11
Microsoft.Extensions.Identity.Core | 7.0.11
Microsoft.Extensions.Http.Polly | 7.0.11
Microsoft.Extensions.Localization | 7.0.11
Microsoft.JSInterop | 7.0.11
Microsoft.JSInterop.WebAssembly | 7.0.11
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.11
AspNetCoreRuntime.7.0.x64 | 7.0.11
Microsoft.AspNetCore.Authentication.Facebook | 7.0.11
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.11
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.11
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.11
FSharp.Compiler.Service | 43.7.400
Microsoft.DotNet.ApiCompat.Task | 7.0.401
Microsoft.DotNet.Common.ItemTemplates | 7.0.401
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.401
FSharp.Core | 7.0.400
Microsoft.DotNet.ApiCompat.Tool | 7.0.401
Microsoft.NET.Build.Containers | 7.0.401
Microsoft.NET.ILLink.Analyzers | 7.0.100-1.23401.1
Microsoft.NET.ILLink | 7.0.100-1.23401.1
Microsoft.NET.ILLink.Tasks | 7.0.100-1.23401.1
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.11
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.11
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.11
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.11
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.11
Microsoft.Data.Sqlite.Core | 7.0.11
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.11
Microsoft.Data.Sqlite | 7.0.11
dotnet-ef | 7.0.11
Microsoft.EntityFrameworkCore | 7.0.11
Microsoft.EntityFrameworkCore.SqlServer | 7.0.11
Microsoft.EntityFrameworkCore.Tools | 7.0.11
Microsoft.EntityFrameworkCore.Cosmos | 7.0.11
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.11
Microsoft.EntityFrameworkCore.Design | 7.0.11
Microsoft.EntityFrameworkCore.Abstractions | 7.0.11
Microsoft.EntityFrameworkCore.Proxies | 7.0.11
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.11
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.11
Microsoft.EntityFrameworkCore.Sqlite | 7.0.11
Microsoft.EntityFrameworkCore.Templates | 7.0.11
Microsoft.EntityFrameworkCore.Analyzers | 7.0.11
Microsoft.EntityFrameworkCore.Relational | 7.0.11
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.11
Microsoft.EntityFrameworkCore.InMemory | 7.0.11
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.11
Microsoft.NET.Build.Containers | 7.0.308
FSharp.Core | 7.0.300
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.Common.ItemTemplates | 7.0.308
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.308
Microsoft.DotNet.ApiCompat.Task | 7.0.308
Microsoft.DotNet.ApiCompat.Tool | 7.0.308
Microsoft.TemplateEngine.IDE | 7.0.308
Microsoft.TemplateEngine.Core | 7.0.308
Microsoft.TemplateEngine.Core.Contracts | 7.0.308
Microsoft.TemplateEngine.Edge | 7.0.308
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.308
Microsoft.TemplateEngine.Abstractions | 7.0.308
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.308
Microsoft.TemplateEngine.Utils | 7.0.308
Microsoft.TemplateSearch.Common | 7.0.308
Microsoft.TemplateEngine.Authoring.CLI | 7.0.308
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.308
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.308
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.Common.ItemTemplates | 7.0.111
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.111
Microsoft.DotNet.ApiCompat.Tool | 7.0.111
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Task | 7.0.111
Microsoft.TemplateEngine.Abstractions | 7.0.111
Microsoft.TemplateEngine.Core.Contracts | 7.0.111
Microsoft.TemplateEngine.Core | 7.0.111
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.111
Microsoft.TemplateEngine.Utils | 7.0.111
Microsoft.TemplateSearch.Common | 7.0.111
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.111
Microsoft.TemplateEngine.Edge | 7.0.111
Microsoft.TemplateEngine.IDE | 7.0.111
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.111
Microsoft.TemplateEngine.Tasks | 7.0.111

[//]: # ( Runtime 7.0.11)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c532797c-9e62-4c96-8148-7405aa87214e/4a3d0d8080312dc5035475fc71e619c3/dotnet-runtime-7.0.11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6079be92-f70b-447f-bdbb-ee85e5b04d14/249738ad78341a40f9765599281579da/dotnet-runtime-7.0.11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/598b2f8a-9290-4551-b2ab-a739287340d1/21db5d8ad90b98548eb8833bfee72886/dotnet-runtime-7.0.11-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/345580e9-0ac9-4413-bdb8-ab64f2370afa/7b3951b964d20bb18aa360eff38687a3/dotnet-runtime-7.0.11-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4314a32-4c6c-4dde-a550-0c4bcc073f20/e6a2ecf1b3a2304782b9d409e042d4d9/dotnet-runtime-7.0.11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/948e3f45-a2c8-4d34-954e-a360851b7ff2/aad7d4a9b73242625bc33b0e9c124478/dotnet-runtime-7.0.11-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/238745c8-e7da-43bd-aeb6-3104dae4f5d8/85cec9809108afd239acbe215ba60231/dotnet-runtime-7.0.11-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6120c903-2058-4ea6-a62a-6b246750c2c9/28d586c9ecacc7fe95a65f98dc6acd6d/dotnet-runtime-7.0.11-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9fc3bdba-51c6-4a7b-a793-74efa9d34592/7170c728ed1f6376bba399d8424da94c/dotnet-runtime-7.0.11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ffaab50c-bc8e-4b4a-a1e1-7bd859a3e7dc/5e6a62a33021d44df7807e3fcca4d111/dotnet-runtime-7.0.11-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e9bf5208-ac4c-4193-b31d-55e2b0f49302/ae0850806b0cfb3f3a34aab20077bfa6/dotnet-runtime-7.0.11-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/323c9935-7fc2-4f6c-b3fb-d97eaa4c9b8e/7d615f339f44542cf5d076e01564111e/dotnet-runtime-7.0.11-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e05aedd4-c6e1-4cf8-91d6-4df84e51adb9/cadaaa83f7403cff53d5d8a491ac8049/dotnet-runtime-7.0.11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3aace640-089d-440e-8618-205791c78ed1/a3318753f9487688bc2cc135987e616c/dotnet-runtime-7.0.11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f7e3cc3a-6980-4613-ac0c-bf5027d34c00/bd9470f2839426866692b9e25165cbc2/dotnet-runtime-7.0.11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e048c721-51bd-4f38-9590-181be22574b0/c1c4139a3d2b4abe98a05afb25511f11/dotnet-runtime-7.0.11-win-x86.zip

[//]: # ( WindowsDesktop 7.0.11)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/94186fe9-7c8e-46d7-b9bc-69759f43e8b0/f9214eb5df67e0b98f0432cf61862de3/windowsdesktop-runtime-7.0.11-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4e63b2bc-d8cf-4463-b35f-995511b4ab48/02a0f00818a6d417d1e04bc123dd3866/windowsdesktop-runtime-7.0.11-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2ce1cbbe-71d1-44e7-8e80-d9ae336b9b17/a2706bca3474eef8ef95e10a12ecc2a4/windowsdesktop-runtime-7.0.11-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d7386711-d321-4cdc-8f2b-03c4f163cfe1/820a69fe4fa994a6fb7c9e1170f3c6cc/windowsdesktop-runtime-7.0.11-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8390b217-55b7-497e-ba1b-b70f0a93cf29/39ab1928787ffc939d95e97c1f5a33e4/windowsdesktop-runtime-7.0.11-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a18a5126-24c5-4b56-9798-e38540056ad1/2194a72e35375aeb343d8569429a4ede/windowsdesktop-runtime-7.0.11-win-x86.zip

[//]: # ( ASP 7.0.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13faaf3c-473b-4bd4-97d4-9bddca0b1d2c/7c5f8e9b3e52f08786a20cd4b0aebeb5/aspnetcore-runtime-7.0.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd1c8c35-921d-44dd-8296-f76126a73e86/5c7c20fb1df66c7b1853f77ffe858d1c/aspnetcore-runtime-7.0.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3d614b2-cb91-41f9-84ba-8bd36bfa5307/038d579fd0d3c93b33022100bbd4662f/aspnetcore-runtime-7.0.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb96b353-eb34-4e93-a033-8b82ea49e2d0/411c88f28b840cc3157bcdb9bd1d66bb/aspnetcore-runtime-7.0.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/728a286f-4b05-415c-809d-7f0532119656/70fcf7a013f2db23d319284be18e72ba/aspnetcore-runtime-7.0.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc2c0a53-85a8-4fda-a283-fa28adb5fbe2/8ccade5bc400a5bb40cd9240f003b45c/aspnetcore-runtime-7.0.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7ea90e7-5d92-44d8-9b55-211182814710/af6bbc87d7505be5d4b22f130076a65d/aspnetcore-runtime-7.0.11-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6df3136e-ba50-43e8-a68f-93e347c63693/e1b7ad4c0009723ab3a83db65969d0b7/aspnetcore-runtime-7.0.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/16c96dfa-f009-4828-b138-705621f2bda4/c2d52b10e2d2426a3e759b7a76254324/aspnetcore-runtime-7.0.11-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/56fbfa65-4bf5-40a0-8935-57f09ab3c76b/d80afe4b74d01c07ca74c4670fcfa1f8/aspnetcore-runtime-7.0.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a99861c8-2e00-4587-aaef-60366ca77307/a44ceec2c5d34165ae881600f52edc43/aspnetcore-runtime-7.0.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3aa49a19-636c-431f-b61e-3e007de33fa3/6cb7e36379bad86a6b52bc3a3cb0acbd/aspnetcore-runtime-7.0.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e6ae7629-9b92-4e13-9b77-9c0c48014d2b/c827f3e488b982d21659568d1a36adef/aspnetcore-runtime-7.0.11-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/91644a20-1e21-43c9-8ae0-90e402c1a368/469c198fab110c6c3d822e03509e9aec/dotnet-hosting-7.0.11-win.exe

[//]: # ( SDK 7.0.401)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29525dd0-1dd5-4d8d-9771-5ebad1143c75/b23ca78cef5e8058222584e09b5fe3de/dotnet-sdk-7.0.401-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/799b3459-f1de-4c88-ae38-fd1aa76c2d73/db275a0fe9776b55cf0f81cb0788b6a9/dotnet-sdk-7.0.401-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a7ad24b-3760-4b97-832a-343442230b71/47f76da87cc1fbd3aba31ed33d8063f2/dotnet-sdk-7.0.401-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e17a2aa-0081-4864-9b26-258303d1ad8b/a90a1681b31cbacad3b1400fe16759a0/dotnet-sdk-7.0.401-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e0542a0-cc8f-42a7-b54d-d2ba769281cc/4fe3c409ff5adc012d1e324222d53281/dotnet-sdk-7.0.401-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61f29db0-10a5-4816-8fd8-ca2f71beaea3/e15fb7288eb5bc0053b91ea7b0bfd580/dotnet-sdk-7.0.401-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ca10bac6-3833-476b-8e5c-4a325fd185bd/6f2b2e056c2a4d322cf55d6ea446bc1c/dotnet-sdk-7.0.401-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4246aa3e-4c90-4022-b3d2-5bf36547bfa6/8f75268f923723fb2c4a44b271dbc042/dotnet-sdk-7.0.401-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e0f9aead-ae21-411b-bb38-1c6393fb278a/69566da6d19724215edda3af6a9663cd/dotnet-sdk-7.0.401-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7190497a-9e02-4369-ba8a-29e7a4acc69e/45af3f104e254cc37cf48227bc8e464c/dotnet-sdk-7.0.401-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fff49f46-ce07-4ecc-95d0-00a15b3e0ba8/a7603aa9711ea1559fcdfbe7718949a8/dotnet-sdk-7.0.401-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2ee1445d-e6a0-46b0-a0b7-81cdf900c0ec/aafbf43b9cb33666590417fcf8307e96/dotnet-sdk-7.0.401-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1c8737a4-8cf1-4251-af5f-4a9c119a2489/c42c16d1f664719564353489c2b9b8d8/dotnet-sdk-7.0.401-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f712b4d0-6b4b-42eb-865a-0c42af79eac9/9db3934d73a826a6e898abc70f41085a/dotnet-sdk-7.0.401-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d2716697-da0f-484b-91cd-0b3b5080f1c8/2042332b4a3fc3c10f8177455b2514ed/dotnet-sdk-7.0.401-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d7bd9906-be1d-482f-8e45-a42c1d19cb1e/db9057e1346ce039eb50836406812a1a/dotnet-sdk-7.0.401-win-x86.zip
