# .NET 7.0.12  - October 10, 2023

The .NET 7.0.12 and .NET SDK 7.0.402 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.402
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.12 release carries security fixes.

[CVE-2023-44487 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-44487)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0 RC1, .NET 7.0 ,and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the ASP.NET  Core Kestrel web server where a malicious client may flood the server with specially crafted HTTP/2 requests, causing denial of service.

[CVE-2023-38171 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38171)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A null pointer vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.

[CVE-2023-36435 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36435)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A memory leak vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.


## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8827](https://github.com/dotnet/core/issues/8827) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.12.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.12-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.12-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/october-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.12+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.12+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.12+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.12+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.12+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.12+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.12xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.12
Microsoft.WindowsDesktop.App.Ref | 7.0.12
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.12
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.12
Microsoft.NETCore.App.Host.linux-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.12
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.12
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.12
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.12
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.12
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.12
Microsoft.NETCore.App.Host.osx-x64 | 7.0.12
Microsoft.NETCore.App.Host.win-arm | 7.0.12
Microsoft.NETCore.App.Host.win-x64 | 7.0.12
Microsoft.NETCore.App.Host.win-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.12
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.12
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.12
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.12
Microsoft.DotNet.ILCompiler | 7.0.12
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.12
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.12
Microsoft.NETCore.App.Host.linux-arm | 7.0.12
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.12
Microsoft.NETCore.App.Ref | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.12
Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.12
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.12
Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.12
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.12
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.12
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.12
Microsoft.NETCore.App.Host.win-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.12
Microsoft.NETCore.DotNetHost | 7.0.12
Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.12
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.12
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.12
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Composite | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.12
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.12
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.12
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.12
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.12
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.12
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.12
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.12
Microsoft.AspNetCore.Components.WebView | 7.0.12
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.12
Microsoft.AspNetCore.Connections.Abstractions | 7.0.12
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.12
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.12
Microsoft.AspNetCore.Http.Connections.Client | 7.0.12
Microsoft.AspNetCore.Grpc.Swagger | 0.3.12
Microsoft.AspNetCore.HeaderPropagation | 7.0.12
Microsoft.AspNetCore.Identity.UI | 7.0.12
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.12
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.12
Microsoft.AspNetCore.SignalR.Client | 7.0.12
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.12
Microsoft.AspNetCore.SignalR.Common | 7.0.12
Microsoft.Authentication.WebAssembly.Msal | 7.0.12
Microsoft.dotnet-openapi | 7.0.12
Microsoft.Extensions.ApiDescription.Client | 7.0.12
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.12
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.12
Microsoft.Extensions.Features | 7.0.12
Microsoft.Extensions.Identity.Core | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.12
AspNetCoreRuntime.7.0.x64 | 7.0.12
AspNetCoreRuntime.7.0.x86 | 7.0.12
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.12
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.12
Microsoft.AspNetCore.Components | 7.0.12
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.12
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.12
Microsoft.AspNetCore.Components.Forms | 7.0.12
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.12
Microsoft.AspNetCore.OpenApi | 7.0.12
Microsoft.AspNetCore.Owin | 7.0.12
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.12
Microsoft.AspNetCore.SpaProxy | 7.0.12
Microsoft.Extensions.ApiDescription.Server | 7.0.12
Microsoft.Extensions.Caching.SqlServer | 7.0.12
Microsoft.Extensions.Identity.Stores | 7.0.12
Microsoft.Extensions.Logging.AzureAppServices | 7.0.12
Microsoft.Extensions.ObjectPool | 7.0.12
Microsoft.Extensions.WebEncoders | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.12
dotnet-sql-cache | 7.0.12
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.12
Microsoft.AspNetCore.App.Ref | 7.0.12
Microsoft.AspNetCore.Authentication.Google | 7.0.12
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.12
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.12
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.12
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.12
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.12
Microsoft.AspNetCore.Components.WebAssembly | 7.0.12
Microsoft.AspNetCore.Cryptography.Internal | 7.0.12
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.12
Microsoft.AspNetCore.DataProtection | 7.0.12
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.12
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.12
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.12
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.12
Microsoft.AspNetCore.JsonPatch | 7.0.12
Microsoft.AspNetCore.Metadata | 7.0.12
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.12
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.12
Microsoft.AspNetCore.Mvc.Testing | 7.0.12
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.12
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.12
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.12
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.12
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.12
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.12
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.12
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.12
Microsoft.AspNetCore.Authentication.Facebook | 7.0.12
Microsoft.AspNetCore.Authentication.Certificate | 7.0.12
Microsoft.AspNetCore.Authorization | 7.0.12
Microsoft.AspNetCore.Authentication.Twitter | 7.0.12
Microsoft.AspNetCore.Components.Analyzers | 7.0.12
Microsoft.AspNetCore.Components.Authorization | 7.0.12
Microsoft.AspNetCore.Components.CustomElements | 7.0.12
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.12
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.12
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.12
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.12
Microsoft.AspNetCore.Components.Web | 7.0.12
Microsoft.AspNetCore.Http.Connections.Common | 7.0.12
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.12
Microsoft.AspNetCore.TestHost | 7.0.12
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.12
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.12
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.12
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.12
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.12
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.12
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.12
Microsoft.Extensions.FileProviders.Embedded | 7.0.12
Microsoft.Extensions.Http.Polly | 7.0.12
Microsoft.Extensions.Localization | 7.0.12
Microsoft.Extensions.Localization.Abstractions | 7.0.12
Microsoft.JSInterop | 7.0.12
Microsoft.JSInterop.WebAssembly | 7.0.12
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.112
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.112
Microsoft.DotNet.ApiCompat.Task | 7.0.112
Microsoft.DotNet.Common.ItemTemplates | 7.0.112
FSharp.Compiler.Service | 42.7.101
Microsoft.EntityFrameworkCore.Abstractions | 7.0.12
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.12
Microsoft.EntityFrameworkCore.Design | 7.0.12
Microsoft.EntityFrameworkCore.InMemory | 7.0.12
Microsoft.EntityFrameworkCore.Relational | 7.0.12
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.12
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.12
Microsoft.EntityFrameworkCore.Proxies | 7.0.12
Microsoft.EntityFrameworkCore | 7.0.12
Microsoft.EntityFrameworkCore.SqlServer | 7.0.12
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.12
Microsoft.EntityFrameworkCore.Templates | 7.0.12
Microsoft.EntityFrameworkCore.Tools | 7.0.12
dotnet-ef | 7.0.12
Microsoft.Data.Sqlite.Core | 7.0.12
Microsoft.Data.Sqlite | 7.0.12
Microsoft.EntityFrameworkCore.Analyzers | 7.0.12
Microsoft.EntityFrameworkCore.Cosmos | 7.0.12
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.12
Microsoft.EntityFrameworkCore.Sqlite | 7.0.12
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.12
Microsoft.TemplateEngine.Core | 7.0.112
Microsoft.TemplateEngine.Core.Contracts | 7.0.112
Microsoft.TemplateEngine.Edge | 7.0.112
Microsoft.TemplateEngine.IDE | 7.0.112
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.112
Microsoft.TemplateEngine.Tasks | 7.0.112
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.112
Microsoft.TemplateSearch.Common | 7.0.112
Microsoft.TemplateEngine.Utils | 7.0.112
Microsoft.TemplateEngine.Abstractions | 7.0.112
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.112
Microsoft.NET.Build.Containers | 7.0.402
FSharp.Compiler.Service | 43.7.400
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.402
Microsoft.DotNet.ApiCompat.Tool | 7.0.402
Microsoft.DotNet.Common.ItemTemplates | 7.0.402
Microsoft.DotNet.ApiCompat.Task | 7.0.402
FSharp.Core | 7.0.400
Microsoft.NET.Build.Containers | 7.0.309
Microsoft.DotNet.ApiCompat.Task | 7.0.309
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.ApiCompat.Tool | 7.0.309
FSharp.Core | 7.0.300
Microsoft.DotNet.Common.ItemTemplates | 7.0.309
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.309

[//]: # ( Runtime 7.0.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2243faea-91fe-44e8-b651-65f3a16bbc5b/749cb03f8c44a8010abc46c724bae315/dotnet-runtime-7.0.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46fbe630-5b1f-49f6-a0fc-2fc88e35fa36/c32eac7749cf35e45e8e551e37a82c39/dotnet-runtime-7.0.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7384d908-c25c-47ee-ab8e-fa38752430fa/4ebe0e95c8273abaf8daa827dcbded0b/dotnet-runtime-7.0.12-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7e99b6d-8ac5-4dde-92a0-c0f18f4f0a68/8859b85ae7834ea8e06da6390c90116f/dotnet-runtime-7.0.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/155e35e1-fb3f-4785-be99-e564dc4fbe5f/5593a46b76257f8ea67b7469f99f6ccd/dotnet-runtime-7.0.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47a663ab-0c5f-4502-9ea1-93c27df8f9ed/5ee65ca13eb40220631dab82a27972d8/dotnet-runtime-7.0.12-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/61df6fff-44b9-444a-b5b4-d412e9713ce7/01755aba0fc7c186f9021568b3d1def1/dotnet-runtime-7.0.12-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7524dce-1699-492b-a98e-3930e27978bd/fd898ab7c7cfe81598270f945ff7e72a/dotnet-runtime-7.0.12-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/35a9cf57-4819-40f7-a61b-14ee493e1e08/62997cd09ff7679b81eb3e6f971ce078/dotnet-runtime-7.0.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5a3eed2a-4c5f-4c05-9ef5-4b59de889a9e/4a577fd9e4b278dfebc16d901691b90f/dotnet-runtime-7.0.12-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d48e097c-baa4-4679-ad6b-5666770def6c/5613f0d6ea2f1bedd356c3b4365a7894/dotnet-runtime-7.0.12-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1b15c24a-42a7-46cd-b5ac-a4d6d89763a7/c8b6a47ca88ea4caf0d7aea2435be2a6/dotnet-runtime-7.0.12-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1d1b78d3-b079-4b47-9b17-f3def75babad/6a66a2c9ad5ee028ae35dd8d6a3add1a/dotnet-runtime-7.0.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6d97a102-c4f3-4183-91d7-d810e96e73a1/272349ea2adf0145d9364e2c12bd23a4/dotnet-runtime-7.0.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fc5aab43-a18e-4cdc-bdaf-a26a09bfdac2/d7ccd0e3180d0bcf5700ea77cadb409d/dotnet-runtime-7.0.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e6be672b-53a9-4050-9b55-53f74a55523c/b59ab5af9be85681cf415865a159624f/dotnet-runtime-7.0.12-win-x86.zip

[//]: # ( WindowsDesktop 7.0.12)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/87be2c02-a0ca-4154-9c29-a33c30ff3ed3/0a6910c08704c50dc4fc059fe35eab0c/windowsdesktop-runtime-7.0.12-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/056f56aa-ec05-4cf4-aac4-83adf95e9fc9/361fe60b355fa712bf77c8665bc6e035/windowsdesktop-runtime-7.0.12-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9ea536d-8e1f-4247-88b8-e79e33fa0873/c06e39f73a3bb1ec8833bb1cde98fce3/windowsdesktop-runtime-7.0.12-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d6faa527-b247-4caa-bb28-42714d936edb/37946fb49ce6845c01b008a13e0d8ab3/windowsdesktop-runtime-7.0.12-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7e606599-560e-47c9-9ff1-60af4beaffb5/377fdff249559470cf483880f16acaf0/windowsdesktop-runtime-7.0.12-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/14976159-7851-4084-a41e-9b701830c4bf/c4cbd49f51f5c6a56e4b32f86b72b470/windowsdesktop-runtime-7.0.12-win-x86.zip

[//]: # ( ASP 7.0.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/069c33a1-af95-41fa-b9e9-1c66abd2b76e/ce69a7fecec81bd01d45bbaf56c219ea/aspnetcore-runtime-7.0.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7ca30b0-2530-4afb-a401-a8079f336109/dc0db7f73a502a423728f9fc78e55557/aspnetcore-runtime-7.0.12-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9890367f-23cc-4535-b6bb-076b3f8980a7/4b1b045044b62b330d06e352e21b8af5/aspnetcore-runtime-7.0.12-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c189e3eb-dca0-4cff-8c43-f316c0a69bf3/2dc3a54181fe0689cf4512625e59a41f/aspnetcore-runtime-7.0.12-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7bcf35c1-c090-4a2b-b0bc-2321a7de3417/eb6c61f1188a5228dcfa9760a22b9890/aspnetcore-runtime-7.0.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65f1f116-4a94-42fc-b3da-5f9441a6d6e0/a55cd567c5433ce7f2c0dd956cb0cfe7/aspnetcore-runtime-7.0.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df5fe306-ea3d-4b47-bd19-a79956cac99c/90e6c97e896c5832732b830d62e36d3d/aspnetcore-runtime-7.0.12-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12f4463f-7e49-4b92-88ef-6acdcc144c6e/6feae722f21f12995c35aec428170bae/aspnetcore-runtime-7.0.12-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b7e87ff-e91f-44ba-a7d8-28c117550208/261ad24076396421b2007fd1e4a9ba9d/aspnetcore-runtime-7.0.12-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9478b711-8d41-4d1c-a95f-b9141c9c5785/6ef110b4d71b4b8d6a16b4503c14ee82/aspnetcore-runtime-7.0.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9c9070e7-5fd2-4338-96d2-1e7f9760f2c3/ebd8e492b2a468bfaacfdde6d705ffb7/aspnetcore-runtime-7.0.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/801dd0ec-8140-4c68-b2d9-676ea0777b50/2257a164f7ad451a8f00fb3d53999673/aspnetcore-runtime-7.0.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6debee37-a604-4d0e-88a5-ed81c9f39016/f1c05fe1d9a14b32a95fa84578d6b05f/aspnetcore-runtime-7.0.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/723dac98-2f86-4efa-a67d-90b7f88d1a78/325c7069d70a1b23dd1a1545930ac251/dotnet-hosting-7.0.12-win.exe

[//]: # ( SDK 7.0.402)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a91573c-61b2-4425-b9cf-0fb95b33ef58/c69a79d0a180956cefaeca06febb88f2/dotnet-sdk-7.0.402-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f01d28d8-388a-46db-986e-dfc4f2e5a531/cbff2d698635543d6aaac2ab630f5d72/dotnet-sdk-7.0.402-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9383141c-27ab-4589-841c-4ab0ad009651/5887e789b25f8867028f4c0f9a243ea9/dotnet-sdk-7.0.402-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e01927e-cce7-49c8-b59d-fc3775cdfe2f/fac2ec847ac0e9e0bdfaa75e215950bc/dotnet-sdk-7.0.402-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5211824-dab3-40eb-8577-12d9e1c4a6e3/e14674f9b195132f8247c47400a0279a/dotnet-sdk-7.0.402-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4b5aad8-a416-436b-927c-3ebd5a9793ad/38efd1b64c8edc7c5f13699dd0be54e1/dotnet-sdk-7.0.402-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2054d7e3-f46c-4b44-9cb1-6b7f8418bc3d/bcb923c0a5d978f7590a176191931455/dotnet-sdk-7.0.402-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8659f18-390b-46ed-afbf-c92f0353c1ec/95aad3eac0e9cd16e20efad4251656b8/dotnet-sdk-7.0.402-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0998f773-80a6-4a6e-bf1f-4a83dd5df01f/ce12481071bbf6350a92e231c7217db6/dotnet-sdk-7.0.402-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71778591-9c8a-44b5-9c74-51e0a387d26b/f0e6bb05f96fd9b725426d5bb25d17ad/dotnet-sdk-7.0.402-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f78d7552-1dc8-4650-819c-60abcb0f789f/88ab499cc2747336fc084d534d41c5b4/dotnet-sdk-7.0.402-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/185b45f1-eda6-4f3a-906c-17af38693cfa/9fb6dbbc7382931c8d51a7050d5a15a0/dotnet-sdk-7.0.402-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d0348cb9-c348-4c68-93aa-70122dd44a33/5f982a6ffdb29ed70af11ffc08d3189e/dotnet-sdk-7.0.402-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c981b201-3f0e-47e3-a1db-a5cd270f0441/ae3cf5c68d59df4b5c77ae716b91175e/dotnet-sdk-7.0.402-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/696ba452-a2bd-466a-b45a-285df60a53de/467af64d697047ada865c8faf87cedc0/dotnet-sdk-7.0.402-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1d6d5333-de61-4757-b2f0-601512aaa679/09f5bda49b0f6fedf6b5ab93def71ae1/dotnet-sdk-7.0.402-win-x86.zip
