# .NET 7.0.13  - October 24, 2023

Microsoft is releasing an update to our October 10, 2023 security release. The .NET 7.0.12 update inadvertently missed (were not cumulative of) the security fixes in our previous September 12, 2023 update. The new .NET 7.0.13 update is cumulative of both September and October security fixes.

The .NET 7.0.13 and .NET SDK 7.0.403 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.403
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

* [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.13 release carries security fixes.

**Note:** The vulnerabilities [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36792), [CVE-2023-36793]( https://www.cve.org/CVERecord?id=CVE-2023-36793), [CVE-2023-36794]( https://www.cve.org/CVERecord?id=CVE-2023-36794), [CVE-2023-36796]( https://www.cve.org/CVERecord?id=CVE-2023-36796) are all resolved by a single patch. Get this update to resolve all of them.

[CVE-2023-36792 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36792)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36793 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36793)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36794 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36794)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36796 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36796)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36799 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36799)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET where reading a maliciously crafted X.509 certificate may result in Denial of Service. This issue only affects Linux systems.

[CVE-2023-44487 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-44487)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0 RC1, .NET 7.0 ,and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the ASP.NET  Core Kestrel web server where a malicious client may flood the server with specially crafted HTTP/2 requests, causing denial of service.

[CVE-2023-38171 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38171)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A null pointer vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.

[CVE-2023-36435 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36435)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A memory leak vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.


## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8856](https://github.com/dotnet/core/issues/8856) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.13.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.13-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.13-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/october-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.13+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.13+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.13+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.13+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.13+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.13+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.13xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 7.0.13
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.13
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.13
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.13
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.13
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.13
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.13
Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.13
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.13
Microsoft.NETCore.App.Host.win-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.13
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Composite | 7.0.13
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.13
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.13
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.13
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.13
Microsoft.NETCore.App.Host.linux-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.13
Microsoft.NETCore.App.Host.win-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.DotNetAppHost | 7.0.13
Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.13
Microsoft.DotNet.ILCompiler | 7.0.13
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.13
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.13
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.13
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.13
Microsoft.NETCore.App.Host.osx-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm | 7.0.13
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.13
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.13
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.13
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.13
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.13
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.13
Microsoft.NETCore.App.Host.linux-x64 | 7.0.13
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.13
Microsoft.NETCore.App.Host.win-arm64 | 7.0.13
Microsoft.NETCore.App.Host.win-x86 | 7.0.13
Microsoft.NETCore.App.Ref | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.13
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.13
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.13
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.13
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.13
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.13
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.13
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.13
dotnet-sql-cache | 7.0.13
Microsoft.AspNetCore.Components.Analyzers | 7.0.13
Microsoft.AspNetCore.Components.CustomElements | 7.0.13
Microsoft.AspNetCore.Cryptography.Internal | 7.0.13
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.13
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.13
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.13
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.13
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.13
Microsoft.AspNetCore.Grpc.Swagger | 0.3.13
Microsoft.AspNetCore.HeaderPropagation | 7.0.13
Microsoft.AspNetCore.Identity.UI | 7.0.13
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.13
Microsoft.AspNetCore.Http.Connections.Client | 7.0.13
Microsoft.AspNetCore.Owin | 7.0.13
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.13
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.13
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.13
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.13
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.13
Microsoft.AspNetCore.SpaProxy | 7.0.13
Microsoft.AspNetCore.TestHost | 7.0.13
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.13
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.13
Microsoft.Extensions.Identity.Core | 7.0.13
Microsoft.AspNetCore.Connections.Abstractions | 7.0.13
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.13
AspNetCoreRuntime.7.0.x86 | 7.0.13
Microsoft.AspNetCore.Authentication.Certificate | 7.0.13
Microsoft.AspNetCore.Authentication.Facebook | 7.0.13
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.13
Microsoft.AspNetCore.Authentication.Google | 7.0.13
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.13
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.13
Microsoft.AspNetCore.Authentication.Twitter | 7.0.13
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.13
Microsoft.AspNetCore.Authorization | 7.0.13
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.13
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.13
Microsoft.AspNetCore.Components.Authorization | 7.0.13
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.13
Microsoft.AspNetCore.JsonPatch | 7.0.13
Microsoft.AspNetCore.Metadata | 7.0.13
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.13
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.13
Microsoft.AspNetCore.OpenApi | 7.0.13
Microsoft.AspNetCore.SignalR.Common | 7.0.13
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.13
Microsoft.Extensions.ApiDescription.Client | 7.0.13
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.13
Microsoft.Extensions.Identity.Stores | 7.0.13
Microsoft.Extensions.Http.Polly | 7.0.13
Microsoft.Extensions.FileProviders.Embedded | 7.0.13
Microsoft.Extensions.Logging.AzureAppServices | 7.0.13
Microsoft.Extensions.Localization.Abstractions | 7.0.13
Microsoft.Extensions.Localization | 7.0.13
Microsoft.Extensions.ObjectPool | 7.0.13
Microsoft.Extensions.WebEncoders | 7.0.13
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.13
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.13
Microsoft.AspNetCore.App.Ref | 7.0.13
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.13
Microsoft.AspNetCore.Components.Forms | 7.0.13
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.13
Microsoft.AspNetCore.Components.WebView | 7.0.13
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.13
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.13
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.13
Microsoft.AspNetCore.Components | 7.0.13
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.13
Microsoft.AspNetCore.Http.Connections.Common | 7.0.13
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.13
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.13
Microsoft.AspNetCore.Mvc.Testing | 7.0.13
Microsoft.AspNetCore.SignalR.Client | 7.0.13
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.13
Microsoft.Authentication.WebAssembly.Msal | 7.0.13
Microsoft.dotnet-openapi | 7.0.13
Microsoft.Extensions.ApiDescription.Server | 7.0.13
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.13
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.13
Microsoft.AspNetCore.Components.Web | 7.0.13
Microsoft.AspNetCore.Components.WebAssembly | 7.0.13
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.13
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.13
Microsoft.AspNetCore.DataProtection | 7.0.13
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.13
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.13
Microsoft.Extensions.Caching.SqlServer | 7.0.13
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.13
Microsoft.JSInterop | 7.0.13
Microsoft.JSInterop.WebAssembly | 7.0.13
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.13
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.13
Microsoft.Extensions.Features | 7.0.13
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.13
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.13
AspNetCoreRuntime.7.0.x64 | 7.0.13
FSharp.Core | 7.0.0
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.ApiCompat.Tool | 7.0.113
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.113
Microsoft.DotNet.Common.ItemTemplates | 7.0.113
Microsoft.DotNet.ApiCompat.Task | 7.0.113
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.13
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.13
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.13
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.13
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.13
dotnet-ef | 7.0.13
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.13
Microsoft.Data.Sqlite | 7.0.13
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.13
Microsoft.EntityFrameworkCore.Relational | 7.0.13
Microsoft.EntityFrameworkCore | 7.0.13
Microsoft.Data.Sqlite.Core | 7.0.13
Microsoft.EntityFrameworkCore.InMemory | 7.0.13
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.13
Microsoft.EntityFrameworkCore.Sqlite | 7.0.13
Microsoft.EntityFrameworkCore.SqlServer | 7.0.13
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.13
Microsoft.EntityFrameworkCore.Templates | 7.0.13
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.13
Microsoft.EntityFrameworkCore.Tools | 7.0.13
Microsoft.EntityFrameworkCore.Abstractions | 7.0.13
Microsoft.EntityFrameworkCore.Analyzers | 7.0.13
Microsoft.EntityFrameworkCore.Cosmos | 7.0.13
Microsoft.EntityFrameworkCore.Design | 7.0.13
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.13
Microsoft.EntityFrameworkCore.Proxies | 7.0.13
Microsoft.TemplateEngine.Core | 7.0.113
Microsoft.TemplateEngine.Core.Contracts | 7.0.113
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.113
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.113
Microsoft.TemplateEngine.Tasks | 7.0.113
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.113
Microsoft.TemplateEngine.Utils | 7.0.113
Microsoft.TemplateEngine.Abstractions | 7.0.113
Microsoft.TemplateEngine.IDE | 7.0.113
Microsoft.TemplateEngine.Edge | 7.0.113
Microsoft.TemplateSearch.Common | 7.0.113
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.ApiCompat.Task | 7.0.310
Microsoft.DotNet.ApiCompat.Tool | 7.0.310
Microsoft.DotNet.Common.ItemTemplates | 7.0.310
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.310
FSharp.Core | 7.0.300
Microsoft.NET.Build.Containers | 7.0.310
Microsoft.TemplateEngine.Abstractions | 7.0.310
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.310
Microsoft.TemplateEngine.IDE | 7.0.310
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.310
Microsoft.TemplateEngine.Core | 7.0.310
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.310
Microsoft.TemplateEngine.Core.Contracts | 7.0.310
Microsoft.TemplateEngine.Edge | 7.0.310
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.310
Microsoft.TemplateSearch.Common | 7.0.310
Microsoft.TemplateEngine.Authoring.CLI | 7.0.310
Microsoft.TemplateEngine.Utils | 7.0.310
FSharp.Compiler.Service | 43.7.401
Microsoft.DotNet.ApiCompat.Tool | 7.0.403
Microsoft.DotNet.ApiCompat.Task | 7.0.403
Microsoft.DotNet.Common.ItemTemplates | 7.0.403
Microsoft.NET.Build.Containers | 7.0.403
FSharp.Core | 7.0.401
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.403
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.403
Microsoft.TemplateEngine.Abstractions | 7.0.403
Microsoft.TemplateEngine.Edge | 7.0.403
Microsoft.TemplateEngine.Utils | 7.0.403
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.403
Microsoft.TemplateSearch.Common | 7.0.403
Microsoft.TemplateEngine.Authoring.CLI | 7.0.403
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.403
Microsoft.TemplateEngine.Core | 7.0.403
Microsoft.TemplateEngine.Core.Contracts | 7.0.403
Microsoft.TemplateEngine.IDE | 7.0.403
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.403

[//]: # ( Runtime 7.0.13)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ac5496c-d9f5-4e0a-b877-0c024f86556c/44ad712465beb6027c6cdfb4d970c8fd/dotnet-runtime-7.0.13-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08f8d331-b20e-4400-a1b9-ddd7b4977fad/b162a6c808f713914ad3ec65f88521d9/dotnet-runtime-7.0.13-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d168e85-411d-4628-b577-8be308e1d4ad/c7f07881a959b16240149208c1821ae5/dotnet-runtime-7.0.13-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/df090e13-1bb9-45dd-9ef6-ff60ce9e4ee8/b495ca5ad46df895f319b6dd3f8c978f/dotnet-runtime-7.0.13-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca22a691-61b6-431f-a1af-1c015dcd813e/a7e36d41148f5bea4d1f3e7618b6d9ab/dotnet-runtime-7.0.13-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/084709e8-8937-4c46-a361-28212cb2838b/4c5d7393c6e79f816a1591264411c22c/dotnet-runtime-7.0.13-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/42896d37-fbfa-4b3a-a255-ac6406befa9d/4b265e4d96e63140c8ae3e1e16ad604d/dotnet-runtime-7.0.13-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee9ebef3-f459-4337-bd45-521c818fae52/58efc8c2ea98c0fdcd8ebb15700a0565/dotnet-runtime-7.0.13-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a47b5421-b267-4e39-bff9-9807ea2521a1/beedcca4f5106902ecfd9f934e35bb33/dotnet-runtime-7.0.13-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30e43cae-eb9e-4d8e-b1ab-bcc4773f9fae/06137966e03cd705d55a86e10d8a6340/dotnet-runtime-7.0.13-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2d69667b-6594-4896-b3f7-806ea1ca147a/71968c1b172120c37107cc1f31305f81/dotnet-runtime-7.0.13-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e00d704e-1f79-4b68-b5c6-ba7af1bddaa9/19976df0594969f63db0b2e6b2b5f4f8/dotnet-runtime-7.0.13-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7f25ba8c-e2f3-4432-83c2-8ab41e361a3e/5201929d4c9b5752a47a9cf4d2b494e0/dotnet-runtime-7.0.13-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4263f876-bd9e-4ecd-9e5e-3058dce6077d/2f27b623a38be3471738f7439c168e77/dotnet-runtime-7.0.13-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/91a03ec1-d418-4d81-b664-545e2057b67f/b8b8066ac5d54b8c6c31960d678b5b30/dotnet-runtime-7.0.13-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b5193a35-615b-47df-9069-a00d0e34e74d/7d64f5bbed062e8378806c557c634294/dotnet-runtime-7.0.13-win-x86.zip

[//]: # ( WindowsDesktop 7.0.13)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/157ab26c-50f7-424d-86f7-ed25509be644/2d8c75f4fc0ca85211e5b2aa47a54632/windowsdesktop-runtime-7.0.13-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4960895f-dde6-4ba8-a564-36bdfb17c420/5ac9c5fd5a07b512ad6619afa1d8bf61/windowsdesktop-runtime-7.0.13-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/515cc796-e9f2-4b5c-be7f-b42f115a65a7/b0b146fcbf1d1c135807ff24b3d88093/windowsdesktop-runtime-7.0.13-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/132386dc-42fc-4ab1-be7c-52066d010357/9cdc97e070fa7c6747dfd80ca2baacff/windowsdesktop-runtime-7.0.13-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/84986c79-dd13-4bbc-abef-294638d5864a/75d29754580986fef26b5d64ec880075/windowsdesktop-runtime-7.0.13-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6c31bac8-cbbd-41d3-bd20-a47e1b3661b2/80bd416c53d62c3a54736ad925441762/windowsdesktop-runtime-7.0.13-win-x86.zip

[//]: # ( ASP 7.0.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c22fa1bc-42ce-45c1-b1fd-0f496ed4409e/64ec95fb21e37872e36ccd04521acf5c/aspnetcore-runtime-7.0.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53990197-c340-4514-b12f-a6c6580cc1b8/c25e55e6e23e7bc94701dc982525d66c/aspnetcore-runtime-7.0.13-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ce587ed-6558-45ea-9a0f-63d013ac9f5b/d75a2759837677dfac79e7ab7ba98f18/aspnetcore-runtime-7.0.13-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4335779-d968-4d0a-9259-965c04a00593/cccc584a7d33fd22f47b2035a7903aba/aspnetcore-runtime-7.0.13-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dace4c35-0743-41c2-807e-b8f5c4a02ea2/86dcbf78a5bf2dbe82962d4fe7f62c84/aspnetcore-runtime-7.0.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4ac0f7a-a65f-4222-bd1a-c1a94f7df32b/2c62b82c325a8c396db10f09cfa952c5/aspnetcore-runtime-7.0.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7823689-d818-4744-8bd3-fef504768c3b/7160531d6f935155772e4b0d4a0e3b78/aspnetcore-runtime-7.0.13-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1858183b-b0ae-4866-86b9-af2efc7bf05b/d69c3f2f527c182a841c7233dedc496a/aspnetcore-runtime-7.0.13-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5c368a3-2134-4444-9aa3-e188a727b61d/c5bdc7c6904a461a6084a2b231aedfc2/aspnetcore-runtime-7.0.13-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2047544d-b948-480e-a4ce-2d5276d906dc/010c6e5c6b822dc2121c1d23f0820cf6/aspnetcore-runtime-7.0.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a122d81-4e8e-4490-83e1-4d71e88553fd/b7aacf9098dd80bf1fc0faf8948e47d7/aspnetcore-runtime-7.0.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6db4150d-11f3-4c21-b2c6-c81d5e6243db/3707dcce96dae59516a7679953df1ace/aspnetcore-runtime-7.0.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6f37ec1f-3f8e-44d5-87fc-d6771ad5ca6b/a28b60f59a64dbf414d228dd59df83a4/aspnetcore-runtime-7.0.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/215095b0-dc0a-4e79-8815-3f72af83d054/3e7b7f99dffe2393a2210472c8c126a8/dotnet-hosting-7.0.13-win.exe

[//]: # ( SDK 7.0.403)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/560e89a4-c731-430a-a810-4e88a846494e/d8b477e0c06c8324769ed3c94703a9ee/dotnet-sdk-7.0.403-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/558bb19a-c08f-4aa4-bcbc-481e9b050031/4de7724688881c9ce6f0e5cfb8a2acb6/dotnet-sdk-7.0.403-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69d624d3-00a1-4a8a-a63f-a55d9f53f282/fd6592deb4bc60256547c51514deb0b5/dotnet-sdk-7.0.403-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1065716-7b9b-49d8-9dc5-a108ac51ee1b/bc88f2c1a68d49be3879450404d6150e/dotnet-sdk-7.0.403-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4132d5d3-6bbd-4015-a5f6-41ce2abac598/91a06d4d270919a86eeefd88b56d529f/dotnet-sdk-7.0.403-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff8c660f-ffa9-4814-ac2d-4089e6ec4eb5/dc806d344844f1d58d8015d105e85c65/dotnet-sdk-7.0.403-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/70b57ca7-7fcb-432d-bad9-809dbcfc35a7/8fca3fbc3f6e638edb29a908621cf9ba/dotnet-sdk-7.0.403-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac1ec933-8265-46e4-b725-5843d483aba9/f41605b8581d114a5131f7761f703a20/dotnet-sdk-7.0.403-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4243dbe5-7173-4422-a073-b13395231cfa/808d2c3639437ef67630dc0083a0fbd6/dotnet-sdk-7.0.403-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff4be5da-8947-4b41-ad0d-84c98bc6d36d/4a20953b6b2aaa5ffd0f0a37e723698b/dotnet-sdk-7.0.403-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cb993c3c-24db-4490-bbe4-f30486f57733/0f6900e38ad719d774d5b44bd12b0e93/dotnet-sdk-7.0.403-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1b46da5d-5b27-4af8-abe7-965f8fc39734/afb7ed3267c10628fda7030a2872fb21/dotnet-sdk-7.0.403-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a099e4b6-a6a8-4d34-bf95-b00739d35bb7/cdad50779717ba0e56caf89a3ba29ab1/dotnet-sdk-7.0.403-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/81514d64-25fd-46ec-a0d1-648ca8b81d4e/b5416848b9ef1ffe5a3e323c62dc859d/dotnet-sdk-7.0.403-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/50295f71-b734-438f-b3ea-7d6b5661cf72/e1be49ed8d1e737b6e962568c485acfc/dotnet-sdk-7.0.403-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d68ea537-074d-41a9-9eb9-88e1e4967d9c/f30c88e20a804d1b5a2b63720535ee9a/dotnet-sdk-7.0.403-win-x86.zip
