# .NET 7.0.14 - November 14, 2023

The .NET 7.0.14 and .NET SDK 7.0.404 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.404
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.14 release carries security fixes.

[CVE-2023-36049 - .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

An elevation of privilege vulnerability exists in .NET where untrusted URIs provided to System.Net.WebRequest.Create can be used to inject arbitrary commands to backend FTP servers.

[CVE-2023-36558 - .NET Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36558)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 6.0, ASP.NET Core 7.0 and, ASP.NET Core 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists in ASP.NET where an unauthenticated user is able to bypass validation on Blazor server forms which could trigger unintended actions.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8910](https://github.com/dotnet/core/issues/8910) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.14.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.14-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.14-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/November-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.14+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.14+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.14+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.14+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.14+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.14+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.14xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 7.0.14
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.14
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.14
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.14
Microsoft.NETCore.App.Composite | 7.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.14
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.14
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.14
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.14
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.14
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.14
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.14
Microsoft.NETCore.App.Host.win-arm64 | 7.0.14
Microsoft.NETCore.App.Host.osx-x64 | 7.0.14
Microsoft.NETCore.App.Host.win-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.14
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.14
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.14
Microsoft.NETCore.App.Host.linux-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.14
Microsoft.NETCore.App.Ref | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.DotNetHost | 7.0.14
Microsoft.NETCore.DotNetHostPolicy | 7.0.14
Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.14
System.Text.Json | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.14
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.14
Microsoft.DotNet.ILCompiler | 7.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.14
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.14
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.14
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.14
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.14
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.14
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.14
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.14
Microsoft.NETCore.App.Host.win-arm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.14
Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.14
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.14
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.14
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.14
Microsoft.NETCore.App.Host.linux-arm | 7.0.14
Microsoft.NETCore.App.Host.win-x86 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.14
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.14
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.14
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.14
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.14
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.14
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.14
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.14
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.14
Microsoft.AspNetCore.Components.Analyzers | 7.0.14
Microsoft.AspNetCore.Components.Authorization | 7.0.14
Microsoft.AspNetCore.Components.CustomElements | 7.0.14
Microsoft.AspNetCore.Components.Forms | 7.0.14
Microsoft.AspNetCore.Components.WebAssembly | 7.0.14
Microsoft.AspNetCore.Components.Web | 7.0.14
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.14
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.14
Microsoft.AspNetCore.Owin | 7.0.14
Microsoft.AspNetCore.SignalR.Client | 7.0.14
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.14
Microsoft.AspNetCore.SignalR.Common | 7.0.14
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.14
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.14
Microsoft.Authentication.WebAssembly.Msal | 7.0.14
Microsoft.dotnet-openapi | 7.0.14
dotnet-sql-cache | 7.0.14
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.14
AspNetCoreRuntime.7.0.x64 | 7.0.14
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.14
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.14
Microsoft.AspNetCore.Authentication.Twitter | 7.0.14
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.14
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.14
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.14
Microsoft.AspNetCore.Components | 7.0.14
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.14
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.14
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.14
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.14
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.14
Microsoft.AspNetCore.JsonPatch | 7.0.14
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.14
Microsoft.AspNetCore.Metadata | 7.0.14
Microsoft.AspNetCore.Mvc.Testing | 7.0.14
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.14
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.14
Microsoft.AspNetCore.OpenApi | 7.0.14
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.14
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.14
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.14
Microsoft.Extensions.Identity.Stores | 7.0.14
Microsoft.Extensions.Localization | 7.0.14
Microsoft.Extensions.Localization.Abstractions | 7.0.14
Microsoft.Extensions.Logging.AzureAppServices | 7.0.14
Microsoft.Extensions.WebEncoders | 7.0.14
Microsoft.Extensions.ObjectPool | 7.0.14
Microsoft.JSInterop | 7.0.14
Microsoft.JSInterop.WebAssembly | 7.0.14
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.14
AspNetCoreRuntime.7.0.x86 | 7.0.14
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.14
Microsoft.Extensions.Caching.SqlServer | 7.0.14
Microsoft.Extensions.ApiDescription.Client | 7.0.14
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.14
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.14
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.14
Microsoft.Extensions.Features | 7.0.14
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.14
Microsoft.Extensions.FileProviders.Embedded | 7.0.14
Microsoft.Extensions.Identity.Core | 7.0.14
Microsoft.Extensions.Http.Polly | 7.0.14
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.14
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.14
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.14
Microsoft.AspNetCore.DataProtection | 7.0.14
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.14
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.14
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.14
Microsoft.AspNetCore.Http.Connections.Common | 7.0.14
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.14
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.14
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.14
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.14
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.14
Microsoft.AspNetCore.TestHost | 7.0.14
Microsoft.AspNetCore.SpaProxy | 7.0.14
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.14
Microsoft.AspNetCore.App.Ref | 7.0.14
Microsoft.AspNetCore.Authentication.Certificate | 7.0.14
Microsoft.AspNetCore.Authentication.Facebook | 7.0.14
Microsoft.AspNetCore.Authentication.Google | 7.0.14
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.14
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.14
Microsoft.AspNetCore.Authorization | 7.0.14
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.14
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.14
Microsoft.AspNetCore.Components.WebView | 7.0.14
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.14
Microsoft.AspNetCore.Cryptography.Internal | 7.0.14
Microsoft.AspNetCore.Connections.Abstractions | 7.0.14
Microsoft.AspNetCore.Identity.UI | 7.0.14
Microsoft.AspNetCore.Grpc.Swagger | 0.3.14
Microsoft.AspNetCore.HeaderPropagation | 7.0.14
Microsoft.AspNetCore.Http.Connections.Client | 7.0.14
Microsoft.Extensions.ApiDescription.Server | 7.0.14
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.14
Microsoft.DotNet.ApiCompat.Task | 7.0.404
Microsoft.NET.Build.Containers | 7.0.404
FSharp.Compiler.Service | 43.7.402
Microsoft.DotNet.ApiCompat.Tool | 7.0.404
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.404
Microsoft.DotNet.Common.ItemTemplates | 7.0.404
FSharp.Core | 7.0.402
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.14
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.14
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.14
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.14
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.14
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.14
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.14
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.14
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.14
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.14
Microsoft.EntityFrameworkCore.Proxies | 7.0.14
Microsoft.EntityFrameworkCore.Relational | 7.0.14
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.14
Microsoft.EntityFrameworkCore.SqlServer | 7.0.14
Microsoft.EntityFrameworkCore.Tools | 7.0.14
Microsoft.EntityFrameworkCore.Templates | 7.0.14
Microsoft.Data.Sqlite.Core | 7.0.14
Microsoft.EntityFrameworkCore.Abstractions | 7.0.14
Microsoft.EntityFrameworkCore.Analyzers | 7.0.14
Microsoft.EntityFrameworkCore.Cosmos | 7.0.14
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.14
Microsoft.EntityFrameworkCore.InMemory | 7.0.14
Microsoft.EntityFrameworkCore.Design | 7.0.14
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.14
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.14
dotnet-ef | 7.0.14
Microsoft.Data.Sqlite | 7.0.14
Microsoft.EntityFrameworkCore | 7.0.14
Microsoft.EntityFrameworkCore.Sqlite | 7.0.14
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.14
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.14
Microsoft.TemplateEngine.Authoring.CLI | 7.0.404
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.404
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.404
Microsoft.TemplateEngine.Core.Contracts | 7.0.404
Microsoft.TemplateEngine.IDE | 7.0.404
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.404
Microsoft.TemplateEngine.Utils | 7.0.404
Microsoft.TemplateSearch.Common | 7.0.404
Microsoft.TemplateEngine.Abstractions | 7.0.404
Microsoft.TemplateEngine.Core | 7.0.404
Microsoft.TemplateEngine.Edge | 7.0.404
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.404
Microsoft.DotNet.ApiCompat.Tool | 7.0.311
Microsoft.DotNet.ApiCompat.Task | 7.0.311
Microsoft.DotNet.Common.ItemTemplates | 7.0.311
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.311
FSharp.Compiler.Service | 43.7.300
FSharp.Core | 7.0.300
Microsoft.NET.Build.Containers | 7.0.311
Microsoft.TemplateEngine.Core.Contracts | 7.0.311
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.311
Microsoft.TemplateEngine.Utils | 7.0.311
Microsoft.TemplateEngine.Edge | 7.0.311
Microsoft.TemplateSearch.Common | 7.0.311
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.311
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.311
Microsoft.TemplateEngine.Core | 7.0.311
Microsoft.TemplateEngine.IDE | 7.0.311
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.311
Microsoft.TemplateEngine.Authoring.CLI | 7.0.311
Microsoft.TemplateEngine.Abstractions | 7.0.311
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.114
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.114
Microsoft.DotNet.Common.ItemTemplates | 7.0.114
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.ApiCompat.Task | 7.0.114
Microsoft.TemplateEngine.Core.Contracts | 7.0.114
Microsoft.TemplateEngine.Abstractions | 7.0.114
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.114
Microsoft.TemplateEngine.Core | 7.0.114
Microsoft.TemplateEngine.Edge | 7.0.114
Microsoft.TemplateEngine.IDE | 7.0.114
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.114
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.114
Microsoft.TemplateEngine.Tasks | 7.0.114
Microsoft.TemplateEngine.Utils | 7.0.114
Microsoft.TemplateSearch.Common | 7.0.114

[//]: # ( Runtime 7.0.14)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f55437d-153b-4dd3-b084-8a2942c99c4f/f88d7c3b6b96dd2331be3c150a2c75f7/dotnet-runtime-7.0.14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c6534cc-0798-4fc7-bc45-1101fd627181/4846e3b3bfd3570d2c6f3e3b6711efef/dotnet-runtime-7.0.14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3870da68-24de-4097-afce-79b30431c3b6/87fc95902e0ab3c3be16d3c8d2857af1/dotnet-runtime-7.0.14-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6139cd1d-3a0b-45e7-a146-4cc750632840/36d4017973601c56adc5a376e287f75b/dotnet-runtime-7.0.14-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/284cca3a-1050-4bf3-98eb-173c21452fec/a0b4fe20659680ebb591f35e7823fd33/dotnet-runtime-7.0.14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bece81ac-e35d-40e3-8b07-cf5b0c4872d9/d571e657adc85ec66141a82dd3ef8fea/dotnet-runtime-7.0.14-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a3293ecd-ac3c-47eb-944f-9d05e05fc0f8/54046b065e1eca27a4614706e32fc3e9/dotnet-runtime-7.0.14-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcede156-7e96-4b45-b750-c0a4893448d7/8ab02359114d9f4930baea23f3b418be/dotnet-runtime-7.0.14-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3238a6cf-c89e-40ed-b726-e418c45d97ba/258f34b6a559a0302258c26c37603867/dotnet-runtime-7.0.14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49878be9-1cba-4e7d-943c-b0f6cf5abd71/1f4d396b60584080d4bfee86269a5e0f/dotnet-runtime-7.0.14-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6addfb4b-2512-4431-9f49-8c98fcb7425f/8ae05fe7b1ba3e5eda4b6301b70579fe/dotnet-runtime-7.0.14-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/86a76278-9162-4662-9f69-d9f222ba2e74/1616286806520409e46d19fd6a75d518/dotnet-runtime-7.0.14-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e3be9c1-4b4c-4605-b3bc-18ef04b3c8d5/b1f864adc9c81ab6680385a4270b3887/dotnet-runtime-7.0.14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c4b101a-63a5-48f0-8a76-a2bbf9dd4c73/c4909124d83a4ca903038253d4f3fdeb/dotnet-runtime-7.0.14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de4e320a-79ea-4304-9acf-975d91251aae/bf49bfe95aa6b22b66eb9af462dee480/dotnet-runtime-7.0.14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4046d011-6955-40d5-b4b1-802dd2418721/b11a88c1132dc3244670efd9a83817ed/dotnet-runtime-7.0.14-win-x86.zip

[//]: # ( WindowsDesktop 7.0.14)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6dd9f16-a5cc-486b-85d7-1f7d67e7f91f/11084e31d4d894e0c01d59b1cf2dbc84/windowsdesktop-runtime-7.0.14-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f27db453-f831-4c4d-b59d-61aea200b900/52823d8e1a4fa1f220c143c25517c20b/windowsdesktop-runtime-7.0.14-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8f5b0079-2bb4-49cd-874e-0f58703eff6e/7010b5f213a2c436a307eb385dbb16ff/windowsdesktop-runtime-7.0.14-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f56c7db0-761f-4407-92ab-60c8b187e9ce/2f57c0284a6dea83e1a8c8d963f631e1/windowsdesktop-runtime-7.0.14-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3a87d4cf-87c7-4432-89af-37f21dc651a7/7996e26d189d21afa4fe54a02062df5d/windowsdesktop-runtime-7.0.14-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/abe74c47-5907-4b37-b51f-eab4eb4b0e36/1e02b18fc9e8439bea9ad4591b5c20db/windowsdesktop-runtime-7.0.14-win-x86.zip

[//]: # ( ASP 7.0.14)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ec955ed-7ea6-449e-907e-57cdf200d972/7136dd9c61a37c16a43edfb8d7c52900/aspnetcore-runtime-7.0.14-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d7ed165d-32b2-435f-a747-9683d4f89354/3372ce43201a1977c30bc8236bf0443d/aspnetcore-runtime-7.0.14-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/530b27c4-78c6-452a-944f-660e8596ca01/8ba9413d232487be69f8dea4a96617bd/aspnetcore-runtime-7.0.14-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37e0ebc1-3c1d-43c0-951a-2e2e85eb0614/81247c297b40f3d50e0ebc25a26f5bd0/aspnetcore-runtime-7.0.14-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30d696e1-6624-4e94-9a80-10c608fed74f/36c2c91f1fffdf24f9296c64ea5b49b0/aspnetcore-runtime-7.0.14-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a1d3e1e-ede9-4b28-a9c8-3023858b7f01/c9214ad6a85286f4abd026d23dca5d3c/aspnetcore-runtime-7.0.14-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3308f4f-65c9-4855-99d3-21657f401854/d12446cf25f3fca12438881117d5b292/aspnetcore-runtime-7.0.14-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d6a0fb7-65bd-4f61-8558-e545af46fee5/f16d3fccf91fde1481c04314fe851e2a/aspnetcore-runtime-7.0.14-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/df489347-be62-4cd8-a53b-96c9ac0a7bbc/8f7ffb70c210bf13444fc276f4828203/aspnetcore-runtime-7.0.14-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f066ab7a-a892-4e3c-95c5-ce87791cb03d/d41a0439ee555a5635fd87dfe86ae59a/aspnetcore-runtime-7.0.14-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/21b2d6b1-fb50-42b4-bdf2-9cb3335cfa7f/55a53114607ee9434e41790d30847d12/aspnetcore-runtime-7.0.14-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/14e62731-8d55-44fe-8c2c-fffa95129223/f9cf2c77bc075757cd7d87cd65637f7d/aspnetcore-runtime-7.0.14-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b51ce7b9-8cfd-4fd4-a111-23cdecaeeaa1/4b293bb3c434f3610c45d2889e9592a7/aspnetcore-runtime-7.0.14-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ac40c925-f49c-4f27-b6f5-540ba6b944d5/457f3e7dbe9feeb2644d5a32fef321e4/dotnet-hosting-7.0.14-win.exe

[//]: # ( SDK 7.0.404)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d070d9e-6748-49b4-8ebb-cfd74c25b89c/530fb7c5244e9a1ac798820335c58c35/dotnet-sdk-7.0.404-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2157e304-6f7a-4646-8886-05cc0dba157d/4cecdaeec9fd4715d0eee8987f406c21/dotnet-sdk-7.0.404-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/031a6941-6f78-43b5-b509-1333b7bb327d/7d5d565649d1cf4dd029dbc784d9c829/dotnet-sdk-7.0.404-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c45309de-778a-43e9-a809-ba144d524c87/b8b0ee835fca0307bd2055d4f48f9708/dotnet-sdk-7.0.404-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f81c31a-85c1-43d0-86d1-3bc50b5cf134/e9e802c6bf212b4fbf94e16938e7aba8/dotnet-sdk-7.0.404-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c3e1dcb-485a-44cf-b1cb-d6c0b643d805/d4b2a46283254b6d68f61ee3f1a06952/dotnet-sdk-7.0.404-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bc914058-c08a-44a2-a581-5c9807143b55/ddb7f2330a4250f28b15e1329bc11fa9/dotnet-sdk-7.0.404-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2df5209-a44a-4567-9a8e-56ad008fe383/c851463feae2305adeaf9466890deea9/dotnet-sdk-7.0.404-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/81b6b736-1218-4bb0-9100-89945de897be/a2be9ad05a16c0b39c02f2328ccdc6b4/dotnet-sdk-7.0.404-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/555d267c-fd4f-4431-93b6-d135cc1b1753/de1e43b9ade16f748a7e0c528bdc1498/dotnet-sdk-7.0.404-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c9536f18-0ca6-4ef9-8f78-108b28baa7fd/5104d138d4dd8a54644f8af5212c4c0d/dotnet-sdk-7.0.404-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f20109ee-499c-4d83-bb09-6319152f1add/aa31e8fa8d299da1aa50e33ba2e13ce1/dotnet-sdk-7.0.404-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/03a5170a-a4cd-458c-b5d0-e5149ee4fdcf/e9026f6fe3c3fec4a774e034d4f98ead/dotnet-sdk-7.0.404-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4f4fc500-65a8-42ca-a70c-c7f8827e7bd0/b6bbe369a0f4c16382811399bdb4a435/dotnet-sdk-7.0.404-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b65cae37-7d3e-4609-85af-71a337fa7333/19445b6330a324a145a0163ba17e731a/dotnet-sdk-7.0.404-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5b1486c7-55a8-4549-8058-8c65c515f1fa/05494cb4cb5e6779fa3354c56294a3ce/dotnet-sdk-7.0.404-win-x86.zip
