# .NET 7.0.15 - January 09, 2024

The .NET 7.0.15 and .NET SDK 7.0.405 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.405
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.15 release carries security fixes.

[CVE-2024-0056 - Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-0056)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET's System.Data.SqlClient and Microsoft.Data.SqlClient NuGet Packages. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider where an attackercan perform an AiTM (adversary-in-the-middle) attack between the SQL client and the SQL server. This may allow the attacker to steal authentication credentials intended for the database server, even if the connection is established over an encrypted channel like TLS.

[CVE-2024-0057- .NET Security Feature bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 . This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists when Microsoft .NET Framework-based applications use X.509 chain building APIs but do not completely validate the X.509 certificate due to a logic flaw. An attacker could present an arbitrary untrusted certificate with malformed signatures, triggering a bug in the framework. The framework will correctly report that X.509 chain building failed, but it will return an incorrect reason code for the failure. Applications which utilize this reason code to make their own chain building trust decisions may inadvertently treat this scenario as a successful chain build. This could allow an adversary to subvert the app's typical authentication logic.

[CVE-2024-21319 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21319)

Microsoft is releasing this security advisory to provide information about a vulnerability in the ASP.NET Core project templates. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A Denial of Service vulnerability exists in ASP.NET Core project templates which utilize JWT-based authentication tokens. This vulnerability allows an unauthenticated client to consume arbitrarily large amounts of server memory, potentially triggering an out-of-memory condition on the server and making the server no longer able to respond to legitimate requests.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9052](https://github.com/dotnet/core/issues/9052) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.15.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.15-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/January-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.15+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.15+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.15+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.15+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.15+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.15+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.15xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 7.0.15
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.15
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.15
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.15
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.15
Microsoft.DotNet.ILCompiler | 7.0.15
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.15
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.15
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.15
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.15
Microsoft.NETCore.App.Host.linux-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.15
Microsoft.NETCore.App.Ref | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.15
Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.15
Microsoft.NETCore.App.Composite | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.15
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.15
Microsoft.NETCore.App.Host.win-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.15
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.15
Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.15
Microsoft.NETCore.App.Host.linux-arm | 7.0.15
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.15
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.15
Microsoft.NETCore.App.Host.osx-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.15
Microsoft.NETCore.App.Host.win-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.15
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.15
Microsoft.NETCore.DotNetHostPolicy | 7.0.15
Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.15
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.15
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.15
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.15
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.15
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.15
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.15
Microsoft.NETCore.App.Host.win-arm | 7.0.15
Microsoft.NETCore.App.Host.win-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.15
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.15
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.15
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.15
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.15
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.15
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.15
dotnet-sql-cache | 7.0.15
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.15
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.15
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.15
Microsoft.AspNetCore.Authorization | 7.0.15
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.15
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.15
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.15
Microsoft.AspNetCore.Components | 7.0.15
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.15
Microsoft.AspNetCore.JsonPatch | 7.0.15
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.15
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.15
Microsoft.AspNetCore.OpenApi | 7.0.15
Microsoft.AspNetCore.SignalR.Client | 7.0.15
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.15
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.15
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.15
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.15
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.15
Microsoft.Extensions.Features | 7.0.15
Microsoft.Extensions.FileProviders.Embedded | 7.0.15
Microsoft.Extensions.Identity.Core | 7.0.15
Microsoft.Extensions.Http.Polly | 7.0.15
Microsoft.Extensions.Identity.Stores | 7.0.15
Microsoft.Extensions.Localization | 7.0.15
AspNetCoreRuntime.7.0.x86 | 7.0.15
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.15
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.15
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.15
Microsoft.AspNetCore.Authentication.Twitter | 7.0.15
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.15
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.15
Microsoft.AspNetCore.Components.Authorization | 7.0.15
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.15
Microsoft.AspNetCore.Http.Connections.Client | 7.0.15
Microsoft.AspNetCore.HeaderPropagation | 7.0.15
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.15
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.15
Microsoft.AspNetCore.Http.Connections.Common | 7.0.15
Microsoft.AspNetCore.Metadata | 7.0.15
Microsoft.AspNetCore.Mvc.Testing | 7.0.15
Microsoft.AspNetCore.Owin | 7.0.15
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.15
Microsoft.Extensions.ApiDescription.Client | 7.0.15
Microsoft.AspNetCore.Connections.Abstractions | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.15
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.15
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.15
Microsoft.AspNetCore.App.Ref | 7.0.15
Microsoft.Extensions.Logging.AzureAppServices | 7.0.15
Microsoft.Extensions.Localization.Abstractions | 7.0.15
Microsoft.Extensions.WebEncoders | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.15
AspNetCoreRuntime.7.0.x64 | 7.0.15
Microsoft.AspNetCore.Components.Analyzers | 7.0.15
Microsoft.AspNetCore.Components.CustomElements | 7.0.15
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.15
Microsoft.AspNetCore.Components.Forms | 7.0.15
Microsoft.AspNetCore.Components.Web | 7.0.15
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.15
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.15
Microsoft.AspNetCore.DataProtection | 7.0.15
Microsoft.AspNetCore.Cryptography.Internal | 7.0.15
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.15
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.15
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.15
Microsoft.AspNetCore.SpaProxy | 7.0.15
Microsoft.Authentication.WebAssembly.Msal | 7.0.15
Microsoft.Extensions.ApiDescription.Server | 7.0.15
Microsoft.Extensions.ObjectPool | 7.0.15
Microsoft.JSInterop.WebAssembly | 7.0.15
Microsoft.JSInterop | 7.0.15
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.15
Microsoft.AspNetCore.Authentication.Certificate | 7.0.15
Microsoft.AspNetCore.Authentication.Facebook | 7.0.15
Microsoft.AspNetCore.Authentication.Google | 7.0.15
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.15
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.15
Microsoft.AspNetCore.Components.WebAssembly | 7.0.15
Microsoft.AspNetCore.Components.WebView | 7.0.15
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.15
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.15
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.15
Microsoft.AspNetCore.Grpc.Swagger | 0.3.15
Microsoft.AspNetCore.Identity.UI | 7.0.15
Microsoft.AspNetCore.SignalR.Common | 7.0.15
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.15
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.15
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.15
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.15
Microsoft.AspNetCore.TestHost | 7.0.15
Microsoft.dotnet-openapi | 7.0.15
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.15
Microsoft.Extensions.Caching.SqlServer | 7.0.15
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.15
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.15
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.15
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.15
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.15
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.15
FSharp.Core | 7.0.403
Microsoft.DotNet.ApiCompat.Task | 7.0.405
Microsoft.DotNet.ApiCompat.Tool | 7.0.405
Microsoft.DotNet.Common.ItemTemplates | 7.0.405
FSharp.Compiler.Service | 43.7.403
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.405
Microsoft.NET.Build.Containers | 7.0.405
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.15
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.15
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.15
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.15
Microsoft.Data.Sqlite | 7.0.15
Microsoft.EntityFrameworkCore.Cosmos | 7.0.15
Microsoft.Data.Sqlite.Core | 7.0.15
Microsoft.EntityFrameworkCore | 7.0.15
Microsoft.EntityFrameworkCore.Abstractions | 7.0.15
Microsoft.EntityFrameworkCore.Analyzers | 7.0.15
Microsoft.EntityFrameworkCore.Proxies | 7.0.15
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.15
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.15
Microsoft.EntityFrameworkCore.Templates | 7.0.15
Microsoft.EntityFrameworkCore.SqlServer | 7.0.15
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.15
Microsoft.EntityFrameworkCore.Tools | 7.0.15
dotnet-ef | 7.0.15
Microsoft.EntityFrameworkCore.Design | 7.0.15
Microsoft.EntityFrameworkCore.Relational | 7.0.15
Microsoft.EntityFrameworkCore.Sqlite | 7.0.15
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.15
Microsoft.EntityFrameworkCore.InMemory | 7.0.15
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.15
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.15
Microsoft.TemplateEngine.Core | 7.0.405
Microsoft.TemplateEngine.Edge | 7.0.405
Microsoft.TemplateEngine.Authoring.CLI | 7.0.405
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.405
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.405
Microsoft.TemplateEngine.IDE | 7.0.405
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.405
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.405
Microsoft.TemplateEngine.Utils | 7.0.405
Microsoft.TemplateSearch.Common | 7.0.405
Microsoft.TemplateEngine.Abstractions | 7.0.405
Microsoft.TemplateEngine.Core.Contracts | 7.0.405
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.ApiCompat.Tool | 7.0.312
Microsoft.DotNet.ApiCompat.Task | 7.0.312
Microsoft.NET.Build.Containers | 7.0.312
Microsoft.DotNet.Common.ItemTemplates | 7.0.312
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.312
FSharp.Core | 7.0.300
Microsoft.TemplateEngine.Abstractions | 7.0.312
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.312
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.312
Microsoft.TemplateEngine.Core | 7.0.312
Microsoft.TemplateEngine.Authoring.CLI | 7.0.312
Microsoft.TemplateEngine.Edge | 7.0.312
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.312
Microsoft.TemplateEngine.Utils | 7.0.312
Microsoft.TemplateSearch.Common | 7.0.312
Microsoft.TemplateEngine.Core.Contracts | 7.0.312
Microsoft.TemplateEngine.IDE | 7.0.312
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.312
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.115
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.115
Microsoft.DotNet.ApiCompat.Task | 7.0.115
Microsoft.DotNet.Common.ItemTemplates | 7.0.115
Microsoft.TemplateEngine.Core | 7.0.115
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.115
Microsoft.TemplateEngine.Utils | 7.0.115
Microsoft.TemplateSearch.Common | 7.0.115
Microsoft.TemplateEngine.Core.Contracts | 7.0.115
Microsoft.TemplateEngine.Edge | 7.0.115
Microsoft.TemplateEngine.IDE | 7.0.115
Microsoft.TemplateEngine.Abstractions | 7.0.115
Microsoft.TemplateEngine.Tasks | 7.0.115
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.115
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.115

[//]: # ( Runtime 7.0.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ef5357d-ad9e-43aa-9d81-d8e9a6406422/8cb59b6315036a8101ce55070085c8e3/dotnet-runtime-7.0.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/854685e1-521f-4784-8a6a-b49307a3a4a7/6079b3613f0a297df59ab563e31074bc/dotnet-runtime-7.0.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55be6919-7a8a-4f04-9d31-61b49edfa6f5/d399d5aac17012a886371687c2c7b0e7/dotnet-runtime-7.0.15-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/100ac9c5-da50-440d-b68e-5d98303c0c26/363e1d249c51851cb3ce04700c35b10c/dotnet-runtime-7.0.15-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16fa38b7-7c0d-41a4-9ec4-2a63827656bf/9ef88902b9e4b73da9ec3ce3725b3739/dotnet-runtime-7.0.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/921a24a1-0a7c-4100-b72e-f948ff3b4614/1cf0fe858e6d42bf1ef88d775fd8d865/dotnet-runtime-7.0.15-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/134ce5f1-44b3-47fd-9705-6b99524ba4d7/bbe5dd32e431ec92fa48250757851ac0/dotnet-runtime-7.0.15-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44fec9e2-bcd6-460f-b1a9-0e8dfddc98fa/06bcccde9a49279d460d2862f54af404/dotnet-runtime-7.0.15-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d5c938a1-9fd8-4681-814d-3af7b861445c/ff570d04e8ab27c3aa942a86bdc1c896/dotnet-runtime-7.0.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f10c8029-961d-4c91-922e-d81eceda9434/004a62489c01ae2a41ac7ec1aba2eec7/dotnet-runtime-7.0.15-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2c5a4ec4-82c9-4097-a0f2-c3a3b9cd8a87/52e93e1955b8ebc0d6d2f59a441ae6c5/dotnet-runtime-7.0.15-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2ff84fae-a5bf-4c87-9f32-b986b1811112/e1a34d3dc5d7bae3df00f01ff57544e0/dotnet-runtime-7.0.15-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/83b58670-c0ea-4442-ad35-beb5009f5396/bcf1e10f57dbeea2f46490430abf6882/dotnet-runtime-7.0.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b5ed1321-d9fd-41aa-aa75-c26edf0b0e6b/0818675fe18a1f566cb3eff2d040b959/dotnet-runtime-7.0.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a0b41d8a-5de8-4dbc-b72b-6c52edf5727e/0b9b3b50a325c1b82ec17a5b63e92ea2/dotnet-runtime-7.0.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1effd491-0dbe-4669-be8f-401405447705/0480e379b6bc5fbd5e68f6d3f23fbeda/dotnet-runtime-7.0.15-win-x86.zip

[//]: # ( WindowsDesktop 7.0.15)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b72d5361-0d95-4021-b5fc-ea1e39607561/e19ce3af776d3cfe023a3dc1ea1153e9/windowsdesktop-runtime-7.0.15-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d26095de-d472-4f8d-b6e0-1396772637e3/6523e70f33c2ef336b34fde35cbc007d/windowsdesktop-runtime-7.0.15-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/00f765dd-f009-41b4-921f-bee1273f3638/3cb6ac95b2aa7eeb272c6179d56fd036/windowsdesktop-runtime-7.0.15-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/063934b0-1ea6-4b08-8783-cbf9ec0e656f/2e1b514c1f690dd1bc1bbaacc99b54a1/windowsdesktop-runtime-7.0.15-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fd3675e7-91e6-4fce-9c77-9336a4973e42/e970987509babd919e8ea29309054c8c/windowsdesktop-runtime-7.0.15-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1d62add1-6310-403a-b486-ae9fec44c282/e6cb984eecfec122dd80558d99ee6cb7/windowsdesktop-runtime-7.0.15-win-x86.zip

[//]: # ( ASP 7.0.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4417e578-9a22-4273-9a15-d4f67887ea51/58689d63082664983b3f6b9ed2058566/aspnetcore-runtime-7.0.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fed5ac78-3c8f-4eb9-bc13-2df4e97d01e1/3125fd43ab4eaf0e3304839295bf4bfd/aspnetcore-runtime-7.0.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11f03408-dfd1-400a-acf1-18f668d022b8/304208efdd75bb9eb7e76e31760dfeb6/aspnetcore-runtime-7.0.15-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a5cb329-1822-4d80-9967-11fba08b62ae/d15c0a8194e65c11394ad3083536dd31/aspnetcore-runtime-7.0.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1874735-65d1-4074-b592-2724cdf8f52d/cc7990db68c7a30ba3febcef910bfcdc/aspnetcore-runtime-7.0.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30cb8b2d-ee36-421b-90d0-6650bf5180ad/9e2dff64d0134c46b74eafcad1bb658d/aspnetcore-runtime-7.0.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/478d989b-d381-448d-be80-f81c5ec93014/9a7b49e5a2c0720e290d19a9447984cc/aspnetcore-runtime-7.0.15-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d44c976-5d7e-441c-aaf2-1b43b95131cc/b9f0c5a91fceb7fd47c76a7097c75c78/aspnetcore-runtime-7.0.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c0f97d9a-ac83-4725-a4b5-3348315979f6/bba379c56b3f7fe8bb19045982b28c92/aspnetcore-runtime-7.0.15-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/af20f5ce-cdf2-469c-ae29-20731dbdb49c/d9c568ae0fb44b91778aa74f6431f041/aspnetcore-runtime-7.0.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1c1d5f0b-f967-410b-bfc6-2f3b5dff1774/be0ba8e4cf4660ce01da77a9038ff9d8/aspnetcore-runtime-7.0.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/23a3ba62-0a1a-4602-8ff9-003b33c52728/c221ac946c2a13484f5df1b655e96e26/aspnetcore-runtime-7.0.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/67ea8710-5746-41cb-915b-20fb8b59cbaf/87ba569c8652540f1558ff839c1b8cfc/aspnetcore-runtime-7.0.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5622bbdd-9184-4dcc-8ea6-7a7f1ce9de74/57103ffa6a60fb2db059d621165ef4b6/dotnet-hosting-7.0.15-win.exe

[//]: # ( SDK 7.0.405)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c1865fa-7197-4177-8807-91ed2f1689f2/a2846ac164072b7a0401102bdce49f91/dotnet-sdk-7.0.405-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bdfe4e91-3a24-421f-881a-47b6d91404cb/cfe786933a6a7fd358b799af23542827/dotnet-sdk-7.0.405-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ed945fc-19dd-44f8-94f3-33cd236df866/7e7c50fc31fcf636e4eda118f8247153/dotnet-sdk-7.0.405-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca3cd43d-f770-47ea-a1ee-787703f1a180/30b10ae84259ac9d9e333eca05a5f553/dotnet-sdk-7.0.405-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/243f7748-e9ef-48f7-ae4f-d7c80d4e1128/22e90a7544e9588927f87db67bb1a560/dotnet-sdk-7.0.405-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5202b091-2406-445c-b40a-68a5b97c882b/b509f2a7a0eb61aea145b990b40b6d5b/dotnet-sdk-7.0.405-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/efa1aae9-9574-4095-b220-900f3b6ee883/10838cb66603fa4cc0f02ae9d2317c56/dotnet-sdk-7.0.405-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5bb0e0e4-2a8d-4aba-88ad-232e1f65c281/ee6d35f762d81965b4cf336edde1b318/dotnet-sdk-7.0.405-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f8586b3c-a8dc-46b7-9079-c04a5d39e446/9e31c12cea5d52ada35d0603943e9b36/dotnet-sdk-7.0.405-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77e1c2df-aaa1-44aa-abc5-ffca44b1dfc9/1fea5228f09398a885ca956d1b537f02/dotnet-sdk-7.0.405-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/37429fff-420c-47d1-bdd2-2d8ec48f3ee2/1058682a5ed53fe0028b5a86e48a4638/dotnet-sdk-7.0.405-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5079d3e3-3fa9-4ffa-92fc-bbf17e2d3543/634299784e4c6f7a1f5b06cf5070d505/dotnet-sdk-7.0.405-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/febc46ff-cc68-4bee-83d2-c34786b5ca68/524ef9b25d29dc90efdb0fba0f589779/dotnet-sdk-7.0.405-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2133b143-9c4f-4daa-99b0-34fa6035d67b/193ede446d922eb833f1bfe0239be3fc/dotnet-sdk-7.0.405-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/79c973e6-7992-4b55-a175-981812c5dfb9/cd403d7bb1c56c104e148655c985fc00/dotnet-sdk-7.0.405-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bf8a63f5-f029-4d0a-8027-975284829ad0/e1fb2ba0532d63c6cec0fb04987a91bf/dotnet-sdk-7.0.405-win-x86.zip
