# .NET 7.0.16 - February 13, 2024

The .NET 7.0.16 and .NET SDK 7.0.406 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.406
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.16 release carries security fixes.

[CVE-2024-21386 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21386)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET 6.0, ASP.NET 7.0 and, ASP.NET 8.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in ASP.NET applications using SignalR where a malicious client can result in a denial-of-service.

[CVE-2024-21404 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21404)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists in .NET with OpenSSL support when parsing X509 certificates.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9163](https://github.com/dotnet/core/issues/9163) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.16-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/February-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.16+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.16+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.16+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.16+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.16+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.16+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.16xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.16
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.16
Microsoft.WindowsDesktop.App.Ref | 7.0.16
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.16
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Composite | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.16
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.16
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.16
Microsoft.NETCore.App.Host.osx-x64 | 7.0.16
Microsoft.NETCore.App.Host.linux-x64 | 7.0.16
Microsoft.NETCore.App.Host.win-arm64 | 7.0.16
Microsoft.NETCore.App.Ref | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.16
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.16
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.16
Microsoft.NETCore.App.Host.win-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.16
Microsoft.NETCore.App.Host.win-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.16
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.16
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.16
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.16
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.16
Microsoft.NETCore.App.Host.win-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.DotNetHost | 7.0.16
Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
Microsoft.DotNet.ILCompiler | 7.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm | 7.0.16
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.16
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.16
Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.16
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.16
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.16
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.16
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.16
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.16
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.16
Microsoft.NETCore.App.Host.linux-arm | 7.0.16
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.16
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.16
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.16
Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.16
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.16
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.16
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.16
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.16
Microsoft.Extensions.Caching.SqlServer | 7.0.16
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.16
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.16
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.16
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.16
Microsoft.Extensions.Localization | 7.0.16
Microsoft.Extensions.Localization.Abstractions | 7.0.16
Microsoft.Extensions.Logging.AzureAppServices | 7.0.16
Microsoft.Extensions.ObjectPool | 7.0.16
Microsoft.Extensions.WebEncoders | 7.0.16
Microsoft.JSInterop | 7.0.16
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.16
Microsoft.AspNetCore.Authorization | 7.0.16
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.16
Microsoft.AspNetCore.Http.Connections.Client | 7.0.16
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.16
Microsoft.AspNetCore.Owin | 7.0.16
Microsoft.AspNetCore.SignalR.Client | 7.0.16
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.16
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.16
Microsoft.AspNetCore.Connections.Abstractions | 7.0.16
AspNetCoreRuntime.7.0.x86 | 7.0.16
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.16
AspNetCoreRuntime.7.0.x64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.16
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.16
Microsoft.AspNetCore.App.Ref | 7.0.16
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.16
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.16
Microsoft.AspNetCore.Components.Web | 7.0.16
Microsoft.AspNetCore.Components.WebAssembly | 7.0.16
Microsoft.AspNetCore.Components.WebView | 7.0.16
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.16
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.16
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.16
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.16
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.16
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.16
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.16
Microsoft.AspNetCore.Grpc.Swagger | 0.3.16
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.16
Microsoft.Extensions.FileProviders.Embedded | 7.0.16
Microsoft.Extensions.Features | 7.0.16
Microsoft.Extensions.Identity.Core | 7.0.16
Microsoft.Extensions.Http.Polly | 7.0.16
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.16
Microsoft.AspNetCore.Authentication.Certificate | 7.0.16
Microsoft.AspNetCore.Authentication.Google | 7.0.16
Microsoft.AspNetCore.Authentication.Facebook | 7.0.16
Microsoft.AspNetCore.Authentication.Twitter | 7.0.16
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.16
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.16
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.16
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.16
Microsoft.AspNetCore.Components.Authorization | 7.0.16
Microsoft.AspNetCore.Components.Analyzers | 7.0.16
Microsoft.AspNetCore.Components.CustomElements | 7.0.16
Microsoft.AspNetCore.Components | 7.0.16
Microsoft.AspNetCore.Components.Forms | 7.0.16
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.16
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.16
Microsoft.AspNetCore.DataProtection | 7.0.16
Microsoft.AspNetCore.Cryptography.Internal | 7.0.16
Microsoft.AspNetCore.HeaderPropagation | 7.0.16
Microsoft.AspNetCore.Identity.UI | 7.0.16
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.16
Microsoft.AspNetCore.JsonPatch | 7.0.16
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.16
Microsoft.AspNetCore.Metadata | 7.0.16
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.16
Microsoft.AspNetCore.Mvc.Testing | 7.0.16
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.16
dotnet-sql-cache | 7.0.16
Microsoft.Extensions.ApiDescription.Client | 7.0.16
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.16
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.16
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.16
Microsoft.Extensions.Identity.Stores | 7.0.16
Microsoft.JSInterop.WebAssembly | 7.0.16
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.16
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.16
Microsoft.AspNetCore.Http.Connections.Common | 7.0.16
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.16
Microsoft.AspNetCore.OpenApi | 7.0.16
Microsoft.AspNetCore.SignalR.Common | 7.0.16
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.16
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.16
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.16
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.16
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.16
Microsoft.AspNetCore.TestHost | 7.0.16
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.16
Microsoft.AspNetCore.SpaProxy | 7.0.16
Microsoft.Authentication.WebAssembly.Msal | 7.0.16
Microsoft.Extensions.ApiDescription.Server | 7.0.16
Microsoft.dotnet-openapi | 7.0.16
Microsoft.DotNet.ApiCompat.Task | 7.0.116
FSharp.Compiler.Service | 42.7.101
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.116
Microsoft.DotNet.Common.ItemTemplates | 7.0.116
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.116
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.16
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.16
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.16
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.16
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.16
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.16
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.16
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.16
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.16
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.16
Microsoft.EntityFrameworkCore | 7.0.16
Microsoft.Data.Sqlite | 7.0.16
Microsoft.Data.Sqlite.Core | 7.0.16
Microsoft.EntityFrameworkCore.Sqlite | 7.0.16
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.16
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.16
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.16
Microsoft.EntityFrameworkCore.SqlServer | 7.0.16
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.16
Microsoft.EntityFrameworkCore.Templates | 7.0.16
Microsoft.EntityFrameworkCore.Tools | 7.0.16
Microsoft.EntityFrameworkCore.Analyzers | 7.0.16
Microsoft.EntityFrameworkCore.Abstractions | 7.0.16
Microsoft.EntityFrameworkCore.Cosmos | 7.0.16
Microsoft.EntityFrameworkCore.Design | 7.0.16
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.16
Microsoft.EntityFrameworkCore.InMemory | 7.0.16
Microsoft.EntityFrameworkCore.Relational | 7.0.16
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.16
Microsoft.EntityFrameworkCore.Proxies | 7.0.16
dotnet-ef | 7.0.16
Microsoft.TemplateEngine.Abstractions | 7.0.116
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.116
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.116
Microsoft.TemplateEngine.Tasks | 7.0.116
Microsoft.TemplateEngine.Utils | 7.0.116
Microsoft.TemplateSearch.Common | 7.0.116
Microsoft.TemplateEngine.Core | 7.0.116
Microsoft.TemplateEngine.Core.Contracts | 7.0.116
Microsoft.TemplateEngine.Edge | 7.0.116
Microsoft.TemplateEngine.IDE | 7.0.116
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.116
Microsoft.DotNet.ApiCompat.Tool | 7.0.313
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.ApiCompat.Task | 7.0.313
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.313
Microsoft.DotNet.Common.ItemTemplates | 7.0.313
Microsoft.NET.Build.Containers | 7.0.313
FSharp.Core | 7.0.300
Microsoft.TemplateEngine.Abstractions | 7.0.313
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.313
Microsoft.TemplateEngine.Core.Contracts | 7.0.313
Microsoft.TemplateEngine.Utils | 7.0.313
Microsoft.TemplateSearch.Common | 7.0.313
Microsoft.TemplateEngine.Core | 7.0.313
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.313
Microsoft.TemplateEngine.Authoring.CLI | 7.0.313
Microsoft.TemplateEngine.Edge | 7.0.313
Microsoft.TemplateEngine.IDE | 7.0.313
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.313
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.313
FSharp.Compiler.Service | 43.7.403
Microsoft.DotNet.ApiCompat.Tool | 7.0.406
Microsoft.DotNet.ApiCompat.Task | 7.0.406
FSharp.Core | 7.0.403
Microsoft.NET.Build.Containers | 7.0.406
Microsoft.DotNet.Common.ItemTemplates | 7.0.406
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.406
Microsoft.TemplateEngine.Core | 7.0.406
Microsoft.TemplateEngine.Core.Contracts | 7.0.406
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.406
Microsoft.TemplateEngine.Abstractions | 7.0.406
Microsoft.TemplateEngine.Authoring.CLI | 7.0.406
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.406
Microsoft.TemplateEngine.Utils | 7.0.406
Microsoft.TemplateSearch.Common | 7.0.406
Microsoft.TemplateEngine.Edge | 7.0.406
Microsoft.TemplateEngine.IDE | 7.0.406
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.406
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.406

[//]: # ( Runtime 7.0.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d42f9d31-6a25-4bb8-9076-7c5b0f7da69f/8e716e6a0325a8b74c4c0699f0418f38/dotnet-runtime-7.0.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d4227ba-2a3c-4313-a22e-216898a2ba28/6de108672de382cacb507d12874abacd/dotnet-runtime-7.0.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/00a49c93-61e2-425a-af4b-0576fd4c88e9/6e39babdbe5a5dd1296efa954bf807ae/dotnet-runtime-7.0.16-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/545f1e36-933f-44b2-b070-6b34ec269495/e1e9752e48af8107f35a96843566250b/dotnet-runtime-7.0.16-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a932be1-11b3-41ee-b10c-38f68c06958d/e1916c4e3a47ac85836759f6a53d2af3/dotnet-runtime-7.0.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1b18f18-1bd5-4c11-a9ed-b38ff8e5276d/c357409f720369b1eb5b6f183521ac95/dotnet-runtime-7.0.16-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1a05fa3b-da27-4ca3-962b-cc0a153d4426/457f0e19484603b5328e8d105b0c6f3e/dotnet-runtime-7.0.16-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ddbf1eea-34b3-4b30-98c4-73ecc0493e43/8d15c0d6dada8fe863549d4ccbf04e82/dotnet-runtime-7.0.16-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/77e235bf-a540-47ea-abd9-1a2f3abf2157/68b73b6c558ba67df4e13d6ecee9ec04/dotnet-runtime-7.0.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f9ceba6-cf74-43d1-b595-79f77648c9cb/00af259fec984c4a51b2f34bbf86402f/dotnet-runtime-7.0.16-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/66307624-76f1-4a3b-aaa8-235b75e40a32/6a575fa73d3293ba3f1169fb584d014a/dotnet-runtime-7.0.16-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/59cb501a-4744-4769-bfc0-53d2d42c8c06/e2f87b59d68d17650cfa4a30ba66b86c/dotnet-runtime-7.0.16-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/db19cf6a-5d54-4150-b1c1-8048cd5093c7/dd00c2ca4d49baf35838976cec0fa5d5/dotnet-runtime-7.0.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b8f20f5c-da38-4b2d-9250-547e4a92975e/f41435d39bb49155814471da8952bba5/dotnet-runtime-7.0.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e6eec276-efad-4b34-bfb8-980a550adda5/2fcb8db627a6e958aaebc9c2ec510ef5/dotnet-runtime-7.0.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4026491e-60c9-4653-8ece-89e86db1161e/397ae3b02dc225522fe1fc608d4def93/dotnet-runtime-7.0.16-win-x86.zip

[//]: # ( WindowsDesktop 7.0.16)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/dcc4e2bb-c2d8-4c26-9340-5fa9248dfb5e/3defd1e70b53730938071792db453e6d/windowsdesktop-runtime-7.0.16-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/45c6d3a0-cb06-4e92-8bcb-d5b6bfccb566/42676e1be96afbb2e744698fff3a356c/windowsdesktop-runtime-7.0.16-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/38c809cc-858d-45ed-88f5-a7f098cab691/2e4f859f8f6cf64aa952df2a80f16d2e/windowsdesktop-runtime-7.0.16-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c6fdb5d-9b95-4027-bb65-6b2de48aafa5/f5088d851dbdec2e9e53826ceb9221ac/windowsdesktop-runtime-7.0.16-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ff4b13ba-07aa-4aa7-b5ae-9111c363c802/5fdedee9a9fae645bfdda3a8930c923d/windowsdesktop-runtime-7.0.16-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9ea6e5ad-8a28-49c8-b92d-9eaa1e6e27ed/ad33fad5a45621af8f2e2e56179fe31b/windowsdesktop-runtime-7.0.16-win-x86.zip

[//]: # ( ASP 7.0.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c0b39c8-fb31-43d5-bf0f-0eb9552c6e42/4898dc960632376d7360bf20e02b82dd/aspnetcore-runtime-7.0.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce5326f4-7aa5-4463-b7aa-5be3a85387a7/940a239d2a0401a1c5745905f22d750b/aspnetcore-runtime-7.0.16-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f25e00b-59fd-4dad-b3a5-e78c38dfca92/8b3392089c165d4835125e3f4b63b684/aspnetcore-runtime-7.0.16-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4dbd75dd-b229-4dbd-a8b1-e79eebba8ed0/6799ad2dcfcd87f16297dd2d30231534/aspnetcore-runtime-7.0.16-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bfb4cc7-7763-48ae-9bd4-5e21b0c83b4b/b1f612709432a6f2647e71755bae3f6a/aspnetcore-runtime-7.0.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd076f88-c72a-411d-8d7c-a5ed352dce9c/fd020c0de8e056bb5c4a7ef6d1d983d4/aspnetcore-runtime-7.0.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d549c9a5-79cc-40fb-a71d-e3a5e80dddf0/9f3abc8afdc5a110776f0b727e13d1cb/aspnetcore-runtime-7.0.16-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b668555-cb1a-4ec9-a095-a2f04c20a0c5/477ca3d9b92b53f4a2cf6fe3ad6859fc/aspnetcore-runtime-7.0.16-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/91c974bb-6b94-4359-9f3d-b76c1de57a12/eac00748c87b58adac9efda08b475d5f/aspnetcore-runtime-7.0.16-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7c7c13e7-e0eb-439c-b17e-0508b15ddb25/dcdb52f1752782bd1e38cc8bcb80556e/aspnetcore-runtime-7.0.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/48fec85a-95ff-409e-8779-5548aea63214/170cbcb58951a14c7c2ff737e27f0562/aspnetcore-runtime-7.0.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/90863c51-8547-4b1d-bc62-3471799f354c/96b20152ede08dc863b122ad2791d817/aspnetcore-runtime-7.0.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/205a13d3-72c5-4756-af29-bfdba37fba0e/4fe0d05d7639148bbedf0e05b3c69957/aspnetcore-runtime-7.0.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1419ee9f-72b4-435f-a1e0-14c1ab7200b4/8d9a7366d093d4afd31c43456da4a2e4/dotnet-hosting-7.0.16-win.exe

[//]: # ( SDK 7.0.406)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/405ac93b-fbfc-4c9b-9395-4f5ad72ec72c/c28821fed1bb1ba1f56c139256c6a074/dotnet-sdk-7.0.406-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67aad17a-4584-40ff-8ac3-0093c63105a4/472183e47222f475198a4b4a394036f8/dotnet-sdk-7.0.406-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6a3b8ed5-fc93-487a-a325-b8e07960fbe6/f718885c732bd2c743fca9ff5cbbc344/dotnet-sdk-7.0.406-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af7d3d3b-49eb-4a42-9bd3-9adca1dc45c4/148d86242783958181c90b92017b5a3f/dotnet-sdk-7.0.406-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cad0e564-f904-4f14-85c0-01825ed42382/0e11a9e8b4a5d651039765661f7ea3ac/dotnet-sdk-7.0.406-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57150757-56af-450b-ba30-8532fac51e0f/507247327723f24970f66f51554c18bc/dotnet-sdk-7.0.406-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d4e19153-d851-434f-9c9a-c59ecbf58ea6/265b5d1f0ea6f1576b3688f063c1610b/dotnet-sdk-7.0.406-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/188a79a4-50f2-4a36-b56b-6a764d5458c4/033b59ec3d8e0ab8d76ca6763be7ae5c/dotnet-sdk-7.0.406-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/43e9b2c8-f397-4170-8cc8-9f01de1b3356/62af9e5b39a50ce42d4c9118d26ce9dd/dotnet-sdk-7.0.406-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a380401-9a77-40a2-a5bd-16c537f7e0a8/ad443240d2182d363d3b5ef7e22d2e46/dotnet-sdk-7.0.406-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9e0ae807-3c74-493a-9400-307b443fde2e/c8edaebdc52605577652033cbfc20a94/dotnet-sdk-7.0.406-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ae70a8b2-8119-4354-953d-bcb34207246a/0b32a0bc53df4032cf1181662d4c3060/dotnet-sdk-7.0.406-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/116578f1-3fd4-4847-8bcb-023aeca2c8b2/bfbd897456eaaf8a56f1e838b35d2717/dotnet-sdk-7.0.406-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/fcb3a458-d679-4ec2-a3fa-0bcbc77da68a/3d08bf7e392f5e028459658d2c722ec1/dotnet-sdk-7.0.406-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4fb09f51-4c64-4d68-9087-95cd956a8cb2/c84d95447636248b7b866a8c78514480/dotnet-sdk-7.0.406-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/484c52ee-8ed3-4c89-bac9-2d42884bf110/dbb86b282a73ae5a7e25fe87f7194647/dotnet-sdk-7.0.406-win-x86.zip
