# .NET 7.0.17 - March 12, 2024

The .NET 7.0.17 and .NET SDK 7.0.407 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.407
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.17 release carries security fixes.

[CVE-2024-21392 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21392)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 . This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in .NET where specially crafted requests may cause a resource leak, leading to a Denial of Service


[CVE-2024-26190 |  Microsoft QUIC Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-26190)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exist in MsQuic.dll which might result in a peer to allocate small chunks of memory as long as connection stays alive.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9214](https://github.com/dotnet/core/issues/9214) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.17.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.17-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.17-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/March-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.17+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.17+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.17+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.17+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.17+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.17+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.17xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.17
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.17
Microsoft.WindowsDesktop.App.Ref | 7.0.17
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.17
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.17
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.17
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.17
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.17
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.17
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.17
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.17
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.17
Microsoft.NETCore.App.Composite | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.17
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.17
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.17
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.17
Microsoft.NETCore.App.Host.linux-x64 | 7.0.17
Microsoft.NETCore.App.Host.osx-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.17
Microsoft.NETCore.DotNetHost | 7.0.17
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.17
Microsoft.NETCore.App.Host.linux-arm | 7.0.17
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.17
Microsoft.NETCore.App.Host.win-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.17
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.17
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.17
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.17
Microsoft.NETCore.App.Host.win-arm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.17
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.17
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.17
Microsoft.DotNet.ILCompiler | 7.0.17
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.17
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.17
Microsoft.NETCore.App.Ref | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.17
Microsoft.Windows.Compatibility | 7.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.17
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.17
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.17
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Host.win-arm64 | 7.0.17
Microsoft.NETCore.App.Host.win-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.17
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.17
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.17
Microsoft.NETCore.DotNetHostPolicy | 7.0.17
Microsoft.NETCore.DotNetAppHost | 7.0.17
Microsoft.NETCore.DotNetHostResolver | 7.0.17
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.17
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.17
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.17
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.17
Microsoft.AspNetCore.Components.Forms | 7.0.17
Microsoft.AspNetCore.DataProtection | 7.0.17
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.17
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.17
Microsoft.AspNetCore.Identity.UI | 7.0.17
Microsoft.AspNetCore.Http.Connections.Client | 7.0.17
Microsoft.AspNetCore.Http.Connections.Common | 7.0.17
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.17
Microsoft.AspNetCore.OpenApi | 7.0.17
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.17
Microsoft.AspNetCore.SignalR.Common | 7.0.17
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.17
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.17
Microsoft.AspNetCore.TestHost | 7.0.17
Microsoft.Extensions.ApiDescription.Client | 7.0.17
Microsoft.JSInterop | 7.0.17
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.17
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.17
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.17
Microsoft.AspNetCore.Authentication.Certificate | 7.0.17
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.17
Microsoft.AspNetCore.Authentication.Twitter | 7.0.17
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.17
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.17
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.17
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.17
Microsoft.AspNetCore.Components.CustomElements | 7.0.17
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.17
Microsoft.AspNetCore.Components.WebAssembly | 7.0.17
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.17
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.17
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.17
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.17
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.17
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.17
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.17
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.17
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.17
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.17
Microsoft.Extensions.FileProviders.Embedded | 7.0.17
Microsoft.Extensions.Identity.Core | 7.0.17
Microsoft.Extensions.Http.Polly | 7.0.17
Microsoft.Extensions.ObjectPool | 7.0.17
Microsoft.Extensions.WebEncoders | 7.0.17
Microsoft.JSInterop.WebAssembly | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.17
AspNetCoreRuntime.7.0.x86 | 7.0.17
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.17
Microsoft.AspNetCore.App.Ref | 7.0.17
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.17
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.17
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.17
dotnet-sql-cache | 7.0.17
AspNetCoreRuntime.7.0.x64 | 7.0.17
Microsoft.AspNetCore.Components | 7.0.17
Microsoft.AspNetCore.Components.Analyzers | 7.0.17
Microsoft.AspNetCore.Components.Authorization | 7.0.17
Microsoft.AspNetCore.Metadata | 7.0.17
Microsoft.AspNetCore.JsonPatch | 7.0.17
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.17
Microsoft.AspNetCore.Mvc.Testing | 7.0.17
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.17
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.17
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.17
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.17
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.17
Microsoft.AspNetCore.Authentication.Google | 7.0.17
Microsoft.AspNetCore.Authentication.Facebook | 7.0.17
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.17
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.17
Microsoft.AspNetCore.Authorization | 7.0.17
Microsoft.AspNetCore.Components.Web | 7.0.17
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.17
Microsoft.AspNetCore.Components.WebView | 7.0.17
Microsoft.AspNetCore.Connections.Abstractions | 7.0.17
Microsoft.AspNetCore.Cryptography.Internal | 7.0.17
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.17
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.17
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.17
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.17
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.17
Microsoft.AspNetCore.Grpc.Swagger | 0.3.174
Microsoft.AspNetCore.HeaderPropagation | 7.0.17
Microsoft.AspNetCore.Owin | 7.0.17
Microsoft.AspNetCore.SignalR.Client | 7.0.17
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.17
Microsoft.AspNetCore.SpaProxy | 7.0.17
Microsoft.Authentication.WebAssembly.Msal | 7.0.17
Microsoft.dotnet-openapi | 7.0.17
Microsoft.Extensions.ApiDescription.Server | 7.0.17
Microsoft.Extensions.Caching.SqlServer | 7.0.17
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.17
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.17
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.17
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.17
Microsoft.Extensions.Features | 7.0.17
Microsoft.Extensions.Localization.Abstractions | 7.0.17
Microsoft.Extensions.Identity.Stores | 7.0.17
Microsoft.Extensions.Localization | 7.0.17
Microsoft.Extensions.Logging.AzureAppServices | 7.0.17
Microsoft.DotNet.Common.ItemTemplates | 7.0.407
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.407
Microsoft.NET.Build.Containers | 7.0.407
FSharp.Compiler.Service | 43.7.403
Microsoft.DotNet.ApiCompat.Tool | 7.0.407
FSharp.Core | 7.0.403
Microsoft.DotNet.ApiCompat.Task | 7.0.407
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.17
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.17
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.17
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.17
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.17
Microsoft.EntityFrameworkCore.Relational | 7.0.17
Microsoft.Data.Sqlite | 7.0.17
Microsoft.EntityFrameworkCore.Sqlite | 7.0.17
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.17
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.17
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.17
Microsoft.EntityFrameworkCore.SqlServer | 7.0.17
Microsoft.EntityFrameworkCore.Tools | 7.0.17
dotnet-ef | 7.0.17
Microsoft.EntityFrameworkCore | 7.0.17
Microsoft.Data.Sqlite.Core | 7.0.17
Microsoft.EntityFrameworkCore.Abstractions | 7.0.17
Microsoft.EntityFrameworkCore.Analyzers | 7.0.17
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.17
Microsoft.EntityFrameworkCore.Cosmos | 7.0.17
Microsoft.EntityFrameworkCore.Design | 7.0.17
Microsoft.EntityFrameworkCore.InMemory | 7.0.17
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.17
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.17
Microsoft.EntityFrameworkCore.Proxies | 7.0.17
Microsoft.EntityFrameworkCore.Templates | 7.0.17
FSharp.Compiler.Service | 43.7.300
Microsoft.NET.Build.Containers | 7.0.314
FSharp.Core | 7.0.300
Microsoft.DotNet.Common.ItemTemplates | 7.0.314
Microsoft.DotNet.ApiCompat.Tool | 7.0.314
Microsoft.DotNet.ApiCompat.Task | 7.0.314
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.314
Microsoft.TemplateEngine.Authoring.CLI | 7.0.314
Microsoft.TemplateEngine.Abstractions | 7.0.314
Microsoft.TemplateEngine.Core | 7.0.314
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.314
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.314
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.314
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.314
Microsoft.TemplateEngine.Edge | 7.0.314
Microsoft.TemplateEngine.IDE | 7.0.314
Microsoft.TemplateEngine.Core.Contracts | 7.0.314
Microsoft.TemplateEngine.Utils | 7.0.314
Microsoft.TemplateSearch.Common | 7.0.314
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.117
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.ApiCompat.Task | 7.0.117
Microsoft.DotNet.Common.ItemTemplates | 7.0.117
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.117
Microsoft.TemplateEngine.Core | 7.0.117
Microsoft.TemplateEngine.Abstractions | 7.0.117
Microsoft.TemplateEngine.Edge | 7.0.117
Microsoft.TemplateEngine.IDE | 7.0.117
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.117
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.117
Microsoft.TemplateSearch.Common | 7.0.117
Microsoft.TemplateEngine.Core.Contracts | 7.0.117
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.117
Microsoft.TemplateEngine.Utils | 7.0.117
Microsoft.TemplateEngine.Tasks | 7.0.117

[//]: # ( Runtime 7.0.17)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6677adf-9e47-42af-98f8-ded684ced399/6ed3ca4d40bd6455b30ea77d1dfab410/dotnet-runtime-7.0.17-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7016bc89-6c69-40da-a8cb-50107f339810/41d1c8560655da79817eb31532570401/dotnet-runtime-7.0.17-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d13f1503-44d9-47df-8214-749daefaaaba/17e4d32c8e6cff15e29f5ebd9b63229d/dotnet-runtime-7.0.17-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2cca7867-1911-4e6c-a5b1-f894c0ace9ea/4bcf31bf87be0abbc0e8691cb32bb174/dotnet-runtime-7.0.17-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f14c677e-c6c1-48f8-a972-f00a1d0c3025/9f7a2038858bbbbaf478a92f1030a429/dotnet-runtime-7.0.17-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7329e982-d340-4e00-9a4a-933327710b9e/c578c156a3e2a94cc4e59447dd312c33/dotnet-runtime-7.0.17-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/97a4fbb6-7e2b-4e9b-af3e-85a87f16bc4d/b10c54825fa76f83a277c2a0f6b164f9/dotnet-runtime-7.0.17-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5585224-b050-4e21-938e-f9c68e3bce62/7af1c98ed83514644337f17028282ae1/dotnet-runtime-7.0.17-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f6fa957c-189f-4092-9e70-6d76c38cdcde/eed8824783f7afd2dd20fd6de6865c53/dotnet-runtime-7.0.17-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7055c472-e60a-41f3-b583-e3d95f2b0730/b099f5fbbedb6c1801465ea9b6f6e55f/dotnet-runtime-7.0.17-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f75e6991-6e7f-4d13-9a9e-bda177f9e2a3/9cb2197ab090a423580289dc39aedadc/dotnet-runtime-7.0.17-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4da6ccc3-c5e4-4256-b035-83b9955e37a4/47b76fdc24fa4360b7432f61a27cfbf2/dotnet-runtime-7.0.17-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e35dac95-2855-44f9-b6c9-dda018d922ba/fcc2416e232942d81435a659024bd4e5/dotnet-runtime-7.0.17-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/90d85e37-2f7a-43d8-a060-ee9bfa2935d9/30bbf49e665484d29bef4763ceb786db/dotnet-runtime-7.0.17-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/37494551-f702-4cfc-a7dd-8f4b2220ba9f/9dd5de132e617b54b6d959fa0688a88d/dotnet-runtime-7.0.17-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2bd24a21-acae-4595-a18c-b95e4689981f/9b4c912742d11f9fbdd5303395f1f174/dotnet-runtime-7.0.17-win-x86.zip

[//]: # ( WindowsDesktop 7.0.17)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1e3fd87b-1c3f-4096-9492-ebcdf33d3e3f/91cb5d7efa6db8bfb1d08d83d0e287c7/windowsdesktop-runtime-7.0.17-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d1133f04-51ed-44ab-b3d7-43f9fa79f066/e0536326adcce3e0de6e03137501f701/windowsdesktop-runtime-7.0.17-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c81fc3af-c371-4bb5-a59d-fa3e852799c7/056ac9df87d92b75cc463cb106ef3b64/windowsdesktop-runtime-7.0.17-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/06978221-00f2-4f1b-ae36-7f75b8c3fe75/212224931b6ff82bd8dc6a842ca4501d/windowsdesktop-runtime-7.0.17-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3375deb2-9c69-41b0-b3ee-a6ed6e87c705/caf33fdd0f8c3e8aa8a7229be1ae3de7/windowsdesktop-runtime-7.0.17-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2cc3f937-417e-44a8-81d7-3dcec0ff67bc/2d8e0a8a8c5e7ffdfa5054ed00d8e45b/windowsdesktop-runtime-7.0.17-win-x86.zip

[//]: # ( ASP 7.0.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3b047f9-425c-45a7-9372-493e6c3fc509/1294f6a3d5013b6b1983cae36bfbac92/aspnetcore-runtime-7.0.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aedca120-d2eb-4b54-aef0-45520ebcf2fb/514dac96b582bcafc7eb238499c3fff5/aspnetcore-runtime-7.0.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bc09bce-843f-4223-98ec-ff94c402eb8d/ca3f719761436d36a9412dc3236aa724/aspnetcore-runtime-7.0.17-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39e361bb-c488-4a44-896a-7206a2a3e29d/b89febec940542836611cb176d9123da/aspnetcore-runtime-7.0.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0ce1367-65ad-4eb3-a461-3236b843ba54/8972d2c873e033217614c2debcd5efcf/aspnetcore-runtime-7.0.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c97c327d-c699-455e-8c98-f2bee01a9816/ac33d9589182f506d2c498b5e7d52bb2/aspnetcore-runtime-7.0.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed189d17-cd55-4f43-ad0b-5b5cee85090b/835d867a5efb1236e1e17ee76af30e16/aspnetcore-runtime-7.0.17-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b87831a-9970-4bb7-8932-e84444b16429/e7f75f20ba9711a8c8a6b23272ec155d/aspnetcore-runtime-7.0.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/eafcf3ef-c90b-4276-8e3d-4223c97818da/52cd440183fb3d8b32dc727b7373f83f/aspnetcore-runtime-7.0.17-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/098be53d-5a2d-4946-82f4-a5634fee5ba3/cdf19e1258534bbd1a42007d3f859f74/aspnetcore-runtime-7.0.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c5fdaee7-5ab6-48a7-8b89-e525e766d173/c5d54d55824a9e4a415428bb3f9404fe/aspnetcore-runtime-7.0.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b52321fc-bb1c-4314-9990-a373e75e1b91/8c92eb4e78cc902148fc920d01080039/aspnetcore-runtime-7.0.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9deaa476-2d8a-4d79-9e97-a891b541b8f5/08f889dcee6bd9d286c9ae4c73cea57a/aspnetcore-runtime-7.0.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5d44e448-88ba-493f-9aff-d6daa1319181/7c500e85192bae5e1c43484b0bc7bdd5/dotnet-hosting-7.0.17-win.exe

[//]: # ( SDK 7.0.407)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f527ce95-181c-44fa-9ebe-a7d899b68eba/12402a77e19caaeff8248eaf5e092367/dotnet-sdk-7.0.407-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20d6bfe0-2d50-4f21-a074-a0c1462bcbcb/7300ba9d53182edea839535774cf9336/dotnet-sdk-7.0.407-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a3e11ff-8f1c-41a1-82f3-c1ea3fa28a54/8bbd4777466f8e2d54e72a2477f280a0/dotnet-sdk-7.0.407-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c97550c-7b52-410f-bf4c-18a9adee7ad6/e6ec08b808e7f839b74585357430699a/dotnet-sdk-7.0.407-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50c9eb3a-4836-4ec6-9f19-cf5fefc4d81b/0eb61d05edfb1d2ee90477a12c14960f/dotnet-sdk-7.0.407-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd9f066f-c0cf-495f-95bc-c3b96c9cf06e/ec93222e82bca1aa14590beb8a73625c/dotnet-sdk-7.0.407-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/64222b05-2138-42c3-b101-08c814b2f6e3/49781e5316479099a9441c4506cd1e5f/dotnet-sdk-7.0.407-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d625ad2-9c2e-41cd-a21b-1de0a49128dd/2f46d764be06da15cdfe07414763601f/dotnet-sdk-7.0.407-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/76919cab-fb8f-4726-b4cc-6c711dd99eb2/f64d22a2adf0426490bd22507bcef35d/dotnet-sdk-7.0.407-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0fb2e12b-4cb7-409c-ba65-91efbc7ed601/8846094f62316e41e44fd751e24264bc/dotnet-sdk-7.0.407-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/eb99fc69-fe18-4f53-bda5-a89e53f88f45/262ea26e79f9eaed963288601f0031df/dotnet-sdk-7.0.407-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f9cc19f4-8c74-4da1-9a23-13187c3d75e8/7cc3e44b289add25b35b2915cafa4285/dotnet-sdk-7.0.407-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f2ec926e-0d98-4a8b-8c70-722ccc2ca0e5/b59941b0c60f16421679baafdb7e9338/dotnet-sdk-7.0.407-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d0136505-ccb0-40c4-9284-341995f520a4/2a9b648902014af699cc9f847d923d1e/dotnet-sdk-7.0.407-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f7f831c9-ee1e-4501-bfc8-d3750aeb0e76/8a7dce2defcd92c77e147603fce87528/dotnet-sdk-7.0.407-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b7c5531a-b80a-4f77-a024-2d677e9a1aa1/a83804f133fe5a7b0d36263b10f3c666/dotnet-sdk-7.0.407-win-x86.zip
