# .NET 7.0.18 - April 09, 2024

The .NET 7.0.18 and .NET SDK 7.0.408 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.408
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.18 release carries security fixes.

[CVE-2024-21409 | .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21409)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 ,and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability. This is a Windows only vulnerability.

A use-after-free vulnerability exists in WPF which may result in Elevation of Privilege when viewing untrusted documents.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9263](https://github.com/dotnet/core/issues/9263) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.18.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.18-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.18-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/April-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.18+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.18+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.18+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.18+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.18+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.18+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.18xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 7.0.18
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.18
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.18
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.18
Microsoft.NETCore.App.Composite | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.18
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.18
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.18
Microsoft.NETCore.App.Host.linux-x64 | 7.0.18
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.18
Microsoft.NETCore.App.Host.win-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.18
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.18
Microsoft.NETCore.App.Host.win-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.18
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm | 7.0.18
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.18
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.18
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.18
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.18
Microsoft.NETCore.App.Host.osx-x64 | 7.0.18
Microsoft.NETCore.App.Ref | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
Microsoft.DotNet.ILCompiler | 7.0.18
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.18
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.18
Microsoft.NETCore.App.Host.win-arm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.18
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.18
Microsoft.NETCore.DotNetAppHost | 7.0.18
Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.18
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.18
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.18
Microsoft.NETCore.App.Host.linux-arm | 7.0.18
Microsoft.NETCore.App.Host.win-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.18
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.18
Microsoft.NETCore.DotNetHost | 7.0.18
Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.18
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.18
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.18
AspNetCoreRuntime.7.0.x64 | 7.0.18
dotnet-sql-cache | 7.0.18
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.18
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.18
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.18
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.18
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.18
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.18
Microsoft.AspNetCore.Grpc.Swagger | 0.3.18
Microsoft.AspNetCore.HeaderPropagation | 7.0.18
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.18
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.18
Microsoft.AspNetCore.Identity.UI | 7.0.18
Microsoft.AspNetCore.Http.Connections.Client | 7.0.18
Microsoft.AspNetCore.Metadata | 7.0.18
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.18
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.18
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.18
Microsoft.AspNetCore.Mvc.Testing | 7.0.18
Microsoft.AspNetCore.OpenApi | 7.0.18
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.18
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.18
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.18
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.18
Microsoft.AspNetCore.SpaProxy | 7.0.18
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.18
Microsoft.AspNetCore.TestHost | 7.0.18
Microsoft.Authentication.WebAssembly.Msal | 7.0.18
Microsoft.Extensions.ApiDescription.Server | 7.0.18
Microsoft.dotnet-openapi | 7.0.18
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.18
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.18
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.18
Microsoft.AspNetCore.Authentication.Certificate | 7.0.18
Microsoft.AspNetCore.Authentication.Facebook | 7.0.18
Microsoft.AspNetCore.Authentication.Google | 7.0.18
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.18
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.18
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.18
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.18
Microsoft.AspNetCore.Authentication.Twitter | 7.0.18
Microsoft.AspNetCore.Components | 7.0.18
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.18
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.18
Microsoft.AspNetCore.Owin | 7.0.18
Microsoft.AspNetCore.SignalR.Common | 7.0.18
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.18
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.18
Microsoft.Extensions.ApiDescription.Client | 7.0.18
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.18
Microsoft.Extensions.FileProviders.Embedded | 7.0.18
Microsoft.Extensions.Identity.Core | 7.0.18
Microsoft.Extensions.Http.Polly | 7.0.18
Microsoft.Extensions.Features | 7.0.18
Microsoft.Extensions.Identity.Stores | 7.0.18
Microsoft.Extensions.ObjectPool | 7.0.18
Microsoft.Extensions.Localization | 7.0.18
Microsoft.Extensions.Localization.Abstractions | 7.0.18
Microsoft.Extensions.Logging.AzureAppServices | 7.0.18
Microsoft.Extensions.WebEncoders | 7.0.18
Microsoft.JSInterop | 7.0.18
Microsoft.JSInterop.WebAssembly | 7.0.18
Microsoft.AspNetCore.Components.WebAssembly | 7.0.18
Microsoft.AspNetCore.DataProtection | 7.0.18
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.18
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.18
AspNetCoreRuntime.7.0.x86 | 7.0.18
Microsoft.AspNetCore.App.Ref | 7.0.18
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.18
Microsoft.AspNetCore.Http.Connections.Common | 7.0.18
Microsoft.AspNetCore.JsonPatch | 7.0.18
Microsoft.AspNetCore.SignalR.Client | 7.0.18
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.18
Microsoft.Extensions.Caching.SqlServer | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.18
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.18
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.18
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.18
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.18
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.18
Microsoft.AspNetCore.Components.Authorization | 7.0.18
Microsoft.AspNetCore.Components.Analyzers | 7.0.18
Microsoft.AspNetCore.Components.CustomElements | 7.0.18
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.18
Microsoft.AspNetCore.Components.Forms | 7.0.18
Microsoft.AspNetCore.Components.Web | 7.0.18
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.18
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.18
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.18
Microsoft.AspNetCore.Authorization | 7.0.18
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.18
Microsoft.AspNetCore.Components.WebView | 7.0.18
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.18
Microsoft.AspNetCore.Connections.Abstractions | 7.0.18
Microsoft.AspNetCore.Cryptography.Internal | 7.0.18
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.18
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.18
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.18
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.18
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.18
FSharp.Compiler.Service | 43.7.403
FSharp.Core | 7.0.403
Microsoft.DotNet.ApiCompat.Tool | 7.0.408
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.408
Microsoft.NET.Build.Containers | 7.0.408
Microsoft.DotNet.ApiCompat.Task | 7.0.408
Microsoft.DotNet.Common.ItemTemplates | 7.0.408
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.18
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.18
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.18
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.18
Microsoft.EntityFrameworkCore | 7.0.18
dotnet-ef | 7.0.18
Microsoft.Data.Sqlite.Core | 7.0.18
Microsoft.EntityFrameworkCore.Abstractions | 7.0.18
Microsoft.EntityFrameworkCore.Analyzers | 7.0.18
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.18
Microsoft.EntityFrameworkCore.Cosmos | 7.0.18
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.18
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.18
Microsoft.EntityFrameworkCore.Tools | 7.0.18
Microsoft.Data.Sqlite | 7.0.18
Microsoft.EntityFrameworkCore.InMemory | 7.0.18
Microsoft.EntityFrameworkCore.Proxies | 7.0.18
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.18
Microsoft.EntityFrameworkCore.Design | 7.0.18
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.18
Microsoft.EntityFrameworkCore.Sqlite | 7.0.18
Microsoft.EntityFrameworkCore.Relational | 7.0.18
Microsoft.EntityFrameworkCore.SqlServer | 7.0.18
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.18
Microsoft.EntityFrameworkCore.Templates | 7.0.18
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.408
Microsoft.TemplateEngine.Core | 7.0.408
Microsoft.TemplateEngine.Authoring.CLI | 7.0.408
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.408
Microsoft.TemplateEngine.Core.Contracts | 7.0.408
Microsoft.TemplateEngine.Edge | 7.0.408
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.408
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.408
Microsoft.TemplateSearch.Common | 7.0.408
Microsoft.TemplateEngine.IDE | 7.0.408
Microsoft.TemplateEngine.Utils | 7.0.408
Microsoft.TemplateEngine.Abstractions | 7.0.408
Microsoft.DotNet.ApiCompat.Task | 7.0.315
Microsoft.NET.Build.Containers | 7.0.315
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.315
Microsoft.DotNet.ApiCompat.Tool | 7.0.315
Microsoft.DotNet.Common.ItemTemplates | 7.0.315
FSharp.Compiler.Service | 43.7.300
FSharp.Core | 7.0.300
Microsoft.TemplateEngine.Core | 7.0.315
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.315
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.315
Microsoft.TemplateEngine.Edge | 7.0.315
Microsoft.TemplateEngine.Core.Contracts | 7.0.315
Microsoft.TemplateEngine.IDE | 7.0.315
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.315
Microsoft.TemplateSearch.Common | 7.0.315
Microsoft.TemplateEngine.Utils | 7.0.315
Microsoft.TemplateEngine.Abstractions | 7.0.315
Microsoft.TemplateEngine.Authoring.CLI | 7.0.315
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.315
FSharp.Compiler.Service | 2.7.101
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Task | 7.0.118
Microsoft.DotNet.Common.ItemTemplates | 7.0.118
Microsoft.DotNet.ApiCompat.Tool | 7.0.118
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.118
Microsoft.TemplateEngine.Abstractions | 7.0.118
Microsoft.TemplateEngine.Core | 7.0.118
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.118
Microsoft.TemplateEngine.IDE | 7.0.118
Microsoft.TemplateEngine.Edge | 7.0.118
Microsoft.TemplateEngine.Tasks | 7.0.118
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.118
Microsoft.TemplateEngine.Utils | 7.0.118
Microsoft.TemplateSearch.Common | 7.0.118
Microsoft.TemplateEngine.Core.Contracts | 7.0.118
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.118

[//]: # ( Runtime 7.0.18)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68657d51-2ae9-47a1-90f1-0304edee9dac/6ab959c39bc60300f6dd15cc12e14a82/dotnet-runtime-7.0.18-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7dc89d5-3287-4f82-b1fa-e0a7f12f7736/3206b55ee6d717f4008a46e67048c100/dotnet-runtime-7.0.18-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a276c65d-2493-4dcc-be97-2024d94fe672/7483c5ed8304bd779920abb8431a3037/dotnet-runtime-7.0.18-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/886fd0af-392f-4084-a85c-1c9dff9301bd/0f7bf6af6dd6859b2e4a5c2dff97befb/dotnet-runtime-7.0.18-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47e101a7-e993-442f-a12f-ccf80a3a6c45/ad905e822580a421da941c4e13fd8c1e/dotnet-runtime-7.0.18-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f48eeb2-ca25-4828-87d9-1114e751fa6e/df269cfd6b9661bcd776ed979541c0fe/dotnet-runtime-7.0.18-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/13ab6be3-e87d-4433-b413-447ec5350f02/9d2f218664fd58b1d2ac98d9104ac0c7/dotnet-runtime-7.0.18-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38526acb-1b20-4fd6-8a4d-09d72a48c9f8/8db4c13c722425ca9b82fed60d539815/dotnet-runtime-7.0.18-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bee2ab1d-6bc6-416a-99fc-3d1595f59e6a/1ce2f67eeda5107bdf108c8e87c02d19/dotnet-runtime-7.0.18-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bbb4960-9fb2-4bd9-a525-80e6260b5979/adecde0cf003ce421b06e76197627533/dotnet-runtime-7.0.18-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c731113e-b0ed-472b-9105-d54a2068c61a/6891a774526c6182424114e81143b2ea/dotnet-runtime-7.0.18-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0b98bd75-5f44-47d8-a6a7-34c0bff7d4fd/5df4c99342e1ed3afe7e51bc6060e023/dotnet-runtime-7.0.18-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8763b899-b403-457a-8bc2-5bd4280e0c25/3818b2cdb9c98f015d90402cbb473426/dotnet-runtime-7.0.18-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f65d29ce-230a-4079-a440-e1be7241662f/ac56bb1e049bc964d45d5dde191fa393/dotnet-runtime-7.0.18-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/45e8bd9b-4de0-4241-b1e3-714382882877/8323ae5b4c55de1257ab569a24ad30ad/dotnet-runtime-7.0.18-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/033c684f-71aa-46ed-829c-62cc89f8b35e/8a5dec5f6c5b12dd3bf2196b3dd18870/dotnet-runtime-7.0.18-win-x86.zip

[//]: # ( WindowsDesktop 7.0.18)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5ba570b4-c834-4b6f-8590-561985f2f326/966f2683a39896227f0d697837b3652a/windowsdesktop-runtime-7.0.18-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c45593bd-3b79-4fe9-acef-211172987b98/ab776821d8a2bdc244e63ebd72e9fc2c/windowsdesktop-runtime-7.0.18-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e8b0aac4-7f86-4a7b-9a9a-448aa2b0f116/99a4178751b799db3d059b4b22b4451e/windowsdesktop-runtime-7.0.18-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4f442473-28c9-4ca8-aa95-2da4b5352a96/a8b3ec35392b7e10ffd837d0e5a64481/windowsdesktop-runtime-7.0.18-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0e6c8e02-c8de-4948-9d9c-95b9521a35dd/bb162aaedc45c0bfc4b110dd26271539/windowsdesktop-runtime-7.0.18-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/16ac7ce4-6f16-4d22-aa57-da15395c789c/6642efd30caa026bb2cacec300beb8b5/windowsdesktop-runtime-7.0.18-win-x86.zip

[//]: # ( ASP 7.0.18)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c5bed59-b840-4f15-8be1-3fd25beb1b5b/a07c070720a76ca1e81d233ec7bff840/aspnetcore-runtime-7.0.18-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/119db743-de75-4bfd-ac51-f2a2bfd1dd1b/4e96dcef933e3787a34691a86f8972cf/aspnetcore-runtime-7.0.18-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62021888-26fd-410c-8a1c-9fb4947cd674/9b3e736c8b52ccc60ce316169f54c769/aspnetcore-runtime-7.0.18-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57591ffa-6096-4bf0-a2d5-4c7b2f01b750/758a6946089c55429b95afd08280581c/aspnetcore-runtime-7.0.18-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9220bf4f-a1de-4df6-93c4-430fc51cd1af/e62a18b2dbbd56fbb7b7410caef52134/aspnetcore-runtime-7.0.18-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39baab6f-96c6-42bf-b772-29830158176b/cde064792e7f22506d692f54993fe5a5/aspnetcore-runtime-7.0.18-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/be772e15-f6f4-46a4-b0de-2365ccafa69d/fac2f4ae76ba20f7d16e07b60c2b8801/aspnetcore-runtime-7.0.18-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79433d6a-6ac8-4c1e-851b-a9335319d846/c91648d921bcec7bedebdaf83cfe0487/aspnetcore-runtime-7.0.18-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f93c1275-8027-405b-b2b8-0273b22005de/f61beafdf2eed62fb199bde1d0dd1ba5/aspnetcore-runtime-7.0.18-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/02dd5cac-62a6-4a34-b515-3987e940dc0d/4116dd9d03b0d7f31c4a15a076b6ec47/aspnetcore-runtime-7.0.18-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/631ccca0-7dac-4429-ac8c-6528ac29748b/a9de65f2324db26a7f2d1b01def2c130/aspnetcore-runtime-7.0.18-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b0fb2305-f64f-4ea0-b90d-5d233973e2d3/1f908dd8f53d9e609c31054668f8c5ea/aspnetcore-runtime-7.0.18-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3190f01d-b74f-4175-b0e5-0d6cd782f7b7/2e52410f12f01b3a958c0c5c43b1e605/aspnetcore-runtime-7.0.18-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5c21d823-4a3d-43ef-8b94-fd5fff183219/7256acb83dfb031b0948b942d35cbf80/dotnet-hosting-7.0.18-win.exe

[//]: # ( SDK 7.0.408)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/523c6c34-047e-4fdf-b36f-1386fb88342c/8790121e36bf5d3d94f7efea1d36d018/dotnet-sdk-7.0.408-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/460f951f-0944-442b-8474-555e20394ca8/5fcf6b1845d87d772f919737b3dd5f55/dotnet-sdk-7.0.408-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d6a07d0-f46c-409e-966a-8419e2348bc0/7c78f5a8abf85e5aa91a85c931e8dd58/dotnet-sdk-7.0.408-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7928f6c-18a6-418b-9ca1-242d2c8ea8cc/ba6deb2063d14a65e13152177c2f8320/dotnet-sdk-7.0.408-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30680979-79a3-4bb4-9179-e570a4d8314e/a5d292c806e90d08e93cc26509e78831/dotnet-sdk-7.0.408-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a256265b-0ec6-4b63-b943-bc27bcfc98c0/47c8bbd54d7f6dbfe0ca4985c410282e/dotnet-sdk-7.0.408-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5cd047f7-899a-4e00-9c86-d79fe7fe3d6e/82f1cb63ebebe92d084cfc7ab6204b6f/dotnet-sdk-7.0.408-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/749ab69c-0726-4503-9e92-035f13753374/68cbf2a5d6c8e1184f5d8d8ca3bc49a6/dotnet-sdk-7.0.408-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a54f7102-d834-48b0-b6f4-32d9d215dd51/57c2418d3d1d7be290e032e535af2d13/dotnet-sdk-7.0.408-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dff43b03-6ca6-413b-a48e-82f593c12d40/5760ef99163056c6850f0fe140e01958/dotnet-sdk-7.0.408-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/49d22ce2-3b18-4766-962a-c873af758766/6be5f19068881f32cc97c48b28e94b31/dotnet-sdk-7.0.408-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f8f123a3-b6cb-4058-86b3-02701ba5c71c/70e4c73c4c1127ec45c1a4b31161441e/dotnet-sdk-7.0.408-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8091a826-e1c4-424a-b17b-5c10776cd3de/8957f21a279322d8fac9b542c6aba12e/dotnet-sdk-7.0.408-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/da9fce82-fdcb-4ca0-b5f3-e7de48671af1/eb11d529902618d1c26823e1a82af2c4/dotnet-sdk-7.0.408-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e0be4849-e53a-43b0-a8df-5995177fc231/0e248a79b845b72065d7c9f3e89e793b/dotnet-sdk-7.0.408-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/45a7d5dd-2f65-4e6d-9439-528377f22ef5/9009f1edbf4571574f6008f481dd4b41/dotnet-sdk-7.0.408-win-x86.zip
