# .NET 7.0.19 - May 14, 2024

The .NET 7.0.19 and .NET SDK 7.0.409 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.409
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

.NET 7.0.19 release carries security fixes.

[CVE-2024-30045 | .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-30045)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Remote Code Execution vulnerability exists in  .NET 7.0 and .NET 8.0 where a stack buffer overrun occurs in .NET Double Parse routine.

[CVE-2024-30046 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-30046)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exist in Microsoft.AspNetCore.Server.Kestrel.Core.dll where a dead-lock can occur resulting in Denial of Service.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9309](https://github.com/dotnet/core/issues/9309) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.19.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.19-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.19-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.19+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.19+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.19+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.19+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.19+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.19+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.19xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.19
Microsoft.WindowsDesktop.App.Ref | 7.0.19
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.19
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.19
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.19
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.19
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.19
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.19
Microsoft.NETCore.App.Host.win-arm64 | 7.0.19
Microsoft.NETCore.App.Host.win-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.19
Microsoft.NETCore.App.Host.linux-arm | 7.0.19
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.19
Microsoft.DotNet.ILCompiler | 7.0.19
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.19
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.19
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.19
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.19
Microsoft.NETCore.App.Ref | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.19
Microsoft.NETCore.DotNetAppHost | 7.0.19
Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.19
Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.19
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Composite | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.19
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Host.win-arm | 7.0.19
Microsoft.NETCore.App.Host.win-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.19
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.19
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.19
Microsoft.NETCore.App.Host.linux-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.19
Microsoft.NETCore.App.Host.osx-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.19
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.19
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.19
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.19
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.19
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.19
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.19
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.19
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.19
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.19
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.19
Microsoft.AspNetCore.Components | 7.0.19
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.19
Microsoft.AspNetCore.Components.Analyzers | 7.0.19
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.19
Microsoft.AspNetCore.Components.Web | 7.0.19
Microsoft.AspNetCore.Components.WebAssembly | 7.0.19
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.19
Microsoft.AspNetCore.Components.WebView | 7.0.19
Microsoft.AspNetCore.Cryptography.Internal | 7.0.19
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.19
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.19
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.19
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.19
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.19
Microsoft.AspNetCore.Grpc.Swagger | 0.3.19
Microsoft.AspNetCore.Identity.UI | 7.0.19
Microsoft.AspNetCore.HeaderPropagation | 7.0.19
Microsoft.AspNetCore.Metadata | 7.0.19
Microsoft.AspNetCore.Mvc.Testing | 7.0.19
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.19
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.19
Microsoft.AspNetCore.TestHost | 7.0.19
Microsoft.AspNetCore.SpaProxy | 7.0.19
Microsoft.Extensions.ApiDescription.Server | 7.0.19
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.19
Microsoft.Extensions.ApiDescription.Client | 7.0.19
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.19
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.19
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.19
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.19
Microsoft.Extensions.Identity.Core | 7.0.19
Microsoft.Extensions.Features | 7.0.19
Microsoft.Extensions.Localization.Abstractions | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.19
Microsoft.AspNetCore.Authentication.Certificate | 7.0.19
Microsoft.AspNetCore.Authentication.Google | 7.0.19
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.19
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.19
Microsoft.AspNetCore.Components.Authorization | 7.0.19
Microsoft.AspNetCore.Components.CustomElements | 7.0.19
Microsoft.AspNetCore.Components.Forms | 7.0.19
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.19
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.19
Microsoft.AspNetCore.DataProtection | 7.0.19
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.19
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.19
Microsoft.AspNetCore.Http.Connections.Client | 7.0.19
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.19
Microsoft.AspNetCore.Http.Connections.Common | 7.0.19
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.19
Microsoft.AspNetCore.Owin | 7.0.19
Microsoft.AspNetCore.OpenApi | 7.0.19
Microsoft.AspNetCore.SignalR.Client | 7.0.19
Microsoft.AspNetCore.SignalR.Common | 7.0.19
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.19
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.19
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.19
Microsoft.Authentication.WebAssembly.Msal | 7.0.19
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.19
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.19
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.19
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.19
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.19
Microsoft.AspNetCore.Connections.Abstractions | 7.0.19
Microsoft.AspNetCore.JsonPatch | 7.0.19
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.19
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.19
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.19
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.19
Microsoft.Extensions.Caching.SqlServer | 7.0.19
Microsoft.Extensions.FileProviders.Embedded | 7.0.19
Microsoft.Extensions.Logging.AzureAppServices | 7.0.19
Microsoft.JSInterop | 7.0.19
Microsoft.JSInterop.WebAssembly | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.19
AspNetCoreRuntime.7.0.x64 | 7.0.19
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.19
Microsoft.Extensions.Http.Polly | 7.0.19
Microsoft.Extensions.Identity.Stores | 7.0.19
Microsoft.Extensions.WebEncoders | 7.0.19
Microsoft.AspNetCore.Authentication.Facebook | 7.0.19
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.19
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.19
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.19
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.19
Microsoft.AspNetCore.Authentication.Twitter | 7.0.19
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.19
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.19
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.19
Microsoft.AspNetCore.Authorization | 7.0.19
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.19
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.19
Microsoft.Extensions.Localization | 7.0.19
Microsoft.Extensions.ObjectPool | 7.0.19
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.19
AspNetCoreRuntime.7.0.x86 | 7.0.19
dotnet-sql-cache | 7.0.19
Microsoft.AspNetCore.App.Ref | 7.0.19
Microsoft.dotnet-openapi | 7.0.19
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.19
FSharp.Core | 7.0.0
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.119
Microsoft.DotNet.ApiCompat.Tool | 7.0.119
Microsoft.DotNet.ApiCompat.Task | 7.0.119
Microsoft.DotNet.Common.ItemTemplates | 7.0.119
FSharp.Compiler.Service | 42.7.101
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.19
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.19
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.19
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.19
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.19
Microsoft.EntityFrameworkCore.Tools | 7.0.19
dotnet-ef | 7.0.19
Microsoft.Data.Sqlite.Core | 7.0.19
Microsoft.EntityFrameworkCore.Relational | 7.0.19
Microsoft.Data.Sqlite | 7.0.19
Microsoft.EntityFrameworkCore | 7.0.19
Microsoft.EntityFrameworkCore.Sqlite | 7.0.19
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.19
Microsoft.EntityFrameworkCore.Templates | 7.0.19
Microsoft.EntityFrameworkCore.SqlServer | 7.0.19
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.19
Microsoft.EntityFrameworkCore.Cosmos | 7.0.19
Microsoft.EntityFrameworkCore.Abstractions | 7.0.19
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.19
Microsoft.EntityFrameworkCore.Analyzers | 7.0.19
Microsoft.EntityFrameworkCore.Proxies | 7.0.19
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.19
Microsoft.EntityFrameworkCore.Design | 7.0.19
Microsoft.EntityFrameworkCore.InMemory | 7.0.19
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.19
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.19
Microsoft.TemplateEngine.Abstractions | 7.0.119
Microsoft.TemplateEngine.Core.Contracts | 7.0.119
Microsoft.TemplateEngine.Tasks | 7.0.119
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.119
Microsoft.TemplateEngine.Core | 7.0.119
Microsoft.TemplateEngine.Edge | 7.0.119
Microsoft.TemplateEngine.Utils | 7.0.119
Microsoft.TemplateEngine.IDE | 7.0.119
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.119
Microsoft.TemplateSearch.Common | 7.0.119
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.119
Microsoft.DotNet.ApiCompat.Task | 7.0.316
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.Common.ItemTemplates | 7.0.316
Microsoft.NET.Build.Containers | 7.0.316
FSharp.Core | 7.0.300
Microsoft.DotNet.ApiCompat.Tool | 7.0.316
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.316
Microsoft.TemplateEngine.Authoring.CLI | 7.0.316
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.316
Microsoft.TemplateEngine.Core | 7.0.316
Microsoft.TemplateEngine.Edge | 7.0.316
Microsoft.TemplateEngine.Abstractions | 7.0.316
Microsoft.TemplateEngine.IDE | 7.0.316
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.316
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.316
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.316
Microsoft.TemplateEngine.Core.Contracts | 7.0.316
Microsoft.TemplateEngine.Utils | 7.0.316
Microsoft.TemplateSearch.Common | 7.0.316
FSharp.Core | 7.0.403
Microsoft.DotNet.ApiCompat.Tool | 7.0.409
FSharp.Compiler.Service | 43.7.403
Microsoft.DotNet.ApiCompat.Task | 7.0.409
Microsoft.NET.Build.Containers | 7.0.409
Microsoft.DotNet.Common.ItemTemplates | 7.0.409
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.409
Microsoft.TemplateEngine.Authoring.CLI | 7.0.409
Microsoft.TemplateEngine.Abstractions | 7.0.409
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.409
Microsoft.TemplateEngine.IDE | 7.0.409
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.409
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.409
Microsoft.TemplateEngine.Utils | 7.0.409
Microsoft.TemplateSearch.Common | 7.0.409
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.409
Microsoft.TemplateEngine.Core | 7.0.409
Microsoft.TemplateEngine.Core.Contracts | 7.0.409
Microsoft.TemplateEngine.Edge | 7.0.409

[//]: # ( Runtime 7.0.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2df83468-5a16-4a11-b830-b2ab16dc4d55/621d70c24e2e3fa1355d018a2498ab0f/dotnet-runtime-7.0.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/81616b49-6c82-4778-884d-caeca4c195a9/51a0a0bcdd17fdb77be7f1c5db52165e/dotnet-runtime-7.0.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07c55f99-8a15-4681-9124-d5ad1f4d6b3a/7382839f0577a1065680a3f61055059e/dotnet-runtime-7.0.19-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e6ea38b-52fa-431c-8640-720161fe4bb7/2c470a5842f4327c189d70ce971f6dac/dotnet-runtime-7.0.19-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fd333dc-fa2e-4f6f-92d2-fd6f4d32d340/df1af68a75e54059c442de857308470a/dotnet-runtime-7.0.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09ab2389-5bab-4d45-9a91-a56ff322e83c/2f8192a98b6887c7f12b0d2dc4a06247/dotnet-runtime-7.0.19-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e2f7e58d-2e7d-46f0-ab11-1ae25dfa1fbd/761f54010c4ccf8ac5ce473d0ac8ae3d/dotnet-runtime-7.0.19-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b8da067-3b82-4636-8e0d-18583857e64b/fba7ceea0e014535a695ceb9259886c6/dotnet-runtime-7.0.19-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/47781c53-d934-4f19-a7fa-c6ce278ddb90/b9e40cb923d506ad8046f6532923d163/dotnet-runtime-7.0.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92c2b6d8-783f-4a48-8575-e001296d4a54/c11d13f994d5016fc13d5c9a81e394f0/dotnet-runtime-7.0.19-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e1e2c82e-2c53-419f-a49b-4e4198d51945/868e91a224ecacf490dd76a8f2be7119/dotnet-runtime-7.0.19-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f22c11eb-f893-43a1-8b91-92ea9fb5a4bf/2a4343879dbe91427aa7c735ec3ceaa7/dotnet-runtime-7.0.19-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4a2b5674-da71-4410-be86-31795620e888/e2e32f18f1aea954ff7b8c883bf64f02/dotnet-runtime-7.0.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/32f909df-fc73-439b-a8e1-55f18bfac3fb/e071d418324b9083629379f3ac6fd07a/dotnet-runtime-7.0.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4d24613f-125a-4f6f-ac88-8113ab897cc4/07482933ed8b3c004e36226f79519cea/dotnet-runtime-7.0.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ea694885-243e-4aa5-b6c6-359be0a85d84/fa80c28487c42beba2667cc43ea45f93/dotnet-runtime-7.0.19-win-x86.zip

[//]: # ( WindowsDesktop 7.0.19)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a5582b5c-5ed7-469d-b0b2-acdf9c8378a4/27ec43b32f8b0a388930566091c159c9/windowsdesktop-runtime-7.0.19-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1318be2d-11ad-4dd5-bdd0-840c9ac49e37/90528aa7075eba5213071f881f34cff4/windowsdesktop-runtime-7.0.19-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/59f35686-7985-4356-9ed6-45bb943bd923/1d04faf7a23c79a5aa5edb6894245baa/windowsdesktop-runtime-7.0.19-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/da66a537-c551-4929-9e72-f1d57a0c3b0e/6dd9c5ae9c1b9974aa3ee188732df776/windowsdesktop-runtime-7.0.19-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1f82e444-69a5-435b-945f-111a4ecf5303/365411fda0082c7b7d9b3a8bf6053868/windowsdesktop-runtime-7.0.19-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/46b6540a-d534-46e1-a4ef-aa2bdb0922db/223976ea3105b838376934d1dcf7b1ce/windowsdesktop-runtime-7.0.19-win-x86.zip

[//]: # ( ASP 7.0.19)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b51c762e-33fe-4f93-be27-e8064ae11ef6/e616efc6dd0e4a7370835f1fecf0dafa/aspnetcore-runtime-7.0.19-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78d9729a-9f05-49a6-81b7-b041452a2828/73214343fb60deddb7faf355ecbbaca3/aspnetcore-runtime-7.0.19-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/871b41f1-76cd-4a4a-bede-45275dc96753/f733f556751ae11c9598ec75bc5deba9/aspnetcore-runtime-7.0.19-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7b87d4f-aa5f-42bf-84b1-88508a10d52b/d7776e99a645c89f8d9ccf1e84ca871a/aspnetcore-runtime-7.0.19-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8882d630-cb5a-4a4b-b7b8-0d75adff0e5a/c8a429dce2a545c6f21d6ec8e502c95e/aspnetcore-runtime-7.0.19-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3d6c11a-a7d6-4be4-8b2b-11154b846100/69bd5fbe2621600e84bb191d0b13abdd/aspnetcore-runtime-7.0.19-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/879c8cbe-37bd-4fc9-b8db-857a3fe09144/231cf7ae2bca959750144d08ad08d057/aspnetcore-runtime-7.0.19-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2bed645-39cb-4ea7-ba7c-503741d8d9e6/07bc37ec71cfe01a4187d94275580b3c/aspnetcore-runtime-7.0.19-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/235bf7e7-34be-49db-81c0-e75d6bb05aab/b37e832fd31f3c712a1871412c79d57a/aspnetcore-runtime-7.0.19-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/345f2916-ec5c-443b-91aa-1f430bcae337/418235e5d73ac3a992006392b62a7169/aspnetcore-runtime-7.0.19-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2dba7d53-96e3-4529-97eb-05cd5bb3740d/c71e21fd3ae5dc4138ef13104f1266e6/aspnetcore-runtime-7.0.19-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f09ac48f-ae75-4c47-9381-2f947fbbf55c/85756c47edcc8b1fa62eccae6cf6cdeb/aspnetcore-runtime-7.0.19-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0f3e5de7-8d24-408e-9e44-85e5cb8990b4/ca9962c80f50f44f5bd48a87225468ce/aspnetcore-runtime-7.0.19-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/851d2f44-41fd-4596-b71e-81974dba924a/49131a86dde54bdb46789235f16a1db4/dotnet-hosting-7.0.19-win.exe

[//]: # ( SDK 7.0.409)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba0bb97b-c81e-452c-b022-74b56d9cd022/1e47598d6f89a06f39f7dfa00aafec8d/dotnet-sdk-7.0.409-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f065c679-7039-4968-9a2f-dda7cda72f5f/702eb11e596f498a1cb23b636e1d83be/dotnet-sdk-7.0.409-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/caa50545-1070-4d3f-9eba-acab72a26b92/838d798efd638aa2eac255e357d2b780/dotnet-sdk-7.0.409-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb3b12dc-28d6-4927-b587-9a1a70fa9a12/63ba0fb6cc234aa6020631e82562bbf5/dotnet-sdk-7.0.409-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ecc5c9a7-36c8-4159-8e8b-d08e3fd42179/99a43ad6027ee8428c4d39c73b64e4ed/dotnet-sdk-7.0.409-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03e24745-90c7-4661-8ffe-e5a857b6e6a3/99038e4e48e403a17bcbe509bfe8d6b8/dotnet-sdk-7.0.409-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6255162b-0302-49b3-9a38-2d3dec15547a/8f4bbdb4230583c802875dd763418209/dotnet-sdk-7.0.409-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0025e3a3-0221-493e-90cf-a5baaedc3cfa/716e07c6342d6625dd9a04f632ca8d50/dotnet-sdk-7.0.409-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/57b23969-984e-4af7-a626-14e88c855e3f/03bca992dbd39408313f8f38152d602b/dotnet-sdk-7.0.409-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/feee7b85-ddb2-4ff5-8927-5656ea1e0a6f/ecdfb330298d11e0d49c3b595ddea452/dotnet-sdk-7.0.409-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/649c5698-6c25-4fa3-81a4-a4552f151ce5/8c38c4c6ea33c810a809ac8819f87afd/dotnet-sdk-7.0.409-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dd58edfa-bb58-4d01-a19c-56874a6b83b5/8ac0c69c2afcd78cfe1f9bbb17248deb/dotnet-sdk-7.0.409-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/03507d55-fea4-40ed-bde7-2bb8904b614b/3582cdfc83133da5d330f3a80f6fb432/dotnet-sdk-7.0.409-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aac15151-b6c2-4b9b-9838-b872c59e24c1/17e15ef9123b3d4b51469b6f02793b76/dotnet-sdk-7.0.409-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bf975732-5ad9-4d3d-bd37-10d3aa121c54/0de1147d4bbc2e2aba008cce40cd3ff2/dotnet-sdk-7.0.409-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/26790e30-c1f5-44e4-b768-783fecff45ac/834bb1812c6d8fe1d70ccf186c6d6ce0/dotnet-sdk-7.0.409-win-x86.zip
