# .NET 7.0.2  - January 10, 2023

The .NET 7.0.2 and .NET SDK 7.0.102 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.102
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.2 release carries non-security fixes.

### Additional fixes in this release
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A7.0.2+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.2+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8090](https://github.com/dotnet/core/issues/8090) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.2-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/january-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.2+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.2+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64| 7.0.2
Microsoft.WindowsDesktop.App.Runtime.win-x86| 7.0.2
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 7.0.2
Microsoft.WindowsDesktop.App.Ref| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 7.0.2
Microsoft.NETCore.App.Host.linux-bionic-x64| 7.0.2
Microsoft.NETCore.App.Host.linux-musl-arm64| 7.0.2
Microsoft.NETCore.App.Host.linux-musl-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 7.0.2
Microsoft.Extensions.Configuration.Binder| 7.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 7.0.2
Microsoft.NET.Runtime.iOS.Sample.Mono| 7.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.win-arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-x64| 7.0.2
Microsoft.NETCore.App.Host.osx-x64| 7.0.2
Microsoft.NETCore.App.Host.win-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-musl-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 7.0.2
Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86| 7.0.2
Microsoft.NETCore.App.Crossgen2.osx-arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 7.0.2
Microsoft.NETCore.App.Host.linux-arm64| 7.0.2
Microsoft.NETCore.App.Host.linux-musl-arm| 7.0.2
Microsoft.NETCore.App.Ref| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-musl-arm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.win-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.win-x86| 7.0.2
Microsoft.NETCore.App.Runtime.osx-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.win-x86| 7.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.osx-x64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 7.0.2
Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
System.Security.Cryptography.Xml| 7.0.1
System.Threading.AccessControl| 7.0.1
Microsoft.NETCore.App.Host.win-x86| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 7.0.2
Microsoft.NETCore.App.Runtime.linux-bionic-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 7.0.2
runtime.linux-arm64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.win-arm64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
Microsoft.NET.Runtime.Android.Sample.Mono| 7.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 7.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 7.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 7.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk| 7.0.2
Microsoft.NET.Runtime.wasm.Sample.Mono| 7.0.2
Microsoft.NETCore.App.Composite| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100| 7.0.2
Microsoft.NETCore.App.Crossgen2.win-arm| 7.0.2
Microsoft.NETCore.App.Host.osx-arm64| 7.0.2
Microsoft.NETCore.App.Host.win-arm| 7.0.2
Microsoft.NETCore.App.Host.linux-x64| 7.0.2
Microsoft.NETCore.App.Host.win-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.osx-x64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 7.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.win-x64.Microsoft.DotNet.ILCompiler| 7.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 7.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Templates| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64| 7.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 7.0.2
Microsoft.NETCore.App.Crossgen2.win-x86| 7.0.2
Microsoft.NETCore.App.Host.linux-bionic-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-arm| 7.0.2
Microsoft.NETCore.App.Runtime.linux-bionic-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.win-x64| 7.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 7.0.2
Microsoft.DotNet.ILCompiler| 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-arm| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86| 7.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86| 7.0.2
Microsoft.NETCore.App.Crossgen2.osx-x64| 7.0.2
Microsoft.NETCore.App.Host.linux-arm| 7.0.2
Microsoft.NETCore.App.Crossgen2.win-x64| 7.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.linux-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64| 7.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 7.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 7.0.2
Microsoft.NETCore.DotNetHost| 7.0.2
Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.linux-x64.Microsoft.DotNet.ILCompiler| 7.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 7.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 7.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 7.0.2
runtime.win-arm.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHost| 7.0.2
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 7.0.2
AspNetCoreRuntime.7.0.x86| 7.0.2
Microsoft.AspNetCore.App.Runtime.win-arm| 7.0.2
Microsoft.AspNetCore.App.Runtime.osx-arm64| 7.0.2
Microsoft.AspNetCore.App.Runtime.osx-x64| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-x64| 7.0.2
Microsoft.AspNetCore.App.Runtime.win-arm64| 7.0.2
Microsoft.AspNetCore.App.Runtime.win-x86| 7.0.2
Microsoft.AspNetCore.App.Ref| 7.0.2
Microsoft.AspNetCore.DataProtection| 7.0.2
Microsoft.AspNetCore.Cryptography.KeyDerivation| 7.0.2
Microsoft.AspNetCore.Cryptography.Internal| 7.0.2
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 7.0.2
Microsoft.AspNetCore.Grpc.JsonTranscoding| 7.0.2
Microsoft.AspNetCore.Grpc.Swagger| 0.3.2
Microsoft.AspNetCore.Identity.UI| 7.0.2
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 7.0.2
Microsoft.AspNetCore.OpenApi| 7.0.2
Microsoft.AspNetCore.SignalR.Client| 7.0.2
Microsoft.AspNetCore.TestHost| 7.0.2
Microsoft.AspNetCore.SpaProxy| 7.0.2
Microsoft.dotnet-openapi| 7.0.2
Microsoft.Extensions.ApiDescription.Server| 7.0.2
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0| 7.0.2
Microsoft.Extensions.Caching.SqlServer| 7.0.2
Microsoft.Extensions.Configuration.KeyPerFile| 7.0.2
Microsoft.Extensions.Caching.StackExchangeRedis| 7.0.2
Microsoft.Extensions.FileProviders.Embedded| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-arm| 7.0.2
Microsoft.Extensions.ApiDescription.Client| 7.0.2
AspNetCoreRuntime.7.0.x64| 7.0.2
Microsoft.AspNetCore.Http.Connections.Client| 7.0.2
Microsoft.AspNetCore.Hosting.WindowsServices| 7.0.2
Microsoft.AspNetCore.Owin| 7.0.2
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 7.0.2
Microsoft.Extensions.Diagnostics.HealthChecks| 7.0.2
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 7.0.2
Microsoft.Extensions.Features| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 7.0.2
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 7.0.2
Microsoft.AspNetCore.SignalR.Client.Core| 7.0.2
Microsoft.AspNetCore.SignalR.Common| 7.0.2
Microsoft.AspNetCore.SignalR.Protocols.Json| 7.0.2
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 7.0.2
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 7.0.2
Microsoft.AspNetCore.SignalR.Specification.Tests| 7.0.2
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 7.0.2
Microsoft.AspNetCore.SpaServices.Extensions| 7.0.2
Microsoft.Authentication.WebAssembly.Msal| 7.0.2
Microsoft.DotNet.Web.ItemTemplates.7.0| 7.0.2
Microsoft.Extensions.Identity.Core| 7.0.2
Microsoft.Extensions.Http.Polly| 7.0.2
Microsoft.Extensions.Identity.Stores| 7.0.2
Microsoft.Extensions.Localization| 7.0.2
Microsoft.Extensions.Localization.Abstractions| 7.0.2
Microsoft.Extensions.Logging.AzureAppServices| 7.0.2
Microsoft.Extensions.ObjectPool| 7.0.2
Microsoft.Extensions.WebEncoders| 7.0.2
Microsoft.JSInterop| 7.0.2
Microsoft.JSInterop.WebAssembly| 7.0.2
Microsoft.AspNetCore.Authentication.Certificate| 7.0.2
Microsoft.AspNetCore.Authentication.JwtBearer| 7.0.2
Microsoft.AspNetCore.Authentication.Facebook| 7.0.2
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 7.0.2
Microsoft.AspNetCore.Components.CustomElements| 7.0.2
Microsoft.AspNetCore.Components.Analyzers| 7.0.2
Microsoft.AspNetCore.Components.WebAssembly.Server| 7.0.2
Microsoft.AspNetCore.Components.Authorization| 7.0.2
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 7.0.2
Microsoft.AspNetCore.Components.Forms| 7.0.2
Microsoft.AspNetCore.Connections.Abstractions| 7.0.2
Microsoft.AspNetCore.Http.Connections.Common| 7.0.2
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 7.0.2
Microsoft.AspNetCore.JsonPatch| 7.0.2
Microsoft.AspNetCore.MiddlewareAnalysis| 7.0.2
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 7.0.2
Microsoft.AspNetCore.Metadata| 7.0.2
Microsoft.AspNetCore.Mvc.Testing| 7.0.2
Microsoft.DotNet.Web.Client.ItemTemplates| 7.0.2
Microsoft.DotNet.Web.ProjectTemplates.7.0| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-arm64| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 7.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 7.0.2
dotnet-sql-cache| 7.0.2
Microsoft.AspNetCore.App.Runtime.win-x64| 7.0.2
Microsoft.AspNetCore.Authentication.Google| 7.0.2
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 7.0.2
Microsoft.AspNetCore.Authentication.Negotiate| 7.0.2
Microsoft.AspNetCore.Authentication.OpenIdConnect| 7.0.2
Microsoft.AspNetCore.Authentication.Twitter| 7.0.2
Microsoft.AspNetCore.Authentication.WsFederation| 7.0.2
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 7.0.2
Microsoft.AspNetCore.Authorization| 7.0.2
Microsoft.AspNetCore.Components| 7.0.2
Microsoft.AspNetCore.AzureAppServicesIntegration| 7.0.2
Microsoft.AspNetCore.Components.Web| 7.0.2
Microsoft.AspNetCore.Components.WebAssembly| 7.0.2
Microsoft.AspNetCore.ConcurrencyLimiter| 7.0.2
Microsoft.AspNetCore.Components.WebView| 7.0.2
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 7.0.2
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 7.0.2
Microsoft.AspNetCore.DataProtection.Extensions| 7.0.2
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 7.0.2
Microsoft.AspNetCore.DataProtection.Abstractions| 7.0.2
Microsoft.AspNetCore.HeaderPropagation| 7.0.2
FSharp.Core| 7.0.0
FSharp.Compiler.Service| 42.7.101
Microsoft.DotNet.ApiCompat.Task| 7.0.102
Microsoft.DotNet.Common.ItemTemplates| 7.0.102
Microsoft.DotNet.Common.ProjectTemplates.7.0| 7.0.102
Microsoft.DotNet.ApiCompat.Tool| 7.0.102
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64| 7.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64| 7.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100| 7.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64| 7.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64| 7.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100| 7.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64| 7.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64| 7.0.2
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64| 7.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86| 7.0.2
Microsoft.EntityFrameworkCore.Abstractions| 7.0.2
Microsoft.EntityFrameworkCore.Cosmos| 7.0.2
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 7.0.2
Microsoft.EntityFrameworkCore.Specification.Tests| 7.0.2
Microsoft.EntityFrameworkCore| 7.0.2
Microsoft.EntityFrameworkCore.Sqlite| 7.0.2
Microsoft.EntityFrameworkCore.Sqlite.Core| 7.0.2
Microsoft.EntityFrameworkCore.Analyzers| 7.0.2
Microsoft.EntityFrameworkCore.Proxies| 7.0.2
Microsoft.EntityFrameworkCore.Design| 7.0.2
Microsoft.EntityFrameworkCore.InMemory| 7.0.2
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 7.0.2
Microsoft.Data.Sqlite| 7.0.2
dotnet-ef| 7.0.2
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 7.0.2
Microsoft.EntityFrameworkCore.Relational| 7.0.2
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 7.0.2
Microsoft.EntityFrameworkCore.Templates| 7.0.2
Microsoft.EntityFrameworkCore.SqlServer| 7.0.2
Microsoft.EntityFrameworkCore.Tools| 7.0.2
Microsoft.Data.Sqlite.Core| 7.0.2
Microsoft.TemplateEngine.Tasks| 7.0.102
Microsoft.TemplateEngine.TemplateLocalizer| 7.0.102
Microsoft.TemplateEngine.Abstractions| 7.0.102
Microsoft.TemplateEngine.Edge| 7.0.102
Microsoft.TemplateEngine.TemplateLocalizer.Core| 7.0.102
Microsoft.TemplateEngine.Core| 7.0.102
Microsoft.TemplateEngine.Core.Contracts| 7.0.102
Microsoft.TemplateEngine.Utils| 7.0.102
Microsoft.TemplateEngine.IDE| 7.0.102
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 7.0.102
Microsoft.TemplateSearch.Common| 7.0.102



[//]: # ( Runtime 7.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3914d9ac-88fd-466d-ba05-e28569201e06/030729c87c4e8fc341b1d633062058ae/dotnet-runtime-7.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38d90a87-4b35-46e8-a4c7-5c4ae15eeb96/77b1c221366f3c748c226edf25a65577/dotnet-runtime-7.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f27a111b-a0de-412e-ae6b-8c4342f7fd1e/89d687ca0798a0e59846a97b1b6b7e18/dotnet-runtime-7.0.2-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71ef4d79-1961-4333-a1e1-33d515daefcd/9cbb3596ee9ca5286f502a30d63e73c3/dotnet-runtime-7.0.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1208d5ea-123f-4b66-be25-4e0482c39bc5/796de7d9e157dd23ab35ab68be8d97d2/dotnet-runtime-7.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83524cc2-60fb-4e49-8769-e9ecb1af8e46/a28b17808ffe21483b2f719091a0544f/dotnet-runtime-7.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/90889739-38b2-4a49-8c97-ee1884d703ae/9f3f6c2de5d357f1905fde9910300072/dotnet-runtime-7.0.2-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42056f30-aea1-456c-94c0-77eafd2cdbec/ddf45ed3e6c84305aa584a35344f5338/dotnet-runtime-7.0.2-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c5c4b5b4-490d-48d3-8645-ed77cb7134ce/e5aea24b7b2a548b2666fa5785e51587/dotnet-runtime-7.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4106c55b-9371-47c6-be04-cffe46c334d8/ad559a1e388d9384ae07381ffccdf26c/dotnet-runtime-7.0.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/41f619ec-1a9d-42c3-a477-4cbb804de914/e664cfc358ffa58c6aa0266d17d88767/dotnet-runtime-7.0.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bbf7b605-f8a9-458c-8476-32ede0783577/3769ccb1080ab272a0f731042631f1b2/dotnet-runtime-7.0.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/df7da01f-1f17-4728-92b7-778e9607da8f/7c18246830f8c78591f02f25aa368dcf/dotnet-runtime-7.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/551638a7-d0d2-44fa-829c-dbbcfa8b569d/0e25cf642aca8d265eb4459a0207b123/dotnet-runtime-7.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/edd6eb5f-7154-421f-b07e-93da5cc320f9/94529bbb5e7b0532a88d2cc26272d012/dotnet-runtime-7.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0822ef76-b82a-458f-9b89-4fe31a8c0739/40a9074480eebd76a88d3d4d57b9f320/dotnet-runtime-7.0.2-win-x86.zip

[//]: # ( WindowsDesktop 7.0.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/17f810f5-7691-4e6c-8169-dc7874ddb938/2381bb0454a0c1cd790f102bb1b04345/windowsdesktop-runtime-7.0.2-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0d88edf3-89d5-4b19-beda-771e9c067368/d7f9f68b7df13f779fe98dc7d15a8157/windowsdesktop-runtime-7.0.2-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8d4ae76c-10d6-450c-b1c2-76b7b2156dc3/9207c5d5d0b608d8ec0622efa4419ed6/windowsdesktop-runtime-7.0.2-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/74b8c2e2-6f60-46ba-b51b-4baebea05498/03daf7ab9edbc8728b0509c09595209c/windowsdesktop-runtime-7.0.2-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f63a565f-28cc-4cb0-94f4-e78bc2412801/f4e19159c0a2980b880ee6f1a73a1199/windowsdesktop-runtime-7.0.2-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/602f0298-abe3-4c5a-967b-f1d2d8bc5a0d/c457cf02ba0360775cc9ac434384ad13/windowsdesktop-runtime-7.0.2-win-x86.zip

[//]: # ( ASP 7.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/907140b5-f018-45bf-8142-83dfe1f4e2d0/a2338572da64d78468ceef95f8ee9905/aspnetcore-runtime-7.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f88ac12a-fcc7-4f69-baf9-17cfbd9b316e/8745af53d52c38afc5c9fc171cf3c7b2/aspnetcore-runtime-7.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5aad7f05-bbd5-43a1-9525-b33ae8db01a5/9893543bd4ee8f13e5ddeeb646329353/aspnetcore-runtime-7.0.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54bfd349-6f45-4f0f-b06c-ba34e95b4a25/0653952082ec4849faf756233af2fb45/aspnetcore-runtime-7.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98b141a7-a46d-4c62-95d0-f140565b8253/46bce38cbef6b279f10957e3d2a1dc94/aspnetcore-runtime-7.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d8c4b4c-aec9-451b-9bd3-bf7cdbd28477/def6c1a7a9cfd4590698d4f338da2803/aspnetcore-runtime-7.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42ad7951-d95e-4d52-8427-9ff58cdb0c16/f6256fba5b7484979737f34f7fa1e0ac/aspnetcore-runtime-7.0.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/035d61f7-0418-4834-8364-eec4d3c3d112/b1fd356e10f14ee2c930e023654186f3/aspnetcore-runtime-7.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/60d33216-7993-409d-9ea1-23ab016968ba/5e278164d7c9ee904f8b5ac219494b52/aspnetcore-runtime-7.0.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3ecad4f7-1342-4688-ae4a-38908c61f4a2/391a9010acad2e312e3d1e766bedfac7/aspnetcore-runtime-7.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/79dbfb6e-78b4-4e2c-a3a9-040666d6b407/ad24076fc19fdfa6c7acdd6bad8a1fc5/aspnetcore-runtime-7.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4d1c8de3-c5d8-41ac-b182-d906cc40f60b/671f4cc0a56905d844809e1e4c348493/aspnetcore-runtime-7.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/84d3bf5a-5b76-426d-b088-a9713f658f1a/168263daabc9626fba6c5ebdc4af0c28/aspnetcore-runtime-7.0.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c8b4d4c4-1f74-4533-80a1-c5813500c7a1/e6d2d78c0fba3744390952fd2ccad7d8/dotnet-hosting-7.0.2-win.exe

[//]: # ( SDK 7.0.102)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54b057ec-36ef-4808-a436-50ee3fa39a44/87d696a761176b721daaf8ab9761c9c8/dotnet-sdk-7.0.102-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72ec0dc2-f425-48c3-97f1-dc83740ba400/78e8fa01fa9987834fa01c19a23dd2e7/dotnet-sdk-7.0.102-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de77d6a5-d77e-4421-8198-135b3cce9caf/ad2194c26f424c81fb2b79decb6e9f2b/dotnet-sdk-7.0.102-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b98e56bf-6021-4236-aa19-58b216a4674e/f367378def5dea5bc439dbb94b7699af/dotnet-sdk-7.0.102-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43fbb34e-6e21-4abd-aa90-0e65de1fa3c2/0f29b8b0f6e7d5dfd6e790e49a4700db/dotnet-sdk-7.0.102-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c646b288-5d5b-4c9c-a95b-e1fad1c0d95d/e13d71d48b629fe3a85f5676deb09e2d/dotnet-sdk-7.0.102-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/dfbffbab-2187-44a8-b911-308136f001c1/8c754f776f6a476f6ab6681d72d88b2e/dotnet-sdk-7.0.102-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0c47b58-a384-46b3-8fce-bd9188541858/dbfe7b537396b747255e65c0fbc9641e/dotnet-sdk-7.0.102-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/17798684-12da-417d-845b-8d2f54b3bd67/d6a67ffe06f263906571aacf7057bc8e/dotnet-sdk-7.0.102-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91c41b31-cf90-4771-934b-6928bbb48aaf/76e95bac2a4cb3fd50c920fd1601527c/dotnet-sdk-7.0.102-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b0650da5-ed0b-4836-b531-21135cfe257a/641c134bbc17fd107099879db67b90d7/dotnet-sdk-7.0.102-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a93af409-9846-4340-b810-1c112db0969b/52557cefadc77036a5febb00a31a439b/dotnet-sdk-7.0.102-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6ba69569-ee5e-460e-afd8-79ae3cd4617b/16a385a4fab2c5806f50f49f5581b4fd/dotnet-sdk-7.0.102-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c869d6e-b49e-4c52-b197-77fca05f0c69/f3b6fb63231c8ed6afc585da090d4595/dotnet-sdk-7.0.102-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b8f62325-92ad-4ba1-8feb-097472b214d4/12dbfb23a761c64aee3225a70231b522/dotnet-sdk-7.0.102-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/30d69e4b-74d9-4043-9b50-2f91b27d9e80/c6ecb4b16858afb2fc1f056bd3ecdbb4/dotnet-sdk-7.0.102-win-x86.zip
