# .NET 7.0.20 - May 28, 2024

The .NET 7.0.20 and .NET SDK 7.0.410 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.410
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 7.0 Blog][dotnet-blog]

 .NET 7.0.20 release carries the security and non-security fixes.

 ### WiX toolset signed with incorrect certificate

 The .NET 7.0.20 release on May 14, 2024 included updates to the WiX toolset which were incorrectly signed. This caused failures in scenarios on Windows where Code Integrity checks were enabled.

 [CVE-2024-20672 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-20672)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0, .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when processing X.509 certificates that may result in Denial of Service. This vulnerabilty only affects macOS.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9362](https://github.com/dotnet/core/issues/9362) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.20.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.20-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.20-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.20+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.20+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.20+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.20+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.20+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.20+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.20xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.20
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.20
Microsoft.WindowsDesktop.App.Ref | 7.0.20
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.20
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.20
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.20
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.20
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.20
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.20
Microsoft.NETCore.App.Host.win-arm64 | 7.0.20
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.20
Microsoft.NETCore.App.Host.osx-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.DotNetAppHost | 7.0.20
Microsoft.NETCore.DotNetHost | 7.0.20
Microsoft.NETCore.DotNetHostPolicy | 7.0.20
Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.20
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.20
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.20
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.20
Microsoft.NETCore.App.Host.win-x64 | 7.0.20
Microsoft.NETCore.App.Ref | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.20
Microsoft.DotNet.ILCompiler | 7.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Composite | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Host.linux-x64 | 7.0.20
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.20
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.20
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.20
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.20
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.20
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.20
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.20
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.20
Microsoft.NETCore.App.Host.linux-arm | 7.0.20
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.20
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.20
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.20
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.20
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.20
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.20
Microsoft.NETCore.App.Host.win-arm | 7.0.20
Microsoft.NETCore.App.Host.win-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.20
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.20
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.20
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.20
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.20
AspNetCoreRuntime.7.0.x64 | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.20
Microsoft.AspNetCore.App.Ref | 7.0.20
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.20
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.20
Microsoft.AspNetCore.Cryptography.Internal | 7.0.20
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.20
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.20
Microsoft.AspNetCore.Http.Connections.Common | 7.0.20
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.20
Microsoft.AspNetCore.Grpc.Swagger | 0.3.20
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.20
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.20
AspNetCoreRuntime.7.0.x86 | 7.0.20
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.20
Microsoft.AspNetCore.Components.WebView | 7.0.20
Microsoft.AspNetCore.DataProtection | 7.0.20
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.20
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.20
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.20
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.20
Microsoft.AspNetCore.HeaderPropagation | 7.0.20
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.20
Microsoft.AspNetCore.Http.Connections.Client | 7.0.20
Microsoft.AspNetCore.Identity.UI | 7.0.20
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.20
Microsoft.AspNetCore.Owin | 7.0.20
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.20
Microsoft.AspNetCore.SignalR.Common | 7.0.20
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.20
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.20
Microsoft.Extensions.ApiDescription.Server | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.20
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.20
Microsoft.AspNetCore.Components.Authorization | 7.0.20
Microsoft.AspNetCore.Components.CustomElements | 7.0.20
Microsoft.AspNetCore.Components.Forms | 7.0.20
Microsoft.AspNetCore.Components.Web | 7.0.20
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.20
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.20
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.20
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.20
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.20
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.20
Microsoft.dotnet-openapi | 7.0.20
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.20
Microsoft.AspNetCore.Components.Analyzers | 7.0.20
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.20
Microsoft.AspNetCore.Components | 7.0.20
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.20
Microsoft.Extensions.Caching.SqlServer | 7.0.20
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.20
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.20
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.20
dotnet-sql-cache | 7.0.20
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.20
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.20
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.20
Microsoft.AspNetCore.Connections.Abstractions | 7.0.20
Microsoft.AspNetCore.JsonPatch | 7.0.20
Microsoft.AspNetCore.SpaProxy | 7.0.20
Microsoft.AspNetCore.Metadata | 7.0.20
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.20
Microsoft.AspNetCore.Mvc.Testing | 7.0.20
Microsoft.AspNetCore.OpenApi | 7.0.20
Microsoft.AspNetCore.SignalR.Client | 7.0.20
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.20
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.20
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.20
Microsoft.Extensions.ApiDescription.Client | 7.0.20
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.20
Microsoft.Extensions.ObjectPool | 7.0.20
Microsoft.JSInterop | 7.0.20
Microsoft.Extensions.WebEncoders | 7.0.20
Microsoft.JSInterop.WebAssembly | 7.0.20
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.20
Microsoft.AspNetCore.Authentication.Certificate | 7.0.20
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.20
Microsoft.AspNetCore.Authentication.Facebook | 7.0.20
Microsoft.AspNetCore.Authentication.Google | 7.0.20
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.20
Microsoft.AspNetCore.Authentication.Twitter | 7.0.20
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.20
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.20
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.20
Microsoft.AspNetCore.Authorization | 7.0.20
Microsoft.AspNetCore.Components.WebAssembly | 7.0.20
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.20
Microsoft.AspNetCore.TestHost | 7.0.20
Microsoft.Authentication.WebAssembly.Msal | 7.0.20
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.20
Microsoft.Extensions.Http.Polly | 7.0.20
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.20
Microsoft.Extensions.Features | 7.0.20
Microsoft.Extensions.FileProviders.Embedded | 7.0.20
Microsoft.Extensions.Identity.Core | 7.0.20
Microsoft.Extensions.Logging.AzureAppServices | 7.0.20
Microsoft.Extensions.Identity.Stores | 7.0.20
Microsoft.Extensions.Localization | 7.0.20
Microsoft.Extensions.Localization.Abstractions | 7.0.20
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.20
FSharp.Core | 7.0.0
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.ApiCompat.Task | 7.0.120
Microsoft.DotNet.Common.ItemTemplates | 7.0.120
Microsoft.DotNet.ApiCompat.Tool | 7.0.120
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.120
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.20
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.20
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.20
Microsoft.EntityFrameworkCore.Sqlite | 7.0.20
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.20
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.20
Microsoft.EntityFrameworkCore.Templates | 7.0.20
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.20
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.20
Microsoft.EntityFrameworkCore.Proxies | 7.0.20
Microsoft.EntityFrameworkCore.Relational | 7.0.20
Microsoft.EntityFrameworkCore.Tools | 7.0.20
dotnet-ef | 7.0.20
Microsoft.EntityFrameworkCore | 7.0.20
Microsoft.Data.Sqlite.Core | 7.0.20
Microsoft.Data.Sqlite | 7.0.20
Microsoft.EntityFrameworkCore.Abstractions | 7.0.20
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.20
Microsoft.EntityFrameworkCore.SqlServer | 7.0.20
Microsoft.EntityFrameworkCore.InMemory | 7.0.20
Microsoft.EntityFrameworkCore.Analyzers | 7.0.20
Microsoft.EntityFrameworkCore.Cosmos | 7.0.20
Microsoft.EntityFrameworkCore.Design | 7.0.20
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.120
Microsoft.TemplateEngine.Abstractions | 7.0.120
Microsoft.TemplateEngine.Edge | 7.0.120
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.120
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.120
Microsoft.TemplateEngine.Tasks | 7.0.120
Microsoft.TemplateEngine.Core | 7.0.120
Microsoft.TemplateEngine.Core.Contracts | 7.0.120
Microsoft.TemplateEngine.IDE | 7.0.120
Microsoft.TemplateEngine.Utils | 7.0.120
Microsoft.TemplateSearch.Common | 7.0.120
Microsoft.DotNet.ApiCompat.Tool | 7.0.317
Microsoft.NET.Build.Containers | 7.0.317
FSharp.Compiler.Service | 43.7.300
FSharp.Core | 7.0.300
Microsoft.DotNet.ApiCompat.Task | 7.0.317
Microsoft.DotNet.Common.ItemTemplates | 7.0.317
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.317
Microsoft.TemplateEngine.Authoring.CLI | 7.0.317
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.317
Microsoft.TemplateEngine.Core.Contracts | 7.0.317
Microsoft.TemplateEngine.Abstractions | 7.0.317
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.317
Microsoft.TemplateEngine.Core | 7.0.317
Microsoft.TemplateEngine.Edge | 7.0.317
Microsoft.TemplateEngine.IDE | 7.0.317
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.317
Microsoft.TemplateEngine.Utils | 7.0.317
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.317
Microsoft.TemplateSearch.Common | 7.0.317
Microsoft.DotNet.ApiCompat.Task | 7.0.410
Microsoft.DotNet.Common.ItemTemplates | 7.0.410
FSharp.Compiler.Service | 43.7.403
Microsoft.NET.Build.Containers | 7.0.410
Microsoft.DotNet.ApiCompat.Tool | 7.0.410
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.410
FSharp.Core | 7.0.403
Microsoft.TemplateEngine.Authoring.CLI | 7.0.410
Microsoft.TemplateEngine.Core | 7.0.410
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.410
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.410
Microsoft.TemplateEngine.Utils | 7.0.410
Microsoft.TemplateEngine.IDE | 7.0.410
Microsoft.TemplateEngine.Abstractions | 7.0.410
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.410
Microsoft.TemplateEngine.Core.Contracts | 7.0.410
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.410
Microsoft.TemplateEngine.Edge | 7.0.410
Microsoft.TemplateSearch.Common | 7.0.410



[//]: # ( Runtime 7.0.20)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06e8869b-e332-411b-aea2-7e29daae6953/6b8f60cbb630acd5d94219faa15faf6f/dotnet-runtime-7.0.20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af6e12de-a63c-449f-b35b-b72ec6ee3da5/ae129eca3d734117d14cd5965dca93a3/dotnet-runtime-7.0.20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d1ca778-4415-451e-873a-dc4062d8d9a9/f38f41e5784c0832e24fe18a938ed5e5/dotnet-runtime-7.0.20-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c30b2e10-7c18-447c-b66b-47bf12f88692/0d5fbdecc6b2cc86fd2f43ebfffd7aa2/dotnet-runtime-7.0.20-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3297a5d6-9f41-4098-9597-c1b966c19983/46559d0d813b36264fb414562caca171/dotnet-runtime-7.0.20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c5981ff-0f0c-47ab-bff4-0ea4919b395b/cbfdfa7f35d133b0bdef87fa3830bfa0/dotnet-runtime-7.0.20-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bf9731fe-26de-49ef-bb2f-a683a72783b5/d335696addb5b35eabde194cdd4300a1/dotnet-runtime-7.0.20-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50dbf5c1-942d-4fd8-b646-1f024326ec1c/5fb99e9dae294298a8131757b3ea829e/dotnet-runtime-7.0.20-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c2dbd8b5-ffba-4ee4-83fa-277d6c3155e1/ac7b2ae9d57a82b4d71d793f5d3a0493/dotnet-runtime-7.0.20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbade9d9-be1e-46c0-9f90-13ba882965dc/31c86e8f4beaf0e5ad9ad35a408be7de/dotnet-runtime-7.0.20-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0f644d8-1e44-47cd-893a-9887a750f3fe/a16530341133ea8071ac36257f53d277/dotnet-runtime-7.0.20-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/793b861e-249a-4dae-a2a8-0db850367237/59b58f885bcd160c4427232972249acb/dotnet-runtime-7.0.20-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/be7eaed0-4e32-472b-b53e-b08ac3433a22/fc99a5977c57cbfb93b4afb401953818/dotnet-runtime-7.0.20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/990ff1f7-b5df-4a80-a65e-7cff3a1a263c/f1a2f3cab0d1787618f7d8043e3a6827/dotnet-runtime-7.0.20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b2e820bd-b591-43df-ab10-1eeb7998cc18/661ca79db4934c6247f5c7a809a62238/dotnet-runtime-7.0.20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f479b75e-9ecb-42ea-8371-c94f411eda8d/0cd700d75f1d04e9108bc4213f8a41ec/dotnet-runtime-7.0.20-win-x86.zip

[//]: # ( WindowsDesktop 7.0.20)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/de2e5484-866e-4149-a3e2-023c705403f9/68a700c68af757d68ec87daa4b878c96/windowsdesktop-runtime-7.0.20-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/db2b2cea-224b-454e-97d5-84ee46db11a4/bc345ec0c9af0855a48ec8630e90bdb0/windowsdesktop-runtime-7.0.20-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/08bbfe8f-812d-479f-803b-23ea0bffce47/c320e4b037f3e92ab7ea92c3d7ea3ca1/windowsdesktop-runtime-7.0.20-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1dec4601-40e5-436f-8787-c73850a5a475/e0b9874aae3b945397b62be8242df594/windowsdesktop-runtime-7.0.20-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b840017b-c69f-4724-a152-11020a0039e6/b74aa12e4ee765a3387a7dcd4ba56187/windowsdesktop-runtime-7.0.20-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d40dc6c6-7d20-4141-8f4b-872613248a26/0c8512b118d50b655ed01162b48082cf/windowsdesktop-runtime-7.0.20-win-x86.zip

[//]: # ( ASP 7.0.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e8680cf-0baa-4957-99b7-81395b8ff60d/5a9c578ff9aaefc7ed77e63b6a90dc03/aspnetcore-runtime-7.0.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae3027ce-cadf-4510-a1aa-125958cf0432/c3d958ba80ec21e9d75ca5e8f43ec2d3/aspnetcore-runtime-7.0.20-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40131679-906c-4afd-90f0-576fbed036b1/85a0c856077ad82c29350486ebdb912d/aspnetcore-runtime-7.0.20-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ef9e16e-9a83-401e-8ef5-905ef374b768/725507d68a8bc4a4297e2c82bb1d06db/aspnetcore-runtime-7.0.20-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3f5953c-68f8-48e1-91bb-0ca62199e6db/b3d7a2de0488fd63fa286c3fc371d68f/aspnetcore-runtime-7.0.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09e67261-215a-4003-bcf8-f90d67dcd02b/b32cf12a5c10b1f74e21c8cb03880891/aspnetcore-runtime-7.0.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2833b957-8fb7-45fa-bf85-4960260ae344/fa4678e8c3ceba67771b5195a2343049/aspnetcore-runtime-7.0.20-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65fff3f3-1b87-42aa-b1f9-04e7e318c1af/4bfbb002455b9a037e75791e99a18c19/aspnetcore-runtime-7.0.20-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b807f90e-8b79-40ed-9878-a06eded4745a/8c4dab5de4d510723b6906f85b1b7f2b/aspnetcore-runtime-7.0.20-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/10651a65-8afc-46e3-9287-fecb0e68504e/4c2bf0cdb44612f29d9b3f901098e13e/aspnetcore-runtime-7.0.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e5424205-fbbb-4c19-a22c-10a7eeb2f918/527b1378927b68e8c6faac6cc40ec5c3/aspnetcore-runtime-7.0.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d84ac38e-a248-4c8d-b1fe-4ee092d6b4b1/9f0bf370619ab3da8869e467827a6dc6/aspnetcore-runtime-7.0.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6f95cda4-166a-4281-ba1f-4963ac5fb958/598e690d7e9d8608b0d60122e127ae1f/aspnetcore-runtime-7.0.20-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0d8a8780-8075-4772-9d74-5adf8390448d/702306fe0eff72af00901702db6314e8/dotnet-hosting-7.0.20-win.exe

[//]: # ( SDK 7.0.410)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b1d565b-7a3d-4e7e-87ad-7c662ec59020/4c6cb8a150efb42f7cea7e0b4c2f61cf/dotnet-sdk-7.0.410-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e408891-74af-4ccb-9ce8-895f6806a97d/3a589bbf6e264059544cef47be672540/dotnet-sdk-7.0.410-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb542b02-38a4-4564-bc66-d7822758cf1c/d18f1e24ef1b3cdb4ef10bc641ce9a5b/dotnet-sdk-7.0.410-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e1f9446-53ee-469e-8dde-cc307306ac61/bce850d1c118b4b6dcf9f808b22a8a54/dotnet-sdk-7.0.410-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d16b077-939f-435d-8f2e-11813d76db6b/ba4829249b04d6c818bc175846e694b5/dotnet-sdk-7.0.410-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ddc1522-2361-4394-97e9-52318bf51951/c5aef30601a86810f1f8ea89d42c26a0/dotnet-sdk-7.0.410-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ff89348c-045e-4fdc-bd6c-31b6d3940420/7f6cb1235b86ee021a6186fbd8542a1e/dotnet-sdk-7.0.410-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfba06ea-d182-4a12-8066-fd78413e6cc3/f7940d1e8d8ae641a3a3d65b6bfa1071/dotnet-sdk-7.0.410-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5c791273-2fbb-4330-9ce0-14e24cf9b1c3/14f324dd113f30fc19a4af2e9038589d/dotnet-sdk-7.0.410-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc8614cd-f333-4adb-815a-9bbd07e02b16/0ccf5e50cf8fa5c600716395e240aff1/dotnet-sdk-7.0.410-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3b42a6a-dc31-493c-911c-13afa1ee80a8/a437ce5b198836042b6fd3179e5dee40/dotnet-sdk-7.0.410-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/19704083-a2a1-477b-8baa-ba61839e3c9b/33184cec3b68bd1bf09f75deea79a857/dotnet-sdk-7.0.410-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6f7abf5c-3f6d-43cc-8f3c-700c27d4976b/b7a3b806505c95c7095ca1e8c057e987/dotnet-sdk-7.0.410-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1c6cf2f4-25f6-4317-94ce-5be9c8ae167d/02364359ad16d626f9dcb55717bd6900/dotnet-sdk-7.0.410-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0da29c3d-29a8-430c-b4a9-80392f7b7af3/44d3db88c5aeb696c764f0ff4e68245e/dotnet-sdk-7.0.410-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4b1577db-7262-49cf-9bc4-251a7c912392/03727d65e6d327e5c500d81c06356618/dotnet-sdk-7.0.410-win-x86.zip
