# .NET 7.0.4  - March 14, 2023

The .NET 7.0.4 and .NET SDK 7.0.202 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.202
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

### Additional fixes in this release

* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A7.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A7.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Linker](https://github.com/dotnet/linker/issues?q=milestone%3A7.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A7.0.4+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8285](https://github.com/dotnet/core/issues/8285) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.4-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.4+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.4+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.4+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.4+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.4+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.4+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.4
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.4
Microsoft.WindowsDesktop.App.Ref | 7.0.4
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.4
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.4
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.4
Microsoft.NETCore.App.Host.win-arm | 7.0.4
Microsoft.NETCore.App.Ref | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Host.linux-x64 | 7.0.4
Microsoft.NETCore.App.Host.win-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.4
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.4
Microsoft.NETCore.DotNetHost | 7.0.4
Microsoft.NETCore.DotNetHostPolicy | 7.0.4
Microsoft.NETCore.DotNetAppHost | 7.0.4
Microsoft.NETCore.Platforms | 7.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.4
Microsoft.DotNet.ILCompiler | 7.0.4
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.4
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.4
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.4
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.4
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.4
Microsoft.NETCore.App.Host.osx-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.4
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.4
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.4
Microsoft.NETCore.App.Host.win-arm64 | 7.0.4
Microsoft.NETCore.App.Host.win-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
System.Reflection.Metadata | 7.0.1
System.Diagnostics.DiagnosticSource | 7.0.2
System.Net.Http.Json | 7.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.4
Microsoft.Extensions.Configuration.Binder | 7.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Composite | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.4
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.4
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.4
Microsoft.NETCore.App.Host.linux-arm | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.4
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.4
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.4
Microsoft.AspNetCore.Authentication.Certificate | 7.0.4
Microsoft.AspNetCore.Components.Analyzers | 7.0.4
Microsoft.Extensions.Localization | 7.0.4
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.4
Microsoft.AspNetCore.App.Ref | 7.0.4
Microsoft.AspNetCore.Authentication.Google | 7.0.4
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.4
Microsoft.AspNetCore.Components | 7.0.4
Microsoft.AspNetCore.Components.Authorization | 7.0.4
Microsoft.AspNetCore.Components.CustomElements | 7.0.4
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.4
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.4
Microsoft.AspNetCore.Components.WebView | 7.0.4
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.4
Microsoft.AspNetCore.Connections.Abstractions | 7.0.4
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.4
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.4
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.4
Microsoft.AspNetCore.Grpc.Swagger | 0.3.4
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.4
Microsoft.AspNetCore.SpaProxy | 7.0.4
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.4
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.4
Microsoft.Authentication.WebAssembly.Msal | 7.0.4
Microsoft.AspNetCore.TestHost | 7.0.4
Microsoft.dotnet-openapi | 7.0.4
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.4
Microsoft.Extensions.ApiDescription.Server | 7.0.4
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.4
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.4
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.4
Microsoft.JSInterop | 7.0.4
AspNetCoreRuntime.7.0.x86 | 7.0.4
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.4
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.4
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.4
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.4
Microsoft.AspNetCore.Authentication.Twitter | 7.0.4
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.4
Microsoft.AspNetCore.Components.Forms | 7.0.4
Microsoft.AspNetCore.Cryptography.Internal | 7.0.4
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.4
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.4
Microsoft.AspNetCore.DataProtection | 7.0.4
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.4
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.4
Microsoft.AspNetCore.Http.Connections.Client | 7.0.4
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.4
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.4
Microsoft.AspNetCore.Metadata | 7.0.4
Microsoft.AspNetCore.Mvc.Testing | 7.0.4
Microsoft.AspNetCore.Owin | 7.0.4
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.4
Microsoft.AspNetCore.SignalR.Client | 7.0.4
Microsoft.AspNetCore.SignalR.Common | 7.0.4
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.4
Microsoft.Extensions.Caching.SqlServer | 7.0.4
Microsoft.Extensions.ApiDescription.Client | 7.0.4
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.4
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.4
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.4
Microsoft.Extensions.Features | 7.0.4
Microsoft.Extensions.FileProviders.Embedded | 7.0.4
Microsoft.Extensions.Localization.Abstractions | 7.0.4
Microsoft.Extensions.Logging.AzureAppServices | 7.0.4
Microsoft.JSInterop.WebAssembly | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.4
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.4
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.4
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.4
Microsoft.AspNetCore.Authentication.Facebook | 7.0.4
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.4
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.4
Microsoft.AspNetCore.Authorization | 7.0.4
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.4
Microsoft.AspNetCore.Components.WebAssembly | 7.0.4
Microsoft.AspNetCore.Http.Connections.Common | 7.0.4
Microsoft.AspNetCore.JsonPatch | 7.0.4
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.4
dotnet-sql-cache | 7.0.4
Microsoft.Extensions.Identity.Stores | 7.0.4
AspNetCoreRuntime.7.0.x64 | 7.0.4
Microsoft.AspNetCore.Components.Web | 7.0.4
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.4
Microsoft.AspNetCore.HeaderPropagation | 7.0.4
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.4
Microsoft.AspNetCore.Identity.UI | 7.0.4
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.4
Microsoft.AspNetCore.OpenApi | 7.0.4
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.4
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.4
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.4
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.4
Microsoft.Extensions.Http.Polly | 7.0.4
Microsoft.Extensions.Identity.Core | 7.0.4
Microsoft.Extensions.WebEncoders | 7.0.4
Microsoft.Extensions.ObjectPool | 7.0.4
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Tool | 7.0.104
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.ApiCompat.Task | 7.0.104
Microsoft.DotNet.Common.ItemTemplates | 7.0.104
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.104
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.4
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.4
Microsoft.EntityFrameworkCore.Abstractions | 7.0.4
Microsoft.EntityFrameworkCore.Analyzers | 7.0.4
Microsoft.EntityFrameworkCore.Relational | 7.0.4
dotnet-ef | 7.0.4
Microsoft.Data.Sqlite | 7.0.4
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.4
Microsoft.EntityFrameworkCore.Cosmos | 7.0.4
Microsoft.EntityFrameworkCore.InMemory | 7.0.4
Microsoft.EntityFrameworkCore.Design | 7.0.4
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.4
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.4
Microsoft.EntityFrameworkCore.SqlServer | 7.0.4
Microsoft.Data.Sqlite.Core | 7.0.4
Microsoft.EntityFrameworkCore.Proxies | 7.0.4
Microsoft.EntityFrameworkCore.Sqlite | 7.0.4
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.4
Microsoft.EntityFrameworkCore | 7.0.4
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.4
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.4
Microsoft.EntityFrameworkCore.Templates | 7.0.4
Microsoft.EntityFrameworkCore.Tools | 7.0.4
Microsoft.TemplateEngine.IDE | 7.0.104
Microsoft.TemplateEngine.Utils | 7.0.104
Microsoft.TemplateSearch.Common | 7.0.104
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.104
Microsoft.TemplateEngine.Core.Contracts | 7.0.104
Microsoft.TemplateEngine.Edge | 7.0.104
Microsoft.TemplateEngine.Tasks | 7.0.104
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.104
Microsoft.TemplateEngine.Core | 7.0.104
Microsoft.TemplateEngine.Abstractions | 7.0.104
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.104
Microsoft.DotNet.ApiCompat.Tool | 7.0.202
Microsoft.DotNet.ApiCompat.Task | 7.0.202
Microsoft.DotNet.Common.ItemTemplates | 7.0.202
FSharp.Compiler.Service | 43.7.200
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.202
FSharp.Core | 7.0.200
Microsoft.TemplateEngine.Core | 7.0.201
Microsoft.TemplateEngine.Utils | 7.0.201
Microsoft.TemplateSearch.Common | 7.0.201
Microsoft.TemplateEngine.Abstractions | 7.0.201
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.201
Microsoft.TemplateEngine.Edge | 7.0.201
Microsoft.TemplateEngine.Authoring.CLI | 7.0.201
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.201
Microsoft.TemplateEngine.Core.Contracts | 7.0.201
Microsoft.TemplateEngine.IDE | 7.0.201
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.201
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.201


[//]: # ( Runtime 7.0.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d45c40c-50e0-4c34-a8e7-02874823ec38/542e091c925c69e529533480c187068b/dotnet-runtime-7.0.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47a77eda-2e32-4106-bc84-375b873a9839/c6d88de403b103248f67f429507ea269/dotnet-runtime-7.0.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46c1ae9c-ba38-45a8-8250-c6cc3306081e/c60f75badddd909d308671ecb4f2faed/dotnet-runtime-7.0.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31fcb8d1-489d-47a9-a6f7-230daa67c77a/b9dc027228cb8a0defedeeb8b658280c/dotnet-runtime-7.0.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5626a791-2469-436e-bba8-d020f244b51b/f6b7f1d3921160a5f097d6f5e3a76b65/dotnet-runtime-7.0.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08c89e27-b593-438e-8303-af765b90e5da/28b1b06748b86a694ac4ddf43d546a32/dotnet-runtime-7.0.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e3f2fe23-5f8f-472a-8c90-e2fd71840bbe/b8cea84bdfa8f27dc68c44ec7faa32f9/dotnet-runtime-7.0.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf2d81d2-d793-43c6-af0f-763a48e1fdea/0457d06cc4e7dea7fff49e944691c72e/dotnet-runtime-7.0.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/417ba51a-bd56-4386-87a7-612d715189f0/48f92194b309e878f16a00956de8d1ce/dotnet-runtime-7.0.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4dd643a-16b8-4f1e-ba38-cdbe32cc24df/67b307accc4abbbc2238310d6ea3c516/dotnet-runtime-7.0.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/aa70e646-6d6d-49f2-a7e5-5cad90f3783b/309665ecddef746789a848f7a8cca610/dotnet-runtime-7.0.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6c19b8ad-c3d1-4262-9fc2-5e42a8b77eb4/a136c7f489c00c5dcb914cfcf1ead671/dotnet-runtime-7.0.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7e842a78-9877-4b82-8450-f3311b406a6f/83352282a0bdf1e5f9dfc5fcc88dc83f/dotnet-runtime-7.0.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/88beaec3-b636-4b17-bdc5-ad8563c11155/0b4e765664b4961b50e167367dcef927/dotnet-runtime-7.0.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a44ad7c4-c079-4299-a5a5-669d53707f76/9a94eeb3cdf9529d40e8020a3b8f6c61/dotnet-runtime-7.0.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d8163d38-8eca-4ed3-ad81-d25140adf370/9652bb2338e2d7fe2eb53d8d05a2b6ba/dotnet-runtime-7.0.4-win-x86.zip

[//]: # ( WindowsDesktop 7.0.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f9e5d878-12fa-4c6a-889c-3c03c22cecb9/0ccb0a599375a19ba34dbbb318864297/windowsdesktop-runtime-7.0.4-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7dfbd2fc-fcd9-4da4-ad0f-a3c833041628/04bd1c17ffc04250efb90afff9c4c52a/windowsdesktop-runtime-7.0.4-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b6a55627-12de-482a-aea8-17d635f4b775/d8798c0c796a945c657d04438cf9b84d/windowsdesktop-runtime-7.0.4-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ae6eaae5-3dbb-4ddf-8ce1-be529fbfdc69/50615bf1b6806d16d2258476005037cd/windowsdesktop-runtime-7.0.4-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c8d474f-e58f-4ab2-ab3c-f6c2c8616910/41b492e1c41083c823d56162c700de57/windowsdesktop-runtime-7.0.4-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/41ca2de4-1a26-45a8-a92d-5dc91ab2fe19/6f57a2c4bfa4fc16754f8f23540e1bcf/windowsdesktop-runtime-7.0.4-win-x86.zip

[//]: # ( ASP 7.0.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43013763-849e-4d6e-b21c-0222eeda0624/6e1be378246de9af8d26df611107a3f3/aspnetcore-runtime-7.0.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/639aae36-b8fe-4bb7-86d7-0216554b6183/3b5caffe27bb78bbb10aff729d65ae03/aspnetcore-runtime-7.0.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4e56097-5a2c-47da-a031-da327545ab5f/804efe030b9eb210024c3fd88aeea1bc/aspnetcore-runtime-7.0.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08c2aee5-4a0c-4433-9772-e0cd5670bf8a/a849803916e33be03c176968ee7a5c6a/aspnetcore-runtime-7.0.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68c9f0b5-105d-47a6-b8c2-32e045ffbc89/19e0050e885bd52508b77ab8296d6571/aspnetcore-runtime-7.0.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2e33ca2-e597-4d7c-b34d-60e47b5fe2fc/a22feac281b4bf63c8b5195a30e6cce1/aspnetcore-runtime-7.0.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d70d5370-7f1c-4fd9-88cb-504569112323/32a23f276392a1fb04f2f3cdd35f961b/aspnetcore-runtime-7.0.4-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb055f27-b58f-47db-b291-91a2700396a4/7b313614b3ba0cd2f9e57b288c82f0b7/aspnetcore-runtime-7.0.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/25c0c79c-1a55-4ba2-b106-46fb689fdce7/8a76691d8d209295d2ca2c50b6b4a9c6/aspnetcore-runtime-7.0.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1c260404-69d2-4c07-979c-644846ba1f46/7d27639ac67f1e502b83a738406da0ee/aspnetcore-runtime-7.0.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/807a366a-ecf2-4704-a468-fc78ea832e79/b3b845fedd389cd76945d379683ae291/aspnetcore-runtime-7.0.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/771de8e0-6c27-435f-8471-32e360408e15/4f84ca38b7988cc602d1ca62c0469ad2/aspnetcore-runtime-7.0.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/06d0f0fd-1840-47ec-938e-8c6103628d0f/253b21ce98e3ed91ea68aad3e4124305/aspnetcore-runtime-7.0.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d97e0776-b316-4c41-a067-202eb027b968/e9694b0aa94e4b814f980f9ec3d3f400/dotnet-hosting-7.0.4-win.exe

[//]: # ( SDK 7.0.202)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b56da47-dbe4-4921-a08e-eb3826565525/36ecf89507f52cc70ec2128b13948290/dotnet-sdk-7.0.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1fd11b0-186a-4aa1-a578-bb1b6613886e/b67e1c9d6d90b1c99b23935273921fa1/dotnet-sdk-7.0.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60033de4-23dc-4b66-a4d2-c8720a7d9641/22c3478f8f350c79f399a0313db6e6a5/dotnet-sdk-7.0.202-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02ce3cad-f8b3-408b-a03b-6237e5beaab2/6a43057a87423fd368920f59e5e2ac6f/dotnet-sdk-7.0.202-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/591b9096-c73a-4dac-9f8a-e38824c12ee2/e2a889594de556f3b7bbef46980ae30e/dotnet-sdk-7.0.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bda88810-e1a6-4cf0-8139-7fd7fe7b2c7a/7a9ffa3e12e5f1c3d8b640e326c1eb14/dotnet-sdk-7.0.202-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d569fc95-64b5-4fc3-ae06-5d3bec40e540/7532a322362c4717fc57211eafe5002c/dotnet-sdk-7.0.202-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4402413a-ef81-4732-a0c0-38f11694b226/e205b8bf48d95902a6dbe1c3cccca272/dotnet-sdk-7.0.202-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a87236b2-9ddd-4f48-ac81-d8d07a7cdac2/91a91d1eac4d598a6eaf5faf148f3afd/dotnet-sdk-7.0.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d3fe9043-0ff4-4584-aacf-1ad41c47407b/7b84ed341359488cd0de21de1b4df6d0/dotnet-sdk-7.0.202-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/32d8d194-4ab7-4913-a524-ba8b971896c2/a45108bd93c9da7e110837968c55e221/dotnet-sdk-7.0.202-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/52f31250-1961-4203-9f51-9b9afce0db15/129915360a0e0e6ee59e895efd389b0a/dotnet-sdk-7.0.202-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6ad374b-9b66-49ed-a140-588348d0c29a/78084d635f2a4011ccd65dc7fd9e83ce/dotnet-sdk-7.0.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e2f99985-b54a-43a2-85cf-cfc9a1e0a307/171339e000ade0b6e10c3cb010ed45ba/dotnet-sdk-7.0.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9d754e4b-caa0-4f0f-b254-b0ee1fdb580f/360dbbbf186f32ecf661b178a1768652/dotnet-sdk-7.0.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c7213e17-4955-4fae-a405-1b7101086daf/71963248a7de64c4b00219a8199e7429/dotnet-sdk-7.0.202-win-x86.zip

[//]: # ( SDK 7.0.104)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66b23fdf-44d7-4aad-a963-2b1db7302ecf/6ef05a379a4411a1aec40dc8d4f2eb51/dotnet-sdk-7.0.104-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7134a248-8879-43d5-99a0-4db4cd63785d/12da11c75491e290eb962a0e684cb9fd/dotnet-sdk-7.0.104-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b82839f8-36eb-410c-ac2e-5f95060d057a/edcea6638b732dfe5c21aa232bbf68e4/dotnet-sdk-7.0.104-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4de503f4-25bc-4151-a97a-5efbfbc3a116/c2ad1ccb3f69f67e2b6d4674563ecedb/dotnet-sdk-7.0.104-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43359b9f-f4e6-416e-b0c0-8d38166ddc77/103ce9765e7b3a4d889d02fdf727057c/dotnet-sdk-7.0.104-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83715ea1-0ea1-4f45-9110-a346c8dc3721/44319b982c7779caf71b96dddbe9313f/dotnet-sdk-7.0.104-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0a0918d4-885d-4bf3-9035-403672abeeb2/9bcc40947fc82af1cbb42ab0b56651b2/dotnet-sdk-7.0.104-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6946c3f5-dad4-4f65-939b-10be0ed81b6a/0ca6b9e3ba86d1ca91db8525781210fb/dotnet-sdk-7.0.104-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ebb60c9d-97cb-4a0c-8e1e-023aebaca4dd/daee1c894a615841c9d8602c311d57e7/dotnet-sdk-7.0.104-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23fde16a-2f08-4c1a-b9a7-ce66c1a394bb/b2117ae117f2746302d937b736caec33/dotnet-sdk-7.0.104-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b84274fc-0a4b-4c25-bebe-8860f6c1f029/97bda201410aec85ae886d8ea5ac2b32/dotnet-sdk-7.0.104-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/58411c8e-1f7b-4790-99ea-f6618cf0a093/2cf6832388ad48d2748235f288bdfa26/dotnet-sdk-7.0.104-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/72c110a3-e7c0-4fee-b45b-bdd7d4f443c2/55c40827bc30d65be5243794d039433a/dotnet-sdk-7.0.104-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/efe88a72-3d40-4353-9ecf-c9c28facbe9c/026ad9510ccc469adf54356caf3390ef/dotnet-sdk-7.0.104-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/32ef1bd0-86ed-4720-9850-453ecbc805c7/03159efe0de07c09094182df269e1380/dotnet-sdk-7.0.104-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a08b9e25-beef-4341-8dad-8a32ac8a6366/3acf81b00e45560c4b5a9eb7231950ac/dotnet-sdk-7.0.104-win-x86.zip
