# .NET 7.0.5  - April 11, 2023

The .NET 7.0.5 and .NET SDK 7.0.203 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.203
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.5 release carries security fixes.

# Microsoft Security Advisory CVE-2023-28260: .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET running on Windows where a runtime DLL can be loaded from an unexpected location, resulting in remote code execution.

### Additional fixes in this release

* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [Linker](https://github.com/dotnet/linker/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [Templating](https://github.com/dotnet/templating/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A7.0.5+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8383](https://github.com/dotnet/core/issues/8383) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.5-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.5+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.5+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.5
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.5
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.5
Microsoft.WindowsDesktop.App.Ref | 7.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.5
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.5
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Host.linux-arm | 7.0.5
Microsoft.DotNet.ILCompiler | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.5
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.5
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.5
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.5
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.5
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.5
Microsoft.NETCore.App.Host.osx-x64 | 7.0.5
Microsoft.NETCore.App.Host.win-x64 | 7.0.5
Microsoft.NETCore.App.Host.win-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.5
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.5
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.5
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.5
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.5
Microsoft.NETCore.App.Ref | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.5
Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.5
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.5
Microsoft.NETCore.App.Host.linux-x64 | 7.0.5
Microsoft.NETCore.App.Host.win-arm | 7.0.5
Microsoft.NETCore.App.Host.win-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.5
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.5
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.5
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.5
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.5
System.Management | 7.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Composite | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.5
Microsoft.NETCore.DotNetHostPolicy | 7.0.5
Microsoft.NETCore.DotNetHost | 7.0.5
Microsoft.NETCore.DotNetAppHost | 7.0.5
Microsoft.NETCore.Platforms | 7.0.2
Microsoft.Windows.Compatibility | 7.0.1
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.5
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.5
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.5
Microsoft.AspNetCore.Authentication.Facebook | 7.0.5
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.5
Microsoft.AspNetCore.Connections.Abstractions | 7.0.5
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.5
Microsoft.AspNetCore.Cryptography.Internal | 7.0.5
Microsoft.AspNetCore.DataProtection | 7.0.5
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.5
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.5
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.5
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.5
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.5
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.5
Microsoft.AspNetCore.Grpc.Swagger | 0.3.5
Microsoft.AspNetCore.HeaderPropagation | 7.0.5
Microsoft.AspNetCore.Http.Connections.Client | 7.0.5
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.5
Microsoft.AspNetCore.Identity.UI | 7.0.5
Microsoft.AspNetCore.Http.Connections.Common | 7.0.5
Microsoft.AspNetCore.JsonPatch | 7.0.5
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.5
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.5
Microsoft.AspNetCore.Mvc.Testing | 7.0.5
Microsoft.AspNetCore.TestHost | 7.0.5
Microsoft.Extensions.ApiDescription.Server | 7.0.5
Microsoft.Authentication.WebAssembly.Msal | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.5
AspNetCoreRuntime.7.0.x64 | 7.0.5
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.5
Microsoft.AspNetCore.App.Ref | 7.0.5
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.5
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.5
dotnet-sql-cache | 7.0.5
Microsoft.AspNetCore.Authentication.Certificate | 7.0.5
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.5
Microsoft.AspNetCore.Authentication.Google | 7.0.5
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.5
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.5
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.5
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.5
Microsoft.AspNetCore.Authentication.Twitter | 7.0.5
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.5
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.5
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.5
Microsoft.AspNetCore.Authorization | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.5
Microsoft.AspNetCore.Components.CustomElements | 7.0.5
Microsoft.AspNetCore.Components.Authorization | 7.0.5
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.5
Microsoft.AspNetCore.Components.Forms | 7.0.5
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.5
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.5
Microsoft.AspNetCore.Metadata | 7.0.5
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.5
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.5
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.5
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.5
Microsoft.Extensions.Identity.Stores | 7.0.5
Microsoft.Extensions.Localization | 7.0.5
Microsoft.Extensions.Localization.Abstractions | 7.0.5
Microsoft.Extensions.WebEncoders | 7.0.5
Microsoft.Extensions.Logging.AzureAppServices | 7.0.5
Microsoft.Extensions.ObjectPool | 7.0.5
AspNetCoreRuntime.7.0.x86 | 7.0.5
Microsoft.AspNetCore.Components.WebView | 7.0.5
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.5
Microsoft.AspNetCore.Owin | 7.0.5
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.5
Microsoft.AspNetCore.OpenApi | 7.0.5
Microsoft.AspNetCore.SignalR.Client | 7.0.5
Microsoft.AspNetCore.SignalR.Common | 7.0.5
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.5
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.5
Microsoft.AspNetCore.SpaProxy | 7.0.5
Microsoft.dotnet-openapi | 7.0.5
Microsoft.Extensions.ApiDescription.Client | 7.0.5
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.5
Microsoft.Extensions.Caching.SqlServer | 7.0.5
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.5
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.5
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.5
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.5
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.5
Microsoft.Extensions.Features | 7.0.5
Microsoft.Extensions.FileProviders.Embedded | 7.0.5
Microsoft.Extensions.Http.Polly | 7.0.5
Microsoft.Extensions.Identity.Core | 7.0.5
Microsoft.JSInterop.WebAssembly | 7.0.5
Microsoft.JSInterop | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.5
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.5
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.5
Microsoft.AspNetCore.Components | 7.0.5
Microsoft.AspNetCore.Components.Analyzers | 7.0.5
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.5
Microsoft.AspNetCore.Components.Web | 7.0.5
Microsoft.AspNetCore.Components.WebAssembly | 7.0.5
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.5
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.5
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.5
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.5
Microsoft.DotNet.ApiCompat.Task | 7.0.105
FSharp.Core | 7.0.0
FSharp.Compiler.Service | 42.7.101
Microsoft.DotNet.Common.ItemTemplates | 7.0.105
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.105
Microsoft.DotNet.ApiCompat.Tool | 7.0.105
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.5
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.5
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.5
Microsoft.EntityFrameworkCore | 7.0.5
Microsoft.EntityFrameworkCore.Analyzers | 7.0.5
Microsoft.EntityFrameworkCore.Relational | 7.0.5
Microsoft.EntityFrameworkCore.Cosmos | 7.0.5
Microsoft.EntityFrameworkCore.Design | 7.0.5
Microsoft.EntityFrameworkCore.InMemory | 7.0.5
Microsoft.EntityFrameworkCore.Proxies | 7.0.5
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.5
Microsoft.EntityFrameworkCore.Sqlite | 7.0.5
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.5
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.5
Microsoft.EntityFrameworkCore.Templates | 7.0.5
Microsoft.EntityFrameworkCore.Tools | 7.0.5
dotnet-ef | 7.0.5
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.5
Microsoft.EntityFrameworkCore.SqlServer | 7.0.5
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.5
Microsoft.EntityFrameworkCore.Abstractions | 7.0.5
Microsoft.Data.Sqlite.Core | 7.0.5
Microsoft.Data.Sqlite | 7.0.5
Microsoft.TemplateEngine.Edge | 7.0.105
Microsoft.TemplateEngine.IDE | 7.0.105
Microsoft.TemplateEngine.Core | 7.0.105
Microsoft.TemplateEngine.Core.Contracts | 7.0.105
Microsoft.TemplateEngine.Tasks | 7.0.105
Microsoft.TemplateEngine.Utils | 7.0.105
Microsoft.TemplateEngine.Abstractions | 7.0.105
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.105
Microsoft.TemplateSearch.Common | 7.0.105
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.105
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.105
FSharp.Core | 7.0.200
Microsoft.DotNet.ApiCompat.Tool | 7.0.203
Microsoft.DotNet.ApiCompat.Task | 7.0.203
Microsoft.DotNet.Common.ItemTemplates | 7.0.203
FSharp.Compiler.Service | 43.7.200
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.203
Microsoft.TemplateEngine.Abstractions | 7.0.203
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.203
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.203
Microsoft.TemplateEngine.Authoring.CLI | 7.0.203
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.203
Microsoft.TemplateEngine.Core | 7.0.203
Microsoft.TemplateEngine.Edge | 7.0.203
Microsoft.TemplateEngine.Core.Contracts | 7.0.203
Microsoft.TemplateEngine.IDE | 7.0.203
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.203
Microsoft.TemplateSearch.Common | 7.0.203
Microsoft.TemplateEngine.Utils | 7.0.203
Microsoft.CodeAnalysis.Metrics | 3.3.4-beta1.23160.1
Roslyn.Diagnostics.Analyzers | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.Analyzers | 3.3.4-beta1.23160.1
Microsoft.CodeAnalysis.NetAnalyzers | 7.0.1-preview1.23160.1
Text.Analyzers | 3.3.4-beta1.23160.1


[//]: # ( Runtime 7.0.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86fd4795-bfa3-41b7-91ff-7b0baadc9d2d/66df53b623f0c9524359c9f01dad110a/dotnet-runtime-7.0.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8fc09c26-b0b1-4f26-921b-c1378547768a/04088af0b59a80a1fe1d613751d0a2c8/dotnet-runtime-7.0.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d5dff2d-9dd0-436e-8a3a-faad2ffed615/a6e3bdc912a2820ae768fcde911a768f/dotnet-runtime-7.0.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/120f0ac7-5c99-4d91-816b-b189b0d305cf/525a76cb3ed256c762f33349e8d70956/dotnet-runtime-7.0.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcbcdd71-eec5-4f66-bd92-1e71fee8b246/738e49c09dddafd29de10d417ed90367/dotnet-runtime-7.0.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e577f9c3-cf57-4f3c-aa2f-2c0c9ce7b9c2/16911adb0b0ac64ece205a8cf96a061d/dotnet-runtime-7.0.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/80126e7f-027c-4d19-bf5c-a15197d1e9f6/94d520fd53fa8124140a3b51da11b773/dotnet-runtime-7.0.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5a4664cc-7009-4b8a-9e6f-e3ae0b2218d0/add2992c737ce7bb70298fc030c84ead/dotnet-runtime-7.0.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c490efa8-9487-4bd9-ba04-27422baf62bc/ee551784913646cea981e7671a480b3d/dotnet-runtime-7.0.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4242cbd-90b1-4fc0-a8a2-44cd251450aa/3d811a2e1d73cf59d077a63099cb8189/dotnet-runtime-7.0.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/dbaaf99f-a5af-4048-b3fb-1dc1b004e863/ab83f0bbd9a05f27ed500f280e5bfa9d/dotnet-runtime-7.0.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7b11a2e-384a-4880-b3d8-6b9ec86652e5/9d9474a5ae2dcb02ed568a6a6f64ea54/dotnet-runtime-7.0.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b99bbc8-917a-417c-907b-d408341726a5/78b225344fbb9b80d3da3681e1d20d68/dotnet-runtime-7.0.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6cc30660-3d0b-48f2-8fbe-4a0301c46363/0776581a6c71da0f01290f08c9493581/dotnet-runtime-7.0.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/da45af44-e437-41b5-a5de-be6698557272/e4aaf2eafc2e983c275189f4a4161bae/dotnet-runtime-7.0.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6e7f1147-5c09-4fec-991a-6339caf75c0f/06fc478af9a150bdcf4a3e9254b87e0c/dotnet-runtime-7.0.5-win-x86.zip

[//]: # ( WindowsDesktop 7.0.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b902dfd-2320-48ae-9d83-4120f7b0955d/e892bacdf6629da532f7604555afd07c/windowsdesktop-runtime-7.0.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6a5134e4-123c-4102-ae4e-1cf056187a5c/853709934574ebcd659e4e227dd39b5e/windowsdesktop-runtime-7.0.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dffb1939-cef1-4db3-a579-5475a3061cdd/578b208733c914c7b7357f6baa4ecfd6/windowsdesktop-runtime-7.0.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bcbbbce9-e9b2-435f-b835-49c3152d786b/593fc9da1ddb494b72a7f0f05be6fe43/windowsdesktop-runtime-7.0.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/eb64dcd1-d277-4798-ada1-600805c9e2dc/fc73c843d66f3996e7ef22468f4902e6/windowsdesktop-runtime-7.0.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/99652d52-96d1-42d7-b38f-b93ccfa8f833/cf2eef3fc49611b3326278a0a3a3b7c7/windowsdesktop-runtime-7.0.5-win-x86.zip

[//]: # ( ASP 7.0.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7cd10989-16bd-4d51-8cc9-333a201086e6/d0e049f1f97918fd1aea856b57006abd/aspnetcore-runtime-7.0.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/565ed9fc-5ae5-4168-b08c-f4e39acf47ff/f5e3c6cc872681c08ab9aa6deb8a72c2/aspnetcore-runtime-7.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab6b4ea9-2f89-4123-af64-c1dea7efc40c/d2c835806fdf58de55f209d6276fded8/aspnetcore-runtime-7.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/032bc6f8-f157-4a2d-b9dd-4f859a32afdf/9f0acd1435053563ff80ee4c59b74df9/aspnetcore-runtime-7.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4486f7a2-8bd1-4329-a18e-0269de558076/9a5fee54d132251a48b8da07642ce954/aspnetcore-runtime-7.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b936641a-57d6-4069-bd32-280020863326/5793e00ff9e9973a01ca735479ff15b3/aspnetcore-runtime-7.0.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfb4f870-e416-459f-bdf5-5362030c6d5f/fb888174a31cea86516a95f60ca8e65c/aspnetcore-runtime-7.0.5-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b707a1b6-7222-4929-96b6-3525f93cd79e/dfa98874e490e3da4024cd20baca4a22/aspnetcore-runtime-7.0.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a2c88dc8-55d4-4e99-a74a-c08e718fa77b/778dacf7446e8537accc1b47bec8fca3/aspnetcore-runtime-7.0.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/02d08d3a-c846-40a9-a75d-4dcfa12b2d8d/c9d48b7ce67ad4e1356d9f3630f51cf4/aspnetcore-runtime-7.0.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/82e7d963-e5b6-41fe-84d1-a8c3f1a75bd7/fe22d4a60c66449d3e97a246fc41d10b/aspnetcore-runtime-7.0.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/423272b5-615c-436b-a198-a10518b3e8a3/e7587e2c70e4db7f9c93d0e6dbbc21f5/aspnetcore-runtime-7.0.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e5cb9bbc-6c3d-4ca2-b57e-47de252e7861/209669f62b361008007f66fffa6af38e/aspnetcore-runtime-7.0.5-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/19927e80-7df2-4906-badd-439502008177/cb55d49c06a3691965b4bcf934ead822/dotnet-hosting-7.0.5-win.exe

[//]: # ( SDK 7.0.203)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/55972ef4-146e-47e6-b014-0163cbaca6a3/fa9713f73f44088898843016d68c5929/dotnet-sdk-7.0.203-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6cd2eaa7-4c06-4168-b90b-ee2d6bb40b10/4a8387eb07e17d262bfb9965f6d34462/dotnet-sdk-7.0.203-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/18b88ba4-38db-4271-b4dc-5e93ba34124d/02462f7d9c477154d962b8323155aef9/dotnet-sdk-7.0.203-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0417714b-65c8-4fc0-a63c-bdd6e0fafaea/ec6c8cfb236aa61c8f3fae9721481a20/dotnet-sdk-7.0.203-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb8f282d-41eb-4926-87b8-78bff54bd0c5/c2cf161fe014133a5d177beb035e3b99/dotnet-sdk-7.0.203-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ebfd0bf8-79bd-480a-9e81-0b217463738d/9adc6bf0614ce02670101e278a2d8555/dotnet-sdk-7.0.203-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a5070179-d53b-4a84-98d6-37a9d3ef458b/f8bba83817d23e3b7726746c59de4e0c/dotnet-sdk-7.0.203-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad0ad533-6970-4099-a0c6-ee1d089a381d/2d7ea966c6d032111389b7686ccc0d9a/dotnet-sdk-7.0.203-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/08b3b509-05e6-4df1-84e1-a76c8855d899/d9b9a2d8ef9788f345d97304ceb67b07/dotnet-sdk-7.0.203-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de3e24bd-f677-4d9e-9717-859ce6659b5d/80c21bb06ca64d9408d11a32f858c7c6/dotnet-sdk-7.0.203-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/99681982-34f1-447c-996f-e2deeaccc2b0/097021e4edee399854ad3bb1032db86d/dotnet-sdk-7.0.203-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/61fefa17-6507-4f53-b5d7-e4851942e03b/248af1a9204b19761dfa6a8f7f7340c8/dotnet-sdk-7.0.203-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/89a2923a-18df-4dce-b069-51e687b04a53/9db4348b561703e622de7f03b1f11e93/dotnet-sdk-7.0.203-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a3b948f2-2335-4c9e-88e6-75794a2824c0/7807d990e142c3a4d8da7d426b5f18a2/dotnet-sdk-7.0.203-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/60253bf7-2405-4ee4-84ea-0a5fc9764f13/f5bd3e91214abfbb89e0f522e92aca70/dotnet-sdk-7.0.203-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1761b80c-fb67-4f49-8a40-4967722357e0/a06736ca9ed2df7401ecfecfdfc2c625/dotnet-sdk-7.0.203-win-x86.zip
