# .NET 7.0.7  - June 13, 2023

The .NET 7.0.7 and .NET SDK 7.0.304 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.304
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.7 release carries security fixes.

[CVE-2023-24895 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24895)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in how WPF for .NET handles certain XAML Frame elements which may result in remote code execution.

[CVE-2023-24897 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24897)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in how .NET reads debugging symbols, where reading a malicious symbols file may result in remote code execution.

[CVE-2023-24936 - .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-24936)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when deserializing a DataSet or DataTable from XML which may result in elevation of privileges.

[CVE-2023-29331 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-29331)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when processing X.509 certificates that may result in Denial of Service.

[CVE-2023-29337 -  NuGet Client Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-29337)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET and NuGet on Linux. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in nuget where a potential race condition that can lead to a symlink attack

[CVE-2023-32032 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-32032)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET using extracting the contents of a Tar file which may result in elevation of privileges.

[CVE-2023-33126 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33126)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET during crash and stack trace scenarios that could lead to loading arbitrary binaries.

[CVE-2023-33128 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33128)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET source generator for P/Invokes that can lead to generated code freeing uninitialized memory and crashing.

[CVE-2023-33135 -  .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-33135)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in the .NET SDK during tool restore which can lead to an elevation of privilege.

### Additional fixes in this release

* [ASPNET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A7.0.7+is%3Aclosed+label%3Aservicing-approved+)
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A7.0.7+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A7.0.7+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A7.0.7+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8539](https://github.com/dotnet/core/issues/8539) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.7-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.7+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.7+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.7+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.7+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.7+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.7+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.7
Microsoft.WindowsDesktop.App.Ref | 7.0.7
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.7
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.7
Microsoft.Extensions.Logging.Abstractions | 7.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.7
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.7
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.7
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.7
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.7
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.7
Microsoft.NETCore.App.Host.linux-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm | 7.0.7
Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.7
Microsoft.DotNet.ILCompiler | 7.0.7
Microsoft.Extensions.Hosting.WindowsServices | 7.0.1
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.7
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.7
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.7
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.7
Microsoft.NETCore.Platforms | 7.0.3
Microsoft.Windows.Compatibility | 7.0.3
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
System.Text.Json | 7.0.3
Microsoft.NETCore.App.Composite | 7.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.7
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.7
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.7
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.7
Microsoft.NETCore.App.Host.win-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.7
Microsoft.NETCore.App.Host.win-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.7
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.7
System.Management | 7.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.7
Microsoft.NETCore.DotNetHostPolicy | 7.0.7
Microsoft.NETCore.DotNetAppHost | 7.0.7
Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
System.Security.Cryptography.Pkcs | 7.0.2
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.7
Microsoft.NETCore.App.Host.osx-x64 | 7.0.7
Microsoft.NETCore.App.Host.win-arm | 7.0.7
Microsoft.NETCore.App.Ref | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.7
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.7
System.DirectoryServices.Protocols | 7.0.1
System.Reflection.Metadata | 7.0.2
System.ServiceProcess.ServiceController | 7.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.7
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.7
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.7
Microsoft.NETCore.App.Host.linux-arm | 7.0.7
Microsoft.NETCore.App.Host.win-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.7
dotnet-sql-cache | 7.0.7
Microsoft.AspNetCore.Authorization | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.7
AspNetCoreRuntime.7.0.x86 | 7.0.7
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.7
Microsoft.AspNetCore.Authentication.Certificate | 7.0.7
Microsoft.AspNetCore.Components.Authorization | 7.0.7
Microsoft.AspNetCore.Components.Analyzers | 7.0.7
Microsoft.AspNetCore.Components.CustomElements | 7.0.7
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.7
Microsoft.AspNetCore.Components.Forms | 7.0.7
Microsoft.AspNetCore.Components.Web | 7.0.7
Microsoft.AspNetCore.Components.WebAssembly | 7.0.7
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.7
Microsoft.AspNetCore.Components.WebView | 7.0.7
Microsoft.AspNetCore.Cryptography.Internal | 7.0.7
Microsoft.AspNetCore.DataProtection | 7.0.7
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.7
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.7
Microsoft.AspNetCore.Grpc.Swagger | 0.3.7
Microsoft.AspNetCore.Http.Connections.Client | 7.0.7
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.7
Microsoft.AspNetCore.Http.Connections.Common | 7.0.7
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.7
Microsoft.AspNetCore.Owin | 7.0.7
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.7
Microsoft.AspNetCore.SignalR.Common | 7.0.7
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.7
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.7
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.7
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.7
Microsoft.AspNetCore.SpaProxy | 7.0.7
Microsoft.dotnet-openapi | 7.0.7
Microsoft.AspNetCore.TestHost | 7.0.7
Microsoft.Extensions.ApiDescription.Server | 7.0.7
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.7
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.7
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.7
Microsoft.JSInterop.WebAssembly | 7.0.7
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.7
Microsoft.AspNetCore.Authentication.Google | 7.0.7
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.7
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.7
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.7
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.7
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.7
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.7
Microsoft.AspNetCore.Authentication.Twitter | 7.0.7
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.7
Microsoft.AspNetCore.Mvc.Testing | 7.0.7
Microsoft.AspNetCore.OpenApi | 7.0.7
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.7
Microsoft.AspNetCore.SignalR.Client | 7.0.7
Microsoft.Authentication.WebAssembly.Msal | 7.0.7
Microsoft.DotNet.Web.ItemTemplates7.0 | 7.0.7
Microsoft.DotNet.Web.Spa.ProjectTemplates7.0 | 7.0.7
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.7
Microsoft.Extensions.FileProviders.Embedded | 7.0.7
Microsoft.Extensions.Features | 7.0.7
Microsoft.Extensions.Localization | 7.0.7
Microsoft.Extensions.Identity.Stores | 7.0.7
Microsoft.JSInterop | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.7
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.7
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.7
AspNetCoreRuntime.7.0.x64 | 7.0.7
Microsoft.AspNetCore.App.Ref | 7.0.7
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.7
Microsoft.AspNetCore.Components | 7.0.7
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.7
Microsoft.AspNetCore.JsonPatch | 7.0.7
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.7
Microsoft.AspNetCore.Metadata | 7.0.7
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.7
Microsoft.Extensions.ApiDescription.Client | 7.0.7
Microsoft.DotNet.Web.ProjectTemplates7.0 | 7.0.7
Microsoft.Extensions.Caching.SqlServer | 7.0.7
Microsoft.Extensions.Identity.Core | 7.0.7
Microsoft.Extensions.Http.Polly | 7.0.7
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.7
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.7
Microsoft.AspNetCore.Authentication.Facebook | 7.0.7
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.7
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.7
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.7
Microsoft.AspNetCore.Connections.Abstractions | 7.0.7
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.7
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.7
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.7
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.7
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.7
Microsoft.AspNetCore.Identity.UI | 7.0.7
Microsoft.AspNetCore.HeaderPropagation | 7.0.7
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.7
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.7
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.7
Microsoft.Extensions.Localization.Abstractions | 7.0.7
Microsoft.Extensions.Logging.AzureAppServices | 7.0.7
Microsoft.Extensions.ObjectPool | 7.0.7
Microsoft.Extensions.WebEncoders | 7.0.7
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.7
FSharp.Core | 7.0.0
Microsoft.DotNet.Common.ItemTemplates | 7.0.107
Microsoft.DotNet.Common.ProjectTemplates | 7.0 | 7.0.107
Microsoft.DotNet.ApiCompat.Tool | 7.0.107
Microsoft.DotNet.ApiCompat.Task | 7.0.107
FSharp.Compiler.Service | 42.7.101
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.7
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.7
dotnet-ef | 7.0.7
Microsoft.EntityFrameworkCore.Cosmos | 7.0.7
Microsoft.EntityFrameworkCore | 7.0.7
Microsoft.EntityFrameworkCore.InMemory | 7.0.7
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.7
Microsoft.Data.Sqlite | 7.0.7
Microsoft.EntityFrameworkCore.Analyzers | 7.0.7
Microsoft.Data.Sqlite.Core | 7.0.7
Microsoft.EntityFrameworkCore.Abstractions | 7.0.7
Microsoft.EntityFrameworkCore.Proxies | 7.0.7
Microsoft.EntityFrameworkCore.Sqlite | 7.0.7
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.7
Microsoft.EntityFrameworkCore.Tools | 7.0.7
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.7
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.7
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.7
Microsoft.EntityFrameworkCore.Relational | 7.0.7
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.7
Microsoft.EntityFrameworkCore.SqlServer | 7.0.7
Microsoft.EntityFrameworkCore.Design | 7.0.7
Microsoft.EntityFrameworkCore.Templates | 7.0.7
Microsoft.TemplateEngine.IDE | 7.0.107
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.107
Microsoft.TemplateSearch.Common | 7.0.107
Microsoft.TemplateEngine.Core | 7.0.107
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.107
Microsoft.TemplateEngine.Abstractions | 7.0.107
Microsoft.TemplateEngine.Edge | 7.0.107
Microsoft.TemplateEngine.Core.Contracts | 7.0.107
Microsoft.TemplateEngine.Tasks | 7.0.107
Microsoft.TemplateEngine.Utils | 7.0.107
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.107
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.Common.ItemTemplates | 7.0.304
Microsoft.NET.Build.Containers | 7.0.304
Microsoft.DotNet.Common.ProjectTemplates | 7.0 | 7.0.304
Microsoft.DotNet.ApiCompat.Task | 7.0.304
FSharp.Core | 7.0.300
Microsoft.DotNet.ApiCompat.Tool | 7.0.304
Microsoft.TemplateSearch.Common | 7.0.304
Microsoft.TemplateEngine.Authoring.CLI | 7.0.304
Microsoft.TemplateEngine.Abstractions | 7.0.304
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.304
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.304
Microsoft.TemplateEngine.Edge | 7.0.304
Microsoft.TemplateEngine.Utils | 7.0.304
Microsoft.TemplateEngine.Core.Contracts | 7.0.304
Microsoft.TemplateEngine.Core | 7.0.304
Microsoft.TemplateEngine.IDE | 7.0.304
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.304
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.304
Microsoft.CodeAnalysis.Metrics | 3.3.4-beta1.23267.1
Microsoft.CodeAnalysis.NetAnalyzers | 7.0.3-preview1.23267.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.3.4-beta1.23267.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.3.4-beta1.23267.1
Text.Analyzers | 3.3.4-beta1.23267.1
Roslyn.Diagnostics.Analyzers | 3.3.4-beta1.23267.1
Microsoft.CodeAnalysis.Analyzers | 3.3.4-beta1.23267.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.3.4-beta1.23267.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.3.4-beta1.23267.1

[//]: # ( Runtime 7.0.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5040bb70-13f2-4868-a1e6-8e7f3c7a13dc/ac8503aef863040f8b78a9d67f5c8547/dotnet-runtime-7.0.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b3e2977-140b-48c1-9125-5a542db56d1d/3d3e5d2c24689b63486cf1c61a00b50c/dotnet-runtime-7.0.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e2e65ba-fea7-4706-9d0c-5e7b40ffc63d/7588f7920e03f696581116024864ffed/dotnet-runtime-7.0.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b32407b6-d31e-4f62-a7ed-a9db7bc034c1/ede358edccb7d6bb9fc3e44f9106e9cb/dotnet-runtime-7.0.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c63b9ffd-27f0-4f5f-8caa-6a9430b08ae3/891c43303b7c40d1088ebbbe201acbe1/dotnet-runtime-7.0.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/123d8ec6-beb4-4acf-8e9d-b54d2b99bb20/32f203246f4a87d70c339e8e06dc9c36/dotnet-runtime-7.0.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/704d2a8e-9fb9-450b-ae57-fa8b36751d8b/0e637cfd1404fa3cc914f0a4f81f585e/dotnet-runtime-7.0.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3e4e56c-8ee6-4aa3-a9a8-6ec7e6b161a3/7a2aa1a2c69ec5f96e7ed5430a1a8933/dotnet-runtime-7.0.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c74c2280-9b07-4c9e-a0cb-50d02b2cff86/5fde594ede7b2068711244e11de0e27a/dotnet-runtime-7.0.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b2d14614-44a5-42f6-92ed-4cb6579c66ee/0472b42d3551d3e673aeb86cba23b95f/dotnet-runtime-7.0.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1cc684ed-4330-4b30-b8cc-f41d7a9ee597/09931a7b5c71b06ee18070ebff0a1f7f/dotnet-runtime-7.0.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/87984fe5-7358-4b2f-b235-bfae64a4f6dd/3cfec77a96258be334045b25997f5fe7/dotnet-runtime-7.0.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ce1d21d9-d3fb-451f-84b1-95f365bcbc2c/23748d17eed2e1c63fdbb6b29d147c2d/dotnet-runtime-7.0.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2adf78f6-f400-4a6e-85c8-5fe82cce08db/2b50b93b1756d046077362c3b4ff9491/dotnet-runtime-7.0.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aea8eb78-3a87-44ff-8edd-d29a0a9bb1bd/e71b7e5d33ecec8e38392ac390c3ca02/dotnet-runtime-7.0.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ae83d804-f39b-4d8c-a787-0a5767e9a56b/d81a3817f03f2c257ed98d46393ee82b/dotnet-runtime-7.0.7-win-x86.zip

[//]: # ( WindowsDesktop 7.0.7)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/00f57df4-c604-46e1-8d32-f87a77f1d233/cd28e125d6f777c6d567a344da1fff2d/windowsdesktop-runtime-7.0.7-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e80c5eff-fd69-4b56-b5a3-9d1f5459bf8f/35bdf7d4d6b39f29e73f18897a80408e/windowsdesktop-runtime-7.0.7-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/342ba160-3776-4ffa-91dd-e3cd9dc0f817/ba649d6b80b27ca164d80bd488cdb51f/windowsdesktop-runtime-7.0.7-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4cb84ade-4dcd-4f9c-b42c-6f0b2a7f3ebc/6adb5d8f5368706d37af355f3172c993/windowsdesktop-runtime-7.0.7-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8a184836-3d12-41c7-b509-7d0d8d63dbf8/5d3bb50e730873808363dea2e9b8a2fd/windowsdesktop-runtime-7.0.7-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2780f5b7-beac-468e-a812-b7a61fd67899/118ef1f7921972b4e6f07a2eeb660b1b/windowsdesktop-runtime-7.0.7-win-x86.zip

[//]: # ( ASP 7.0.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c969e62-1c70-4f1a-9023-248f07acde46/d1597f232eb34295c649beb7fc37ffff/aspnetcore-runtime-7.0.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/803c679c-de71-466c-8ada-81139a7c55eb/03af937e87cd7220cf22681420ce0595/aspnetcore-runtime-7.0.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/708024d9-9eff-47e3-9508-9f55af7a5d11/448ebfae030f1f8439736ec46d76b5d6/aspnetcore-runtime-7.0.7-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b97fe6b7-af29-47ed-b762-60e4a97768c0/a4fdcb64a349f8d53d28546a512fdc8a/aspnetcore-runtime-7.0.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e6549ec2-c19e-429d-a0c3-7450b6f793ed/160d3023bf375e651758d6133ce63c4f/aspnetcore-runtime-7.0.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1e2729e-ab96-4929-911d-bf0f24f06f47/1b2f39cbc4eb530e39cfe6f54ce78e45/aspnetcore-runtime-7.0.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97bb1f46-3b87-4475-bc06-e5cb7f4e6d0a/3e36e0c804c5805d2fe856505d7b1b3c/aspnetcore-runtime-7.0.7-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e052c143-c16d-45bd-a9ab-af85c66177c8/d8bde85b6f127ce794274c1bc111034b/aspnetcore-runtime-7.0.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f6998f6-267a-4719-9f98-030618af66bf/f34059f5e327ee17e0522c59f6d831c7/aspnetcore-runtime-7.0.7-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/754ad45c-5713-4bf7-8182-e82291e12d2f/4fbc681a6d28c7895b46940ebe573ae3/aspnetcore-runtime-7.0.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aa2dfb23-d4ac-48d0-bd3a-aac4ae2cbbe0/b8b58fcb4ee703610179c1710c4e36d7/aspnetcore-runtime-7.0.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/17ed245a-044a-4740-b307-40fa48670d76/d7325bb13405d1dfcc8a0f1bff2c390b/aspnetcore-runtime-7.0.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/aa96766a-1b62-49e7-8ca7-ff0443873078/4ae7de0ff00d997f3f7260f2054516e2/aspnetcore-runtime-7.0.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d5d8a7b5-a190-4237-8cc0-6b72d6dd3022/2644b9b70ba39b60e35f6d483d1c9c47/dotnet-hosting-7.0.7-win.exe

[//]: # ( SDK 7.0.304)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f9c4db4-4619-4ebb-8b85-aa90a5ec71bb/9e7a5b3b6c27600c8c2dec7b6b3bd06b/dotnet-sdk-7.0.304-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d36e684-4405-4e54-a6df-7f342ceda377/956ae226bcf74d038845964e88c6904b/dotnet-sdk-7.0.304-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8436a209-a0a9-4b4f-a0f4-4e5067ebccac/cb151c9e1d9424991689b73890057ce1/dotnet-sdk-7.0.304-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25677876-8587-46b1-bc2d-bd5a5d102b8c/41fe56b44a6d1a5000306aad4640869f/dotnet-sdk-7.0.304-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f01087d1-871f-4608-b2ba-6e44c2061a9c/f8732be2e88e56dded2c1d31db88498a/dotnet-sdk-7.0.304-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c86d7b4-acb2-4be4-8a89-d13bc3c3f28f/1d044c7c29df018e8f2837bb343e8a84/dotnet-sdk-7.0.304-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/53f2dc54-c56d-4bc2-b7ac-4705565f1f58/ce10a5e5e5ed4acf1ea3caf443ecbd2e/dotnet-sdk-7.0.304-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7a10ece-45cd-483f-be8d-15a10b2d0c51/1ded758a3b6140c435e283b0d0ace182/dotnet-sdk-7.0.304-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6e4a2a04-483d-42d4-8cbd-27257c47a8bf/52917aad4fb720797c351e38fb706531/dotnet-sdk-7.0.304-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/18e7fd79-48de-4ad9-a7a5-a659a485e3d7/fc0d190f90917587626fc8086ad6d2f2/dotnet-sdk-7.0.304-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bdc383f7-1109-413a-8e5d-b0e7eccd3a32/afe0e0ce771457bf391a9dc815b9966e/dotnet-sdk-7.0.304-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2072c912-78cb-4022-9132-3835f1ea9b89/8996d3c445abd35cda5af470171f6fe7/dotnet-sdk-7.0.304-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2ab1aa68-3e14-401a-b106-833d66fa992b/060457e640f4095acf4723c4593314b6/dotnet-sdk-7.0.304-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8f08bebf-8851-4cb3-9a16-7e800004867a/38369e796f1c61272732532e5b7c4fc3/dotnet-sdk-7.0.304-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4bce9ba3-a258-4ab9-a2c1-549792d83969/32f53854cc1e36d4a8aeadbfd5336b9a/dotnet-sdk-7.0.304-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/474860d6-8867-460c-b671-30e28d2402b2/9fd985acc79f1deda7d5ac6d8c4686c2/dotnet-sdk-7.0.304-win-x86.zip
