# .NET 7.0.8  - June 22, 2023

The .NET 7.0.8 and .NET SDK 7.0.305 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.305
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.8 release carries non-security fixes.

## .NET June OOB Updates

### Background
The NET 6.0.18 and 7.0.7 updates update added constraints to PFX certificate loading to fix a DoS vulnerability (CVE-2023-29331). We created a specific exception message with an FWlink to a known issue KB https://support.microsoft.com/kb/5025823 to describe these behavioral changes.

Some customer reports during the week of June 13, 2023, reveal that .NET 6.0.18 and 7.0.7 may fail to import PKCS12 blobs whose private keys are protected by a null password. Callers may non-deterministically observe a `CryptographicException` being thrown by the `X509Certificate` constructor on those runtimes. This regression was unintentional and a fix is being offered for affected applications.

## Visual Studio Compatibility

You need [Visual Studio 17.4](https://visualstudio.microsoft.com) or later to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8570](https://github.com/dotnet/core/issues/8570) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.8.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.8-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2023-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.8+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.8+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.8+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.8+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0.8+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0.8+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 7.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 7.0.8
Microsoft.WindowsDesktop.App.Ref | 7.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 7.0.8
Microsoft.DotNet.ILCompiler | 7.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 7.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Composite | 7.0.8
Microsoft.NETCore.App.Host.win-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 7.0.8
Microsoft.NETCore.App.Host.win-x86 | 7.0.8
Microsoft.NETCore.App.Ref | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-arm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm | 7.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 7.0.8
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 7.0.8
Microsoft.Windows.Compatibility | 7.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 7.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk | 7.0.8
Microsoft.NETCore.App.Host.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm | 7.0.8
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 7.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.win-x64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHost | 7.0.8
Microsoft.NET.Runtime.Android.Sample.Mono | 7.0.8
Microsoft.NET.Runtime.iOS.Sample.Mono | 7.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 7.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x64 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.arm64 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.arm64 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm64 | 7.0.8
Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 7.0.8
System.Security.Cryptography.Pkcs | 7.0.3
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Templates | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-7.0.100.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 7.0.8
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 7.0.8
Microsoft.NETCore.App.Host.linux-bionic-x64 | 7.0.8
Microsoft.NETCore.App.Host.linux-musl-arm | 7.0.8
Microsoft.NETCore.App.Host.linux-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64 | 7.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 7.0.8
Microsoft.NETCore.DotNetAppHost | 7.0.8
Microsoft.NETCore.DotNetHost | 7.0.8
Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 7.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-7.0.100.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Crossgen2.win-x64 | 7.0.8
Microsoft.NETCore.App.Host.linux-musl-arm64 | 7.0.8
Microsoft.NETCore.App.Host.osx-arm64 | 7.0.8
Microsoft.NETCore.App.Host.win-arm64 | 7.0.8
Microsoft.NETCore.App.Host.win-arm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.linux-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.osx-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 7.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 7.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
Microsoft.NET.Runtime.wasm.Sample.Mono | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm | 7.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.win-arm64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.win-x86 | 7.0.8
Microsoft.NETCore.App.Crossgen2.linux-x64 | 7.0.8
Microsoft.NETCore.App.Crossgen2.win-arm | 7.0.8
Microsoft.NETCore.App.Host.linux-arm | 7.0.8
Microsoft.NETCore.App.Host.linux-musl-x64 | 7.0.8
Microsoft.NETCore.App.Host.osx-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 7.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 7.0.8
Microsoft.NETCore.App.Runtime.Mono.perftrace.browser-wasm.Msi.x64 | 7.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 7.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 7.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 7.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 7.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 7.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 7.0.8
AspNetCoreRuntime.7.0.x64 | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 7.0.8
AspNetCoreRuntime.7.0.x86 | 7.0.8
Microsoft.AspNetCore.App.Runtime.win-arm64 | 7.0.8
Microsoft.AspNetCore.Authorization | 7.0.8
Microsoft.AspNetCore.AzureAppServicesIntegration | 7.0.8
Microsoft.AspNetCore.Components.WebView | 7.0.8
Microsoft.dotnet-openapi | 7.0.8
Microsoft.DotNet.Web.ItemTemplates.7.0 | 7.0.8
Microsoft.DotNet.Web.Spa.ProjectTemplates.7.0 | 7.0.8
Microsoft.Extensions.Configuration.KeyPerFile | 7.0.8
Microsoft.Extensions.Caching.SqlServer | 7.0.8
Microsoft.Extensions.Diagnostics.HealthChecks | 7.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 7.0.8
Microsoft.Extensions.Caching.StackExchangeRedis | 7.0.8
Microsoft.Extensions.Features | 7.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 7.0.8
Microsoft.Extensions.FileProviders.Embedded | 7.0.8
Microsoft.Extensions.Identity.Core | 7.0.8
Microsoft.Extensions.Identity.Stores | 7.0.8
Microsoft.Extensions.Http.Polly | 7.0.8
Microsoft.Extensions.Localization | 7.0.8
Microsoft.Extensions.Logging.AzureAppServices | 7.0.8
Microsoft.Extensions.Localization.Abstractions | 7.0.8
Microsoft.Extensions.WebEncoders | 7.0.8
Microsoft.Extensions.ObjectPool | 7.0.8
Microsoft.JSInterop | 7.0.8
dotnet-sql-cache | 7.0.8
Microsoft.AspNetCore.Authentication.Certificate | 7.0.8
Microsoft.AspNetCore.Authentication.Facebook | 7.0.8
Microsoft.AspNetCore.Authentication.JwtBearer | 7.0.8
Microsoft.AspNetCore.Authentication.Google | 7.0.8
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 7.0.8
Microsoft.AspNetCore.Authentication.Negotiate | 7.0.8
Microsoft.AspNetCore.Authentication.OpenIdConnect | 7.0.8
Microsoft.AspNetCore.Authentication.Twitter | 7.0.8
Microsoft.AspNetCore.Authentication.WsFederation | 7.0.8
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 7.0.8
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 7.0.8
Microsoft.AspNetCore.Components.Authorization | 7.0.8
Microsoft.AspNetCore.Components | 7.0.8
Microsoft.AspNetCore.Components.Forms | 7.0.8
Microsoft.AspNetCore.Components.Web | 7.0.8
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 7.0.8
Microsoft.AspNetCore.Grpc.Swagger | 0.3.8
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 7.0.8
Microsoft.AspNetCore.Http.Connections.Client | 7.0.8
Microsoft.AspNetCore.HeaderPropagation | 7.0.8
Microsoft.AspNetCore.Identity.UI | 7.0.8
Microsoft.AspNetCore.Hosting.WindowsServices | 7.0.8
Microsoft.AspNetCore.MiddlewareAnalysis | 7.0.8
Microsoft.AspNetCore.Metadata | 7.0.8
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 7.0.8
Microsoft.AspNetCore.Mvc.Testing | 7.0.8
Microsoft.AspNetCore.Owin | 7.0.8
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 7.0.8
Microsoft.AspNetCore.OpenApi | 7.0.8
Microsoft.AspNetCore.SignalR.Client.Core | 7.0.8
Microsoft.AspNetCore.SignalR.Client | 7.0.8
Microsoft.AspNetCore.SignalR.Common | 7.0.8
Microsoft.AspNetCore.SignalR.Specification.Tests | 7.0.8
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 7.0.8
Microsoft.AspNetCore.SignalR.Protocols.Json | 7.0.8
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 7.0.8
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 7.0.8
Microsoft.AspNetCore.SpaServices.Extensions | 7.0.8
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 7.0.8
Microsoft.AspNetCore.App.Runtime.win-arm | 7.0.8
Microsoft.AspNetCore.App.Runtime.win-x86 | 7.0.8
Microsoft.AspNetCore.App.Ref | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 7.0.8
Microsoft.AspNetCore.Components.CustomElements | 7.0.8
Microsoft.AspNetCore.Components.WebAssembly.Server | 7.0.8
Microsoft.AspNetCore.Components.Analyzers | 7.0.8
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 7.0.8
Microsoft.AspNetCore.Components.WebAssembly | 7.0.8
Microsoft.AspNetCore.ConcurrencyLimiter | 7.0.8
Microsoft.AspNetCore.DataProtection | 7.0.8
Microsoft.AspNetCore.Connections.Abstractions | 7.0.8
Microsoft.AspNetCore.Cryptography.Internal | 7.0.8
Microsoft.AspNetCore.Cryptography.KeyDerivation | 7.0.8
Microsoft.AspNetCore.DataProtection.Extensions | 7.0.8
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 7.0.8
Microsoft.AspNetCore.DataProtection.Abstractions | 7.0.8
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 7.0.8
Microsoft.AspNetCore.Grpc.JsonTranscoding | 7.0.8
Microsoft.AspNetCore.TestHost | 7.0.8
Microsoft.AspNetCore.SpaProxy | 7.0.8
Microsoft.Extensions.ApiDescription.Server | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 7.0.8
Microsoft.AspNetCore.App.Runtime.osx-x64 | 7.0.8
Microsoft.AspNetCore.App.Runtime.linux-x64 | 7.0.8
Microsoft.AspNetCore.Http.Connections.Common | 7.0.8
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 7.0.8
Microsoft.AspNetCore.JsonPatch | 7.0.8
Microsoft.Authentication.WebAssembly.Msal | 7.0.8
Microsoft.Extensions.ApiDescription.Client | 7.0.8
Microsoft.DotNet.Web.Client.ItemTemplates | 7.0.8
Microsoft.DotNet.Web.ProjectTemplates.7.0 | 7.0.8
Microsoft.JSInterop.WebAssembly | 7.0.8
Microsoft.AspNetCore.App.Runtime.win-x64 | 7.0.8
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 7.0.8
FSharp.Core | 7.0.0
Microsoft.DotNet.ApiCompat.Task | 7.0.108
Microsoft.DotNet.ApiCompat.Tool | 7.0.108
Microsoft.DotNet.Common.ItemTemplates | 7.0.108
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.108
FSharp.Compiler.Service | 42.7.101
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.linux-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.osx-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64 | 7.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100 | 7.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x64 | 7.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.linux-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.osx-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64.Msi.arm64 | 7.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x86 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.osx-x64 | 7.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.linux-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.win-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Cache.win-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Sdk.osx-x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Node.win-x64.Msi.x64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.arm64 | 7.0.8
Microsoft.NET.Runtime.Emscripten.3.1.12.Python.win-x64.Msi.x64 | 7.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-7.0.100.Msi.x86 | 7.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100 | 7.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-7.0.100.Msi.x64 | 7.0.8
dotnet-ef | 7.0.8
Microsoft.EntityFrameworkCore | 7.0.8
Microsoft.Data.Sqlite.Core | 7.0.8
Microsoft.EntityFrameworkCore.Abstractions | 7.0.8
Microsoft.Data.Sqlite | 7.0.8
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 7.0.8
Microsoft.EntityFrameworkCore.Analyzers | 7.0.8
Microsoft.EntityFrameworkCore.Cosmos | 7.0.8
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 7.0.8
Microsoft.EntityFrameworkCore.Templates | 7.0.8
Microsoft.EntityFrameworkCore.InMemory | 7.0.8
Microsoft.EntityFrameworkCore.Specification.Tests | 7.0.8
Microsoft.EntityFrameworkCore.Relational | 7.0.8
Microsoft.EntityFrameworkCore.Proxies | 7.0.8
Microsoft.EntityFrameworkCore.SqlServer | 7.0.8
Microsoft.EntityFrameworkCore.Sqlite.Core | 7.0.8
Microsoft.EntityFrameworkCore.Sqlite | 7.0.8
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 7.0.8
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 7.0.8
Microsoft.EntityFrameworkCore.Tools | 7.0.8
Microsoft.EntityFrameworkCore.Design | 7.0.8
Microsoft.TemplateEngine.Core.Contracts | 7.0.108
Microsoft.TemplateEngine.Tasks | 7.0.108
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.108
Microsoft.TemplateEngine.IDE | 7.0.108
Microsoft.TemplateEngine.TemplateLocalizer | 7.0.108
Microsoft.TemplateEngine.Abstractions | 7.0.108
Microsoft.TemplateEngine.Core | 7.0.108
Microsoft.TemplateEngine.Edge | 7.0.108
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.108
Microsoft.TemplateEngine.Utils | 7.0.108
Microsoft.TemplateSearch.Common | 7.0.108
Microsoft.DotNet.Common.ItemTemplates | 7.0.305
FSharp.Compiler.Service | 43.7.300
Microsoft.DotNet.ApiCompat.Task | 7.0.305
Microsoft.NET.Build.Containers | 7.0.305
FSharp.Core | 7.0.300
Microsoft.DotNet.ApiCompat.Tool | 7.0.305
Microsoft.DotNet.Common.ProjectTemplates.7.0 | 7.0.305
Microsoft.TemplateEngine.Authoring.Tasks | 7.0.305
Microsoft.TemplateEngine.Core | 7.0.305
Microsoft.TemplateEngine.Core.Contracts | 7.0.305
Microsoft.TemplateEngine.Authoring.CLI | 7.0.305
Microsoft.TemplateEngine.TemplateLocalizer.Core | 7.0.305
Microsoft.TemplateEngine.Utils | 7.0.305
Microsoft.TemplateEngine.Abstractions | 7.0.305
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 7.0.305
Microsoft.TemplateEngine.Edge | 7.0.305
Microsoft.TemplateEngine.IDE | 7.0.305
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 7.0.305
Microsoft.TemplateSearch.Common | 7.0.305

[//]: # ( Runtime 7.0.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac881f3f-e08f-4823-aa9f-abba96b16072/e6954a5122ff2c70acc3d3aa4c4aa1ce/dotnet-runtime-7.0.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc0cbb05-48d1-4f9d-aa78-8f2bf6423f1b/f06a3e717b95abf8ca5f40504cd63dee/dotnet-runtime-7.0.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b3e121a-0c80-4726-b802-c19bc5a4cce4/01a0b03b1b485c13f6e9e48f2a54285c/dotnet-runtime-7.0.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33ea96c9-cf3c-4591-a41b-59e0bc888934/3ed2b1f1edd24f1755e19f35d798a18a/dotnet-runtime-7.0.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6e417176-4f89-42ed-9afb-a872a7806788/e00e591d2e60d0f06a5dc88236d16433/dotnet-runtime-7.0.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9514df2-f03a-45a3-9a6d-65b2260accd1/0f59516ed5bc603ee95ae91301090ebb/dotnet-runtime-7.0.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/92c6b5dd-f636-48ad-9692-fdb6e3b2a80c/ab14c80606b82d1653d66e9ee348fcea/dotnet-runtime-7.0.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11db4f76-fbe9-4692-ba1e-9edd2b5e0eb4/9204a2e30c58c8a01a8a6f7185e6175e/dotnet-runtime-7.0.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/606e72c5-ed7d-4120-b73b-699fe486dbdd/49e7883608e7f9ef6263489baca0b0a5/dotnet-runtime-7.0.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b7cd80a-49dc-4364-a4e8-a760219548aa/6ba0a83c6da3897dab16ba709acfcc9e/dotnet-runtime-7.0.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ffb7819d-9d40-4157-baf8-a1e0bc262e94/d55c37a3ae850592c5c3395eefaf8919/dotnet-runtime-7.0.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a8bd3498-b72a-4cf2-9d01-9f98bbded2cf/54c579ada4856572631d3e6022518359/dotnet-runtime-7.0.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ea347520-6aab-4b2f-9cf4-e24209d3e83c/c41fcd4e47d16f1ddf065ce32b0452c1/dotnet-runtime-7.0.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6bbc0663-ab26-4ecb-aeae-361c90d9ab1a/de8cabb52fc9213a99fff9ad443139b3/dotnet-runtime-7.0.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c5cd3312-a224-4de7-83b2-f46f77e9f91a/6e53825dbaa1b53f085404e5b2216d7d/dotnet-runtime-7.0.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0b0c4f01-5fa8-436f-9750-6064d35b7b61/71d17701c99e61be1587b0a416ca0ca0/dotnet-runtime-7.0.8-win-x86.zip

[//]: # ( WindowsDesktop 7.0.8)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6e2bfdba-a6c6-4c91-b200-036cbec361a5/a1a0933659556145d8b9ab3e8808f50c/windowsdesktop-runtime-7.0.8-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/57aa83db-e47c-49ea-b676-2890f95076c1/73f34bd09bbd640c88b910cd3d69d18f/windowsdesktop-runtime-7.0.8-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/53868e57-c621-476a-885b-dea78ac6edba/f1d5957ba91bde28370f0e782b3d6177/windowsdesktop-runtime-7.0.8-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/58e8c7ad-8565-47f4-bc2f-e83a01247904/1ff5397aa4e25d08f900910f63077d12/windowsdesktop-runtime-7.0.8-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b59c30b1-05b8-46ef-9384-a94d58dc5016/8cb385cf8552abaa5876710c5c2f9492/windowsdesktop-runtime-7.0.8-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b63d5ed6-34c8-4fc3-890c-627edcf69811/fda531d6b0315e26121e71fe943af489/windowsdesktop-runtime-7.0.8-win-x86.zip

[//]: # ( ASP 7.0.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b61769fe-f75d-473e-af39-d0025b7f098d/b1291358344649ad7049e4c74afa2453/aspnetcore-runtime-7.0.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04dc0f8d-880d-4722-bd51-6669e6cd1e72/cd5689508f2da5395bc70473018ff165/aspnetcore-runtime-7.0.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2b92f62-26f5-46c8-aad4-fca34d25d853/934a4eb818ab9dc7269926b4126d098d/aspnetcore-runtime-7.0.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e3bfbdd3-548b-4464-a1fc-e3dba3d7f6d4/24dbb2a28fcbe4eda836f46459936972/aspnetcore-runtime-7.0.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0decbf4-dfb5-49fe-9442-027c3e497817/2a0c5360db49c1acf08013eedc61915e/aspnetcore-runtime-7.0.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f452e148-b4ef-4ca7-9d97-59b709c55221/852e848f9fbd345445a0de43efa4e7ec/aspnetcore-runtime-7.0.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/787adeb9-d6c1-4db3-8c72-63653dd939c4/a7aafd0908cf7866c6908a14a78ac994/aspnetcore-runtime-7.0.8-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/755a7169-d77c-42e1-a1a5-1eea4213675d/1375f947547134e9297aba032c3760b5/aspnetcore-runtime-7.0.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/09f02d66-b681-4345-8932-9d7f9a1ec099/1cc803cefeffa8002431e5e1b4d7428c/aspnetcore-runtime-7.0.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ddfe312d-511a-4e1c-bca2-59046d1ec73f/823812d3a1421aa967748da9ac26b4e5/aspnetcore-runtime-7.0.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5472c6ee-1586-4728-8551-8153075aa014/f2ba84f86e133f3d713d397a4083836e/aspnetcore-runtime-7.0.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6ad5ebde-12f9-46c3-89a2-189834ce3ac5/e90560462225d598a7de058c818750bb/aspnetcore-runtime-7.0.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/546a0cde-960f-47cd-87d2-b30e16edb1db/9377a6f26607f11c446602d39808615f/aspnetcore-runtime-7.0.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/68e88ddb-bf01-48fc-abd0-3e1503212deb/98d1e15dcccf7cd76915a1772c8e901e/dotnet-hosting-7.0.8-win.exe

[//]: # ( SDK 7.0.305)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fcb3bc80-9dce-4f84-a6f2-110051f8d812/921c7c5a3d0b46163e6ddeea7ff1786e/dotnet-sdk-7.0.305-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2ca71f5-17e9-4dbd-aaf4-1e0fa225a212/61c440dae017c7129de10cfbfe36fd90/dotnet-sdk-7.0.305-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e27d821e-ab90-4243-b381-fccbbb119c66/dc2a1cafdb22e2195aeed5529290e408/dotnet-sdk-7.0.305-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23d74615-72ce-4b57-a666-bafe978b2a7e/632e1b85ed80f8d5b8ab1c99b33f2e9c/dotnet-sdk-7.0.305-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6259a54d-a6f9-4644-85e0-ea92bed61b02/ffeccb14aa10ed74c573ad2af54ea945/dotnet-sdk-7.0.305-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87a55ae3-917d-449e-a4e8-776f82976e91/03380e598c326c2f9465d262c6a88c45/dotnet-sdk-7.0.305-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2dccbeef-704b-4bb9-984f-6d49ecef5e06/df1c7e68a77fc47ec0523942df43bbde/dotnet-sdk-7.0.305-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5514f57a-bdd3-4bf8-aeee-9469379dff7b/8b14cea61057408b04bef7cd94123e66/dotnet-sdk-7.0.305-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cc993071-2ecd-415b-a055-2918072bbfd4/545947633a386671807fc3f3db511295/dotnet-sdk-7.0.305-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42115a70-7082-41db-bffa-b54ba38d3a76/5dc32fb8dbd24f358947e96400792bca/dotnet-sdk-7.0.305-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c71220b5-f998-45c6-8e87-a48929ca493d/9da455e8afadac27cfc9278f712ff8f4/dotnet-sdk-7.0.305-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e513a57a-fbb4-4379-be3c-f141dd9f6162/9371977b18d48f439b2a36f249d4905d/dotnet-sdk-7.0.305-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4453ece-c90b-496a-b36b-600cec7d47d2/0f53119fe68f0ceef45e598b65c176f9/dotnet-sdk-7.0.305-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ca2298f8-7c39-4187-98e5-f1be30e5eee5/b76077aaf76b1751b77fd4574837a0ab/dotnet-sdk-7.0.305-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0f962678-6e50-4ba9-b203-9b83e7afd622/33ae6da78ef9c6210d8fac2c7845baa0/dotnet-sdk-7.0.305-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/126e946a-10cf-4e99-87a8-6a4f69831854/4d65c3bd0dccaa3f508396090cfeeafa/dotnet-sdk-7.0.305-win-x86.zip
