# .NET 7 CVEs

The .NET Team releases [monthly updates for .NET 7](https://github.com/dotnet/announcements/labels/.NET%207.0) on [Patch Tuesday](https://en.wikipedia.org/wiki/Patch_Tuesday). These updates often include security fixes. If you are on an older version, your app may be vulnerable.

Your app needs to be on the latest .NET 7 patch version to be secure. The longer you wait to upgrade, the greater the exposure to CVEs.

## Which CVEs apply to my app?

Your app may be vulnerable to the following published security [CVEs](https://www.cve.org/) if you are using the given version or older.

- 7.0.20 (May 28 2024)
   - No new CVEs.
- 7.0.19 (May 2024)
  - [CVE-2024-30045 | .NET Remote code Execution Vulnerability](https://github.com/dotnet/announcements/issues/307)
  - [CVE-2024-30046 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/308)
- 7.0.18 (April 2024)
  - [CVE-2024-21409 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/303)
- 7.0.17 (March 2024)
  - [CVE-2024-21392 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/299)
  - [CVE-2024-26190 | Microsoft QUIC Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/300)
- 7.0.16 (February 2024)
  - [CVE-2024-21386 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/295)
  - [CVE-2024-21404 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/296)
- 7.0.15 (January 2024)
  - [CVE-2024-0056 | .NET Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/292)
  - [CVE-2024-0057 | .NET Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/291)
  - [CVE-2024-21319 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/290)
- 7.0.14 (November 2023)
  - [CVE-2023-36049 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/287)
  - [CVE-2023-36558 | .NET Security Feature Bypass Vulnerability](https://github.com/dotnet/announcements/issues/288)
- 7.0.13 (October 2023)
  - [CVE-2023-36435 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/281)
  - [CVE-2023-38171 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/280)
  - [CVE-2023-44487 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/282)
  - [CVE-2023-36799 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/275)
  - [CVE-2023-36796 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/274)
  - [CVE-2023-36793 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/273)
  - [CVE-2023-36794 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/272)
  - [CVE-2023-36792 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/271)
- 7.0.12 (October 2023)
  - [CVE-2023-36435 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/281)
  - [CVE-2023-38171 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/280)
  - [CVE-2023-44487 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/277)
- 7.0.11 (September 2023)
  - [CVE-2023-36799 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/275)
  - [CVE-2023-36796 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/274)
  - [CVE-2023-36793 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/273)
  - [CVE-2023-36794 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/272)
  - [CVE-2023-36792 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/271)
- 7.0.10 (August 2023)
  - [CVE-2023-35390 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/266)
  - [CVE-2023-35391 | .NET Information Disclosure Vulnerability](https://github.com/dotnet/announcements/issues/267)
  - [CVE-2023-38178 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/268)
  - [CVE-2023-38180 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/269)
- 7.0.9 (July 2023)
  - [CVE-2023-33127 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/263)
  - [CVE-2023-33170 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/264)
- 7.0.8 (June 2023)
  - No new CVEs.
- 7.0.7 (June 2023)
  - [CVE-2023-24895 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/261)
  - [CVE-2023-24897 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/260)
  - [CVE-2023-24936 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/259)
  - [CVE-2023-29331 | .NET Denial of Service Vulnerability](https://github.com/dotnet/announcements/issues/257)
  - [CVE-2023-29337 | Nuget Client Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/256)
  - [CVE-2023-32032 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/255)
  - [CVE-2023-33126 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/254)
  - [CVE-2023-33128 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/253)
  - [CVE-2023-33135 | .NET Elevation of Privilege Vulnerability](https://github.com/dotnet/announcements/issues/252)
- 7.0.5 (April 2023)
  - [CVE-2023-28260 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/250)
- 7.0.4 (March 2023)
  - No new CVEs.
- 7.0.3 (February 2023)
  - [CVE-2023-21808 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/247)
- 7.0.2 (January 2023)
  - No new CVEs.
- 7.0.1 (December 2022)
  - [CVE-2022-41089 | .NET Remote Code Execution Vulnerability](https://github.com/dotnet/announcements/issues/242)
- 7.0.0 (November 2022)
  - No new CVEs.

The CVE exposure is cumulative. For example, `7.0.0` users may be vulnerable to the CVEs present in `7.0.0` and newer releases. Similarly, `7.0.3` users may be vulnerable to the CVEs present in `7.0.4` and newer releases. The latest release is not vulnerable to any published CVEs.
