# .NET 7.0.0 Preview 2 - March 15, 2022

The .NET 7.0.0 Preview 2 and .NET SDK 7.0.100-preview.2.22153.17 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 2

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 2 at [dotnet/core #7107](https://github.com/dotnet/core/issues/7107).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 2.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.2.22153.17
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.2 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7284](https://github.com/dotnet/core/issues/7284) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.2-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-preview-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-dotnet-7-preview-2
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx
[linux-packages]: ../install-linux.md



[//]: # ( Runtime 7.0.0-preview.2.22152.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d75f42ab-f32a-4c71-9198-bfeb5051fbd0/ff39bd32601fdb583a13a06e979f152b/dotnet-runtime-7.0.0-preview.2.22152.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5154f383-6a09-41b3-bfcc-5958562e2c4b/b0fea89768d540f83ff10b8c3a556cc1/dotnet-runtime-7.0.0-preview.2.22152.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/796d0f81-e071-4a1e-87c4-fe39a4a4aa6d/73bffc4f91e2c8e89e24aff1f8ea43f3/dotnet-runtime-7.0.0-preview.2.22152.2-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70e2d3e3-c5a2-4943-bd6d-0671a93e1871/22777c837aa91062b909d198226b3d5a/dotnet-runtime-7.0.0-preview.2.22152.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16edd568-b9a4-462c-9a5e-af010847c5c6/326f0f687857b536c3e2a45dbfd3617a/dotnet-runtime-7.0.0-preview.2.22152.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d310a601-7f68-412a-a139-b8d6a037c9fd/b00941dc09d85a51b198117d8efdba8a/dotnet-runtime-7.0.0-preview.2.22152.2-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/131656c4-1caf-4d50-abab-f2e297faa3c9/d0321edd361e67be278da7c3b7089430/dotnet-runtime-7.0.0-preview.2.22152.2-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac1eefa5-d5a8-425a-a394-c6e2bc564e43/2c8cd64c7167cd9b444df6112ea95a2d/dotnet-runtime-7.0.0-preview.2.22152.2-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9660c828-fb78-4fd7-85bc-3ab4e3dbb179/3c25335ff279f4e06c054e715b36f175/dotnet-runtime-7.0.0-preview.2.22152.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d1de2627-e6fc-4657-a614-59f87b3964e0/e04ea0fe25c1eb719cf1de4d6e7676f1/dotnet-runtime-7.0.0-preview.2.22152.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a138e0a5-a99b-490e-aa3b-e343c3f39e25/d868eae31c16dae1891a8780bf989bd1/dotnet-runtime-7.0.0-preview.2.22152.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/387cc604-3e60-4093-8ec7-097fc6ec83ea/c7e70f4ed32806a8f7acde94b9acc102/dotnet-runtime-7.0.0-preview.2.22152.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/76bb18a3-0fda-4a0d-9d2d-ce83667a2668/9534db4f3b885ef2ccdaa16d37cb3133/dotnet-runtime-7.0.0-preview.2.22152.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/27fa0e6a-b4d1-4023-8467-d1eda2f2f8f0/a0ff83fc152ac1ca4ec59292d32baa5a/dotnet-runtime-7.0.0-preview.2.22152.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/066b1423-93ca-49c1-8f23-8bfba3cf6e84/1b9584330bc342bec480156e17cd961e/dotnet-runtime-7.0.0-preview.2.22152.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f77a2a6e-4138-401d-ad1a-7f8cd8aa6c69/e0f5a9ccc9c225e481cb27cf155e3113/dotnet-runtime-7.0.0-preview.2.22152.2-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.2.22153.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6dbbbeeb-c11f-4f32-a165-0a73a17ae41e/f011743571c716a25911d62f21800650/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/33697e18-1793-448a-954d-ced3dde002bd/3eef88084b2e4c8f4247c51862f84361/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/15596c40-e6d3-4133-b04b-81fc9fbd532d/0bdd610ade324b0e67924169eeabded4/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6f1acefd-0fb3-409b-b4a9-c81fc92b24aa/12ed761f2257431b9b573bf3819d8d16/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0059c92c-a180-42aa-859f-b244054113ea/41293f683ae3491c01d3aa7b7dba9052/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c2890582-8f9f-46ef-afcf-27aac666e3f3/a2e9a79ed9033efd8eae58dd3333919a/windowsdesktop-runtime-7.0.0-preview.2.22153.5-win-x86.zip

[//]: # ( ASP 7.0.0-preview.2.22153.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f62c2be-99fb-418d-b98e-30d5d1d7e862/ea163ba205a0ac680d995e0f8d657bb7/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91aba62d-7b61-46fd-bae9-a34299a01ec4/f0597bde0eab2c832ce30eef80583d4d/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a67f9239-04e7-4194-8b90-3f22210dc06d/6a64962a90094707298d79b550271ff3/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/74129065-f8a6-42a4-861c-0ba2aba16765/3f67a82679aa7c57775dd77d479934f2/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b474ec4-78a3-4e50-a446-bd1ad933ab15/ec2d64820abe3d8351e05f0213a7ab2f/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d24d018-755a-4326-930f-b6f88e7c8851/330dfff882e637583cfde0c8cd90debf/aspnetcore-runtime-7.0.0-preview.2.22153.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a3082a5-9c7c-4152-a3a5-7b504b4dec03/39ae27a9590ffb72f2b52d3af698ba1e/aspnetcore-runtime-7.0.0-preview.2.22153.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/92bec271-6ed5-4c5a-89d3-002873d147c6/735323c91eb4a14d8737c52b5ea58455/aspnetcore-runtime-7.0.0-preview.2.22153.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7f917f63-d7f5-404d-9e0e-ce847cd1fab0/8bbaecbace79eb896d19ca70f8505152/aspnetcore-runtime-7.0.0-preview.2.22153.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6752a69-2860-495b-a1b8-ebbba3f5be19/d645486202d9357b6374ab78c52dfeed/aspnetcore-runtime-7.0.0-preview.2.22153.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/48930452-e7b8-453b-a53d-c562d1e28e23/8760008e53bff5b067ad10ef3e0d0003/aspnetcore-runtime-7.0.0-preview.2.22153.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3f573ad7-e56d-4249-8c9e-1cde5f65d680/c9ea38cdbcffe09877a889276bb3730c/aspnetcore-runtime-7.0.0-preview.2.22153.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/af43b709-4576-4dec-b50d-004ef8d7e193/42d821dcd80c92816c32798c0e1d59cb/aspnetcore-runtime-7.0.0-preview.2.22153.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/6b78ad20-011f-42f0-93eb-d19eb26bb573/2d38309bcc46c6f337fbab6c2837aa2d/dotnet-hosting-7.0.0-preview.2.22153.2-win.exe

[//]: # ( SDK 7.0.100-preview.2.22153.17)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7615bb0-7d72-4ff4-8501-5711298b337c/ad01d2bd02a758ac4d88c712075839b1/dotnet-sdk-7.0.100-preview.2.22153.17-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/464b9ad3-c0f9-4b96-8d04-8c607a5a6c17/429d60c7c172d9ec1d58515c9a94c3ca/dotnet-sdk-7.0.100-preview.2.22153.17-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f066553-66be-4e7e-a623-b0de9e2425e8/b3205c742db320539c8b9007af2ebc8c/dotnet-sdk-7.0.100-preview.2.22153.17-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bdb18180-0ea0-4eeb-b07e-51c70163cc37/607053dcff935afe7cbce6268d6290b7/dotnet-sdk-7.0.100-preview.2.22153.17-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b83e64ea-f2c4-4563-8622-ccf73ad1d365/144b78ed96b2ddb721d6927295c40a31/dotnet-sdk-7.0.100-preview.2.22153.17-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/754fe8c6-9088-4a1e-87df-cfc5efdf1a9a/e4d3a877c112ef8d09c6c7e9a444ad9e/dotnet-sdk-7.0.100-preview.2.22153.17-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cd80f4c1-b605-44d1-a322-f4e4e3c01776/c494ef9e353fe544830da1b6347859bd/dotnet-sdk-7.0.100-preview.2.22153.17-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e48daeec-7861-4193-b6eb-d3f965be6032/d203ccf2a2186096783d8deecfa63483/dotnet-sdk-7.0.100-preview.2.22153.17-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f6ec71c8-fc91-49f4-8409-f36e5b58902a/3d3ccb4dcaf0823d55ecd470854cb2c8/dotnet-sdk-7.0.100-preview.2.22153.17-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/344a9dcd-ad0a-49f5-990b-7933624c82df/8684f72d6429661c816330d0da5b42cc/dotnet-sdk-7.0.100-preview.2.22153.17-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/18336bb7-a835-45f2-a0e1-096b9c289d0a/00894271e2577209017b985d2a8ffcca/dotnet-sdk-7.0.100-preview.2.22153.17-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a30f77f6-8b77-4955-80bc-fcfe7bd99abe/41344727d9c94bb8ff86f46841d3978e/dotnet-sdk-7.0.100-preview.2.22153.17-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e904f60b-8b5a-46cc-a3c7-e37f87aa9aa2/ee9decc38b24f05e6edf8a63639653a1/dotnet-sdk-7.0.100-preview.2.22153.17-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d759acdb-c289-43ad-8698-4a9783d80ef8/11838a24f71dd4c359bc9a02b1e14d5f/dotnet-sdk-7.0.100-preview.2.22153.17-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c3125850-8c7b-4516-bba7-0e3f2c855725/5a64fd988de04d746b7d332c1682de7e/dotnet-sdk-7.0.100-preview.2.22153.17-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a844a854-92ad-4887-8fbc-6028bccf194a/10e407d4f629b046b73e8f1e6c06d294/dotnet-sdk-7.0.100-preview.2.22153.17-win-x86.zip



[//]: # ( Symbols )
