# .NET 7.0.0 Preview 4  - May 10, 2022

The .NET 7.0.0 Preview 4 and .NET SDK 7.0.100-preview.4.22252.9 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 4

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 4 at [dotnet/core #7378](https://github.com/dotnet/core/issues/7378).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 4.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.4.22252.9
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.2 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7445](https://github.com/dotnet/core/issues/7445) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.0-preview.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.4-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-preview-4/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-dotnet-7-preview-4
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-7-preview-4
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview4+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview4+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview4+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview4+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md



[//]: # ( Runtime 7.0.0-preview.4.22229.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/712346dd-aa3c-4edb-956b-1250b4d492e6/1c37467d40b15e89a1b28de7b95e21b0/dotnet-runtime-7.0.0-preview.4.22229.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/518e18c0-84b5-4ecc-b8a0-0dfb351774d4/0fa0bfc3b509042a4a15c8026ec50932/dotnet-runtime-7.0.0-preview.4.22229.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f684063-cec2-492a-82af-e8360d0737c7/0e3f62f3ee36abb66606647e0e9aca84/dotnet-runtime-7.0.0-preview.4.22229.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf20b258-eb1e-4810-abf3-2e508a46cb93/ed34277b286561164e661f80ac030dc9/dotnet-runtime-7.0.0-preview.4.22229.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70093d32-5394-4ad0-9c0c-3489b3d1436a/5b5d135cb274972ec7051df342b7999a/dotnet-runtime-7.0.0-preview.4.22229.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae7253dc-03c2-47a9-9c8c-3e4d1f44243a/bc22c5e61419b111622c56ccaf3cd5a9/dotnet-runtime-7.0.0-preview.4.22229.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2b5f0093-3c2b-45cf-85fc-ee37907334f4/234f8efce95a54513fdbc9bd02d013c4/dotnet-runtime-7.0.0-preview.4.22229.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/263af895-292f-41ed-a0cf-23109cf11068/639244e3d7a9b11d765b3883ad346ef7/dotnet-runtime-7.0.0-preview.4.22229.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1876aa0e-9484-41fd-b6e5-8a9a40efff6a/edacb1069d1d3cc1ee33a5bb6e4d585d/dotnet-runtime-7.0.0-preview.4.22229.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2f0c754-1e51-4e40-a707-0a2088464f23/bd2849969bb24857ba5650ce440bd564/dotnet-runtime-7.0.0-preview.4.22229.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a5fabc8-c740-4e7c-aaad-b14c1b6ed661/dd7b5db79bad8391fc27e4a2a6ac11b3/dotnet-runtime-7.0.0-preview.4.22229.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e21331ce-03f4-4d08-9f51-55d3631d36d3/535bf857b4789a5b8e1b6767d3711129/dotnet-runtime-7.0.0-preview.4.22229.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ceccdc31-68cc-491c-b2da-642af1922d62/35c117052896ba5c9417d2dc6329fc9b/dotnet-runtime-7.0.0-preview.4.22229.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62b98d57-12b3-4713-b258-36132921ec3f/34501586b1f974cff61a59d6cd7586d8/dotnet-runtime-7.0.0-preview.4.22229.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/09c487d7-7962-43b1-b9f7-519ee393bf64/e67ec093e896829158f535008785bc21/dotnet-runtime-7.0.0-preview.4.22229.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2b425458-f5ca-4271-bbab-f4e5b2ff369b/496ce630aee77c29dcf9a884442bd204/dotnet-runtime-7.0.0-preview.4.22229.4-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.4.22229.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b8888966-76f3-4f55-a22c-835c5bb7c822/0e419ee09f1da614fd1582139b301969/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/eac49cc3-f6f2-477c-b2d6-9516ddbc2513/823fc40580d0f9b6856c440aae6ce5a0/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6148ebcc-7a4a-4dda-950e-4bdb4ce66d2d/e87ca2a32d8d1c254d86bb10dbb5e5fb/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/063dde6a-29b2-4cac-9548-31455b638a53/b892fa0ace5f137c88e5a9f840a40275/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b05c6ad0-4815-48f0-ba10-37bb46cedf59/be427b793210c2c5383a742e799fdad4/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8ceedd3a-2d22-47f5-bcb9-62f1e436e6d4/86e16dd6810fd66b635f4ae3e69ee14a/windowsdesktop-runtime-7.0.0-preview.4.22229.2-win-x86.zip

[//]: # ( ASP 7.0.0-preview.4.22251.1)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7f44aea-97c8-4e50-894e-927faf25cd26/3f494443d0ebe12c2c12bc052ad2de2d/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77106ad3-b532-4dd4-98bb-cf2d4a9b401c/a4a645b14ec8ce8d020f2bc1cb07c853/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dded7c6a-b72c-4a93-870f-3a6d40ba255c/862cff9e098f9b1d632cecbd26c55ce9/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10d95b23-9660-49e1-8d6b-2960e62b3beb/40d89a8bd39e65ffb2e9d33c6de4a6ba/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7ea5373-7dff-4dbb-b120-8ee98010b8ae/867aa542b72859c58d4672214b438713/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/81fceda1-cffa-4301-8bef-d4fda5c84985/d6ecf648c8046afed6fde902ab452c63/aspnetcore-runtime-7.0.0-preview.4.22251.1-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b2060ea-6443-4595-a691-46be60b36e73/39d89ad1e71dbd75f6c3c2e95617d112/aspnetcore-runtime-7.0.0-preview.4.22251.1-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/744d3a1e-4ad7-45d9-bdf5-e98d63a3e180/7ecdf7a01ce968206d8278404d35580a/aspnetcore-runtime-7.0.0-preview.4.22251.1-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ce612db1-c992-442c-9205-08362be84d86/0defefdaafa3a7cb0fc3624b4ed97f37/aspnetcore-runtime-7.0.0-preview.4.22251.1-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/61bce088-6c34-47e6-a6d6-3f9c171dd249/dc022bed4a49ff6b769bdf8b60cb349c/aspnetcore-runtime-7.0.0-preview.4.22251.1-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/040013af-267c-48ef-ae3b-a2e77dde61d5/6aa48aa27bd8ab42ad4ce1df1b2bbf7e/aspnetcore-runtime-7.0.0-preview.4.22251.1-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a0eb7ab3-7baf-4b5d-be44-4ec955f12e14/a1cbd4af2f5052867a7388eedc17df6a/aspnetcore-runtime-7.0.0-preview.4.22251.1-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7757edc8-0c8c-4355-b3fd-6d1578a897d7/383c15d59f02b6ea78bccc18896bf66d/aspnetcore-runtime-7.0.0-preview.4.22251.1-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ac902cf6-fcdd-46e4-a5e3-8a0ecae16011/7745eff94eaa9e706c6f3b06bc0250a4/dotnet-hosting-7.0.0-preview.4.22251.1-win.exe

[//]: # ( SDK 7.0.100-preview.4.22252.9)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d02eca23-5d8e-4cac-9ced-c0f53109ff2e/a44302f99f897f79a41addbd105ceff9/dotnet-sdk-7.0.100-preview.4.22252.9-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a292f0a0-1659-40d0-9893-ea4686be6deb/bef1fadbbe9ebe9ee06ba1cb52e809a2/dotnet-sdk-7.0.100-preview.4.22252.9-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a94f3a1-be25-4175-8307-79e266d80c53/b2ebd39d8d7a02a11b45fcb64195def8/dotnet-sdk-7.0.100-preview.4.22252.9-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4b0eb89-fa9c-4176-9a37-5dfa9d9a4eb5/a4a438172874354b1c9700350038e313/dotnet-sdk-7.0.100-preview.4.22252.9-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/965f776e-1987-4640-ae83-5b9ef7a38376/614f6a6fbda7513743c0434e2a25ec0c/dotnet-sdk-7.0.100-preview.4.22252.9-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/322dd9d6-3135-4f8f-aa00-4daf61bc51d0/a4e28f08a42034b276e4536acdd0d7f0/dotnet-sdk-7.0.100-preview.4.22252.9-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/710799ef-650d-4ecb-8ff4-bf4532fb8d55/afc8538380be4257e271212d15664ab8/dotnet-sdk-7.0.100-preview.4.22252.9-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e0cf05d-d75e-4659-bf3c-bb49034d2b1d/91ce34d85b93980f6a3eaf711798168b/dotnet-sdk-7.0.100-preview.4.22252.9-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6b26f2f0-f2d1-4ca3-a0ae-ffbd8ac31629/174bdf9b481872c7591fa576833c6c30/dotnet-sdk-7.0.100-preview.4.22252.9-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72e7a10e-1349-4e8c-9874-ed0469e68ce1/a7835f5b15186b0366c1c84e6640d727/dotnet-sdk-7.0.100-preview.4.22252.9-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7cdc4b6c-d02e-4777-84c0-0c291d9475f5/c3b07d9d380eecc184e54d75366b419b/dotnet-sdk-7.0.100-preview.4.22252.9-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6ea7a70b-0f14-4779-aaea-73464d9c8b7b/e1746b78b693f77262c0241ae732560b/dotnet-sdk-7.0.100-preview.4.22252.9-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2b2a2f05-2381-4073-a774-80368dcfdef9/b63ad4ee1e933e45b9fefbbd2a5291ea/dotnet-sdk-7.0.100-preview.4.22252.9-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/21af2868-0870-4f4f-b678-918e6cf83459/3dc6852e403254a193a1f56cfec70c41/dotnet-sdk-7.0.100-preview.4.22252.9-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7d3c8652-c3a0-43f3-a9e6-4fc361577765/e35deb300bc2c6a36f18b2c9dc6cb926/dotnet-sdk-7.0.100-preview.4.22252.9-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/23816311-ff1b-4797-b8be-6c69a6f1226d/f31650405ce63d3e9cf6f0d6e15d4e60/dotnet-sdk-7.0.100-preview.4.22252.9-win-x86.zip
