# .NET 7.0.0 RC 1  - September 14, 2022

The .NET 7.0.0 RC 1 and .NET SDK 7.0.100-rc.1.22431.12 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 RC 1

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 RC 1 at [dotnet/core #7716](https://github.com/dotnet/core/issues/7716).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in RC 1.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-rc.1.22431.12
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes
.NET 7.0.0-RC 1 release carries security fixes.

# Microsoft Security Advisory CVE-2022-38013: .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core 3.1, .NET 6.0, and .NET 7.0.0-Preview. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in ASP.NET Core 3.1, .NET 6.0, and .NET 7.0.0-Preview where a malicious client could cause a stack overflow which may result in a denial of service attack when an attacker sends a customized payload that is parsed during model binding.

## Visual Studio Compatibility

You need [Visual Studio 17.4 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7800](https://github.com/dotnet/core/issues/7800) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 7.0.0-rc.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-rc.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-rc.1-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-rc-1/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-rc-1
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7-rc1
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-rc1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-rc1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-rc1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-rc1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md


[//]: # ( Runtime 7.0.0-rc.1.22426.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e81495a7-1946-433d-82ac-643315665718/e202e03285af845f2c743c6281db1ea4/dotnet-runtime-7.0.0-rc.1.22426.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82211656-7196-4508-90f2-b1adc95814ec/b9b2856e7b2a8788d213fdd29662ed30/dotnet-runtime-7.0.0-rc.1.22426.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/db88be55-96ce-4566-b974-b3d899bf4dc3/83e70fd568804deabbcdc7c2dd8f8320/dotnet-runtime-7.0.0-rc.1.22426.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/971f71f7-2cd3-4d77-ab5d-41c698bcf42b/0381f256c137839cfd61577da7b010a8/dotnet-runtime-7.0.0-rc.1.22426.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccebce74-c18a-4dbd-bcf6-47408c7f53ab/814f6e5af89a2facf5d5cd4f65883d56/dotnet-runtime-7.0.0-rc.1.22426.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d25df01-b918-44f3-9963-2f47a1317437/62142b0f944105ceee2514b00482327e/dotnet-runtime-7.0.0-rc.1.22426.10-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/427e5eda-5b38-4705-9c3e-231a1a937b4f/28be328d327f708fd7c53728696d44bf/dotnet-runtime-7.0.0-rc.1.22426.10-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b2fbc1d-da1e-446e-a052-8400078593e4/e26d013d79d5c6026755b1ab1f71efd3/dotnet-runtime-7.0.0-rc.1.22426.10-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7138e084-facc-423c-9291-d42905daf0fe/4fd55041dab67a68fea19cfd3fc08c41/dotnet-runtime-7.0.0-rc.1.22426.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61e5fbb9-341f-425d-8e20-dc97b906a886/c30c401a73339b3161eff6faf13eec0a/dotnet-runtime-7.0.0-rc.1.22426.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8fe2f3c-c244-403c-bb32-1e651c507d82/c9cd39fc77cec2d4310a653a6f0a5d1f/dotnet-runtime-7.0.0-rc.1.22426.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/56fe5a33-8c1a-464e-a63c-bf5e1b19bfd9/0d8a5ec1bb881bb20b6305a15a9a9e1a/dotnet-runtime-7.0.0-rc.1.22426.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/245a3d77-5ebd-45ac-a505-1be5dc719729/7535501fd3f5b3b5321f05233d5dd8f9/dotnet-runtime-7.0.0-rc.1.22426.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2535148a-11a1-48d5-b403-1503cbccc96a/a4f5c7d83d2da0f60cd63e0bda70b16e/dotnet-runtime-7.0.0-rc.1.22426.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c28b157f-c61e-4de7-902a-23a943ce76f8/84916ac37b61ee4bc5f392af170a640a/dotnet-runtime-7.0.0-rc.1.22426.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d37b0e77-2fbc-4357-bea2-91d8aa3f5bf5/275beeb00aee87a0de068f3378c0c437/dotnet-runtime-7.0.0-rc.1.22426.10-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-rc.1.22427.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fe2d9be9-a784-49ab-8cc2-7573108a2b57/9b438d779de18b22df927519b7870f2e/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1bf24988-6eda-479f-93ff-7a4a926a2b11/4b14de1844ee35bcfa22a457a5580ccc/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3d12acf4-0c81-4e57-a863-95a8cbb53773/fcf497631eee353a00ea21e968aa59d4/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b8efb7f-802d-47ae-844a-c65914a053ed/35f89319a63209273b50c43b30a4d848/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a499d525-7228-4a80-bf32-360516313e0b/663d0fb49980be76e56116cb1cb32956/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5b268c4b-cac6-4383-8ca4-a4f5c3d6c503/434516442d04ccda23391c69c487e3db/windowsdesktop-runtime-7.0.0-rc.1.22427.1-win-x86.zip

[//]: # ( ASP 7.0.0-rc.1.22427.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68e724e6-06bb-434f-a3c8-19e70b38d6a6/6a001576172b2651f7357acd6be4db90/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/120c4609-0fc9-4291-b84a-462315825fc7/dca79b88f966455e82d0b864d990eca2/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7632a53e-9154-480c-9bd0-390173373efb/5f907513fadcb05262002395bbf13e7c/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4efa7f8-2b40-4649-8107-b5e65e8d6aa1/7d6da01322793967612f20dcbbc795ed/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0857e86d-4206-4c14-b814-e5e3424f8396/6e1113fce778ef9ff69eb2ffefd6de76/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90a3ef50-f7fa-46d7-8839-1ad7a2d64945/ff0d7ad5aef915e19eb255d708a94a07/aspnetcore-runtime-7.0.0-rc.1.22427.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0fde6271-9b31-40eb-aee1-6bd4794e0fa9/1e5a72a21e733ab866dfb51a8f3b31a4/aspnetcore-runtime-7.0.0-rc.1.22427.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2d65754e-061f-45a9-9f9c-8c3910d4e0c2/8b8527c926c21020748d89922ae84eff/aspnetcore-runtime-7.0.0-rc.1.22427.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/aedae625-5adb-42f4-aa62-bc7b2ca9eec7/c55c37f66db3617c8daaea9ebaa8748d/aspnetcore-runtime-7.0.0-rc.1.22427.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/362b53af-8fea-4eee-a1f8-92604569a34f/2d00273ee48d227511556eef6f48862d/aspnetcore-runtime-7.0.0-rc.1.22427.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5d0f3572-2f86-41b8-a75a-42495b27d424/834d1b4d4567eab165ace0dc91e36bf0/aspnetcore-runtime-7.0.0-rc.1.22427.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fa7c9081-14d8-4e82-b9d9-2ec264f9b425/c629c6fa28648eea2c411a2554240b46/aspnetcore-runtime-7.0.0-rc.1.22427.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/45f849a9-976f-4a48-aaf2-930b3c93ed02/bc66a28bb82ee159cdfc709f6b951cf0/aspnetcore-runtime-7.0.0-rc.1.22427.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/4d72038c-e72b-41fa-b770-6a73564bced0/3922adc4c9cac36b9994ddcc6cceee7f/dotnet-hosting-7.0.0-rc.1.22427.2-win.exe

[//]: # ( SDK 7.0.100-rc.1.22431.12)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11fed703-51af-4e9e-a21c-6a1c089721b2/c904471d138fcc998f07617fa826cbda/dotnet-sdk-7.0.100-rc.1.22431.12-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/620a7215-63f9-47bb-b88a-7798e958ed2d/539a8c04045ab69efa77504f75f07a23/dotnet-sdk-7.0.100-rc.1.22431.12-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/21c9dcb5-77da-4803-90c0-5a39714bd8d8/42e10ffe950d4895a2ef4c76bd47c9ee/dotnet-sdk-7.0.100-rc.1.22431.12-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7bb4f273-20b2-429c-8570-1560012620c7/b3dee2ef395500f1e2ec14737072a270/dotnet-sdk-7.0.100-rc.1.22431.12-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42787c90-9edb-49eb-be41-146177ce842a/5495fd13c15337925b5fb507ebfb97d4/dotnet-sdk-7.0.100-rc.1.22431.12-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf594dbb-5ec8-486b-8395-95058e719e1c/42e8bc351654ed4c3ccaed58ea9180a1/dotnet-sdk-7.0.100-rc.1.22431.12-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a600948e-4b2b-40d2-8551-57d85492df13/196fed4c3c6c5498a0b861127353cc07/dotnet-sdk-7.0.100-rc.1.22431.12-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dbefddef-fd07-4dda-a9a7-e3a1b474d314/52d3b44b2fbb9bd2e0e8f17a01565ab8/dotnet-sdk-7.0.100-rc.1.22431.12-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/dae368f5-c03c-48b6-a7de-6dc423c3a5b7/180e601942c810f45f87fc75be783fbc/dotnet-sdk-7.0.100-rc.1.22431.12-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b605689-07ca-40a1-9619-e5e2a26a18e2/869ba34d898a8025ffe16f3e914277ab/dotnet-sdk-7.0.100-rc.1.22431.12-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c9d02533-caa5-4c6e-9441-55bc90aafde4/ce765cc725365f63c03f6fe8ee8ec8f3/dotnet-sdk-7.0.100-rc.1.22431.12-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/13c76c4b-7bff-4dcd-83f2-89d3b8f5c47d/c97889a542226294588bef296a1f2846/dotnet-sdk-7.0.100-rc.1.22431.12-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/87a58b01-55e1-4a0b-80bd-51a12d403bd6/f88b8b7908aab1a3876a686ce984acf8/dotnet-sdk-7.0.100-rc.1.22431.12-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b3b5dce4-d810-4477-a8a3-97cbb0bdf3ea/91d0dd167239cfdfb48ae18166f444d4/dotnet-sdk-7.0.100-rc.1.22431.12-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5ddfca1a-2c1d-4208-8200-c106cf1e46df/c9d96c57665e89421b52368f166df73b/dotnet-sdk-7.0.100-rc.1.22431.12-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c9573512-98aa-499c-a021-4dc96b0d37ef/631767111e78ff7f8e40cd0baea3e2df/dotnet-sdk-7.0.100-rc.1.22431.12-win-x86.zip
