# System.Numerics

``` diff
 namespace System.Numerics {
     public static class BitOperations {
+        public static bool IsPow2(IntPtr value);
+        public static bool IsPow2(UIntPtr value);
+        public static int LeadingZeroCount(UIntPtr value);
+        public static int Log2(UIntPtr value);
+        public static int PopCount(UIntPtr value);
+        public static UIntPtr RotateLeft(UIntPtr value, int offset);
+        public static UIntPtr RotateRight(UIntPtr value, int offset);
+        public static UIntPtr RoundUpToPowerOf2(UIntPtr value);
+        public static int TrailingZeroCount(IntPtr value);
+        public static int TrailingZeroCount(UIntPtr value);
     }
     public struct Matrix3x2 : IEquatable<Matrix3x2> {
+        public float this[int row, int column] { get; set; }
     }
     public struct Matrix4x4 : IEquatable<Matrix4x4> {
+        public float this[int row, int column] { get; set; }
     }
     public struct Quaternion : IEquatable<Quaternion> {
+        public float this[int index] { get; set; }
+        public static Quaternion Zero { get; }
     }
     public static class Vector {
+        public static Vector<Byte> ShiftLeft(Vector<Byte> value, int shiftCount);
+        public static Vector<Int16> ShiftLeft(Vector<Int16> value, int shiftCount);
+        public static Vector<Int32> ShiftLeft(Vector<Int32> value, int shiftCount);
+        public static Vector<Int64> ShiftLeft(Vector<Int64> value, int shiftCount);
+        public static Vector<IntPtr> ShiftLeft(Vector<IntPtr> value, int shiftCount);
+        public static Vector<SByte> ShiftLeft(Vector<SByte> value, int shiftCount);
+        public static Vector<UInt16> ShiftLeft(Vector<UInt16> value, int shiftCount);
+        public static Vector<UInt32> ShiftLeft(Vector<UInt32> value, int shiftCount);
+        public static Vector<UInt64> ShiftLeft(Vector<UInt64> value, int shiftCount);
+        public static Vector<UIntPtr> ShiftLeft(Vector<UIntPtr> value, int shiftCount);
+        public static Vector<Int16> ShiftRightArithmetic(Vector<Int16> value, int shiftCount);
+        public static Vector<Int32> ShiftRightArithmetic(Vector<Int32> value, int shiftCount);
+        public static Vector<Int64> ShiftRightArithmetic(Vector<Int64> value, int shiftCount);
+        public static Vector<IntPtr> ShiftRightArithmetic(Vector<IntPtr> value, int shiftCount);
+        public static Vector<SByte> ShiftRightArithmetic(Vector<SByte> value, int shiftCount);
+        public static Vector<Byte> ShiftRightLogical(Vector<Byte> value, int shiftCount);
+        public static Vector<Int16> ShiftRightLogical(Vector<Int16> value, int shiftCount);
+        public static Vector<Int32> ShiftRightLogical(Vector<Int32> value, int shiftCount);
+        public static Vector<Int64> ShiftRightLogical(Vector<Int64> value, int shiftCount);
+        public static Vector<IntPtr> ShiftRightLogical(Vector<IntPtr> value, int shiftCount);
+        public static Vector<SByte> ShiftRightLogical(Vector<SByte> value, int shiftCount);
+        public static Vector<UInt16> ShiftRightLogical(Vector<UInt16> value, int shiftCount);
+        public static Vector<UInt32> ShiftRightLogical(Vector<UInt32> value, int shiftCount);
+        public static Vector<UInt64> ShiftRightLogical(Vector<UInt64> value, int shiftCount);
+        public static Vector<UIntPtr> ShiftRightLogical(Vector<UIntPtr> value, int shiftCount);
     }
-    public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct
+    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct
     public struct Vector2 : IEquatable<Vector2>, IFormattable {
+        public float this[int index] { get; set; }
     }
     public struct Vector3 : IEquatable<Vector3>, IFormattable {
+        public float this[int index] { get; set; }
     }
     public struct Vector4 : IEquatable<Vector4>, IFormattable {
+        public float this[int index] { get; set; }
     }
 }
```

