# System.Runtime.Intrinsics

``` diff
 namespace System.Runtime.Intrinsics {
     public static class Vector128 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector128<T> Abs<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> Add<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> AndNot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
-        public static Vector128<U> As<T, U>(this Vector128<T> vector) where T : struct where U : struct;

+        public static Vector128<TTo> As<TFrom, TTo>(this Vector128<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector128<IntPtr> AsNInt<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<UIntPtr> AsNUInt<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<T> BitwiseAnd<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> BitwiseOr<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<Double> Ceiling(Vector128<Double> vector);
+        public static Vector128<Single> Ceiling(Vector128<Single> vector);
+        public static Vector128<T> ConditionalSelect<T>(Vector128<T> condition, Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<Double> ConvertToDouble(Vector128<Int64> vector);
+        public static Vector128<Double> ConvertToDouble(Vector128<UInt64> vector);
+        public static Vector128<Int32> ConvertToInt32(Vector128<Single> vector);
+        public static Vector128<Int64> ConvertToInt64(Vector128<Double> vector);
+        public static Vector128<Single> ConvertToSingle(Vector128<Int32> vector);
+        public static Vector128<Single> ConvertToSingle(Vector128<UInt32> vector);
+        public static Vector128<UInt32> ConvertToUInt32(Vector128<Single> vector);
+        public static Vector128<UInt64> ConvertToUInt64(Vector128<Double> vector);
+        public static void CopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector128<IntPtr> Create(IntPtr value);
+        public static Vector128<UIntPtr> Create(UIntPtr value);
+        public static Vector128<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector128<T> Create<T>(T value) where T : struct;
+        public static Vector128<T> Create<T>(T[] values) where T : struct;
+        public static Vector128<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector128<IntPtr> CreateScalar(IntPtr value);
+        public static Vector128<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector128<IntPtr> CreateScalarUnsafe(IntPtr value);
+        public static Vector128<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector128<T> Divide<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static T Dot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Equals<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static uint ExtractMostSignificantBits<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<Double> Floor(Vector128<Double> vector);
+        public static Vector128<Single> Floor(Vector128<Single> vector);
+        public static Vector128<T> GreaterThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> GreaterThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public unsafe static Vector128<T> Load<T>(T* source) where T : struct;
+        public unsafe static Vector128<T> LoadAligned<T>(T* source) where T : struct;
+        public unsafe static Vector128<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector128<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector128<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector128<T> Max<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Min<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, T right) where T : struct;
+        public static Vector128<T> Multiply<T>(T left, Vector128<T> right) where T : struct;
+        public static Vector128<Single> Narrow(Vector128<Double> lower, Vector128<Double> upper);
+        public static Vector128<SByte> Narrow(Vector128<Int16> lower, Vector128<Int16> upper);
+        public static Vector128<Int16> Narrow(Vector128<Int32> lower, Vector128<Int32> upper);
+        public static Vector128<Int32> Narrow(Vector128<Int64> lower, Vector128<Int64> upper);
+        public static Vector128<Byte> Narrow(Vector128<UInt16> lower, Vector128<UInt16> upper);
+        public static Vector128<UInt16> Narrow(Vector128<UInt32> lower, Vector128<UInt32> upper);
+        public static Vector128<UInt32> Narrow(Vector128<UInt64> lower, Vector128<UInt64> upper);
+        public static Vector128<T> Negate<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> OnesComplement<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<Byte> ShiftLeft(Vector128<Byte> vector, int shiftCount);
+        public static Vector128<Int16> ShiftLeft(Vector128<Int16> vector, int shiftCount);
+        public static Vector128<Int32> ShiftLeft(Vector128<Int32> vector, int shiftCount);
+        public static Vector128<Int64> ShiftLeft(Vector128<Int64> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftLeft(Vector128<IntPtr> vector, int shiftCount);
+        public static Vector128<SByte> ShiftLeft(Vector128<SByte> vector, int shiftCount);
+        public static Vector128<UInt16> ShiftLeft(Vector128<UInt16> vector, int shiftCount);
+        public static Vector128<UInt32> ShiftLeft(Vector128<UInt32> vector, int shiftCount);
+        public static Vector128<UInt64> ShiftLeft(Vector128<UInt64> vector, int shiftCount);
+        public static Vector128<UIntPtr> ShiftLeft(Vector128<UIntPtr> vector, int shiftCount);
+        public static Vector128<Int16> ShiftRightArithmetic(Vector128<Int16> vector, int shiftCount);
+        public static Vector128<Int32> ShiftRightArithmetic(Vector128<Int32> vector, int shiftCount);
+        public static Vector128<Int64> ShiftRightArithmetic(Vector128<Int64> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftRightArithmetic(Vector128<IntPtr> vector, int shiftCount);
+        public static Vector128<SByte> ShiftRightArithmetic(Vector128<SByte> vector, int shiftCount);
+        public static Vector128<Byte> ShiftRightLogical(Vector128<Byte> vector, int shiftCount);
+        public static Vector128<Int16> ShiftRightLogical(Vector128<Int16> vector, int shiftCount);
+        public static Vector128<Int32> ShiftRightLogical(Vector128<Int32> vector, int shiftCount);
+        public static Vector128<Int64> ShiftRightLogical(Vector128<Int64> vector, int shiftCount);
+        public static Vector128<IntPtr> ShiftRightLogical(Vector128<IntPtr> vector, int shiftCount);
+        public static Vector128<SByte> ShiftRightLogical(Vector128<SByte> vector, int shiftCount);
+        public static Vector128<UInt16> ShiftRightLogical(Vector128<UInt16> vector, int shiftCount);
+        public static Vector128<UInt32> ShiftRightLogical(Vector128<UInt32> vector, int shiftCount);
+        public static Vector128<UInt64> ShiftRightLogical(Vector128<UInt64> vector, int shiftCount);
+        public static Vector128<UIntPtr> ShiftRightLogical(Vector128<UIntPtr> vector, int shiftCount);
+        public static Vector128<T> Sqrt<T>(Vector128<T> vector) where T : struct;
+        public unsafe static void Store<T>(this Vector128<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAligned<T>(this Vector128<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector128<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector128<T> Subtract<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static T Sum<T>(Vector128<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        public static (Vector128<ushort> Lower, Vector128<ushort> Upper) Widen(Vector128<Byte> source);
+        public static (Vector128<int> Lower, Vector128<int> Upper) Widen(Vector128<Int16> source);
+        public static (Vector128<long> Lower, Vector128<long> Upper) Widen(Vector128<Int32> source);
+        public static (Vector128<short> Lower, Vector128<short> Upper) Widen(Vector128<SByte> source);
+        public static (Vector128<double> Lower, Vector128<double> Upper) Widen(Vector128<Single> source);
+        public static (Vector128<uint> Lower, Vector128<uint> Upper) Widen(Vector128<UInt16> source);
+        public static (Vector128<ulong> Lower, Vector128<ulong> Upper) Widen(Vector128<UInt32> source);
+        public static Vector128<T> Xor<T>(Vector128<T> left, Vector128<T> right) where T : struct;
     }
     public readonly struct Vector128<T> : IEquatable<Vector128<T>> where T : struct {
+        public T this[int index] { get; }
+        public static Vector128<T> operator +(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator &(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator |(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator /(Vector128<T> left, Vector128<T> right);
+        public static bool operator ==(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator ^(Vector128<T> left, Vector128<T> right);
+        public static bool operator !=(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator *(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator *(Vector128<T> left, T right);
+        public static Vector128<T> operator *(T left, Vector128<T> right);
+        public static Vector128<T> operator ~(Vector128<T> vector);
+        public static Vector128<T> operator -(Vector128<T> left, Vector128<T> right);
+        public static Vector128<T> operator -(Vector128<T> vector);
+        public static Vector128<T> operator +(Vector128<T> value);
     }
     public static class Vector256 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector256<T> Abs<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> Add<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> AndNot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
-        public static Vector256<U> As<T, U>(this Vector256<T> vector) where T : struct where U : struct;

+        public static Vector256<TTo> As<TFrom, TTo>(this Vector256<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector256<IntPtr> AsNInt<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<UIntPtr> AsNUInt<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<T> BitwiseAnd<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> BitwiseOr<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<Double> Ceiling(Vector256<Double> vector);
+        public static Vector256<Single> Ceiling(Vector256<Single> vector);
+        public static Vector256<T> ConditionalSelect<T>(Vector256<T> condition, Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<Double> ConvertToDouble(Vector256<Int64> vector);
+        public static Vector256<Double> ConvertToDouble(Vector256<UInt64> vector);
+        public static Vector256<Int32> ConvertToInt32(Vector256<Single> vector);
+        public static Vector256<Int64> ConvertToInt64(Vector256<Double> vector);
+        public static Vector256<Single> ConvertToSingle(Vector256<Int32> vector);
+        public static Vector256<Single> ConvertToSingle(Vector256<UInt32> vector);
+        public static Vector256<UInt32> ConvertToUInt32(Vector256<Single> vector);
+        public static Vector256<UInt64> ConvertToUInt64(Vector256<Double> vector);
+        public static void CopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector256<IntPtr> Create(IntPtr value);
+        public static Vector256<UIntPtr> Create(UIntPtr value);
+        public static Vector256<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector256<T> Create<T>(T value) where T : struct;
+        public static Vector256<T> Create<T>(T[] values) where T : struct;
+        public static Vector256<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector256<IntPtr> CreateScalar(IntPtr value);
+        public static Vector256<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector256<IntPtr> CreateScalarUnsafe(IntPtr value);
+        public static Vector256<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector256<T> Divide<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static T Dot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Equals<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static uint ExtractMostSignificantBits<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<Double> Floor(Vector256<Double> vector);
+        public static Vector256<Single> Floor(Vector256<Single> vector);
+        public static Vector256<T> GreaterThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> GreaterThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public unsafe static Vector256<T> Load<T>(T* source) where T : struct;
+        public unsafe static Vector256<T> LoadAligned<T>(T* source) where T : struct;
+        public unsafe static Vector256<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector256<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector256<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector256<T> Max<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Min<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, T right) where T : struct;
+        public static Vector256<T> Multiply<T>(T left, Vector256<T> right) where T : struct;
+        public static Vector256<Single> Narrow(Vector256<Double> lower, Vector256<Double> upper);
+        public static Vector256<SByte> Narrow(Vector256<Int16> lower, Vector256<Int16> upper);
+        public static Vector256<Int16> Narrow(Vector256<Int32> lower, Vector256<Int32> upper);
+        public static Vector256<Int32> Narrow(Vector256<Int64> lower, Vector256<Int64> upper);
+        public static Vector256<Byte> Narrow(Vector256<UInt16> lower, Vector256<UInt16> upper);
+        public static Vector256<UInt16> Narrow(Vector256<UInt32> lower, Vector256<UInt32> upper);
+        public static Vector256<UInt32> Narrow(Vector256<UInt64> lower, Vector256<UInt64> upper);
+        public static Vector256<T> Negate<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> OnesComplement<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<Byte> ShiftLeft(Vector256<Byte> vector, int shiftCount);
+        public static Vector256<Int16> ShiftLeft(Vector256<Int16> vector, int shiftCount);
+        public static Vector256<Int32> ShiftLeft(Vector256<Int32> vector, int shiftCount);
+        public static Vector256<Int64> ShiftLeft(Vector256<Int64> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftLeft(Vector256<IntPtr> vector, int shiftCount);
+        public static Vector256<SByte> ShiftLeft(Vector256<SByte> vector, int shiftCount);
+        public static Vector256<UInt16> ShiftLeft(Vector256<UInt16> vector, int shiftCount);
+        public static Vector256<UInt32> ShiftLeft(Vector256<UInt32> vector, int shiftCount);
+        public static Vector256<UInt64> ShiftLeft(Vector256<UInt64> vector, int shiftCount);
+        public static Vector256<UIntPtr> ShiftLeft(Vector256<UIntPtr> vector, int shiftCount);
+        public static Vector256<Int16> ShiftRightArithmetic(Vector256<Int16> vector, int shiftCount);
+        public static Vector256<Int32> ShiftRightArithmetic(Vector256<Int32> vector, int shiftCount);
+        public static Vector256<Int64> ShiftRightArithmetic(Vector256<Int64> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftRightArithmetic(Vector256<IntPtr> vector, int shiftCount);
+        public static Vector256<SByte> ShiftRightArithmetic(Vector256<SByte> vector, int shiftCount);
+        public static Vector256<Byte> ShiftRightLogical(Vector256<Byte> vector, int shiftCount);
+        public static Vector256<Int16> ShiftRightLogical(Vector256<Int16> vector, int shiftCount);
+        public static Vector256<Int32> ShiftRightLogical(Vector256<Int32> vector, int shiftCount);
+        public static Vector256<Int64> ShiftRightLogical(Vector256<Int64> vector, int shiftCount);
+        public static Vector256<IntPtr> ShiftRightLogical(Vector256<IntPtr> vector, int shiftCount);
+        public static Vector256<SByte> ShiftRightLogical(Vector256<SByte> vector, int shiftCount);
+        public static Vector256<UInt16> ShiftRightLogical(Vector256<UInt16> vector, int shiftCount);
+        public static Vector256<UInt32> ShiftRightLogical(Vector256<UInt32> vector, int shiftCount);
+        public static Vector256<UInt64> ShiftRightLogical(Vector256<UInt64> vector, int shiftCount);
+        public static Vector256<UIntPtr> ShiftRightLogical(Vector256<UIntPtr> vector, int shiftCount);
+        public static Vector256<T> Sqrt<T>(Vector256<T> vector) where T : struct;
+        public unsafe static void Store<T>(this Vector256<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAligned<T>(this Vector256<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector256<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector256<T> Subtract<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static T Sum<T>(Vector256<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        public static (Vector256<ushort> Lower, Vector256<ushort> Upper) Widen(Vector256<Byte> source);
+        public static (Vector256<int> Lower, Vector256<int> Upper) Widen(Vector256<Int16> source);
+        public static (Vector256<long> Lower, Vector256<long> Upper) Widen(Vector256<Int32> source);
+        public static (Vector256<short> Lower, Vector256<short> Upper) Widen(Vector256<SByte> source);
+        public static (Vector256<double> Lower, Vector256<double> Upper) Widen(Vector256<Single> source);
+        public static (Vector256<uint> Lower, Vector256<uint> Upper) Widen(Vector256<UInt16> source);
+        public static (Vector256<ulong> Lower, Vector256<ulong> Upper) Widen(Vector256<UInt32> source);
+        public static Vector256<T> Xor<T>(Vector256<T> left, Vector256<T> right) where T : struct;
     }
     public readonly struct Vector256<T> : IEquatable<Vector256<T>> where T : struct {
+        public T this[int index] { get; }
+        public static Vector256<T> operator +(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator &(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator |(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator /(Vector256<T> left, Vector256<T> right);
+        public static bool operator ==(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator ^(Vector256<T> left, Vector256<T> right);
+        public static bool operator !=(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator *(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator *(Vector256<T> left, T right);
+        public static Vector256<T> operator *(T left, Vector256<T> right);
+        public static Vector256<T> operator ~(Vector256<T> vector);
+        public static Vector256<T> operator -(Vector256<T> left, Vector256<T> right);
+        public static Vector256<T> operator -(Vector256<T> vector);
+        public static Vector256<T> operator +(Vector256<T> value);
     }
     public static class Vector64 {
+        public static bool IsHardwareAccelerated { get; }
+        public static Vector64<T> Abs<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> Add<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> AndNot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
-        public static Vector64<U> As<T, U>(this Vector64<T> vector) where T : struct where U : struct;

+        public static Vector64<TTo> As<TFrom, TTo>(this Vector64<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector64<IntPtr> AsNInt<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<UIntPtr> AsNUInt<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<T> BitwiseAnd<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> BitwiseOr<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<Double> Ceiling(Vector64<Double> vector);
+        public static Vector64<Single> Ceiling(Vector64<Single> vector);
+        public static Vector64<T> ConditionalSelect<T>(Vector64<T> condition, Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<Double> ConvertToDouble(Vector64<Int64> vector);
+        public static Vector64<Double> ConvertToDouble(Vector64<UInt64> vector);
+        public static Vector64<Int32> ConvertToInt32(Vector64<Single> vector);
+        public static Vector64<Int64> ConvertToInt64(Vector64<Double> vector);
+        public static Vector64<Single> ConvertToSingle(Vector64<Int32> vector);
+        public static Vector64<Single> ConvertToSingle(Vector64<UInt32> vector);
+        public static Vector64<UInt32> ConvertToUInt32(Vector64<Single> vector);
+        public static Vector64<UInt64> ConvertToUInt64(Vector64<Double> vector);
+        public static void CopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination, int startIndex) where T : struct;
+        public static Vector64<IntPtr> Create(IntPtr value);
+        public static Vector64<UIntPtr> Create(UIntPtr value);
+        public static Vector64<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector64<T> Create<T>(T value) where T : struct;
+        public static Vector64<T> Create<T>(T[] values) where T : struct;
+        public static Vector64<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector64<IntPtr> CreateScalar(IntPtr value);
+        public static Vector64<UIntPtr> CreateScalar(UIntPtr value);
+        public static Vector64<IntPtr> CreateScalarUnsafe(IntPtr value);
+        public static Vector64<UIntPtr> CreateScalarUnsafe(UIntPtr value);
+        public static Vector64<T> Divide<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static T Dot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Equals<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static uint ExtractMostSignificantBits<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<Double> Floor(Vector64<Double> vector);
+        public static Vector64<Single> Floor(Vector64<Single> vector);
+        public static Vector64<T> GreaterThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> GreaterThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public unsafe static Vector64<T> Load<T>(T* source) where T : struct;
+        public unsafe static Vector64<T> LoadAligned<T>(T* source) where T : struct;
+        public unsafe static Vector64<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector64<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector64<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        public static Vector64<T> Max<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Min<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, T right) where T : struct;
+        public static Vector64<T> Multiply<T>(T left, Vector64<T> right) where T : struct;
+        public static Vector64<Single> Narrow(Vector64<Double> lower, Vector64<Double> upper);
+        public static Vector64<SByte> Narrow(Vector64<Int16> lower, Vector64<Int16> upper);
+        public static Vector64<Int16> Narrow(Vector64<Int32> lower, Vector64<Int32> upper);
+        public static Vector64<Int32> Narrow(Vector64<Int64> lower, Vector64<Int64> upper);
+        public static Vector64<Byte> Narrow(Vector64<UInt16> lower, Vector64<UInt16> upper);
+        public static Vector64<UInt16> Narrow(Vector64<UInt32> lower, Vector64<UInt32> upper);
+        public static Vector64<UInt32> Narrow(Vector64<UInt64> lower, Vector64<UInt64> upper);
+        public static Vector64<T> Negate<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> OnesComplement<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<Byte> ShiftLeft(Vector64<Byte> vector, int shiftCount);
+        public static Vector64<Int16> ShiftLeft(Vector64<Int16> vector, int shiftCount);
+        public static Vector64<Int32> ShiftLeft(Vector64<Int32> vector, int shiftCount);
+        public static Vector64<Int64> ShiftLeft(Vector64<Int64> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftLeft(Vector64<IntPtr> vector, int shiftCount);
+        public static Vector64<SByte> ShiftLeft(Vector64<SByte> vector, int shiftCount);
+        public static Vector64<UInt16> ShiftLeft(Vector64<UInt16> vector, int shiftCount);
+        public static Vector64<UInt32> ShiftLeft(Vector64<UInt32> vector, int shiftCount);
+        public static Vector64<UInt64> ShiftLeft(Vector64<UInt64> vector, int shiftCount);
+        public static Vector64<UIntPtr> ShiftLeft(Vector64<UIntPtr> vector, int shiftCount);
+        public static Vector64<Int16> ShiftRightArithmetic(Vector64<Int16> vector, int shiftCount);
+        public static Vector64<Int32> ShiftRightArithmetic(Vector64<Int32> vector, int shiftCount);
+        public static Vector64<Int64> ShiftRightArithmetic(Vector64<Int64> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftRightArithmetic(Vector64<IntPtr> vector, int shiftCount);
+        public static Vector64<SByte> ShiftRightArithmetic(Vector64<SByte> vector, int shiftCount);
+        public static Vector64<Byte> ShiftRightLogical(Vector64<Byte> vector, int shiftCount);
+        public static Vector64<Int16> ShiftRightLogical(Vector64<Int16> vector, int shiftCount);
+        public static Vector64<Int32> ShiftRightLogical(Vector64<Int32> vector, int shiftCount);
+        public static Vector64<Int64> ShiftRightLogical(Vector64<Int64> vector, int shiftCount);
+        public static Vector64<IntPtr> ShiftRightLogical(Vector64<IntPtr> vector, int shiftCount);
+        public static Vector64<SByte> ShiftRightLogical(Vector64<SByte> vector, int shiftCount);
+        public static Vector64<UInt16> ShiftRightLogical(Vector64<UInt16> vector, int shiftCount);
+        public static Vector64<UInt32> ShiftRightLogical(Vector64<UInt32> vector, int shiftCount);
+        public static Vector64<UInt64> ShiftRightLogical(Vector64<UInt64> vector, int shiftCount);
+        public static Vector64<UIntPtr> ShiftRightLogical(Vector64<UIntPtr> vector, int shiftCount);
+        public static Vector64<T> Sqrt<T>(Vector64<T> vector) where T : struct;
+        public unsafe static void Store<T>(this Vector64<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAligned<T>(this Vector64<T> source, T* destination) where T : struct;
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector64<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static Vector64<T> Subtract<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static T Sum<T>(Vector64<T> vector) where T : struct;
+        public static bool TryCopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        public static (Vector64<ushort> Lower, Vector64<ushort> Upper) Widen(Vector64<Byte> source);
+        public static (Vector64<int> Lower, Vector64<int> Upper) Widen(Vector64<Int16> source);
+        public static (Vector64<long> Lower, Vector64<long> Upper) Widen(Vector64<Int32> source);
+        public static (Vector64<short> Lower, Vector64<short> Upper) Widen(Vector64<SByte> source);
+        public static (Vector64<double> Lower, Vector64<double> Upper) Widen(Vector64<Single> source);
+        public static (Vector64<uint> Lower, Vector64<uint> Upper) Widen(Vector64<UInt16> source);
+        public static (Vector64<ulong> Lower, Vector64<ulong> Upper) Widen(Vector64<UInt32> source);
+        public static Vector64<T> Xor<T>(Vector64<T> left, Vector64<T> right) where T : struct;
     }
     public readonly struct Vector64<T> : IEquatable<Vector64<T>> where T : struct {
+        public T this[int index] { get; }
+        public static Vector64<T> operator +(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator &(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator |(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator /(Vector64<T> left, Vector64<T> right);
+        public static bool operator ==(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator ^(Vector64<T> left, Vector64<T> right);
+        public static bool operator !=(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator *(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator *(Vector64<T> left, T right);
+        public static Vector64<T> operator *(T left, Vector64<T> right);
+        public static Vector64<T> operator ~(Vector64<T> vector);
+        public static Vector64<T> operator -(Vector64<T> left, Vector64<T> right);
+        public static Vector64<T> operator -(Vector64<T> vector);
+        public static Vector64<T> operator +(Vector64<T> value);
     }
 }
```

