# System

``` diff
 namespace System {
     public static class AppContext {
+        public static void SetData(string name, object? data);
     }
     public class ArgumentNullException : ArgumentException {
+        public unsafe static void ThrowIfNull(void* argument, string? paramName = null);
     }
     public class ObjectDisposedException : InvalidOperationException {
+        public static void ThrowIf(bool condition, object instance);
+        public static void ThrowIf(bool condition, Type type);
     }
-    public struct RuntimeFieldHandle : ISerializable
+    public struct RuntimeFieldHandle : IEquatable<RuntimeFieldHandle>, ISerializable
-    public struct RuntimeMethodHandle : ISerializable
+    public struct RuntimeMethodHandle : IEquatable<RuntimeMethodHandle>, ISerializable
-    public struct RuntimeTypeHandle : ISerializable
+    public struct RuntimeTypeHandle : IEquatable<RuntimeTypeHandle>, ISerializable
     public abstract class Type : MemberInfo, IReflect {
-        public static Type GetTypeFromHandle(RuntimeTypeHandle handle);
+        public static Type? GetTypeFromHandle(RuntimeTypeHandle handle);
     }
 }
```

