# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public enum Architecture {
+        Armv6 = 7,
     }
-    public readonly struct ArrayWithOffset
+    public readonly struct ArrayWithOffset : IEquatable<ArrayWithOffset>
-    public struct GCHandle {
+    public struct GCHandle : IEquatable<GCHandle> {
+        public bool Equals(GCHandle other);
     }
-    public readonly struct NFloat : IEquatable<NFloat> {
+    public readonly struct NFloat : IComparable, IComparable<NFloat>, IEquatable<NFloat>, IFormattable, ISpanFormattable {
+        public static NFloat Epsilon { get; }
+        public static NFloat MaxValue { get; }
+        public static NFloat MinValue { get; }
+        public static NFloat NaN { get; }
+        public static NFloat NegativeInfinity { get; }
+        public static NFloat PositiveInfinity { get; }
+        public static int Size { get; }
+        public int CompareTo(object? obj);
+        public int CompareTo(NFloat other);
-        public override bool Equals(object? o);
+        public override bool Equals(object? obj);
+        public static bool IsFinite(NFloat value);
+        public static bool IsInfinity(NFloat value);
+        public static bool IsNaN(NFloat value);
+        public static bool IsNegative(NFloat value);
+        public static bool IsNegativeInfinity(NFloat value);
+        public static bool IsNormal(NFloat value);
+        public static bool IsPositiveInfinity(NFloat value);
+        public static bool IsSubnormal(NFloat value);
+        public static NFloat operator +(NFloat left, NFloat right);
+        public static NFloat operator --(NFloat value);
+        public static NFloat operator /(NFloat left, NFloat right);
+        public static bool operator ==(NFloat left, NFloat right);
+        public static explicit operator NFloat (decimal value);
+        public static explicit operator NFloat (double value);
+        public static explicit operator byte (NFloat value);
+        public static explicit operator char (NFloat value);
+        public static explicit operator decimal (NFloat value);
+        public static explicit operator short (NFloat value);
+        public static explicit operator int (NFloat value);
+        public static explicit operator long (NFloat value);
+        public static explicit operator IntPtr (NFloat value);
+        public static explicit operator sbyte (NFloat value);
+        public static explicit operator float (NFloat value);
+        public static explicit operator ushort (NFloat value);
+        public static explicit operator uint (NFloat value);
+        public static explicit operator ulong (NFloat value);
+        public static explicit operator UIntPtr (NFloat value);
+        public static bool operator >(NFloat left, NFloat right);
+        public static bool operator >=(NFloat left, NFloat right);
+        public static implicit operator NFloat (byte value);
+        public static implicit operator NFloat (char value);
+        public static implicit operator NFloat (short value);
+        public static implicit operator NFloat (int value);
+        public static implicit operator NFloat (long value);
+        public static implicit operator NFloat (IntPtr value);
+        public static implicit operator double (NFloat value);
+        public static implicit operator NFloat (sbyte value);
+        public static implicit operator NFloat (float value);
+        public static implicit operator NFloat (ushort value);
+        public static implicit operator NFloat (uint value);
+        public static implicit operator NFloat (ulong value);
+        public static implicit operator NFloat (UIntPtr value);
+        public static NFloat operator ++(NFloat value);
+        public static bool operator !=(NFloat left, NFloat right);
+        public static bool operator <(NFloat left, NFloat right);
+        public static bool operator <=(NFloat left, NFloat right);
+        public static NFloat operator %(NFloat left, NFloat right);
+        public static NFloat operator *(NFloat left, NFloat right);
+        public static NFloat operator -(NFloat left, NFloat right);
+        public static NFloat operator -(NFloat value);
+        public static NFloat operator +(NFloat value);
+        public static NFloat Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        public static NFloat Parse(string s);
+        public static NFloat Parse(string s, NumberStyles style);
+        public static NFloat Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static NFloat Parse(string s, IFormatProvider? provider);
+        public string ToString(IFormatProvider? provider);
+        public string ToString(string? format);
+        public string ToString(string? format, IFormatProvider? provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(ReadOnlySpan<char> s, out NFloat result);
+        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(string? s, out NFloat result);
     }
 }
```

