# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public sealed class AesCng : Aes {
+        protected override bool TryDecryptCbcCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryDecryptCfbCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryDecryptEcbCore(ReadOnlySpan<byte> ciphertext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCbcCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCfbCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryEncryptEcbCore(ReadOnlySpan<byte> plaintext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
     }
     public sealed class DSACng : DSA {
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        protected override bool TryCreateSignatureCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        protected override bool VerifySignatureCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
     public sealed class DSACryptoServiceProvider : DSA, ICspAsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
     }
     public sealed class DSAOpenSsl : DSA {
-        public override int KeySize { set; }

-        public override KeySizes[] LegalKeySizes { get; }

-        protected override void Dispose(bool disposing);

-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);

-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);

     }
     public sealed class ECDiffieHellmanCng : ECDiffieHellman {
+        public override KeySizes[] LegalKeySizes { get; }
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
     }
     public sealed class ECDiffieHellmanOpenSsl : ECDiffieHellman {
-        public override byte[] DeriveKeyFromHash(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[]? secretPrepend, byte[]? secretAppend);

-        public override byte[] DeriveKeyFromHmac(ECDiffieHellmanPublicKey otherPartyPublicKey, HashAlgorithmName hashAlgorithm, byte[]? hmacKey, byte[]? secretPrepend, byte[]? secretAppend);

-        public override byte[] DeriveKeyMaterial(ECDiffieHellmanPublicKey otherPartyPublicKey);

-        public override byte[] DeriveKeyTls(ECDiffieHellmanPublicKey otherPartyPublicKey, byte[] prfLabel, byte[] prfSeed);

-        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);

-        public override void GenerateKey(ECCurve curve);

     }
     public sealed class ECDsaCng : ECDsa {
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public override bool TrySignHash(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected override bool TrySignHashCore(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat, out int bytesWritten);
+        public override bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature);
+        protected override bool VerifyHashCore(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, DSASignatureFormat signatureFormat);
     }
     public sealed class ECDsaOpenSsl : ECDsa {
-        public override int KeySize { get; set; }

-        public override KeySizes[] LegalKeySizes { get; }

-        protected override void Dispose(bool disposing);

-        public override ECParameters ExportExplicitParameters(bool includePrivateParameters);

-        public override ECParameters ExportParameters(bool includePrivateParameters);

-        public override void GenerateKey(ECCurve curve);

-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);

-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);

-        public override void ImportParameters(ECParameters parameters);

     }
     public class HMACMD5 : HMAC {
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class HMACSHA1 : HMAC {
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class HMACSHA256 : HMAC {
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class HMACSHA384 : HMAC {
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class HMACSHA512 : HMAC {
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class MD5 : HashAlgorithm {
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class RSACng : RSA {
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public override byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryDecrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public override bool TryEncrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public override bool TrySignHash(ReadOnlySpan<byte> hash, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public override bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
     public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
     }
     public sealed class RSAOpenSsl : RSA {
-        public override int KeySize { set; }

-        public override KeySizes[] LegalKeySizes { get; }

-        public override byte[] Decrypt(byte[] data, RSAEncryptionPadding padding);

-        protected override void Dispose(bool disposing);

-        public override byte[] Encrypt(byte[] data, RSAEncryptionPadding padding);

-        protected override byte[] HashData(byte[] data, int offset, int count, HashAlgorithmName hashAlgorithm);

-        protected override byte[] HashData(Stream data, HashAlgorithmName hashAlgorithm);

-        public override byte[] SignHash(byte[] hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);

-        public override bool VerifyHash(byte[] hash, byte[] signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);

     }
     public abstract class SHA1 : HashAlgorithm {
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA256 : HashAlgorithm {
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA384 : HashAlgorithm {
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class SHA512 : HashAlgorithm {
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class TripleDESCng : TripleDES {
+        protected override bool TryDecryptCbcCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryDecryptCfbCore(ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryDecryptEcbCore(ReadOnlySpan<byte> ciphertext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCbcCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
+        protected override bool TryEncryptCfbCore(ReadOnlySpan<byte> plaintext, ReadOnlySpan<byte> iv, Span<byte> destination, PaddingMode paddingMode, int feedbackSizeInBits, out int bytesWritten);
+        protected override bool TryEncryptEcbCore(ReadOnlySpan<byte> plaintext, Span<byte> destination, PaddingMode paddingMode, out int bytesWritten);
     }
 }
```

