# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public sealed class AcceptedAtRouteHttpResult : IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public object Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class AcceptedHttpResult : IResult {
+        public string Location { get; }
+        public int StatusCode { get; }
+        public object Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class BadRequestObjectHttpResult : IResult {
+        public int StatusCode { get; }
+        public object Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ChallengeHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ConflictObjectHttpResult : IResult {
+        public int StatusCode { get; }
+        public object Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ContentHttpResult : IResult {
+        public string Content { get; internal set; }
+        public string ContentType { get; internal set; }
+        public int? StatusCode { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class CreatedAtRouteHttpResult : IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public object Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class CreatedHttpResult : IResult {
+        public string Location { get; }
+        public int StatusCode { get; }
+        public object Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class EmptyHttpResult : IResult {
+        public static EmptyHttpResult Instance { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
     public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object> {
+        public T GetRequiredMetadata<T>() where T : class;
     }
+    public sealed class FileContentHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public ReadOnlyMemory<byte> FileContents { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class FileStreamHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public Stream FileStream { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ForbidHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public interface IRouteHandlerFilter {
+        ValueTask<object?> InvokeAsync(RouteHandlerInvocationContext context, RouteHandlerFilterDelegate next);
+    }
+    public sealed class JsonHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public JsonSerializerOptions JsonSerializerOptions { get; internal set; }
+        public int? StatusCode { get; }
+        public object Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public class NoContentHttpResult : IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class NotFoundObjectHttpResult : IResult {
+        public int StatusCode { get; }
+        public object Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class OkObjectHttpResult : IResult {
+        public int StatusCode { get; }
+        public object Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class PhysicalFileHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ProblemHttpResult : IResult {
+        public string ContentType { get; }
+        public ProblemDetails ProblemDetails { get; }
+        public int? StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class PushStreamHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectHttpResult : IResult {
+        public bool AcceptLocalUrlOnly { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string Url { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectToRouteHttpResult : IResult {
+        public string Fragment { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
     public sealed class RequestDelegateFactoryOptions {
+        public IReadOnlyList<Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate>>? RouteHandlerFilterFactories { get; set; }
     }
     public static class Results {
+        public static IResult Empty { get; }
     }
+    public sealed class RouteHandlerContext {
+        public RouteHandlerContext(MethodInfo methodInfo, EndpointMetadataCollection endpointMetadata);
+        public EndpointMetadataCollection EndpointMetadata { get; }
+        public MethodInfo MethodInfo { get; }
+    }
+    public delegate ValueTask<object?> RouteHandlerFilterDelegate(RouteHandlerInvocationContext context);
+    public static class RouteHandlerFilterExtensions {
+        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, IRouteHandlerFilter filter);
+        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate> filterFactory);
+        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, Func<RouteHandlerInvocationContext, RouteHandlerFilterDelegate, ValueTask<object?>> routeHandlerFilter);
+        public static RouteHandlerBuilder AddFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IRouteHandlerFilter;
+    }
+    public sealed class RouteHandlerInvocationContext {
+        public RouteHandlerInvocationContext(HttpContext httpContext, params object[] parameters);
+        public HttpContext HttpContext { get; }
+        public IList<object?> Parameters { get; }
+    }
+    public sealed class SignInHttpResult : IResult {
+        public string AuthenticationScheme { get; internal set; }
+        public ClaimsPrincipal Principal { get; internal set; }
+        public AuthenticationProperties Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class SignOutHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class StatusCodeHttpResult : IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnauthorizedHttpResult : IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnprocessableEntityObjectHttpResult : IResult {
+        public int StatusCode { get; }
+        public object Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class VirtualFileHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
 }
```

