# System.Text.RegularExpressions

``` diff
 namespace System.Text.RegularExpressions {
     public class Regex : ISerializable {
+        public int Count(ReadOnlySpan<char> input);
+        public static int Count(ReadOnlySpan<char> input, string pattern);
+        public static int Count(ReadOnlySpan<char> input, string pattern, RegexOptions options);
+        public static int Count(ReadOnlySpan<char> input, string pattern, RegexOptions options, TimeSpan matchTimeout);
+        public bool IsMatch(ReadOnlySpan<char> input);
+        public static bool IsMatch(ReadOnlySpan<char> input, string pattern);
+        public static bool IsMatch(ReadOnlySpan<char> input, string pattern, RegexOptions options);
+        public static bool IsMatch(ReadOnlySpan<char> input, string pattern, RegexOptions options, TimeSpan matchTimeout);
     }
     public abstract class RegexRunner {
-        protected abstract bool FindFirstChar();
+        protected virtual bool FindFirstChar();
-        protected abstract void Go();
+        protected virtual void Go();
-        protected abstract void InitTrackCount();
+        protected virtual void InitTrackCount();
+        protected internal virtual void Scan(ReadOnlySpan<char> text);
     }
 }
```

