# System

``` diff
 namespace System {
-    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable, ISpanFormattable {
+    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, IParseable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParseable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+        public const byte AdditiveIdentity = (byte)0;
+        public const byte MultiplicativeIdentity = (byte)1;
+        public const byte One = (byte)1;
+        public const byte Zero = (byte)0;
+        static byte System.IAdditiveIdentity<System.Byte,System.Byte>.AdditiveIdentity { get; }
+        static byte System.IMinMaxValue<System.Byte>.MaxValue { get; }
+        static byte System.IMinMaxValue<System.Byte>.MinValue { get; }
+        static byte System.IMultiplicativeIdentity<System.Byte,System.Byte>.MultiplicativeIdentity { get; }
+        static byte System.INumber<System.Byte>.One { get; }
+        static byte System.INumber<System.Byte>.Zero { get; }
+        static Byte Abs(Byte value);
+        static Byte Clamp(Byte value, Byte min, Byte max);
+        static Byte Create<TOther>(TOther value);
+        static Byte CreateSaturating<TOther>(TOther value);
+        static Byte CreateTruncating<TOther>(TOther value);
+        static (byte Quotient, byte Remainder) DivRem(Byte left, Byte right);
+        static bool IsPow2(Byte value);
+        static Byte LeadingZeroCount(Byte value);
+        static Byte Log2(Byte value);
+        static Byte Max(Byte x, Byte y);
+        static Byte Min(Byte x, Byte y);
-        public static Byte Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Byte Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Byte Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Byte Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Byte Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Byte Parse(string s, IFormatProvider? provider);
+        static Byte Parse(string s, IFormatProvider? provider);
+        static Byte PopCount(Byte value);
+        static Byte RotateLeft(Byte value, int rotateAmount);
+        static Byte RotateRight(Byte value, int rotateAmount);
+        static Byte Sign(Byte value);
+        static Byte System.IAdditionOperators<System.Byte,System.Byte,System.Byte>.op_Addition(Byte left, Byte right);
+        static Byte System.IBitwiseOperators<System.Byte,System.Byte,System.Byte>.op_BitwiseAnd(Byte left, Byte right);
+        static Byte System.IBitwiseOperators<System.Byte,System.Byte,System.Byte>.op_BitwiseOr(Byte left, Byte right);
+        static Byte System.IBitwiseOperators<System.Byte,System.Byte,System.Byte>.op_ExclusiveOr(Byte left, Byte right);
+        static Byte System.IBitwiseOperators<System.Byte,System.Byte,System.Byte>.op_OnesComplement(Byte value);
+        static bool System.IComparisonOperators<System.Byte,System.Byte>.op_GreaterThan(Byte left, Byte right);
+        static bool System.IComparisonOperators<System.Byte,System.Byte>.op_GreaterThanOrEqual(Byte left, Byte right);
+        static bool System.IComparisonOperators<System.Byte,System.Byte>.op_LessThan(Byte left, Byte right);
+        static bool System.IComparisonOperators<System.Byte,System.Byte>.op_LessThanOrEqual(Byte left, Byte right);
+        static Byte System.IDecrementOperators<System.Byte>.op_Decrement(Byte value);
+        static Byte System.IDivisionOperators<System.Byte,System.Byte,System.Byte>.op_Division(Byte left, Byte right);
+        static bool System.IEqualityOperators<System.Byte,System.Byte>.op_Equality(Byte left, Byte right);
+        static bool System.IEqualityOperators<System.Byte,System.Byte>.op_Inequality(Byte left, Byte right);
+        static Byte System.IIncrementOperators<System.Byte>.op_Increment(Byte value);
+        static Byte System.IModulusOperators<System.Byte,System.Byte,System.Byte>.op_Modulus(Byte left, Byte right);
+        static Byte System.IMultiplyOperators<System.Byte,System.Byte,System.Byte>.op_Multiply(Byte left, Byte right);
+        static Byte System.IShiftOperators<System.Byte,System.Byte>.op_LeftShift(Byte value, int shiftAmount);
+        static Byte System.IShiftOperators<System.Byte,System.Byte>.op_RightShift(Byte value, int shiftAmount);
+        static Byte System.ISubtractionOperators<System.Byte,System.Byte,System.Byte>.op_Subtraction(Byte left, Byte right);
+        static Byte System.IUnaryNegationOperators<System.Byte,System.Byte>.op_UnaryNegation(Byte value);
+        static Byte System.IUnaryPlusOperators<System.Byte,System.Byte>.op_UnaryPlus(Byte value);
+        static Byte TrailingZeroCount(Byte value);
+        static bool TryCreate<TOther>(TOther value, out Byte result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Byte result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Byte result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Byte result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Byte result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Byte result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Byte result);
     }
-    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>, IFormattable, ISpanFormattable {
+    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, IParseable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParseable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+        static char System.IAdditiveIdentity<System.Char,System.Char>.AdditiveIdentity { get; }
+        static char System.IMinMaxValue<System.Char>.MaxValue { get; }
+        static char System.IMinMaxValue<System.Char>.MinValue { get; }
+        static char System.IMultiplicativeIdentity<System.Char,System.Char>.MultiplicativeIdentity { get; }
+        static char System.INumber<System.Char>.One { get; }
+        static char System.INumber<System.Char>.Zero { get; }
+        static Char Abs(Char value);
+        static Char Clamp(Char value, Char min, Char max);
+        static Char Create<TOther>(TOther value);
+        static Char CreateSaturating<TOther>(TOther value);
+        static Char CreateTruncating<TOther>(TOther value);
+        static (char Quotient, char Remainder) DivRem(Char left, Char right);
+        static bool IsPow2(Char value);
+        static Char LeadingZeroCount(Char value);
+        static Char Log2(Char value);
+        static Char Max(Char x, Char y);
+        static Char Min(Char x, Char y);
+        static Char PopCount(Char value);
+        static Char RotateLeft(Char value, int rotateAmount);
+        static Char RotateRight(Char value, int rotateAmount);
+        static Char Sign(Char value);
+        static Char System.IAdditionOperators<System.Char,System.Char,System.Char>.op_Addition(Char left, Char right);
+        static Char System.IBitwiseOperators<System.Char,System.Char,System.Char>.op_BitwiseAnd(Char left, Char right);
+        static Char System.IBitwiseOperators<System.Char,System.Char,System.Char>.op_BitwiseOr(Char left, Char right);
+        static Char System.IBitwiseOperators<System.Char,System.Char,System.Char>.op_ExclusiveOr(Char left, Char right);
+        static Char System.IBitwiseOperators<System.Char,System.Char,System.Char>.op_OnesComplement(Char value);
+        static bool System.IComparisonOperators<System.Char,System.Char>.op_GreaterThan(Char left, Char right);
+        static bool System.IComparisonOperators<System.Char,System.Char>.op_GreaterThanOrEqual(Char left, Char right);
+        static bool System.IComparisonOperators<System.Char,System.Char>.op_LessThan(Char left, Char right);
+        static bool System.IComparisonOperators<System.Char,System.Char>.op_LessThanOrEqual(Char left, Char right);
+        static Char System.IDecrementOperators<System.Char>.op_Decrement(Char value);
+        static Char System.IDivisionOperators<System.Char,System.Char,System.Char>.op_Division(Char left, Char right);
+        static bool System.IEqualityOperators<System.Char,System.Char>.op_Equality(Char left, Char right);
+        static bool System.IEqualityOperators<System.Char,System.Char>.op_Inequality(Char left, Char right);
+        static Char System.IIncrementOperators<System.Char>.op_Increment(Char value);
+        static Char System.IModulusOperators<System.Char,System.Char,System.Char>.op_Modulus(Char left, Char right);
+        static Char System.IMultiplyOperators<System.Char,System.Char,System.Char>.op_Multiply(Char left, Char right);
+        static Char System.INumber<System.Char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);
+        static Char System.INumber<System.Char>.Parse(string s, NumberStyles style, IFormatProvider provider);
+        static bool System.INumber<System.Char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Char result);
+        static bool System.INumber<System.Char>.TryParse(string s, NumberStyles style, IFormatProvider provider, out Char result);
+        static Char System.IParseable<System.Char>.Parse(string s, IFormatProvider provider);
+        static bool System.IParseable<System.Char>.TryParse(string s, IFormatProvider provider, out Char result);
+        static Char System.IShiftOperators<System.Char,System.Char>.op_LeftShift(Char value, int shiftAmount);
+        static Char System.IShiftOperators<System.Char,System.Char>.op_RightShift(Char value, int shiftAmount);
+        static Char System.ISpanParseable<System.Char>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool System.ISpanParseable<System.Char>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out Char result);
+        static Char System.ISubtractionOperators<System.Char,System.Char,System.Char>.op_Subtraction(Char left, Char right);
+        static Char System.IUnaryNegationOperators<System.Char,System.Char>.op_UnaryNegation(Char value);
+        static Char System.IUnaryPlusOperators<System.Char,System.Char>.op_UnaryPlus(Char value);
+        static Char TrailingZeroCount(Char value);
+        static bool TryCreate<TOther>(TOther value, out Char result);
     }
-    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, ISpanFormattable {
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IComparisonOperators<DateOnly, DateOnly>, IEqualityOperators<DateOnly, DateOnly>, IEquatable<DateOnly>, IFormattable, IMinMaxValue<DateOnly>, IParseable<DateOnly>, ISpanFormattable, ISpanParseable<DateOnly> {
-        public static DateOnly MaxValue { get; }
+        static DateOnly MaxValue { get; }
-        public static DateOnly MinValue { get; }
+        static DateOnly MinValue { get; }
-        public static bool operator ==(DateOnly left, DateOnly right);
+        static bool operator ==(DateOnly left, DateOnly right);
-        public static bool operator >(DateOnly left, DateOnly right);
+        static bool operator >(DateOnly left, DateOnly right);
-        public static bool operator >=(DateOnly left, DateOnly right);
+        static bool operator >=(DateOnly left, DateOnly right);
-        public static bool operator !=(DateOnly left, DateOnly right);
+        static bool operator !=(DateOnly left, DateOnly right);
-        public static bool operator <(DateOnly left, DateOnly right);
+        static bool operator <(DateOnly left, DateOnly right);
-        public static bool operator <=(DateOnly left, DateOnly right);
+        static bool operator <=(DateOnly left, DateOnly right);
+        static DateOnly Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        static DateOnly Parse(string s, IFormatProvider? provider);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateOnly result);
+        static bool TryParse(string? s, IFormatProvider? provider, out DateOnly result);
     }
-    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct DateTime : IAdditionOperators<DateTime, TimeSpan, DateTime>, IAdditiveIdentity<DateTime, TimeSpan>, IComparable, IComparable<DateTime>, IComparisonOperators<DateTime, DateTime>, IConvertible, IEqualityOperators<DateTime, DateTime>, IEquatable<DateTime>, IFormattable, IMinMaxValue<DateTime>, IParseable<DateTime>, ISerializable, ISpanFormattable, ISpanParseable<DateTime>, ISubtractionOperators<DateTime, DateTime, TimeSpan>, ISubtractionOperators<DateTime, TimeSpan, DateTime> {
+        static TimeSpan AdditiveIdentity { get; }
+        static DateTime System.IMinMaxValue<System.DateTime>.MaxValue { get; }
+        static DateTime System.IMinMaxValue<System.DateTime>.MinValue { get; }
-        public static DateTime operator +(DateTime d, TimeSpan t);
+        static DateTime operator +(DateTime d, TimeSpan t);
-        public static bool operator ==(DateTime d1, DateTime d2);
+        static bool operator ==(DateTime d1, DateTime d2);
-        public static bool operator >(DateTime t1, DateTime t2);
+        static bool operator >(DateTime t1, DateTime t2);
-        public static bool operator >=(DateTime t1, DateTime t2);
+        static bool operator >=(DateTime t1, DateTime t2);
-        public static bool operator !=(DateTime d1, DateTime d2);
+        static bool operator !=(DateTime d1, DateTime d2);
-        public static bool operator <(DateTime t1, DateTime t2);
+        static bool operator <(DateTime t1, DateTime t2);
-        public static bool operator <=(DateTime t1, DateTime t2);
+        static bool operator <=(DateTime t1, DateTime t2);
-        public static TimeSpan operator -(DateTime d1, DateTime d2);
+        static TimeSpan operator -(DateTime d1, DateTime d2);
-        public static DateTime operator -(DateTime d, TimeSpan t);
+        static DateTime operator -(DateTime d, TimeSpan t);
+        static DateTime Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static DateTime Parse(string s, IFormatProvider? provider);
+        static DateTime Parse(string s, IFormatProvider? provider);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateTime result);
+        static bool TryParse(string? s, IFormatProvider? provider, out DateTime result);
     }
-    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct DateTimeOffset : IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>, IAdditiveIdentity<DateTimeOffset, TimeSpan>, IComparable, IComparable<DateTimeOffset>, IComparisonOperators<DateTimeOffset, DateTimeOffset>, IDeserializationCallback, IEqualityOperators<DateTimeOffset, DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable, IMinMaxValue<DateTimeOffset>, IParseable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParseable<DateTimeOffset>, ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>, ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset> {
+        static TimeSpan AdditiveIdentity { get; }
+        static DateTimeOffset System.IMinMaxValue<System.DateTimeOffset>.MaxValue { get; }
+        static DateTimeOffset System.IMinMaxValue<System.DateTimeOffset>.MinValue { get; }
-        public static DateTimeOffset operator +(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
+        static DateTimeOffset operator +(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
-        public static bool operator ==(DateTimeOffset left, DateTimeOffset right);
+        static bool operator ==(DateTimeOffset left, DateTimeOffset right);
-        public static bool operator >(DateTimeOffset left, DateTimeOffset right);
+        static bool operator >(DateTimeOffset left, DateTimeOffset right);
-        public static bool operator >=(DateTimeOffset left, DateTimeOffset right);
+        static bool operator >=(DateTimeOffset left, DateTimeOffset right);
-        public static bool operator !=(DateTimeOffset left, DateTimeOffset right);
+        static bool operator !=(DateTimeOffset left, DateTimeOffset right);
-        public static bool operator <(DateTimeOffset left, DateTimeOffset right);
+        static bool operator <(DateTimeOffset left, DateTimeOffset right);
-        public static bool operator <=(DateTimeOffset left, DateTimeOffset right);
+        static bool operator <=(DateTimeOffset left, DateTimeOffset right);
-        public static TimeSpan operator -(DateTimeOffset left, DateTimeOffset right);
+        static TimeSpan operator -(DateTimeOffset left, DateTimeOffset right);
-        public static DateTimeOffset operator -(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
+        static DateTimeOffset operator -(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
+        static DateTimeOffset Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static DateTimeOffset Parse(string input, IFormatProvider? formatProvider);
+        static DateTimeOffset Parse(string input, IFormatProvider? formatProvider);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out DateTimeOffset result);
+        static bool TryParse(string? s, IFormatProvider? provider, out DateTimeOffset result);
     }
-    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, IParseable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParseable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+        public static readonly decimal AdditiveIdentity;
+        public static readonly decimal MultiplicativeIdentity;
+        public static readonly decimal NegativeOne;
+        public byte Scale { get; }
+        static decimal System.IAdditiveIdentity<System.Decimal,System.Decimal>.AdditiveIdentity { get; }
+        static decimal System.IMinMaxValue<System.Decimal>.MaxValue { get; }
+        static decimal System.IMinMaxValue<System.Decimal>.MinValue { get; }
+        static decimal System.IMultiplicativeIdentity<System.Decimal,System.Decimal>.MultiplicativeIdentity { get; }
+        static decimal System.INumber<System.Decimal>.One { get; }
+        static decimal System.INumber<System.Decimal>.Zero { get; }
+        static decimal System.ISignedNumber<System.Decimal>.NegativeOne { get; }
+        static Decimal Abs(Decimal value);
+        static Decimal Clamp(Decimal value, Decimal min, Decimal max);
+        static Decimal Create<TOther>(TOther value);
+        static Decimal CreateSaturating<TOther>(TOther value);
+        static Decimal CreateTruncating<TOther>(TOther value);
+        static (decimal Quotient, decimal Remainder) DivRem(Decimal left, Decimal right);
+        static Decimal Max(Decimal x, Decimal y);
+        static Decimal Min(Decimal x, Decimal y);
-        public static Decimal operator +(Decimal d1, Decimal d2);
+        static Decimal operator +(Decimal d1, Decimal d2);
-        public static Decimal operator --(Decimal d);
+        static Decimal operator --(Decimal d);
-        public static Decimal operator /(Decimal d1, Decimal d2);
+        static Decimal operator /(Decimal d1, Decimal d2);
-        public static bool operator ==(Decimal d1, Decimal d2);
+        static bool operator ==(Decimal d1, Decimal d2);
-        public static bool operator >(Decimal d1, Decimal d2);
+        static bool operator >(Decimal d1, Decimal d2);
-        public static bool operator >=(Decimal d1, Decimal d2);
+        static bool operator >=(Decimal d1, Decimal d2);
-        public static Decimal operator ++(Decimal d);
+        static Decimal operator ++(Decimal d);
-        public static bool operator !=(Decimal d1, Decimal d2);
+        static bool operator !=(Decimal d1, Decimal d2);
-        public static bool operator <(Decimal d1, Decimal d2);
+        static bool operator <(Decimal d1, Decimal d2);
-        public static bool operator <=(Decimal d1, Decimal d2);
+        static bool operator <=(Decimal d1, Decimal d2);
-        public static Decimal operator %(Decimal d1, Decimal d2);
+        static Decimal operator %(Decimal d1, Decimal d2);
-        public static Decimal operator *(Decimal d1, Decimal d2);
+        static Decimal operator *(Decimal d1, Decimal d2);
-        public static Decimal operator -(Decimal d1, Decimal d2);
+        static Decimal operator -(Decimal d1, Decimal d2);
-        public static Decimal operator -(Decimal d);
+        static Decimal operator -(Decimal d);
-        public static Decimal operator +(Decimal d);
+        static Decimal operator +(Decimal d);
-        public static Decimal Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Number, IFormatProvider? provider = null);
+        static Decimal Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Number, IFormatProvider? provider = null);
+        static Decimal Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Decimal Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Decimal Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Decimal Parse(string s, IFormatProvider? provider);
+        static Decimal Parse(string s, IFormatProvider? provider);
+        static Decimal System.INumber<System.Decimal>.Sign(Decimal value);
+        static bool TryCreate<TOther>(TOther value, out Decimal result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Decimal result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Decimal result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Decimal result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Decimal result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Decimal result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Decimal result);
     }
-    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable, ISpanFormattable {
+    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPoint<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IFloatingPoint<double>, IFormattable, IIncrementOperators<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, IParseable<double>, ISignedNumber<double>, ISpanFormattable, ISpanParseable<double>, ISubtractionOperators<double, double, double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        public const double AdditiveIdentity = 0;
+        public const double E = 2.718281828459045;
+        public const double MultiplicativeIdentity = 1;
+        public const double NegativeOne = -1;
+        public const double NegativeZero = 0;
+        public const double One = 1;
+        public const double Pi = 3.141592653589793;
+        public const double Tau = 6.283185307179586;
+        public const double Zero = 0;
+        static double System.IAdditiveIdentity<System.Double,System.Double>.AdditiveIdentity { get; }
+        static double System.IFloatingPoint<System.Double>.E { get; }
+        static double System.IFloatingPoint<System.Double>.Epsilon { get; }
+        static double System.IFloatingPoint<System.Double>.NaN { get; }
+        static double System.IFloatingPoint<System.Double>.NegativeInfinity { get; }
+        static double System.IFloatingPoint<System.Double>.NegativeZero { get; }
+        static double System.IFloatingPoint<System.Double>.Pi { get; }
+        static double System.IFloatingPoint<System.Double>.PositiveInfinity { get; }
+        static double System.IFloatingPoint<System.Double>.Tau { get; }
+        static double System.IMinMaxValue<System.Double>.MaxValue { get; }
+        static double System.IMinMaxValue<System.Double>.MinValue { get; }
+        static double System.IMultiplicativeIdentity<System.Double,System.Double>.MultiplicativeIdentity { get; }
+        static double System.INumber<System.Double>.One { get; }
+        static double System.INumber<System.Double>.Zero { get; }
+        static double System.ISignedNumber<System.Double>.NegativeOne { get; }
+        static Double Abs(Double value);
+        static Double Acos(Double x);
+        static Double Acosh(Double x);
+        static Double Asin(Double x);
+        static Double Asinh(Double x);
+        static Double Atan(Double x);
+        static Double Atan2(Double y, Double x);
+        static Double Atanh(Double x);
+        static Double BitDecrement(Double x);
+        static Double BitIncrement(Double x);
+        static Double Cbrt(Double x);
+        static Double Ceiling(Double x);
+        static Double Clamp(Double value, Double min, Double max);
+        static Double CopySign(Double x, Double y);
+        static Double Cos(Double x);
+        static Double Cosh(Double x);
+        static Double Create<TOther>(TOther value);
+        static Double CreateSaturating<TOther>(TOther value);
+        static Double CreateTruncating<TOther>(TOther value);
+        static (double Quotient, double Remainder) DivRem(Double left, Double right);
+        static Double Exp(Double x);
+        static Double Floor(Double x);
+        static Double FusedMultiplyAdd(Double left, Double right, Double addend);
+        static Double IEEERemainder(Double left, Double right);
+        static TInteger ILogB<TInteger>(Double x);
-        public static bool IsFinite(Double d);
+        static bool IsFinite(Double d);
-        public static bool IsInfinity(Double d);
+        static bool IsInfinity(Double d);
-        public static bool IsNaN(Double d);
+        static bool IsNaN(Double d);
-        public static bool IsNegative(Double d);
+        static bool IsNegative(Double d);
-        public static bool IsNegativeInfinity(Double d);
+        static bool IsNegativeInfinity(Double d);
-        public static bool IsNormal(Double d);
+        static bool IsNormal(Double d);
-        public static bool IsPositiveInfinity(Double d);
+        static bool IsPositiveInfinity(Double d);
+        static bool IsPow2(Double value);
-        public static bool IsSubnormal(Double d);
+        static bool IsSubnormal(Double d);
+        static Double Log(Double x);
+        static Double Log(Double x, Double newBase);
+        static Double Log10(Double x);
+        static Double Log2(Double value);
+        static Double Max(Double x, Double y);
+        static Double MaxMagnitude(Double x, Double y);
+        static Double Min(Double x, Double y);
+        static Double MinMagnitude(Double x, Double y);
-        public static bool operator ==(Double left, Double right);
+        static bool operator ==(Double left, Double right);
-        public static bool operator >(Double left, Double right);
+        static bool operator >(Double left, Double right);
-        public static bool operator >=(Double left, Double right);
+        static bool operator >=(Double left, Double right);
-        public static bool operator !=(Double left, Double right);
+        static bool operator !=(Double left, Double right);
-        public static bool operator <(Double left, Double right);
+        static bool operator <(Double left, Double right);
-        public static bool operator <=(Double left, Double right);
+        static bool operator <=(Double left, Double right);
-        public static Double Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Double Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Double Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Double Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Double Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Double Parse(string s, IFormatProvider? provider);
+        static Double Parse(string s, IFormatProvider? provider);
+        static Double Pow(Double x, Double y);
+        static Double Round(Double x);
+        static Double Round(Double x, MidpointRounding mode);
+        static Double Round<TInteger>(Double x, TInteger digits);
+        static Double Round<TInteger>(Double x, TInteger digits, MidpointRounding mode);
+        static Double ScaleB<TInteger>(Double x, TInteger n);
+        static Double Sign(Double value);
+        static Double Sin(Double x);
+        static Double Sinh(Double x);
+        static Double Sqrt(Double x);
+        static Double System.IAdditionOperators<System.Double,System.Double,System.Double>.op_Addition(Double left, Double right);
+        static Double System.IBitwiseOperators<System.Double,System.Double,System.Double>.op_BitwiseAnd(Double left, Double right);
+        static Double System.IBitwiseOperators<System.Double,System.Double,System.Double>.op_BitwiseOr(Double left, Double right);
+        static Double System.IBitwiseOperators<System.Double,System.Double,System.Double>.op_ExclusiveOr(Double left, Double right);
+        static Double System.IBitwiseOperators<System.Double,System.Double,System.Double>.op_OnesComplement(Double value);
+        static Double System.IDecrementOperators<System.Double>.op_Decrement(Double value);
+        static Double System.IDivisionOperators<System.Double,System.Double,System.Double>.op_Division(Double left, Double right);
+        static Double System.IIncrementOperators<System.Double>.op_Increment(Double value);
+        static Double System.IModulusOperators<System.Double,System.Double,System.Double>.op_Modulus(Double left, Double right);
+        static Double System.IMultiplyOperators<System.Double,System.Double,System.Double>.op_Multiply(Double left, Double right);
+        static Double System.ISubtractionOperators<System.Double,System.Double,System.Double>.op_Subtraction(Double left, Double right);
+        static Double System.IUnaryNegationOperators<System.Double,System.Double>.op_UnaryNegation(Double value);
+        static Double System.IUnaryPlusOperators<System.Double,System.Double>.op_UnaryPlus(Double value);
+        static Double Tan(Double x);
+        static Double Tanh(Double x);
+        static Double Truncate(Double x);
+        static bool TryCreate<TOther>(TOther value, out Double result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Double result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Double result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Double result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Double result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Double result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Double result);
     }
-    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, ISpanFormattable {
+    public readonly struct Guid : IComparable, IComparable<Guid>, IComparisonOperators<Guid, Guid>, IEqualityOperators<Guid, Guid>, IEquatable<Guid>, IFormattable, IParseable<Guid>, ISpanFormattable, ISpanParseable<Guid> {
-        public static bool operator ==(Guid a, Guid b);
+        static bool operator ==(Guid a, Guid b);
+        static bool operator >(Guid left, Guid right);
+        static bool operator >=(Guid left, Guid right);
-        public static bool operator !=(Guid a, Guid b);
+        static bool operator !=(Guid a, Guid b);
+        static bool operator <(Guid left, Guid right);
+        static bool operator <=(Guid left, Guid right);
+        static Guid Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        static Guid Parse(string s, IFormatProvider? provider);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Guid result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Guid result);
     }
-    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable, ISpanFormattable {
+    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPoint<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IFloatingPoint<Half>, IFormattable, IIncrementOperators<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, IParseable<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParseable<Half>, ISubtractionOperators<Half, Half, Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        static Half AdditiveIdentity { get; }
+        static Half E { get; }
-        public static Half Epsilon { get; }
+        static Half Epsilon { get; }
-        public static Half MaxValue { get; }
+        static Half MaxValue { get; }
-        public static Half MinValue { get; }
+        static Half MinValue { get; }
+        static Half MultiplicativeIdentity { get; }
-        public static Half NaN { get; }
+        static Half NaN { get; }
-        public static Half NegativeInfinity { get; }
+        static Half NegativeInfinity { get; }
+        static Half NegativeOne { get; }
+        static Half NegativeZero { get; }
+        static Half One { get; }
+        static Half Pi { get; }
-        public static Half PositiveInfinity { get; }
+        static Half PositiveInfinity { get; }
+        static Half Tau { get; }
+        static Half Zero { get; }
+        static Half Abs(Half value);
+        static Half Acos(Half x);
+        static Half Acosh(Half x);
+        static Half Asin(Half x);
+        static Half Asinh(Half x);
+        static Half Atan(Half x);
+        static Half Atan2(Half y, Half x);
+        static Half Atanh(Half x);
+        static Half BitDecrement(Half x);
+        static Half BitIncrement(Half x);
+        static Half Cbrt(Half x);
+        static Half Ceiling(Half x);
+        static Half Clamp(Half value, Half min, Half max);
+        static Half CopySign(Half x, Half y);
+        static Half Cos(Half x);
+        static Half Cosh(Half x);
+        static Half Create<TOther>(TOther value);
+        static Half CreateSaturating<TOther>(TOther value);
+        static Half CreateTruncating<TOther>(TOther value);
+        static (Half Quotient, Half Remainder) DivRem(Half left, Half right);
+        static Half Exp(Half x);
+        static Half Floor(Half x);
+        static Half FusedMultiplyAdd(Half left, Half right, Half addend);
+        static Half IEEERemainder(Half left, Half right);
+        static TInteger ILogB<TInteger>(Half x);
-        public static bool IsFinite(Half value);
+        static bool IsFinite(Half value);
-        public static bool IsInfinity(Half value);
+        static bool IsInfinity(Half value);
-        public static bool IsNaN(Half value);
+        static bool IsNaN(Half value);
-        public static bool IsNegative(Half value);
+        static bool IsNegative(Half value);
-        public static bool IsNegativeInfinity(Half value);
+        static bool IsNegativeInfinity(Half value);
-        public static bool IsNormal(Half value);
+        static bool IsNormal(Half value);
-        public static bool IsPositiveInfinity(Half value);
+        static bool IsPositiveInfinity(Half value);
+        static bool IsPow2(Half value);
-        public static bool IsSubnormal(Half value);
+        static bool IsSubnormal(Half value);
+        static Half Log(Half x);
+        static Half Log(Half x, Half newBase);
+        static Half Log10(Half x);
+        static Half Log2(Half value);
+        static Half Max(Half x, Half y);
+        static Half MaxMagnitude(Half x, Half y);
+        static Half Min(Half x, Half y);
+        static Half MinMagnitude(Half x, Half y);
+        static Half operator +(Half left, Half right);
+        static Half operator --(Half value);
+        static Half operator /(Half left, Half right);
-        public static bool operator ==(Half left, Half right);
+        static bool operator ==(Half left, Half right);
-        public static bool operator >(Half left, Half right);
+        static bool operator >(Half left, Half right);
-        public static bool operator >=(Half left, Half right);
+        static bool operator >=(Half left, Half right);
+        static Half operator ++(Half value);
-        public static bool operator !=(Half left, Half right);
+        static bool operator !=(Half left, Half right);
-        public static bool operator <(Half left, Half right);
+        static bool operator <(Half left, Half right);
-        public static bool operator <=(Half left, Half right);
+        static bool operator <=(Half left, Half right);
+        static Half operator %(Half left, Half right);
+        static Half operator *(Half left, Half right);
+        static Half operator -(Half left, Half right);
+        static Half operator -(Half value);
+        static Half operator +(Half value);
-        public static Half Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Half Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Half Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Half Parse(string s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Half Parse(string s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
-        public static Half Parse(string s, IFormatProvider? provider);
+        static Half Parse(string s, IFormatProvider? provider);
+        static Half Pow(Half x, Half y);
+        static Half Round(Half x);
+        static Half Round(Half x, MidpointRounding mode);
+        static Half Round<TInteger>(Half x, TInteger digits);
+        static Half Round<TInteger>(Half x, TInteger digits, MidpointRounding mode);
+        static Half ScaleB<TInteger>(Half x, TInteger n);
+        static Half Sign(Half value);
+        static Half Sin(Half x);
+        static Half Sinh(Half x);
+        static Half Sqrt(Half x);
+        static Half System.IBitwiseOperators<System.Half,System.Half,System.Half>.op_BitwiseAnd(Half left, Half right);
+        static Half System.IBitwiseOperators<System.Half,System.Half,System.Half>.op_BitwiseOr(Half left, Half right);
+        static Half System.IBitwiseOperators<System.Half,System.Half,System.Half>.op_ExclusiveOr(Half left, Half right);
+        static Half System.IBitwiseOperators<System.Half,System.Half,System.Half>.op_OnesComplement(Half value);
+        static Half Tan(Half x);
+        static Half Tanh(Half x);
+        static Half Truncate(Half x);
+        static bool TryCreate<TOther>(TOther value, out Half result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Half result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Half result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Half result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Half result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Half result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Half result);
     }
+    public interface IAdditionOperators<TSelf, TOther, TResult> where TSelf : IAdditionOperators<TSelf, TOther, TResult> {
+        TResult operator +(TSelf left, TOther right);
+    }
+    public interface IAdditiveIdentity<TSelf, TResult> where TSelf : IAdditiveIdentity<TSelf, TResult> {
+        TResult AdditiveIdentity { get; }
+    }
+    public interface IBinaryFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFloatingPoint<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryFloatingPoint<TSelf>
+    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, IShiftOperators<TSelf, TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf> {
+        TSelf LeadingZeroCount(TSelf value);
+        TSelf PopCount(TSelf value);
+        TSelf RotateLeft(TSelf value, int rotateAmount);
+        TSelf RotateRight(TSelf value, int rotateAmount);
+        TSelf TrailingZeroCount(TSelf value);
+    }
+    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryNumber<TSelf> {
+        bool IsPow2(TSelf value);
+        TSelf Log2(TSelf value);
+    }
+    public interface IBitwiseOperators<TSelf, TOther, TResult> where TSelf : IBitwiseOperators<TSelf, TOther, TResult> {
+        TResult operator &(TSelf left, TOther right);
+        TResult operator |(TSelf left, TOther right);
+        TResult operator ^(TSelf left, TOther right);
+        TResult operator ~(TSelf value);
+    }
+    public interface IComparisonOperators<TSelf, TOther> : IComparable, IComparable<TOther>, IEqualityOperators<TSelf, TOther>, IEquatable<TOther> where TSelf : IComparisonOperators<TSelf, TOther> {
+        bool operator >(TSelf left, TOther right);
+        bool operator >=(TSelf left, TOther right);
+        bool operator <(TSelf left, TOther right);
+        bool operator <=(TSelf left, TOther right);
+    }
+    public interface IDecrementOperators<TSelf> where TSelf : IDecrementOperators<TSelf> {
+        TSelf operator --(TSelf value);
+    }
+    public interface IDivisionOperators<TSelf, TOther, TResult> where TSelf : IDivisionOperators<TSelf, TOther, TResult> {
+        TResult operator /(TSelf left, TOther right);
+    }
+    public interface IEqualityOperators<TSelf, TOther> : IEquatable<TOther> where TSelf : IEqualityOperators<TSelf, TOther> {
+        bool operator ==(TSelf left, TOther right);
+        bool operator !=(TSelf left, TOther right);
+    }
+    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf> {
+        TSelf E { get; }
+        TSelf Epsilon { get; }
+        TSelf NaN { get; }
+        TSelf NegativeInfinity { get; }
+        TSelf NegativeZero { get; }
+        TSelf Pi { get; }
+        TSelf PositiveInfinity { get; }
+        TSelf Tau { get; }
+        TSelf Acos(TSelf x);
+        TSelf Acosh(TSelf x);
+        TSelf Asin(TSelf x);
+        TSelf Asinh(TSelf x);
+        TSelf Atan(TSelf x);
+        TSelf Atan2(TSelf y, TSelf x);
+        TSelf Atanh(TSelf x);
+        TSelf BitDecrement(TSelf x);
+        TSelf BitIncrement(TSelf x);
+        TSelf Cbrt(TSelf x);
+        TSelf Ceiling(TSelf x);
+        TSelf CopySign(TSelf x, TSelf y);
+        TSelf Cos(TSelf x);
+        TSelf Cosh(TSelf x);
+        TSelf Exp(TSelf x);
+        TSelf Floor(TSelf x);
+        TSelf FusedMultiplyAdd(TSelf left, TSelf right, TSelf addend);
+        TSelf IEEERemainder(TSelf left, TSelf right);
+        TInteger ILogB<TInteger>(TSelf x);
+        bool IsFinite(TSelf value);
+        bool IsInfinity(TSelf value);
+        bool IsNaN(TSelf value);
+        bool IsNegative(TSelf value);
+        bool IsNegativeInfinity(TSelf value);
+        bool IsNormal(TSelf value);
+        bool IsPositiveInfinity(TSelf value);
+        bool IsSubnormal(TSelf value);
+        TSelf Log(TSelf x);
+        TSelf Log(TSelf x, TSelf newBase);
+        TSelf Log10(TSelf x);
+        TSelf Log2(TSelf x);
+        TSelf MaxMagnitude(TSelf x, TSelf y);
+        TSelf MinMagnitude(TSelf x, TSelf y);
+        TSelf Pow(TSelf x, TSelf y);
+        TSelf Round(TSelf x);
+        TSelf Round(TSelf x, MidpointRounding mode);
+        TSelf Round<TInteger>(TSelf x, TInteger digits);
+        TSelf Round<TInteger>(TSelf x, TInteger digits, MidpointRounding mode);
+        TSelf ScaleB<TInteger>(TSelf x, TInteger n);
+        TSelf Sin(TSelf x);
+        TSelf Sinh(TSelf x);
+        TSelf Sqrt(TSelf x);
+        TSelf Tan(TSelf x);
+        TSelf Tanh(TSelf x);
+        TSelf Truncate(TSelf x);
+    }
+    public interface IIncrementOperators<TSelf> where TSelf : IIncrementOperators<TSelf> {
+        TSelf operator ++(TSelf value);
+    }
+    public interface IMinMaxValue<TSelf> where TSelf : IMinMaxValue<TSelf> {
+        TSelf MaxValue { get; }
+        TSelf MinValue { get; }
+    }
+    public interface IModulusOperators<TSelf, TOther, TResult> where TSelf : IModulusOperators<TSelf, TOther, TResult> {
+        TResult operator %(TSelf left, TOther right);
+    }
+    public interface IMultiplicativeIdentity<TSelf, TResult> where TSelf : IMultiplicativeIdentity<TSelf, TResult> {
+        TResult MultiplicativeIdentity { get; }
+    }
+    public interface IMultiplyOperators<TSelf, TOther, TResult> where TSelf : IMultiplyOperators<TSelf, TOther, TResult> {
+        TResult operator *(TSelf left, TOther right);
+    }
-    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable, ISpanFormattable {
+    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, IParseable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParseable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+        public const short AdditiveIdentity = (short)0;
+        public const short MultiplicativeIdentity = (short)1;
+        public const short NegativeOne = (short)-1;
+        public const short One = (short)1;
+        public const short Zero = (short)0;
+        static short System.IAdditiveIdentity<System.Int16,System.Int16>.AdditiveIdentity { get; }
+        static short System.IMinMaxValue<System.Int16>.MaxValue { get; }
+        static short System.IMinMaxValue<System.Int16>.MinValue { get; }
+        static short System.IMultiplicativeIdentity<System.Int16,System.Int16>.MultiplicativeIdentity { get; }
+        static short System.INumber<System.Int16>.One { get; }
+        static short System.INumber<System.Int16>.Zero { get; }
+        static short System.ISignedNumber<System.Int16>.NegativeOne { get; }
+        static Int16 Abs(Int16 value);
+        static Int16 Clamp(Int16 value, Int16 min, Int16 max);
+        static Int16 Create<TOther>(TOther value);
+        static Int16 CreateSaturating<TOther>(TOther value);
+        static Int16 CreateTruncating<TOther>(TOther value);
+        static (short Quotient, short Remainder) DivRem(Int16 left, Int16 right);
+        static bool IsPow2(Int16 value);
+        static Int16 LeadingZeroCount(Int16 value);
+        static Int16 Log2(Int16 value);
+        static Int16 Max(Int16 x, Int16 y);
+        static Int16 Min(Int16 x, Int16 y);
-        public static Int16 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int16 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int16 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Int16 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Int16 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Int16 Parse(string s, IFormatProvider? provider);
+        static Int16 Parse(string s, IFormatProvider? provider);
+        static Int16 PopCount(Int16 value);
+        static Int16 RotateLeft(Int16 value, int rotateAmount);
+        static Int16 RotateRight(Int16 value, int rotateAmount);
+        static Int16 Sign(Int16 value);
+        static Int16 System.IAdditionOperators<System.Int16,System.Int16,System.Int16>.op_Addition(Int16 left, Int16 right);
+        static Int16 System.IBitwiseOperators<System.Int16,System.Int16,System.Int16>.op_BitwiseAnd(Int16 left, Int16 right);
+        static Int16 System.IBitwiseOperators<System.Int16,System.Int16,System.Int16>.op_BitwiseOr(Int16 left, Int16 right);
+        static Int16 System.IBitwiseOperators<System.Int16,System.Int16,System.Int16>.op_ExclusiveOr(Int16 left, Int16 right);
+        static Int16 System.IBitwiseOperators<System.Int16,System.Int16,System.Int16>.op_OnesComplement(Int16 value);
+        static bool System.IComparisonOperators<System.Int16,System.Int16>.op_GreaterThan(Int16 left, Int16 right);
+        static bool System.IComparisonOperators<System.Int16,System.Int16>.op_GreaterThanOrEqual(Int16 left, Int16 right);
+        static bool System.IComparisonOperators<System.Int16,System.Int16>.op_LessThan(Int16 left, Int16 right);
+        static bool System.IComparisonOperators<System.Int16,System.Int16>.op_LessThanOrEqual(Int16 left, Int16 right);
+        static Int16 System.IDecrementOperators<System.Int16>.op_Decrement(Int16 value);
+        static Int16 System.IDivisionOperators<System.Int16,System.Int16,System.Int16>.op_Division(Int16 left, Int16 right);
+        static bool System.IEqualityOperators<System.Int16,System.Int16>.op_Equality(Int16 left, Int16 right);
+        static bool System.IEqualityOperators<System.Int16,System.Int16>.op_Inequality(Int16 left, Int16 right);
+        static Int16 System.IIncrementOperators<System.Int16>.op_Increment(Int16 value);
+        static Int16 System.IModulusOperators<System.Int16,System.Int16,System.Int16>.op_Modulus(Int16 left, Int16 right);
+        static Int16 System.IMultiplyOperators<System.Int16,System.Int16,System.Int16>.op_Multiply(Int16 left, Int16 right);
+        static Int16 System.IShiftOperators<System.Int16,System.Int16>.op_LeftShift(Int16 value, int shiftAmount);
+        static Int16 System.IShiftOperators<System.Int16,System.Int16>.op_RightShift(Int16 value, int shiftAmount);
+        static Int16 System.ISubtractionOperators<System.Int16,System.Int16,System.Int16>.op_Subtraction(Int16 left, Int16 right);
+        static Int16 System.IUnaryNegationOperators<System.Int16,System.Int16>.op_UnaryNegation(Int16 value);
+        static Int16 System.IUnaryPlusOperators<System.Int16,System.Int16>.op_UnaryPlus(Int16 value);
+        static Int16 TrailingZeroCount(Int16 value);
+        static bool TryCreate<TOther>(TOther value, out Int16 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int16 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int16 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Int16 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int16 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int16 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Int16 result);
     }
-    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable, ISpanFormattable {
+    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, IParseable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParseable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+        public const int AdditiveIdentity = 0;
+        public const int MultiplicativeIdentity = 1;
+        public const int NegativeOne = -1;
+        public const int One = 1;
+        public const int Zero = 0;
+        static int System.IAdditiveIdentity<System.Int32,System.Int32>.AdditiveIdentity { get; }
+        static int System.IMinMaxValue<System.Int32>.MaxValue { get; }
+        static int System.IMinMaxValue<System.Int32>.MinValue { get; }
+        static int System.IMultiplicativeIdentity<System.Int32,System.Int32>.MultiplicativeIdentity { get; }
+        static int System.INumber<System.Int32>.One { get; }
+        static int System.INumber<System.Int32>.Zero { get; }
+        static int System.ISignedNumber<System.Int32>.NegativeOne { get; }
+        static Int32 Abs(Int32 value);
+        static Int32 Clamp(Int32 value, Int32 min, Int32 max);
+        static Int32 Create<TOther>(TOther value);
+        static Int32 CreateSaturating<TOther>(TOther value);
+        static Int32 CreateTruncating<TOther>(TOther value);
+        static (int Quotient, int Remainder) DivRem(Int32 left, Int32 right);
+        static bool IsPow2(Int32 value);
+        static Int32 LeadingZeroCount(Int32 value);
+        static Int32 Log2(Int32 value);
+        static Int32 Max(Int32 x, Int32 y);
+        static Int32 Min(Int32 x, Int32 y);
-        public static Int32 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int32 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int32 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Int32 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Int32 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Int32 Parse(string s, IFormatProvider? provider);
+        static Int32 Parse(string s, IFormatProvider? provider);
+        static Int32 PopCount(Int32 value);
+        static Int32 RotateLeft(Int32 value, Int32 rotateAmount);
+        static Int32 RotateRight(Int32 value, Int32 rotateAmount);
+        static Int32 Sign(Int32 value);
+        static Int32 System.IAdditionOperators<System.Int32,System.Int32,System.Int32>.op_Addition(Int32 left, Int32 right);
+        static Int32 System.IBitwiseOperators<System.Int32,System.Int32,System.Int32>.op_BitwiseAnd(Int32 left, Int32 right);
+        static Int32 System.IBitwiseOperators<System.Int32,System.Int32,System.Int32>.op_BitwiseOr(Int32 left, Int32 right);
+        static Int32 System.IBitwiseOperators<System.Int32,System.Int32,System.Int32>.op_ExclusiveOr(Int32 left, Int32 right);
+        static Int32 System.IBitwiseOperators<System.Int32,System.Int32,System.Int32>.op_OnesComplement(Int32 value);
+        static bool System.IComparisonOperators<System.Int32,System.Int32>.op_GreaterThan(Int32 left, Int32 right);
+        static bool System.IComparisonOperators<System.Int32,System.Int32>.op_GreaterThanOrEqual(Int32 left, Int32 right);
+        static bool System.IComparisonOperators<System.Int32,System.Int32>.op_LessThan(Int32 left, Int32 right);
+        static bool System.IComparisonOperators<System.Int32,System.Int32>.op_LessThanOrEqual(Int32 left, Int32 right);
+        static Int32 System.IDecrementOperators<System.Int32>.op_Decrement(Int32 value);
+        static Int32 System.IDivisionOperators<System.Int32,System.Int32,System.Int32>.op_Division(Int32 left, Int32 right);
+        static bool System.IEqualityOperators<System.Int32,System.Int32>.op_Equality(Int32 left, Int32 right);
+        static bool System.IEqualityOperators<System.Int32,System.Int32>.op_Inequality(Int32 left, Int32 right);
+        static Int32 System.IIncrementOperators<System.Int32>.op_Increment(Int32 value);
+        static Int32 System.IModulusOperators<System.Int32,System.Int32,System.Int32>.op_Modulus(Int32 left, Int32 right);
+        static Int32 System.IMultiplyOperators<System.Int32,System.Int32,System.Int32>.op_Multiply(Int32 left, Int32 right);
+        static Int32 System.IShiftOperators<System.Int32,System.Int32>.op_LeftShift(Int32 value, Int32 shiftAmount);
+        static Int32 System.IShiftOperators<System.Int32,System.Int32>.op_RightShift(Int32 value, Int32 shiftAmount);
+        static Int32 System.ISubtractionOperators<System.Int32,System.Int32,System.Int32>.op_Subtraction(Int32 left, Int32 right);
+        static Int32 System.IUnaryNegationOperators<System.Int32,System.Int32>.op_UnaryNegation(Int32 value);
+        static Int32 System.IUnaryPlusOperators<System.Int32,System.Int32>.op_UnaryPlus(Int32 value);
+        static Int32 TrailingZeroCount(Int32 value);
+        static bool TryCreate<TOther>(TOther value, out Int32 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int32 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int32 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Int32 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int32 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int32 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Int32 result);
     }
-    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable, ISpanFormattable {
+    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, IParseable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParseable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+        public const long AdditiveIdentity = (long)0;
+        public const long MultiplicativeIdentity = (long)1;
+        public const long NegativeOne = (long)-1;
+        public const long One = (long)1;
+        public const long Zero = (long)0;
+        static long System.IAdditiveIdentity<System.Int64,System.Int64>.AdditiveIdentity { get; }
+        static long System.IMinMaxValue<System.Int64>.MaxValue { get; }
+        static long System.IMinMaxValue<System.Int64>.MinValue { get; }
+        static long System.IMultiplicativeIdentity<System.Int64,System.Int64>.MultiplicativeIdentity { get; }
+        static long System.INumber<System.Int64>.One { get; }
+        static long System.INumber<System.Int64>.Zero { get; }
+        static long System.ISignedNumber<System.Int64>.NegativeOne { get; }
+        static Int64 Abs(Int64 value);
+        static Int64 Clamp(Int64 value, Int64 min, Int64 max);
+        static Int64 Create<TOther>(TOther value);
+        static Int64 CreateSaturating<TOther>(TOther value);
+        static Int64 CreateTruncating<TOther>(TOther value);
+        static (long Quotient, long Remainder) DivRem(Int64 left, Int64 right);
+        static bool IsPow2(Int64 value);
+        static Int64 LeadingZeroCount(Int64 value);
+        static Int64 Log2(Int64 value);
+        static Int64 Max(Int64 x, Int64 y);
+        static Int64 Min(Int64 x, Int64 y);
-        public static Int64 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int64 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static Int64 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Int64 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Int64 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Int64 Parse(string s, IFormatProvider? provider);
+        static Int64 Parse(string s, IFormatProvider? provider);
+        static Int64 PopCount(Int64 value);
+        static Int64 RotateLeft(Int64 value, int rotateAmount);
+        static Int64 RotateRight(Int64 value, int rotateAmount);
+        static Int64 Sign(Int64 value);
+        static Int64 System.IAdditionOperators<System.Int64,System.Int64,System.Int64>.op_Addition(Int64 left, Int64 right);
+        static Int64 System.IBitwiseOperators<System.Int64,System.Int64,System.Int64>.op_BitwiseAnd(Int64 left, Int64 right);
+        static Int64 System.IBitwiseOperators<System.Int64,System.Int64,System.Int64>.op_BitwiseOr(Int64 left, Int64 right);
+        static Int64 System.IBitwiseOperators<System.Int64,System.Int64,System.Int64>.op_ExclusiveOr(Int64 left, Int64 right);
+        static Int64 System.IBitwiseOperators<System.Int64,System.Int64,System.Int64>.op_OnesComplement(Int64 value);
+        static bool System.IComparisonOperators<System.Int64,System.Int64>.op_GreaterThan(Int64 left, Int64 right);
+        static bool System.IComparisonOperators<System.Int64,System.Int64>.op_GreaterThanOrEqual(Int64 left, Int64 right);
+        static bool System.IComparisonOperators<System.Int64,System.Int64>.op_LessThan(Int64 left, Int64 right);
+        static bool System.IComparisonOperators<System.Int64,System.Int64>.op_LessThanOrEqual(Int64 left, Int64 right);
+        static Int64 System.IDecrementOperators<System.Int64>.op_Decrement(Int64 value);
+        static Int64 System.IDivisionOperators<System.Int64,System.Int64,System.Int64>.op_Division(Int64 left, Int64 right);
+        static bool System.IEqualityOperators<System.Int64,System.Int64>.op_Equality(Int64 left, Int64 right);
+        static bool System.IEqualityOperators<System.Int64,System.Int64>.op_Inequality(Int64 left, Int64 right);
+        static Int64 System.IIncrementOperators<System.Int64>.op_Increment(Int64 value);
+        static Int64 System.IModulusOperators<System.Int64,System.Int64,System.Int64>.op_Modulus(Int64 left, Int64 right);
+        static Int64 System.IMultiplyOperators<System.Int64,System.Int64,System.Int64>.op_Multiply(Int64 left, Int64 right);
+        static Int64 System.IShiftOperators<System.Int64,System.Int64>.op_LeftShift(Int64 value, int shiftAmount);
+        static Int64 System.IShiftOperators<System.Int64,System.Int64>.op_RightShift(Int64 value, int shiftAmount);
+        static Int64 System.ISubtractionOperators<System.Int64,System.Int64,System.Int64>.op_Subtraction(Int64 left, Int64 right);
+        static Int64 System.IUnaryNegationOperators<System.Int64,System.Int64>.op_UnaryNegation(Int64 value);
+        static Int64 System.IUnaryPlusOperators<System.Int64,System.Int64>.op_UnaryPlus(Int64 value);
+        static Int64 TrailingZeroCount(Int64 value);
+        static bool TryCreate<TOther>(TOther value, out Int64 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int64 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int64 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Int64 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int64 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int64 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Int64 result);
     }
-    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, IParseable<IntPtr>, ISerializable, IShiftOperators<IntPtr, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParseable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+        static IntPtr System.IAdditiveIdentity<nint,nint>.AdditiveIdentity { get; }
+        static IntPtr System.IMinMaxValue<nint>.MaxValue { get; }
+        static IntPtr System.IMinMaxValue<nint>.MinValue { get; }
+        static IntPtr System.IMultiplicativeIdentity<nint,nint>.MultiplicativeIdentity { get; }
+        static IntPtr System.INumber<nint>.One { get; }
+        static IntPtr System.INumber<nint>.Zero { get; }
+        static IntPtr System.ISignedNumber<nint>.NegativeOne { get; }
-        public static bool operator ==(IntPtr value1, IntPtr value2);
+        static bool operator ==(IntPtr value1, IntPtr value2);
-        public static bool operator !=(IntPtr value1, IntPtr value2);
+        static bool operator !=(IntPtr value1, IntPtr value2);
-        public static IntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static IntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static IntPtr Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static IntPtr Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static IntPtr Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static IntPtr Parse(string s, IFormatProvider? provider);
+        static IntPtr Parse(string s, IFormatProvider? provider);
+        static IntPtr System.IAdditionOperators<nint,nint,nint>.op_Addition(IntPtr left, IntPtr right);
+        static IntPtr System.IBinaryInteger<nint>.LeadingZeroCount(IntPtr value);
+        static IntPtr System.IBinaryInteger<nint>.PopCount(IntPtr value);
+        static IntPtr System.IBinaryInteger<nint>.RotateLeft(IntPtr value, int rotateAmount);
+        static IntPtr System.IBinaryInteger<nint>.RotateRight(IntPtr value, int rotateAmount);
+        static IntPtr System.IBinaryInteger<nint>.TrailingZeroCount(IntPtr value);
+        static bool System.IBinaryNumber<nint>.IsPow2(IntPtr value);
+        static IntPtr System.IBinaryNumber<nint>.Log2(IntPtr value);
+        static IntPtr System.IBitwiseOperators<nint,nint,nint>.op_BitwiseAnd(IntPtr left, IntPtr right);
+        static IntPtr System.IBitwiseOperators<nint,nint,nint>.op_BitwiseOr(IntPtr left, IntPtr right);
+        static IntPtr System.IBitwiseOperators<nint,nint,nint>.op_ExclusiveOr(IntPtr left, IntPtr right);
+        static IntPtr System.IBitwiseOperators<nint,nint,nint>.op_OnesComplement(IntPtr value);
+        static bool System.IComparisonOperators<nint,nint>.op_GreaterThan(IntPtr left, IntPtr right);
+        static bool System.IComparisonOperators<nint,nint>.op_GreaterThanOrEqual(IntPtr left, IntPtr right);
+        static bool System.IComparisonOperators<nint,nint>.op_LessThan(IntPtr left, IntPtr right);
+        static bool System.IComparisonOperators<nint,nint>.op_LessThanOrEqual(IntPtr left, IntPtr right);
+        static IntPtr System.IDecrementOperators<nint>.op_Decrement(IntPtr value);
+        static IntPtr System.IDivisionOperators<nint,nint,nint>.op_Division(IntPtr left, IntPtr right);
+        static IntPtr System.IIncrementOperators<nint>.op_Increment(IntPtr value);
+        static IntPtr System.IModulusOperators<nint,nint,nint>.op_Modulus(IntPtr left, IntPtr right);
+        static IntPtr System.IMultiplyOperators<nint,nint,nint>.op_Multiply(IntPtr left, IntPtr right);
+        static IntPtr System.INumber<nint>.Abs(IntPtr value);
+        static IntPtr System.INumber<nint>.Clamp(IntPtr value, IntPtr min, IntPtr max);
+        static IntPtr System.INumber<nint>.Create<TOther>(TOther value);
+        static IntPtr System.INumber<nint>.CreateSaturating<TOther>(TOther value);
+        static IntPtr System.INumber<nint>.CreateTruncating<TOther>(TOther value);
+        static (IntPtr Quotient, IntPtr Remainder) System.INumber<nint>.DivRem(IntPtr left, IntPtr right);
+        static IntPtr System.INumber<nint>.Max(IntPtr x, IntPtr y);
+        static IntPtr System.INumber<nint>.Min(IntPtr x, IntPtr y);
+        static IntPtr System.INumber<nint>.Sign(IntPtr value);
+        static bool System.INumber<nint>.TryCreate<TOther>(TOther value, out IntPtr result);
+        static IntPtr System.IShiftOperators<nint,nint>.op_LeftShift(IntPtr value, int shiftAmount);
+        static IntPtr System.IShiftOperators<nint,nint>.op_RightShift(IntPtr value, int shiftAmount);
+        static IntPtr System.ISubtractionOperators<nint,nint,nint>.op_Subtraction(IntPtr left, IntPtr right);
+        static IntPtr System.IUnaryNegationOperators<nint,nint>.op_UnaryNegation(IntPtr value);
+        static IntPtr System.IUnaryPlusOperators<nint,nint>.op_UnaryPlus(IntPtr value);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out IntPtr result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out IntPtr result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out IntPtr result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out IntPtr result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out IntPtr result);
+        static bool TryParse(string? s, IFormatProvider? provider, out IntPtr result);
     }
+    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf> {
+        TSelf One { get; }
+        TSelf Zero { get; }
+        TSelf Abs(TSelf value);
+        TSelf Clamp(TSelf value, TSelf min, TSelf max);
+        TSelf Create<TOther>(TOther value);
+        TSelf CreateSaturating<TOther>(TOther value);
+        TSelf CreateTruncating<TOther>(TOther value);
+        (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);
+        TSelf Max(TSelf x, TSelf y);
+        TSelf Min(TSelf x, TSelf y);
+        TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);
+        TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);
+        TSelf Sign(TSelf value);
+        bool TryCreate<TOther>(TOther value, out TSelf result);
+        bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out TSelf result);
+        bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out TSelf result);
+    }
+    public interface IParseable<TSelf> where TSelf : IParseable<TSelf> {
+        TSelf Parse(string s, IFormatProvider? provider);
+        bool TryParse(string? s, IFormatProvider? provider, out TSelf result);
+    }
+    public interface IShiftOperators<TSelf, TResult> where TSelf : IShiftOperators<TSelf, TResult> {
+        TResult operator <<(TSelf value, int shiftAmount);
+        TResult operator >>(TSelf value, int shiftAmount);
+    }
+    public interface ISignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ISignedNumber<TSelf> {
+        TSelf NegativeOne { get; }
+    }
+    public interface ISpanParseable<TSelf> : IParseable<TSelf> where TSelf : ISpanParseable<TSelf> {
+        TSelf Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out TSelf result);
+    }
+    public interface ISubtractionOperators<TSelf, TOther, TResult> where TSelf : ISubtractionOperators<TSelf, TOther, TResult> {
+        TResult operator -(TSelf left, TOther right);
+    }
+    public interface IUnaryNegationOperators<TSelf, TResult> where TSelf : IUnaryNegationOperators<TSelf, TResult> {
+        TResult operator -(TSelf value);
+    }
+    public interface IUnaryPlusOperators<TSelf, TResult> where TSelf : IUnaryPlusOperators<TSelf, TResult> {
+        TResult operator +(TSelf value);
+    }
+    public interface IUnsignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IUnsignedNumber<TSelf>
     public static class Nullable {
+        public static ref readonly T GetValueRefOrDefaultRef<T>(in T? nullable) where T : struct;
     }
-    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable, ISpanFormattable {
+    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, IParseable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParseable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+        public const sbyte AdditiveIdentity = (sbyte)0;
+        public const sbyte MultiplicativeIdentity = (sbyte)1;
+        public const sbyte NegativeOne = (sbyte)-1;
+        public const sbyte One = (sbyte)1;
+        public const sbyte Zero = (sbyte)0;
+        static sbyte System.IAdditiveIdentity<System.SByte,System.SByte>.AdditiveIdentity { get; }
+        static sbyte System.IMinMaxValue<System.SByte>.MaxValue { get; }
+        static sbyte System.IMinMaxValue<System.SByte>.MinValue { get; }
+        static sbyte System.IMultiplicativeIdentity<System.SByte,System.SByte>.MultiplicativeIdentity { get; }
+        static sbyte System.INumber<System.SByte>.One { get; }
+        static sbyte System.INumber<System.SByte>.Zero { get; }
+        static sbyte System.ISignedNumber<System.SByte>.NegativeOne { get; }
+        static SByte Abs(SByte value);
+        static SByte Clamp(SByte value, SByte min, SByte max);
+        static SByte Create<TOther>(TOther value);
+        static SByte CreateSaturating<TOther>(TOther value);
+        static SByte CreateTruncating<TOther>(TOther value);
+        static (sbyte Quotient, sbyte Remainder) DivRem(SByte left, SByte right);
+        static bool IsPow2(SByte value);
+        static SByte LeadingZeroCount(SByte value);
+        static SByte Log2(SByte value);
+        static SByte Max(SByte x, SByte y);
+        static SByte Min(SByte x, SByte y);
-        public static SByte Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static SByte Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static SByte Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static SByte Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static SByte Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static SByte Parse(string s, IFormatProvider? provider);
+        static SByte Parse(string s, IFormatProvider? provider);
+        static SByte PopCount(SByte value);
+        static SByte RotateLeft(SByte value, int rotateAmount);
+        static SByte RotateRight(SByte value, int rotateAmount);
+        static SByte Sign(SByte value);
+        static SByte System.IAdditionOperators<System.SByte,System.SByte,System.SByte>.op_Addition(SByte left, SByte right);
+        static SByte System.IBitwiseOperators<System.SByte,System.SByte,System.SByte>.op_BitwiseAnd(SByte left, SByte right);
+        static SByte System.IBitwiseOperators<System.SByte,System.SByte,System.SByte>.op_BitwiseOr(SByte left, SByte right);
+        static SByte System.IBitwiseOperators<System.SByte,System.SByte,System.SByte>.op_ExclusiveOr(SByte left, SByte right);
+        static SByte System.IBitwiseOperators<System.SByte,System.SByte,System.SByte>.op_OnesComplement(SByte value);
+        static bool System.IComparisonOperators<System.SByte,System.SByte>.op_GreaterThan(SByte left, SByte right);
+        static bool System.IComparisonOperators<System.SByte,System.SByte>.op_GreaterThanOrEqual(SByte left, SByte right);
+        static bool System.IComparisonOperators<System.SByte,System.SByte>.op_LessThan(SByte left, SByte right);
+        static bool System.IComparisonOperators<System.SByte,System.SByte>.op_LessThanOrEqual(SByte left, SByte right);
+        static SByte System.IDecrementOperators<System.SByte>.op_Decrement(SByte value);
+        static SByte System.IDivisionOperators<System.SByte,System.SByte,System.SByte>.op_Division(SByte left, SByte right);
+        static bool System.IEqualityOperators<System.SByte,System.SByte>.op_Equality(SByte left, SByte right);
+        static bool System.IEqualityOperators<System.SByte,System.SByte>.op_Inequality(SByte left, SByte right);
+        static SByte System.IIncrementOperators<System.SByte>.op_Increment(SByte value);
+        static SByte System.IModulusOperators<System.SByte,System.SByte,System.SByte>.op_Modulus(SByte left, SByte right);
+        static SByte System.IMultiplyOperators<System.SByte,System.SByte,System.SByte>.op_Multiply(SByte left, SByte right);
+        static SByte System.IShiftOperators<System.SByte,System.SByte>.op_LeftShift(SByte value, int shiftAmount);
+        static SByte System.IShiftOperators<System.SByte,System.SByte>.op_RightShift(SByte value, int shiftAmount);
+        static SByte System.ISubtractionOperators<System.SByte,System.SByte,System.SByte>.op_Subtraction(SByte left, SByte right);
+        static SByte System.IUnaryNegationOperators<System.SByte,System.SByte>.op_UnaryNegation(SByte value);
+        static SByte System.IUnaryPlusOperators<System.SByte,System.SByte>.op_UnaryPlus(SByte value);
+        static SByte TrailingZeroCount(SByte value);
+        static bool TryCreate<TOther>(TOther value, out SByte result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out SByte result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out SByte result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out SByte result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out SByte result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out SByte result);
+        static bool TryParse(string? s, IFormatProvider? provider, out SByte result);
     }
-    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable, ISpanFormattable {
+    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPoint<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IFloatingPoint<float>, IFormattable, IIncrementOperators<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, IParseable<float>, ISignedNumber<float>, ISpanFormattable, ISpanParseable<float>, ISubtractionOperators<float, float, float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        public const float AdditiveIdentity = 0f;
+        public const float E = 2.7182817f;
+        public const float MultiplicativeIdentity = 1f;
+        public const float NegativeOne = -1f;
+        public const float NegativeZero = -0f;
+        public const float One = 1f;
+        public const float Pi = 3.1415927f;
+        public const float Tau = 6.2831855f;
+        public const float Zero = 0f;
+        static float System.IAdditiveIdentity<System.Single,System.Single>.AdditiveIdentity { get; }
+        static float System.IFloatingPoint<System.Single>.E { get; }
+        static float System.IFloatingPoint<System.Single>.Epsilon { get; }
+        static float System.IFloatingPoint<System.Single>.NaN { get; }
+        static float System.IFloatingPoint<System.Single>.NegativeInfinity { get; }
+        static float System.IFloatingPoint<System.Single>.NegativeZero { get; }
+        static float System.IFloatingPoint<System.Single>.Pi { get; }
+        static float System.IFloatingPoint<System.Single>.PositiveInfinity { get; }
+        static float System.IFloatingPoint<System.Single>.Tau { get; }
+        static float System.IMinMaxValue<System.Single>.MaxValue { get; }
+        static float System.IMinMaxValue<System.Single>.MinValue { get; }
+        static float System.IMultiplicativeIdentity<System.Single,System.Single>.MultiplicativeIdentity { get; }
+        static float System.INumber<System.Single>.One { get; }
+        static float System.INumber<System.Single>.Zero { get; }
+        static float System.ISignedNumber<System.Single>.NegativeOne { get; }
+        static Single Abs(Single value);
+        static Single Acos(Single x);
+        static Single Acosh(Single x);
+        static Single Asin(Single x);
+        static Single Asinh(Single x);
+        static Single Atan(Single x);
+        static Single Atan2(Single y, Single x);
+        static Single Atanh(Single x);
+        static Single BitDecrement(Single x);
+        static Single BitIncrement(Single x);
+        static Single Cbrt(Single x);
+        static Single Ceiling(Single x);
+        static Single Clamp(Single value, Single min, Single max);
+        static Single CopySign(Single x, Single y);
+        static Single Cos(Single x);
+        static Single Cosh(Single x);
+        static Single Create<TOther>(TOther value);
+        static Single CreateSaturating<TOther>(TOther value);
+        static Single CreateTruncating<TOther>(TOther value);
+        static (float Quotient, float Remainder) DivRem(Single left, Single right);
+        static Single Exp(Single x);
+        static Single Floor(Single x);
+        static Single FusedMultiplyAdd(Single left, Single right, Single addend);
+        static Single IEEERemainder(Single left, Single right);
+        static TInteger ILogB<TInteger>(Single x);
-        public static bool IsFinite(Single f);
+        static bool IsFinite(Single f);
-        public static bool IsInfinity(Single f);
+        static bool IsInfinity(Single f);
-        public static bool IsNaN(Single f);
+        static bool IsNaN(Single f);
-        public static bool IsNegative(Single f);
+        static bool IsNegative(Single f);
-        public static bool IsNegativeInfinity(Single f);
+        static bool IsNegativeInfinity(Single f);
-        public static bool IsNormal(Single f);
+        static bool IsNormal(Single f);
-        public static bool IsPositiveInfinity(Single f);
+        static bool IsPositiveInfinity(Single f);
+        static bool IsPow2(Single value);
-        public static bool IsSubnormal(Single f);
+        static bool IsSubnormal(Single f);
+        static Single Log(Single x);
+        static Single Log(Single x, Single newBase);
+        static Single Log10(Single x);
+        static Single Log2(Single value);
+        static Single Max(Single x, Single y);
+        static Single MaxMagnitude(Single x, Single y);
+        static Single Min(Single x, Single y);
+        static Single MinMagnitude(Single x, Single y);
-        public static bool operator ==(Single left, Single right);
+        static bool operator ==(Single left, Single right);
-        public static bool operator >(Single left, Single right);
+        static bool operator >(Single left, Single right);
-        public static bool operator >=(Single left, Single right);
+        static bool operator >=(Single left, Single right);
-        public static bool operator !=(Single left, Single right);
+        static bool operator !=(Single left, Single right);
-        public static bool operator <(Single left, Single right);
+        static bool operator <(Single left, Single right);
-        public static bool operator <=(Single left, Single right);
+        static bool operator <=(Single left, Single right);
-        public static Single Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Single Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        static Single Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static Single Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static Single Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static Single Parse(string s, IFormatProvider? provider);
+        static Single Parse(string s, IFormatProvider? provider);
+        static Single Pow(Single x, Single y);
+        static Single Round(Single x);
+        static Single Round(Single x, MidpointRounding mode);
+        static Single Round<TInteger>(Single x, TInteger digits);
+        static Single Round<TInteger>(Single x, TInteger digits, MidpointRounding mode);
+        static Single ScaleB<TInteger>(Single x, TInteger n);
+        static Single Sign(Single value);
+        static Single Sin(Single x);
+        static Single Sinh(Single x);
+        static Single Sqrt(Single x);
+        static Single System.IAdditionOperators<System.Single,System.Single,System.Single>.op_Addition(Single left, Single right);
+        static Single System.IBitwiseOperators<System.Single,System.Single,System.Single>.op_BitwiseAnd(Single left, Single right);
+        static Single System.IBitwiseOperators<System.Single,System.Single,System.Single>.op_BitwiseOr(Single left, Single right);
+        static Single System.IBitwiseOperators<System.Single,System.Single,System.Single>.op_ExclusiveOr(Single left, Single right);
+        static Single System.IBitwiseOperators<System.Single,System.Single,System.Single>.op_OnesComplement(Single value);
+        static Single System.IDecrementOperators<System.Single>.op_Decrement(Single value);
+        static Single System.IDivisionOperators<System.Single,System.Single,System.Single>.op_Division(Single left, Single right);
+        static Single System.IIncrementOperators<System.Single>.op_Increment(Single value);
+        static Single System.IModulusOperators<System.Single,System.Single,System.Single>.op_Modulus(Single left, Single right);
+        static Single System.IMultiplyOperators<System.Single,System.Single,System.Single>.op_Multiply(Single left, Single right);
+        static Single System.ISubtractionOperators<System.Single,System.Single,System.Single>.op_Subtraction(Single left, Single right);
+        static Single System.IUnaryNegationOperators<System.Single,System.Single>.op_UnaryNegation(Single value);
+        static Single System.IUnaryPlusOperators<System.Single,System.Single>.op_UnaryPlus(Single value);
+        static Single Tan(Single x);
+        static Single Tanh(Single x);
+        static Single Truncate(Single x);
+        static bool TryCreate<TOther>(TOther value, out Single result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Single result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Single result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Single result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Single result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Single result);
+        static bool TryParse(string? s, IFormatProvider? provider, out Single result);
     }
-    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, ISpanFormattable {
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IComparisonOperators<TimeOnly, TimeOnly>, IEqualityOperators<TimeOnly, TimeOnly>, IEquatable<TimeOnly>, IFormattable, IMinMaxValue<TimeOnly>, IParseable<TimeOnly>, ISpanFormattable, ISpanParseable<TimeOnly>, ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan> {
+        static TimeOnly System.IMinMaxValue<System.TimeOnly>.MaxValue { get; }
+        static TimeOnly System.IMinMaxValue<System.TimeOnly>.MinValue { get; }
-        public static bool operator ==(TimeOnly left, TimeOnly right);
+        static bool operator ==(TimeOnly left, TimeOnly right);
-        public static bool operator >(TimeOnly left, TimeOnly right);
+        static bool operator >(TimeOnly left, TimeOnly right);
-        public static bool operator >=(TimeOnly left, TimeOnly right);
+        static bool operator >=(TimeOnly left, TimeOnly right);
-        public static bool operator !=(TimeOnly left, TimeOnly right);
+        static bool operator !=(TimeOnly left, TimeOnly right);
-        public static bool operator <(TimeOnly left, TimeOnly right);
+        static bool operator <(TimeOnly left, TimeOnly right);
-        public static bool operator <=(TimeOnly left, TimeOnly right);
+        static bool operator <=(TimeOnly left, TimeOnly right);
-        public static TimeSpan operator -(TimeOnly t1, TimeOnly t2);
+        static TimeSpan operator -(TimeOnly t1, TimeOnly t2);
+        static TimeOnly Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        static TimeOnly Parse(string s, IFormatProvider? provider);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out TimeOnly result);
+        static bool TryParse(string? s, IFormatProvider? provider, out TimeOnly result);
     }
-    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, ISpanFormattable {
+    public readonly struct TimeSpan : IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>, IAdditiveIdentity<TimeSpan, TimeSpan>, IComparable, IComparable<TimeSpan>, IComparisonOperators<TimeSpan, TimeSpan>, IDivisionOperators<TimeSpan, double, TimeSpan>, IDivisionOperators<TimeSpan, TimeSpan, double>, IEqualityOperators<TimeSpan, TimeSpan>, IEquatable<TimeSpan>, IFormattable, IMinMaxValue<TimeSpan>, IMultiplicativeIdentity<TimeSpan, double>, IMultiplyOperators<TimeSpan, double, TimeSpan>, IParseable<TimeSpan>, ISpanFormattable, ISpanParseable<TimeSpan>, ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>, IUnaryNegationOperators<TimeSpan, TimeSpan>, IUnaryPlusOperators<TimeSpan, TimeSpan> {
+        static TimeSpan AdditiveIdentity { get; }
+        static double MultiplicativeIdentity { get; }
+        static TimeSpan System.IMinMaxValue<System.TimeSpan>.MaxValue { get; }
+        static TimeSpan System.IMinMaxValue<System.TimeSpan>.MinValue { get; }
-        public static TimeSpan operator +(TimeSpan t1, TimeSpan t2);
+        static TimeSpan operator +(TimeSpan t1, TimeSpan t2);
-        public static TimeSpan operator /(TimeSpan timeSpan, double divisor);
+        static TimeSpan operator /(TimeSpan timeSpan, double divisor);
-        public static double operator /(TimeSpan t1, TimeSpan t2);
+        static double operator /(TimeSpan t1, TimeSpan t2);
-        public static bool operator ==(TimeSpan t1, TimeSpan t2);
+        static bool operator ==(TimeSpan t1, TimeSpan t2);
-        public static bool operator >(TimeSpan t1, TimeSpan t2);
+        static bool operator >(TimeSpan t1, TimeSpan t2);
-        public static bool operator >=(TimeSpan t1, TimeSpan t2);
+        static bool operator >=(TimeSpan t1, TimeSpan t2);
-        public static bool operator !=(TimeSpan t1, TimeSpan t2);
+        static bool operator !=(TimeSpan t1, TimeSpan t2);
-        public static bool operator <(TimeSpan t1, TimeSpan t2);
+        static bool operator <(TimeSpan t1, TimeSpan t2);
-        public static bool operator <=(TimeSpan t1, TimeSpan t2);
+        static bool operator <=(TimeSpan t1, TimeSpan t2);
-        public static TimeSpan operator *(TimeSpan timeSpan, double factor);
+        static TimeSpan operator *(TimeSpan timeSpan, double factor);
-        public static TimeSpan operator -(TimeSpan t1, TimeSpan t2);
+        static TimeSpan operator -(TimeSpan t1, TimeSpan t2);
-        public static TimeSpan operator -(TimeSpan t);
+        static TimeSpan operator -(TimeSpan t);
-        public static TimeSpan operator +(TimeSpan t);
+        static TimeSpan operator +(TimeSpan t);
-        public static TimeSpan Parse(ReadOnlySpan<char> input, IFormatProvider? formatProvider = null);
+        static TimeSpan Parse(ReadOnlySpan<char> input, IFormatProvider? formatProvider = null);
-        public static TimeSpan Parse(string input, IFormatProvider? formatProvider);
+        static TimeSpan Parse(string input, IFormatProvider? formatProvider);
-        public static bool TryParse(ReadOnlySpan<char> input, IFormatProvider? formatProvider, out TimeSpan result);
+        static bool TryParse(ReadOnlySpan<char> input, IFormatProvider? formatProvider, out TimeSpan result);
-        public static bool TryParse(string? input, IFormatProvider? formatProvider, out TimeSpan result);
+        static bool TryParse(string? input, IFormatProvider? formatProvider, out TimeSpan result);
     }
-    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable, ISpanFormattable {
+    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, IParseable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParseable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+        public const ushort AdditiveIdentity = (ushort)0;
+        public const ushort MultiplicativeIdentity = (ushort)1;
+        public const ushort One = (ushort)1;
+        public const ushort Zero = (ushort)0;
+        static ushort System.IAdditiveIdentity<System.UInt16,System.UInt16>.AdditiveIdentity { get; }
+        static ushort System.IMinMaxValue<System.UInt16>.MaxValue { get; }
+        static ushort System.IMinMaxValue<System.UInt16>.MinValue { get; }
+        static ushort System.IMultiplicativeIdentity<System.UInt16,System.UInt16>.MultiplicativeIdentity { get; }
+        static ushort System.INumber<System.UInt16>.One { get; }
+        static ushort System.INumber<System.UInt16>.Zero { get; }
+        static UInt16 Abs(UInt16 value);
+        static UInt16 Clamp(UInt16 value, UInt16 min, UInt16 max);
+        static UInt16 Create<TOther>(TOther value);
+        static UInt16 CreateSaturating<TOther>(TOther value);
+        static UInt16 CreateTruncating<TOther>(TOther value);
+        static (ushort Quotient, ushort Remainder) DivRem(UInt16 left, UInt16 right);
+        static bool IsPow2(UInt16 value);
+        static UInt16 LeadingZeroCount(UInt16 value);
+        static UInt16 Log2(UInt16 value);
+        static UInt16 Max(UInt16 x, UInt16 y);
+        static UInt16 Min(UInt16 x, UInt16 y);
-        public static UInt16 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt16 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt16 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static UInt16 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static UInt16 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static UInt16 Parse(string s, IFormatProvider? provider);
+        static UInt16 Parse(string s, IFormatProvider? provider);
+        static UInt16 PopCount(UInt16 value);
+        static UInt16 RotateLeft(UInt16 value, int rotateAmount);
+        static UInt16 RotateRight(UInt16 value, int rotateAmount);
+        static UInt16 Sign(UInt16 value);
+        static UInt16 System.IAdditionOperators<System.UInt16,System.UInt16,System.UInt16>.op_Addition(UInt16 left, UInt16 right);
+        static UInt16 System.IBitwiseOperators<System.UInt16,System.UInt16,System.UInt16>.op_BitwiseAnd(UInt16 left, UInt16 right);
+        static UInt16 System.IBitwiseOperators<System.UInt16,System.UInt16,System.UInt16>.op_BitwiseOr(UInt16 left, UInt16 right);
+        static UInt16 System.IBitwiseOperators<System.UInt16,System.UInt16,System.UInt16>.op_ExclusiveOr(UInt16 left, UInt16 right);
+        static UInt16 System.IBitwiseOperators<System.UInt16,System.UInt16,System.UInt16>.op_OnesComplement(UInt16 value);
+        static bool System.IComparisonOperators<System.UInt16,System.UInt16>.op_GreaterThan(UInt16 left, UInt16 right);
+        static bool System.IComparisonOperators<System.UInt16,System.UInt16>.op_GreaterThanOrEqual(UInt16 left, UInt16 right);
+        static bool System.IComparisonOperators<System.UInt16,System.UInt16>.op_LessThan(UInt16 left, UInt16 right);
+        static bool System.IComparisonOperators<System.UInt16,System.UInt16>.op_LessThanOrEqual(UInt16 left, UInt16 right);
+        static UInt16 System.IDecrementOperators<System.UInt16>.op_Decrement(UInt16 value);
+        static UInt16 System.IDivisionOperators<System.UInt16,System.UInt16,System.UInt16>.op_Division(UInt16 left, UInt16 right);
+        static bool System.IEqualityOperators<System.UInt16,System.UInt16>.op_Equality(UInt16 left, UInt16 right);
+        static bool System.IEqualityOperators<System.UInt16,System.UInt16>.op_Inequality(UInt16 left, UInt16 right);
+        static UInt16 System.IIncrementOperators<System.UInt16>.op_Increment(UInt16 value);
+        static UInt16 System.IModulusOperators<System.UInt16,System.UInt16,System.UInt16>.op_Modulus(UInt16 left, UInt16 right);
+        static UInt16 System.IMultiplyOperators<System.UInt16,System.UInt16,System.UInt16>.op_Multiply(UInt16 left, UInt16 right);
+        static UInt16 System.IShiftOperators<System.UInt16,System.UInt16>.op_LeftShift(UInt16 value, int shiftAmount);
+        static UInt16 System.IShiftOperators<System.UInt16,System.UInt16>.op_RightShift(UInt16 value, int shiftAmount);
+        static UInt16 System.ISubtractionOperators<System.UInt16,System.UInt16,System.UInt16>.op_Subtraction(UInt16 left, UInt16 right);
+        static UInt16 System.IUnaryNegationOperators<System.UInt16,System.UInt16>.op_UnaryNegation(UInt16 value);
+        static UInt16 System.IUnaryPlusOperators<System.UInt16,System.UInt16>.op_UnaryPlus(UInt16 value);
+        static UInt16 TrailingZeroCount(UInt16 value);
+        static bool TryCreate<TOther>(TOther value, out UInt16 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt16 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt16 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UInt16 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt16 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt16 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out UInt16 result);
     }
-    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable, ISpanFormattable {
+    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, IParseable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParseable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+        public const uint AdditiveIdentity = (uint)0;
+        public const uint MultiplicativeIdentity = (uint)1;
+        public const uint One = (uint)1;
+        public const uint Zero = (uint)0;
+        static uint System.IAdditiveIdentity<System.UInt32,System.UInt32>.AdditiveIdentity { get; }
+        static uint System.IMinMaxValue<System.UInt32>.MaxValue { get; }
+        static uint System.IMinMaxValue<System.UInt32>.MinValue { get; }
+        static uint System.IMultiplicativeIdentity<System.UInt32,System.UInt32>.MultiplicativeIdentity { get; }
+        static uint System.INumber<System.UInt32>.One { get; }
+        static uint System.INumber<System.UInt32>.Zero { get; }
+        static UInt32 Abs(UInt32 value);
+        static UInt32 Clamp(UInt32 value, UInt32 min, UInt32 max);
+        static UInt32 Create<TOther>(TOther value);
+        static UInt32 CreateSaturating<TOther>(TOther value);
+        static UInt32 CreateTruncating<TOther>(TOther value);
+        static (uint Quotient, uint Remainder) DivRem(UInt32 left, UInt32 right);
+        static bool IsPow2(UInt32 value);
+        static UInt32 LeadingZeroCount(UInt32 value);
+        static UInt32 Log2(UInt32 value);
+        static UInt32 Max(UInt32 x, UInt32 y);
+        static UInt32 Min(UInt32 x, UInt32 y);
-        public static UInt32 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt32 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt32 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static UInt32 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static UInt32 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static UInt32 Parse(string s, IFormatProvider? provider);
+        static UInt32 Parse(string s, IFormatProvider? provider);
+        static UInt32 PopCount(UInt32 value);
+        static UInt32 RotateLeft(UInt32 value, int rotateAmount);
+        static UInt32 RotateRight(UInt32 value, int rotateAmount);
+        static UInt32 Sign(UInt32 value);
+        static UInt32 System.IAdditionOperators<System.UInt32,System.UInt32,System.UInt32>.op_Addition(UInt32 left, UInt32 right);
+        static UInt32 System.IBitwiseOperators<System.UInt32,System.UInt32,System.UInt32>.op_BitwiseAnd(UInt32 left, UInt32 right);
+        static UInt32 System.IBitwiseOperators<System.UInt32,System.UInt32,System.UInt32>.op_BitwiseOr(UInt32 left, UInt32 right);
+        static UInt32 System.IBitwiseOperators<System.UInt32,System.UInt32,System.UInt32>.op_ExclusiveOr(UInt32 left, UInt32 right);
+        static UInt32 System.IBitwiseOperators<System.UInt32,System.UInt32,System.UInt32>.op_OnesComplement(UInt32 value);
+        static bool System.IComparisonOperators<System.UInt32,System.UInt32>.op_GreaterThan(UInt32 left, UInt32 right);
+        static bool System.IComparisonOperators<System.UInt32,System.UInt32>.op_GreaterThanOrEqual(UInt32 left, UInt32 right);
+        static bool System.IComparisonOperators<System.UInt32,System.UInt32>.op_LessThan(UInt32 left, UInt32 right);
+        static bool System.IComparisonOperators<System.UInt32,System.UInt32>.op_LessThanOrEqual(UInt32 left, UInt32 right);
+        static UInt32 System.IDecrementOperators<System.UInt32>.op_Decrement(UInt32 value);
+        static UInt32 System.IDivisionOperators<System.UInt32,System.UInt32,System.UInt32>.op_Division(UInt32 left, UInt32 right);
+        static bool System.IEqualityOperators<System.UInt32,System.UInt32>.op_Equality(UInt32 left, UInt32 right);
+        static bool System.IEqualityOperators<System.UInt32,System.UInt32>.op_Inequality(UInt32 left, UInt32 right);
+        static UInt32 System.IIncrementOperators<System.UInt32>.op_Increment(UInt32 value);
+        static UInt32 System.IModulusOperators<System.UInt32,System.UInt32,System.UInt32>.op_Modulus(UInt32 left, UInt32 right);
+        static UInt32 System.IMultiplyOperators<System.UInt32,System.UInt32,System.UInt32>.op_Multiply(UInt32 left, UInt32 right);
+        static UInt32 System.IShiftOperators<System.UInt32,System.UInt32>.op_LeftShift(UInt32 value, int shiftAmount);
+        static UInt32 System.IShiftOperators<System.UInt32,System.UInt32>.op_RightShift(UInt32 value, int shiftAmount);
+        static UInt32 System.ISubtractionOperators<System.UInt32,System.UInt32,System.UInt32>.op_Subtraction(UInt32 left, UInt32 right);
+        static UInt32 System.IUnaryNegationOperators<System.UInt32,System.UInt32>.op_UnaryNegation(UInt32 value);
+        static UInt32 System.IUnaryPlusOperators<System.UInt32,System.UInt32>.op_UnaryPlus(UInt32 value);
+        static UInt32 TrailingZeroCount(UInt32 value);
+        static bool TryCreate<TOther>(TOther value, out UInt32 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt32 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt32 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UInt32 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt32 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt32 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out UInt32 result);
     }
-    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable, ISpanFormattable {
+    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, IParseable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParseable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+        public const ulong AdditiveIdentity = (ulong)0;
+        public const ulong MultiplicativeIdentity = (ulong)1;
+        public const ulong One = (ulong)1;
+        public const ulong Zero = (ulong)0;
+        static ulong System.IAdditiveIdentity<System.UInt64,System.UInt64>.AdditiveIdentity { get; }
+        static ulong System.IMinMaxValue<System.UInt64>.MaxValue { get; }
+        static ulong System.IMinMaxValue<System.UInt64>.MinValue { get; }
+        static ulong System.IMultiplicativeIdentity<System.UInt64,System.UInt64>.MultiplicativeIdentity { get; }
+        static ulong System.INumber<System.UInt64>.One { get; }
+        static ulong System.INumber<System.UInt64>.Zero { get; }
+        static UInt64 Abs(UInt64 value);
+        static UInt64 Clamp(UInt64 value, UInt64 min, UInt64 max);
+        static UInt64 Create<TOther>(TOther value);
+        static UInt64 CreateSaturating<TOther>(TOther value);
+        static UInt64 CreateTruncating<TOther>(TOther value);
+        static (ulong Quotient, ulong Remainder) DivRem(UInt64 left, UInt64 right);
+        static bool IsPow2(UInt64 value);
+        static UInt64 LeadingZeroCount(UInt64 value);
+        static UInt64 Log2(UInt64 value);
+        static UInt64 Max(UInt64 x, UInt64 y);
+        static UInt64 Min(UInt64 x, UInt64 y);
-        public static UInt64 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt64 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UInt64 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static UInt64 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static UInt64 Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static UInt64 Parse(string s, IFormatProvider? provider);
+        static UInt64 Parse(string s, IFormatProvider? provider);
+        static UInt64 PopCount(UInt64 value);
+        static UInt64 RotateLeft(UInt64 value, int rotateAmount);
+        static UInt64 RotateRight(UInt64 value, int rotateAmount);
+        static UInt64 Sign(UInt64 value);
+        static UInt64 System.IAdditionOperators<System.UInt64,System.UInt64,System.UInt64>.op_Addition(UInt64 left, UInt64 right);
+        static UInt64 System.IBitwiseOperators<System.UInt64,System.UInt64,System.UInt64>.op_BitwiseAnd(UInt64 left, UInt64 right);
+        static UInt64 System.IBitwiseOperators<System.UInt64,System.UInt64,System.UInt64>.op_BitwiseOr(UInt64 left, UInt64 right);
+        static UInt64 System.IBitwiseOperators<System.UInt64,System.UInt64,System.UInt64>.op_ExclusiveOr(UInt64 left, UInt64 right);
+        static UInt64 System.IBitwiseOperators<System.UInt64,System.UInt64,System.UInt64>.op_OnesComplement(UInt64 value);
+        static bool System.IComparisonOperators<System.UInt64,System.UInt64>.op_GreaterThan(UInt64 left, UInt64 right);
+        static bool System.IComparisonOperators<System.UInt64,System.UInt64>.op_GreaterThanOrEqual(UInt64 left, UInt64 right);
+        static bool System.IComparisonOperators<System.UInt64,System.UInt64>.op_LessThan(UInt64 left, UInt64 right);
+        static bool System.IComparisonOperators<System.UInt64,System.UInt64>.op_LessThanOrEqual(UInt64 left, UInt64 right);
+        static UInt64 System.IDecrementOperators<System.UInt64>.op_Decrement(UInt64 value);
+        static UInt64 System.IDivisionOperators<System.UInt64,System.UInt64,System.UInt64>.op_Division(UInt64 left, UInt64 right);
+        static bool System.IEqualityOperators<System.UInt64,System.UInt64>.op_Equality(UInt64 left, UInt64 right);
+        static bool System.IEqualityOperators<System.UInt64,System.UInt64>.op_Inequality(UInt64 left, UInt64 right);
+        static UInt64 System.IIncrementOperators<System.UInt64>.op_Increment(UInt64 value);
+        static UInt64 System.IModulusOperators<System.UInt64,System.UInt64,System.UInt64>.op_Modulus(UInt64 left, UInt64 right);
+        static UInt64 System.IMultiplyOperators<System.UInt64,System.UInt64,System.UInt64>.op_Multiply(UInt64 left, UInt64 right);
+        static UInt64 System.IShiftOperators<System.UInt64,System.UInt64>.op_LeftShift(UInt64 value, int shiftAmount);
+        static UInt64 System.IShiftOperators<System.UInt64,System.UInt64>.op_RightShift(UInt64 value, int shiftAmount);
+        static UInt64 System.ISubtractionOperators<System.UInt64,System.UInt64,System.UInt64>.op_Subtraction(UInt64 left, UInt64 right);
+        static UInt64 System.IUnaryNegationOperators<System.UInt64,System.UInt64>.op_UnaryNegation(UInt64 value);
+        static UInt64 System.IUnaryPlusOperators<System.UInt64,System.UInt64>.op_UnaryPlus(UInt64 value);
+        static UInt64 TrailingZeroCount(UInt64 value);
+        static bool TryCreate<TOther>(TOther value, out UInt64 result);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt64 result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt64 result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UInt64 result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt64 result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt64 result);
+        static bool TryParse(string? s, IFormatProvider? provider, out UInt64 result);
     }
-    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable, ISpanFormattable {
+    public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, IParseable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, UIntPtr>, ISpanFormattable, ISpanParseable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+        static UIntPtr System.IAdditiveIdentity<nuint,nuint>.AdditiveIdentity { get; }
+        static UIntPtr System.IMinMaxValue<nuint>.MaxValue { get; }
+        static UIntPtr System.IMinMaxValue<nuint>.MinValue { get; }
+        static UIntPtr System.IMultiplicativeIdentity<nuint,nuint>.MultiplicativeIdentity { get; }
+        static UIntPtr System.INumber<nuint>.One { get; }
+        static UIntPtr System.INumber<nuint>.Zero { get; }
-        public static bool operator ==(UIntPtr value1, UIntPtr value2);
+        static bool operator ==(UIntPtr value1, UIntPtr value2);
-        public static bool operator !=(UIntPtr value1, UIntPtr value2);
+        static bool operator !=(UIntPtr value1, UIntPtr value2);
-        public static UIntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UIntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        static UIntPtr Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
-        public static UIntPtr Parse(string s, NumberStyles style, IFormatProvider? provider);
+        static UIntPtr Parse(string s, NumberStyles style, IFormatProvider? provider);
-        public static UIntPtr Parse(string s, IFormatProvider? provider);
+        static UIntPtr Parse(string s, IFormatProvider? provider);
+        static UIntPtr System.IAdditionOperators<nuint,nuint,nuint>.op_Addition(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IBinaryInteger<nuint>.LeadingZeroCount(UIntPtr value);
+        static UIntPtr System.IBinaryInteger<nuint>.PopCount(UIntPtr value);
+        static UIntPtr System.IBinaryInteger<nuint>.RotateLeft(UIntPtr value, int rotateAmount);
+        static UIntPtr System.IBinaryInteger<nuint>.RotateRight(UIntPtr value, int rotateAmount);
+        static UIntPtr System.IBinaryInteger<nuint>.TrailingZeroCount(UIntPtr value);
+        static bool System.IBinaryNumber<nuint>.IsPow2(UIntPtr value);
+        static UIntPtr System.IBinaryNumber<nuint>.Log2(UIntPtr value);
+        static UIntPtr System.IBitwiseOperators<nuint,nuint,nuint>.op_BitwiseAnd(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IBitwiseOperators<nuint,nuint,nuint>.op_BitwiseOr(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IBitwiseOperators<nuint,nuint,nuint>.op_ExclusiveOr(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IBitwiseOperators<nuint,nuint,nuint>.op_OnesComplement(UIntPtr value);
+        static bool System.IComparisonOperators<nuint,nuint>.op_GreaterThan(UIntPtr left, UIntPtr right);
+        static bool System.IComparisonOperators<nuint,nuint>.op_GreaterThanOrEqual(UIntPtr left, UIntPtr right);
+        static bool System.IComparisonOperators<nuint,nuint>.op_LessThan(UIntPtr left, UIntPtr right);
+        static bool System.IComparisonOperators<nuint,nuint>.op_LessThanOrEqual(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IDecrementOperators<nuint>.op_Decrement(UIntPtr value);
+        static UIntPtr System.IDivisionOperators<nuint,nuint,nuint>.op_Division(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IIncrementOperators<nuint>.op_Increment(UIntPtr value);
+        static UIntPtr System.IModulusOperators<nuint,nuint,nuint>.op_Modulus(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IMultiplyOperators<nuint,nuint,nuint>.op_Multiply(UIntPtr left, UIntPtr right);
+        static UIntPtr System.INumber<nuint>.Abs(UIntPtr value);
+        static UIntPtr System.INumber<nuint>.Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        static UIntPtr System.INumber<nuint>.Create<TOther>(TOther value);
+        static UIntPtr System.INumber<nuint>.CreateSaturating<TOther>(TOther value);
+        static UIntPtr System.INumber<nuint>.CreateTruncating<TOther>(TOther value);
+        static (UIntPtr Quotient, UIntPtr Remainder) System.INumber<nuint>.DivRem(UIntPtr left, UIntPtr right);
+        static UIntPtr System.INumber<nuint>.Max(UIntPtr x, UIntPtr y);
+        static UIntPtr System.INumber<nuint>.Min(UIntPtr x, UIntPtr y);
+        static UIntPtr System.INumber<nuint>.Sign(UIntPtr value);
+        static bool System.INumber<nuint>.TryCreate<TOther>(TOther value, out UIntPtr result);
+        static UIntPtr System.IShiftOperators<nuint,nuint>.op_LeftShift(UIntPtr value, int shiftAmount);
+        static UIntPtr System.IShiftOperators<nuint,nuint>.op_RightShift(UIntPtr value, int shiftAmount);
+        static UIntPtr System.ISubtractionOperators<nuint,nuint,nuint>.op_Subtraction(UIntPtr left, UIntPtr right);
+        static UIntPtr System.IUnaryNegationOperators<nuint,nuint>.op_UnaryNegation(UIntPtr value);
+        static UIntPtr System.IUnaryPlusOperators<nuint,nuint>.op_UnaryPlus(UIntPtr value);
-        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UIntPtr result);
+        static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UIntPtr result);
+        static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UIntPtr result);
-        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UIntPtr result);
+        static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UIntPtr result);
+        static bool TryParse(string? s, IFormatProvider? provider, out UIntPtr result);
     }
 }
```

