# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
-    public sealed class AcceptedAtRouteHttpResult : IResult {
 {
-        public string RouteName { get; }

-        public RouteValueDictionary RouteValues { get; }

-        public int StatusCode { get; }

-        public object Value { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class AcceptedHttpResult : IResult {
 {
-        public string Location { get; }

-        public int StatusCode { get; }

-        public object Value { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class BadRequestObjectHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public object Value { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class ChallengeHttpResult : IResult {
 {
-        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }

-        public AuthenticationProperties? Properties { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class ConflictObjectHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public object Value { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class ContentHttpResult : IResult {
 {
-        public string Content { get; internal set; }

-        public string ContentType { get; internal set; }

-        public int? StatusCode { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class CreatedAtRouteHttpResult : IResult {
 {
-        public string RouteName { get; }

-        public RouteValueDictionary RouteValues { get; }

-        public int StatusCode { get; }

-        public object Value { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class CreatedHttpResult : IResult {
 {
-        public string Location { get; }

-        public int StatusCode { get; }

-        public object Value { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class EmptyHttpResult : IResult {
 {
-        public static EmptyHttpResult Instance { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
     public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object> {
-        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<object?> {
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<object> {
-            public object? Current { get; }
+            public object Current { get; }
         }
     }
-    public sealed class FileContentHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public bool EnableRangeProcessing { get; internal set; }

-        public EntityTagHeaderValue EntityTag { get; internal set; }

-        public ReadOnlyMemory<byte> FileContents { get; internal set; }

-        public string FileDownloadName { get; internal set; }

-        public long? FileLength { get; internal set; }

-        public DateTimeOffset? LastModified { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class FileStreamHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public bool EnableRangeProcessing { get; internal set; }

-        public EntityTagHeaderValue EntityTag { get; internal set; }

-        public string FileDownloadName { get; internal set; }

-        public long? FileLength { get; internal set; }

-        public Stream FileStream { get; }

-        public DateTimeOffset? LastModified { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class ForbidHttpResult : IResult {
 {
-        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }

-        public AuthenticationProperties? Properties { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
     public static class HttpRequestJsonExtensions {
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerContext context, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonTypeInfo<TValue> jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
     }
     public static class HttpResponseJsonExtensions {
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, JsonSerializerContext context, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
     }
-    public sealed class JsonHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public JsonSerializerOptions JsonSerializerOptions { get; internal set; }

-        public int? StatusCode { get; }

-        public object Value { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public class NoContentHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class NotFoundObjectHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public object Value { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class OkObjectHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public object Value { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class PhysicalFileHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public bool EnableRangeProcessing { get; internal set; }

-        public EntityTagHeaderValue? EntityTag { get; internal set; }

-        public string? FileDownloadName { get; internal set; }

-        public long? FileLength { get; internal set; }

-        public string FileName { get; }

-        public DateTimeOffset? LastModified { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class ProblemHttpResult : IResult {
 {
-        public string ContentType { get; }

-        public ProblemDetails ProblemDetails { get; }

-        public int? StatusCode { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class PushStreamHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public bool EnableRangeProcessing { get; internal set; }

-        public EntityTagHeaderValue EntityTag { get; internal set; }

-        public string FileDownloadName { get; internal set; }

-        public long? FileLength { get; internal set; }

-        public DateTimeOffset? LastModified { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class RedirectHttpResult : IResult {
 {
-        public bool AcceptLocalUrlOnly { get; }

-        public bool Permanent { get; }

-        public bool PreserveMethod { get; }

-        public string Url { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class RedirectToRouteHttpResult : IResult {
 {
-        public string Fragment { get; }

-        public bool Permanent { get; }

-        public bool PreserveMethod { get; }

-        public string RouteName { get; }

-        public RouteValueDictionary RouteValues { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
     public sealed class RequestDelegateFactoryOptions {
+        public IEnumerable<object>? InitialEndpointMetadata { get; set; }
     }
-    public sealed class SignInHttpResult : IResult {
 {
-        public string AuthenticationScheme { get; internal set; }

-        public ClaimsPrincipal Principal { get; internal set; }

-        public AuthenticationProperties Properties { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class SignOutHttpResult : IResult {
 {
-        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }

-        public AuthenticationProperties? Properties { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class StatusCodeHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
+    public static class TypedResults {
+        public static EmptyHttpResult Empty { get; }
+        public static Accepted Accepted(string? uri);
+        public static Accepted Accepted(Uri uri);
+        public static Accepted<TValue> Accepted<TValue>(string? uri, TValue? value);
+        public static Accepted<TValue> Accepted<TValue>(Uri uri, TValue? value);
+        public static AcceptedAtRoute AcceptedAtRoute(string? routeName = null, object? routeValues = null);
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue? value, string? routeName = null, object? routeValues = null);
+        public static BadRequest BadRequest();
+        public static BadRequest<TValue> BadRequest<TValue>(TValue? error);
+        public static FileContentHttpResult Bytes(byte[] contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileContentHttpResult Bytes(ReadOnlyMemory<byte> contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static ChallengeHttpResult Challenge(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static Conflict Conflict();
+        public static Conflict<TValue> Conflict<TValue>(TValue? error);
+        public static ContentHttpResult Content(string content, MediaTypeHeaderValue contentType);
+        public static ContentHttpResult Content(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static Created Created(string uri);
+        public static Created Created(Uri uri);
+        public static Created<TValue> Created<TValue>(string uri, TValue? value);
+        public static Created<TValue> Created<TValue>(Uri uri, TValue? value);
+        public static CreatedAtRoute CreatedAtRoute(string? routeName = null, object? routeValues = null);
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue? value, string? routeName = null, object? routeValues = null);
+        public static FileContentHttpResult File(byte[] fileContents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileStreamHttpResult File(Stream fileStream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static ForbidHttpResult Forbid(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static JsonHttpResult<TValue> Json<TValue>(TValue? data, JsonSerializerOptions? options = null, string? contentType = null, int? statusCode = default(int?));
+        public static RedirectHttpResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static NoContent NoContent();
+        public static NotFound NotFound();
+        public static NotFound<TValue> NotFound<TValue>(TValue? value);
+        public static Ok Ok();
+        public static Ok<TValue> Ok<TValue>(TValue? value);
+        public static PhysicalFileHttpResult PhysicalFile(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static ProblemHttpResult Problem(ProblemDetails problemDetails);
+        public static ProblemHttpResult Problem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static RedirectHttpResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static RedirectToRouteHttpResult RedirectToRoute(string? routeName = null, object? routeValues = null, bool permanent = false, bool preserveMethod = false, string? fragment = null);
+        public static SignInHttpResult SignIn(ClaimsPrincipal principal, AuthenticationProperties? properties = null, string? authenticationScheme = null);
+        public static SignOutHttpResult SignOut(AuthenticationProperties? properties = null, IList<string>? authenticationSchemes = null);
+        public static StatusCodeHttpResult StatusCode(int statusCode);
+        public static PushStreamHttpResult Stream(Func<Stream, Task> streamWriterCallback, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileStreamHttpResult Stream(PipeReader pipeReader, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static FileStreamHttpResult Stream(Stream stream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static ContentHttpResult Text(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static UnauthorizedHttpResult Unauthorized();
+        public static UnprocessableEntity UnprocessableEntity();
+        public static UnprocessableEntity<TValue> UnprocessableEntity<TValue>(TValue? error);
+        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string? detail = null, string? instance = null, string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static VirtualFileHttpResult VirtualFile(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+    }
-    public sealed class UnauthorizedHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class UnprocessableEntityObjectHttpResult : IResult {
 {
-        public int StatusCode { get; }

-        public object Value { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
-    public sealed class VirtualFileHttpResult : IResult {
 {
-        public string ContentType { get; internal set; }

-        public bool EnableRangeProcessing { get; internal set; }

-        public EntityTagHeaderValue? EntityTag { get; internal set; }

-        public string? FileDownloadName { get; internal set; }

-        public long? FileLength { get; internal set; }

-        public string FileName { get; internal set; }

-        public DateTimeOffset? LastModified { get; internal set; }

-        public Task ExecuteAsync(HttpContext httpContext);

-    }
 }
```

