# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity : IDisposable {
+        public static event EventHandler<ActivityChangedEventArgs>? CurrentChanged;
+        public Activity.Enumerator<ActivityEvent> EnumerateEvents();
+        public Activity.Enumerator<ActivityLink> EnumerateLinks();
+        public Activity.Enumerator<KeyValuePair<string, object?>> EnumerateTagObjects();
+        public struct Enumerator<T> {
+            public ref T Current { get; }
+            public Activity.Enumerator<T> GetEnumerator();
+            public bool MoveNext();
+        }
     }
+    public readonly struct ActivityChangedEventArgs {
+        public Activity Current { get; set; }
+        public Activity Previous { get; set; }
+    }
     public class Process : Component, IDisposable {
+        public bool WaitForExit(TimeSpan timeout);
+        public bool WaitForInputIdle(TimeSpan timeout);
     }
 }
```

