# System.Formats.Tar

``` diff
+namespace System.Formats.Tar {
+    public sealed class GnuTarEntry : PosixTarEntry {
+        public GnuTarEntry(TarEntryType entryType, string entryName);
+        public DateTimeOffset AccessTime { get; set; }
+        public DateTimeOffset ChangeTime { get; set; }
+    }
+    public sealed class PaxTarEntry : PosixTarEntry {
+        public PaxTarEntry(TarEntryType entryType, string entryName);
+        public PaxTarEntry(TarEntryType entryType, string entryName, IEnumerable<KeyValuePair<string, string>> extendedAttributes);
+        public IReadOnlyDictionary<string, string> ExtendedAttributes { get; }
+    }
+    public abstract class PosixTarEntry : TarEntry {
+        public int DeviceMajor { get; set; }
+        public int DeviceMinor { get; set; }
+        public string GroupName { get; set; }
+        public string UserName { get; set; }
+    }
+    public abstract class TarEntry {
+        public int Checksum { get; }
+        public Stream? DataStream { get; set; }
+        public TarEntryType EntryType { get; }
+        public int Gid { get; set; }
+        public long Length { get; }
+        public string LinkName { get; set; }
+        public TarFileMode Mode { get; set; }
+        public DateTimeOffset ModificationTime { get; set; }
+        public string Name { get; set; }
+        public int Uid { get; set; }
+        public void ExtractToFile(string destinationFileName, bool overwrite);
+        public override string ToString();
+    }
+    public enum TarEntryType : byte {
+        BlockDevice = (byte)52,
+        CharacterDevice = (byte)51,
+        ContiguousFile = (byte)55,
+        Directory = (byte)53,
+        DirectoryList = (byte)68,
+        ExtendedAttributes = (byte)120,
+        Fifo = (byte)54,
+        GlobalExtendedAttributes = (byte)103,
+        HardLink = (byte)49,
+        LongLink = (byte)75,
+        LongPath = (byte)76,
+        MultiVolume = (byte)77,
+        RegularFile = (byte)48,
+        RenamedOrSymlinked = (byte)78,
+        SparseFile = (byte)83,
+        SymbolicLink = (byte)50,
+        TapeVolume = (byte)86,
+        V7RegularFile = (byte)0,
+    }
+    public static class TarFile {
+        public static void CreateFromDirectory(string sourceDirectoryName, Stream destination, bool includeBaseDirectory);
+        public static void CreateFromDirectory(string sourceDirectoryName, string destinationFileName, bool includeBaseDirectory);
+        public static void ExtractToDirectory(Stream source, string destinationDirectoryName, bool overwriteFiles);
+        public static void ExtractToDirectory(string sourceFileName, string destinationDirectoryName, bool overwriteFiles);
+    }
+    public enum TarFileMode {
+        GroupExecute = 8,
+        GroupRead = 32,
+        GroupSpecial = 1024,
+        GroupWrite = 16,
+        None = 0,
+        OtherExecute = 1,
+        OtherRead = 4,
+        OtherWrite = 2,
+        StickyBit = 512,
+        UserExecute = 64,
+        UserRead = 256,
+        UserSpecial = 2048,
+        UserWrite = 128,
+    }
+    public enum TarFormat {
+        Gnu = 4,
+        Pax = 3,
+        Unknown = 0,
+        Ustar = 2,
+        V7 = 1,
+    }
+    public sealed class TarReader : IDisposable {
+        public TarReader(Stream archiveStream, bool leaveOpen = false);
+        public TarFormat Format { get; }
+        public IReadOnlyDictionary<string, string>? GlobalExtendedAttributes { get; }
+        public void Dispose();
+        public TarEntry? GetNextEntry(bool copyData = false);
+    }
+    public sealed class TarWriter : IDisposable {
+        public TarWriter(Stream archiveStream, IEnumerable<KeyValuePair<string, string>>? globalExtendedAttributes = null, bool leaveOpen = false);
+        public TarWriter(Stream archiveStream, TarFormat archiveFormat, bool leaveOpen = false);
+        public TarFormat Format { get; }
+        public void Dispose();
+        public void WriteEntry(TarEntry entry);
+        public void WriteEntry(string fileName, string? entryName);
+    }
+    public sealed class UstarTarEntry : PosixTarEntry {
+        public UstarTarEntry(TarEntryType entryType, string entryName);
+    }
+    public sealed class V7TarEntry : TarEntry {
+        public V7TarEntry(TarEntryType entryType, string entryName);
+    }
+}
```

