# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
+    public ref struct AnsiStringMarshaller {
+        public AnsiStringMarshaller(string? str);
+        public AnsiStringMarshaller(string? str, Span<byte> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public string? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public ref struct ArrayMarshaller<T> {
+        public ArrayMarshaller(int sizeOfNativeElement);
+        public ArrayMarshaller(T[]? array, int sizeOfNativeElement);
+        public ArrayMarshaller(T[]? array, Span<byte> buffer, int sizeOfNativeElement);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public Span<T> GetManagedValuesDestination(int length);
+        public ReadOnlySpan<T> GetManagedValuesSource();
+        public Span<byte> GetNativeValuesDestination();
+        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
+        public ref byte GetPinnableReference();
+        public T[]? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public sealed class CustomTypeMarshallerAttribute : Attribute {
+        public CustomTypeMarshallerAttribute(Type managedType, CustomTypeMarshallerKind marshallerKind = CustomTypeMarshallerKind.Value);
+        public int BufferSize { get; set; }
+        public CustomTypeMarshallerDirection Direction { get; set; }
+        public CustomTypeMarshallerFeatures Features { get; set; }
+        public Type ManagedType { get; }
+        public CustomTypeMarshallerKind MarshallerKind { get; }
+        public struct GenericPlaceholder
+    }
+    public enum CustomTypeMarshallerDirection {
+        In = 1,
+        None = 0,
+        Out = 2,
+        Ref = 3,
+    }
+    public enum CustomTypeMarshallerFeatures {
+        CallerAllocatedBuffer = 2,
+        None = 0,
+        TwoStageMarshalling = 4,
+        UnmanagedResources = 1,
+    }
+    public enum CustomTypeMarshallerKind {
+        LinearCollection = 1,
+        Value = 0,
+    }
+    public sealed class MarshalUsingAttribute : Attribute {
+        public const string ReturnsCountValue = "return-value";
+        public MarshalUsingAttribute();
+        public MarshalUsingAttribute(Type nativeType);
+        public int ConstantElementCount { get; set; }
+        public string CountElementName { get; set; }
+        public int ElementIndirectionDepth { get; set; }
+        public Type? NativeType { get; }
+    }
+    public sealed class NativeMarshallingAttribute : Attribute {
+        public NativeMarshallingAttribute(Type nativeType);
+        public Type NativeType { get; }
+    }
-    public readonly struct NFloat : IComparable, IComparable<NFloat>, IEquatable<NFloat>, IFormattable, ISpanFormattable {
+    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+        public static NFloat E { get; }
+        public static NFloat NegativeZero { get; }
+        public static NFloat Pi { get; }
+        static NFloat System.Numerics.IAdditiveIdentity<System.Runtime.InteropServices.NFloat,System.Runtime.InteropServices.NFloat>.AdditiveIdentity { get; }
+        static NFloat System.Numerics.IMultiplicativeIdentity<System.Runtime.InteropServices.NFloat,System.Runtime.InteropServices.NFloat>.MultiplicativeIdentity { get; }
+        static NFloat System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.One { get; }
+        static NFloat System.Numerics.INumberBase<System.Runtime.InteropServices.NFloat>.Zero { get; }
+        static NFloat System.Numerics.ISignedNumber<System.Runtime.InteropServices.NFloat>.NegativeOne { get; }
+        public static NFloat Tau { get; }
+        public static NFloat Abs(NFloat value);
+        public static NFloat Acos(NFloat x);
+        public static NFloat Acosh(NFloat x);
+        public static NFloat Asin(NFloat x);
+        public static NFloat Asinh(NFloat x);
+        public static NFloat Atan(NFloat x);
+        public static NFloat Atan2(NFloat y, NFloat x);
+        public static NFloat Atanh(NFloat x);
+        public static NFloat BitDecrement(NFloat x);
+        public static NFloat BitIncrement(NFloat x);
+        public static NFloat Cbrt(NFloat x);
+        public static NFloat Ceiling(NFloat x);
+        public static NFloat Clamp(NFloat value, NFloat min, NFloat max);
+        public static NFloat CopySign(NFloat x, NFloat y);
+        public static NFloat Cos(NFloat x);
+        public static NFloat Cosh(NFloat x);
+        public static NFloat CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static NFloat CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static NFloat CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static NFloat Exp(NFloat x);
+        public static NFloat Floor(NFloat x);
+        public static NFloat FusedMultiplyAdd(NFloat left, NFloat right, NFloat addend);
+        public static NFloat Ieee754Remainder(NFloat left, NFloat right);
+        public static int ILogB(NFloat x);
+        public static bool IsPow2(NFloat value);
+        public static NFloat Log(NFloat x);
+        public static NFloat Log(NFloat x, NFloat newBase);
+        public static NFloat Log10(NFloat x);
+        public static NFloat Log2(NFloat value);
+        public static NFloat Max(NFloat x, NFloat y);
+        public static NFloat MaxMagnitude(NFloat x, NFloat y);
+        public static NFloat Min(NFloat x, NFloat y);
+        public static NFloat MinMagnitude(NFloat x, NFloat y);
+        public static NFloat Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static NFloat Pow(NFloat x, NFloat y);
+        public static NFloat ReciprocalEstimate(NFloat x);
+        public static NFloat ReciprocalSqrtEstimate(NFloat x);
+        public static NFloat Round(NFloat x);
+        public static NFloat Round(NFloat x, int digits);
+        public static NFloat Round(NFloat x, int digits, MidpointRounding mode);
+        public static NFloat Round(NFloat x, MidpointRounding mode);
+        public static NFloat ScaleB(NFloat x, int n);
+        public static int Sign(NFloat value);
+        public static NFloat Sin(NFloat x);
+        public static (NFloat Sin, NFloat Cos) SinCos(NFloat x);
+        public static NFloat Sinh(NFloat x);
+        public static NFloat Sqrt(NFloat x);
+        static NFloat IAdditionOperators<NFloat, NFloat, NFloat>.operator checked +(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator &(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator |(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator ^(NFloat left, NFloat right);
+        static NFloat IBitwiseOperators<NFloat, NFloat, NFloat>.operator ~(NFloat value);
+        static NFloat IDecrementOperators<NFloat>.operator checked --(NFloat value);
+        static NFloat IDivisionOperators<NFloat, NFloat, NFloat>.operator checked /(NFloat left, NFloat right);
+        int IFloatingPoint<NFloat>.GetExponentByteCount();
+        long IFloatingPoint<NFloat>.GetExponentShortestBitLength();
+        long IFloatingPoint<NFloat>.GetSignificandBitLength();
+        int IFloatingPoint<NFloat>.GetSignificandByteCount();
+        bool IFloatingPoint<NFloat>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<NFloat>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static NFloat IIncrementOperators<NFloat>.operator checked ++(NFloat value);
+        static NFloat IMultiplyOperators<NFloat, NFloat, NFloat>.operator checked *(NFloat left, NFloat right);
+        static NFloat ISubtractionOperators<NFloat, NFloat, NFloat>.operator checked -(NFloat left, NFloat right);
+        static NFloat IUnaryNegationOperators<NFloat, NFloat>.operator checked -(NFloat value);
+        public static NFloat Tan(NFloat x);
+        public static NFloat Tanh(NFloat x);
+        public static NFloat Truncate(NFloat x);
+        public static bool TryCreate<TOther>(TOther value, out NFloat result) where TOther : INumber<TOther>;
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(string? s, IFormatProvider? provider, out NFloat result);
     }
+    public ref struct PointerArrayMarshaller<T> where T : struct {
+        public PointerArrayMarshaller(int sizeOfNativeElement);
+        public PointerArrayMarshaller(T*[]? array, int sizeOfNativeElement);
+        public PointerArrayMarshaller(T*[]? array, Span<byte> buffer, int sizeOfNativeElement);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public Span<IntPtr> GetManagedValuesDestination(int length);
+        public ReadOnlySpan<IntPtr> GetManagedValuesSource();
+        public Span<byte> GetNativeValuesDestination();
+        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
+        public ref byte GetPinnableReference();
+        public T*[]? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public ref struct Utf16StringMarshaller {
+        public Utf16StringMarshaller(string? str);
+        public Utf16StringMarshaller(string? str, Span<ushort> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(ushort* value);
+        public ref ushort GetPinnableReference();
+        public string? ToManaged();
+        public unsafe ushort* ToNativeValue();
+    }
+    public ref struct Utf8StringMarshaller {
+        public Utf8StringMarshaller(string? str);
+        public Utf8StringMarshaller(string? str, Span<byte> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public string? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
 }
```

