# System

``` diff
 namespace System {
-    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, IParseable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParseable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
-        public const byte AdditiveIdentity = (byte)0;

-        public const byte MultiplicativeIdentity = (byte)1;

-        public const byte One = (byte)1;

-        public const byte Zero = (byte)0;

-        static byte System.IAdditiveIdentity<System.Byte,System.Byte>.AdditiveIdentity { get; }

-        static byte System.IMinMaxValue<System.Byte>.MaxValue { get; }

-        static byte System.IMinMaxValue<System.Byte>.MinValue { get; }

-        static byte System.IMultiplicativeIdentity<System.Byte,System.Byte>.MultiplicativeIdentity { get; }

-        static byte System.INumber<System.Byte>.One { get; }

-        static byte System.INumber<System.Byte>.Zero { get; }

+        static byte System.Numerics.IAdditiveIdentity<System.Byte,System.Byte>.AdditiveIdentity { get; }
+        static byte System.Numerics.IMinMaxValue<System.Byte>.MaxValue { get; }
+        static byte System.Numerics.IMinMaxValue<System.Byte>.MinValue { get; }
+        static byte System.Numerics.IMultiplicativeIdentity<System.Byte,System.Byte>.MultiplicativeIdentity { get; }
+        static byte System.Numerics.INumberBase<System.Byte>.One { get; }
+        static byte System.Numerics.INumberBase<System.Byte>.Zero { get; }
-        public static byte Abs(byte value);

-        public static byte Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static byte CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static byte Sign(byte value);

+        public static int Sign(byte value);
-        static byte IAdditionOperators<byte, byte, byte>.operator +(byte left, byte right);

-        static byte IBitwiseOperators<byte, byte, byte>.operator &(byte left, byte right);

-        static byte IBitwiseOperators<byte, byte, byte>.operator |(byte left, byte right);

-        static byte IBitwiseOperators<byte, byte, byte>.operator ^(byte left, byte right);

-        static byte IBitwiseOperators<byte, byte, byte>.operator ~(byte value);

-        static bool IComparisonOperators<byte, byte>.operator >(byte left, byte right);

-        static bool IComparisonOperators<byte, byte>.operator >=(byte left, byte right);

-        static bool IComparisonOperators<byte, byte>.operator <(byte left, byte right);

-        static bool IComparisonOperators<byte, byte>.operator <=(byte left, byte right);

-        static byte IDecrementOperators<byte>.operator --(byte value);

-        static byte IDivisionOperators<byte, byte, byte>.operator /(byte left, byte right);

-        static bool IEqualityOperators<byte, byte>.operator ==(byte left, byte right);

-        static bool IEqualityOperators<byte, byte>.operator !=(byte left, byte right);

-        static byte IIncrementOperators<byte>.operator ++(byte value);

-        static byte IModulusOperators<byte, byte, byte>.operator %(byte left, byte right);

-        static byte IMultiplyOperators<byte, byte, byte>.operator *(byte left, byte right);

-        static byte IShiftOperators<byte, byte>.operator <<(byte value, int shiftAmount);

-        static byte IShiftOperators<byte, byte>.operator >>(byte value, int shiftAmount);

-        static byte ISubtractionOperators<byte, byte, byte>.operator -(byte left, byte right);

-        static byte IUnaryNegationOperators<byte, byte>.operator -(byte value);

-        static byte IUnaryPlusOperators<byte, byte>.operator +(byte value);

+        static byte IAdditionOperators<byte, byte, byte>.operator +(byte left, byte right);
+        static byte IAdditionOperators<byte, byte, byte>.operator checked +(byte left, byte right);
+        int IBinaryInteger<byte>.GetByteCount();
+        long IBinaryInteger<byte>.GetShortestBitLength();
+        bool IBinaryInteger<byte>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static byte IBitwiseOperators<byte, byte, byte>.operator &(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator |(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator ^(byte left, byte right);
+        static byte IBitwiseOperators<byte, byte, byte>.operator ~(byte value);
+        static bool IComparisonOperators<byte, byte>.operator >(byte left, byte right);
+        static bool IComparisonOperators<byte, byte>.operator >=(byte left, byte right);
+        static bool IComparisonOperators<byte, byte>.operator <(byte left, byte right);
+        static bool IComparisonOperators<byte, byte>.operator <=(byte left, byte right);
+        static byte IDecrementOperators<byte>.operator checked --(byte value);
+        static byte IDecrementOperators<byte>.operator --(byte value);
+        static byte IDivisionOperators<byte, byte, byte>.operator checked /(byte left, byte right);
+        static byte IDivisionOperators<byte, byte, byte>.operator /(byte left, byte right);
+        static bool IEqualityOperators<byte, byte>.operator ==(byte left, byte right);
+        static bool IEqualityOperators<byte, byte>.operator !=(byte left, byte right);
+        static byte IIncrementOperators<byte>.operator checked ++(byte value);
+        static byte IIncrementOperators<byte>.operator ++(byte value);
+        static byte IModulusOperators<byte, byte, byte>.operator %(byte left, byte right);
+        static byte IMultiplyOperators<byte, byte, byte>.operator checked *(byte left, byte right);
+        static byte IMultiplyOperators<byte, byte, byte>.operator *(byte left, byte right);
+        static byte INumber<byte>.Abs(byte value);
+        static byte INumber<byte>.CopySign(byte value, byte sign);
+        static bool INumber<byte>.IsNegative(byte value);
+        static byte INumber<byte>.MaxMagnitude(byte x, byte y);
+        static byte INumber<byte>.MinMagnitude(byte x, byte y);
+        static byte IShiftOperators<byte, byte>.operator <<(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, byte>.operator >>(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, byte>.operator >>>(byte value, int shiftAmount);
+        static byte ISubtractionOperators<byte, byte, byte>.operator checked -(byte left, byte right);
+        static byte ISubtractionOperators<byte, byte, byte>.operator -(byte left, byte right);
+        static byte IUnaryNegationOperators<byte, byte>.operator checked -(byte value);
+        static byte IUnaryNegationOperators<byte, byte>.operator -(byte value);
+        static byte IUnaryPlusOperators<byte, byte>.operator +(byte value);
     }
-    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, IParseable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParseable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
-        static char System.IAdditiveIdentity<System.Char,System.Char>.AdditiveIdentity { get; }

-        static char System.IMinMaxValue<System.Char>.MaxValue { get; }

-        static char System.IMinMaxValue<System.Char>.MinValue { get; }

-        static char System.IMultiplicativeIdentity<System.Char,System.Char>.MultiplicativeIdentity { get; }

-        static char System.INumber<System.Char>.One { get; }

-        static char System.INumber<System.Char>.Zero { get; }

+        static char System.Numerics.IAdditiveIdentity<System.Char,System.Char>.AdditiveIdentity { get; }
+        static char System.Numerics.IMinMaxValue<System.Char>.MaxValue { get; }
+        static char System.Numerics.IMinMaxValue<System.Char>.MinValue { get; }
+        static char System.Numerics.IMultiplicativeIdentity<System.Char,System.Char>.MultiplicativeIdentity { get; }
+        static char System.Numerics.INumberBase<System.Char>.One { get; }
+        static char System.Numerics.INumberBase<System.Char>.Zero { get; }
-        public static char Abs(char value);

-        public static char Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static char CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static char Sign(char value);

+        public static int Sign(char value);
-        static char IAdditionOperators<char, char, char>.operator +(char left, char right);

-        static char IBitwiseOperators<char, char, char>.operator &(char left, char right);

-        static char IBitwiseOperators<char, char, char>.operator |(char left, char right);

-        static char IBitwiseOperators<char, char, char>.operator ^(char left, char right);

-        static char IBitwiseOperators<char, char, char>.operator ~(char value);

-        static bool IComparisonOperators<char, char>.operator >(char left, char right);

-        static bool IComparisonOperators<char, char>.operator >=(char left, char right);

-        static bool IComparisonOperators<char, char>.operator <(char left, char right);

-        static bool IComparisonOperators<char, char>.operator <=(char left, char right);

-        static char IDecrementOperators<char>.operator --(char value);

-        static char IDivisionOperators<char, char, char>.operator /(char left, char right);

-        static bool IEqualityOperators<char, char>.operator ==(char left, char right);

-        static bool IEqualityOperators<char, char>.operator !=(char left, char right);

-        static char IIncrementOperators<char>.operator ++(char value);

-        static char IModulusOperators<char, char, char>.operator %(char left, char right);

-        static char IMultiplyOperators<char, char, char>.operator *(char left, char right);

-        static char INumber<char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);

-        static char INumber<char>.Parse(string s, NumberStyles style, IFormatProvider provider);

-        static bool INumber<char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out char result);

-        static bool INumber<char>.TryParse(string s, NumberStyles style, IFormatProvider provider, out char result);

+        static char IParsable<char>.Parse(string s, IFormatProvider provider);
+        static bool IParsable<char>.TryParse(string s, IFormatProvider provider, out char result);
-        static char IParseable<char>.Parse(string s, IFormatProvider provider);

-        static bool IParseable<char>.TryParse(string s, IFormatProvider provider, out char result);

-        static char IShiftOperators<char, char>.operator <<(char value, int shiftAmount);

-        static char IShiftOperators<char, char>.operator >>(char value, int shiftAmount);

+        static char ISpanParsable<char>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool ISpanParsable<char>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out char result);
-        static char ISpanParseable<char>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);

-        static bool ISpanParseable<char>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out char result);

-        static char ISubtractionOperators<char, char, char>.operator -(char left, char right);

-        static char IUnaryNegationOperators<char, char>.operator -(char value);

-        static char IUnaryPlusOperators<char, char>.operator +(char value);

+        static char IAdditionOperators<char, char, char>.operator +(char left, char right);
+        static char IAdditionOperators<char, char, char>.operator checked +(char left, char right);
+        int IBinaryInteger<char>.GetByteCount();
+        long IBinaryInteger<char>.GetShortestBitLength();
+        bool IBinaryInteger<char>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static char IBitwiseOperators<char, char, char>.operator &(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator |(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator ^(char left, char right);
+        static char IBitwiseOperators<char, char, char>.operator ~(char value);
+        static bool IComparisonOperators<char, char>.operator >(char left, char right);
+        static bool IComparisonOperators<char, char>.operator >=(char left, char right);
+        static bool IComparisonOperators<char, char>.operator <(char left, char right);
+        static bool IComparisonOperators<char, char>.operator <=(char left, char right);
+        static char IDecrementOperators<char>.operator checked --(char value);
+        static char IDecrementOperators<char>.operator --(char value);
+        static char IDivisionOperators<char, char, char>.operator checked /(char left, char right);
+        static char IDivisionOperators<char, char, char>.operator /(char left, char right);
+        static bool IEqualityOperators<char, char>.operator ==(char left, char right);
+        static bool IEqualityOperators<char, char>.operator !=(char left, char right);
+        static char IIncrementOperators<char>.operator checked ++(char value);
+        static char IIncrementOperators<char>.operator ++(char value);
+        static char IModulusOperators<char, char, char>.operator %(char left, char right);
+        static char IMultiplyOperators<char, char, char>.operator checked *(char left, char right);
+        static char IMultiplyOperators<char, char, char>.operator *(char left, char right);
+        static char INumber<char>.Abs(char value);
+        static char INumber<char>.CopySign(char value, char sign);
+        static bool INumber<char>.IsNegative(char value);
+        static char INumber<char>.MaxMagnitude(char x, char y);
+        static char INumber<char>.MinMagnitude(char x, char y);
+        static char INumber<char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);
+        static char INumber<char>.Parse(string s, NumberStyles style, IFormatProvider provider);
+        static bool INumber<char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out char result);
+        static bool INumber<char>.TryParse(string s, NumberStyles style, IFormatProvider provider, out char result);
+        static char IShiftOperators<char, char>.operator <<(char value, int shiftAmount);
+        static char IShiftOperators<char, char>.operator >>(char value, int shiftAmount);
+        static char IShiftOperators<char, char>.operator >>>(char value, int shiftAmount);
+        static char ISubtractionOperators<char, char, char>.operator checked -(char left, char right);
+        static char ISubtractionOperators<char, char, char>.operator -(char left, char right);
+        static char IUnaryNegationOperators<char, char>.operator checked -(char value);
+        static char IUnaryNegationOperators<char, char>.operator -(char value);
+        static char IUnaryPlusOperators<char, char>.operator +(char value);
     }
-    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IComparisonOperators<DateOnly, DateOnly>, IEqualityOperators<DateOnly, DateOnly>, IEquatable<DateOnly>, IFormattable, IMinMaxValue<DateOnly>, IParseable<DateOnly>, ISpanFormattable, ISpanParseable<DateOnly>
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IComparisonOperators<DateOnly, DateOnly>, IEqualityOperators<DateOnly, DateOnly>, IEquatable<DateOnly>, IFormattable, IMinMaxValue<DateOnly>, IParsable<DateOnly>, ISpanFormattable, ISpanParsable<DateOnly>
-    public readonly struct DateTime : IAdditionOperators<DateTime, TimeSpan, DateTime>, IAdditiveIdentity<DateTime, TimeSpan>, IComparable, IComparable<DateTime>, IComparisonOperators<DateTime, DateTime>, IConvertible, IEqualityOperators<DateTime, DateTime>, IEquatable<DateTime>, IFormattable, IMinMaxValue<DateTime>, IParseable<DateTime>, ISerializable, ISpanFormattable, ISpanParseable<DateTime>, ISubtractionOperators<DateTime, DateTime, TimeSpan>, ISubtractionOperators<DateTime, TimeSpan, DateTime> {
+    public readonly struct DateTime : IAdditionOperators<DateTime, TimeSpan, DateTime>, IAdditiveIdentity<DateTime, TimeSpan>, IComparable, IComparable<DateTime>, IComparisonOperators<DateTime, DateTime>, IConvertible, IEqualityOperators<DateTime, DateTime>, IEquatable<DateTime>, IFormattable, IMinMaxValue<DateTime>, IParsable<DateTime>, ISerializable, ISpanFormattable, ISpanParsable<DateTime>, ISubtractionOperators<DateTime, DateTime, TimeSpan>, ISubtractionOperators<DateTime, TimeSpan, DateTime> {
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, DateTimeKind kind);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar);
+        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar, DateTimeKind kind);
-        public static TimeSpan AdditiveIdentity { get; }

+        public int Microsecond { get; }
+        public int Nanosecond { get; }
-        static DateTime System.IMinMaxValue<System.DateTime>.MaxValue { get; }

-        static DateTime System.IMinMaxValue<System.DateTime>.MinValue { get; }

+        static TimeSpan System.Numerics.IAdditiveIdentity<System.DateTime,System.TimeSpan>.AdditiveIdentity { get; }
+        static DateTime System.Numerics.IMinMaxValue<System.DateTime>.MaxValue { get; }
+        static DateTime System.Numerics.IMinMaxValue<System.DateTime>.MinValue { get; }
+        public DateTime AddMicroseconds(double value);
+        static DateTime IAdditionOperators<DateTime, TimeSpan, DateTime>.operator checked +(DateTime left, TimeSpan right);
+        static TimeSpan ISubtractionOperators<DateTime, DateTime, TimeSpan>.operator checked -(DateTime left, DateTime right);
+        static DateTime ISubtractionOperators<DateTime, TimeSpan, DateTime>.operator checked -(DateTime left, TimeSpan right);
     }
-    public readonly struct DateTimeOffset : IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>, IAdditiveIdentity<DateTimeOffset, TimeSpan>, IComparable, IComparable<DateTimeOffset>, IComparisonOperators<DateTimeOffset, DateTimeOffset>, IDeserializationCallback, IEqualityOperators<DateTimeOffset, DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable, IMinMaxValue<DateTimeOffset>, IParseable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParseable<DateTimeOffset>, ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>, ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset> {
+    public readonly struct DateTimeOffset : IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>, IAdditiveIdentity<DateTimeOffset, TimeSpan>, IComparable, IComparable<DateTimeOffset>, IComparisonOperators<DateTimeOffset, DateTimeOffset>, IDeserializationCallback, IEqualityOperators<DateTimeOffset, DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable, IMinMaxValue<DateTimeOffset>, IParsable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParsable<DateTimeOffset>, ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>, ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset> {
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, Calendar calendar, TimeSpan offset);
+        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, int microsecond, TimeSpan offset);
-        public static TimeSpan AdditiveIdentity { get; }

+        public int Microsecond { get; }
+        public int Nanosecond { get; }
-        static DateTimeOffset System.IMinMaxValue<System.DateTimeOffset>.MaxValue { get; }

-        static DateTimeOffset System.IMinMaxValue<System.DateTimeOffset>.MinValue { get; }

+        static TimeSpan System.Numerics.IAdditiveIdentity<System.DateTimeOffset,System.TimeSpan>.AdditiveIdentity { get; }
+        static DateTimeOffset System.Numerics.IMinMaxValue<System.DateTimeOffset>.MaxValue { get; }
+        static DateTimeOffset System.Numerics.IMinMaxValue<System.DateTimeOffset>.MinValue { get; }
+        public DateTimeOffset AddMicroseconds(double microseconds);
+        static DateTimeOffset IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>.operator checked +(DateTimeOffset left, TimeSpan right);
+        static TimeSpan ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>.operator checked -(DateTimeOffset left, DateTimeOffset right);
+        static DateTimeOffset ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>.operator checked -(DateTimeOffset left, TimeSpan right);
     }
-    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, IParseable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParseable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFloatingPoint<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
-        public static readonly decimal AdditiveIdentity;

-        public static readonly decimal MultiplicativeIdentity;

-        public static readonly decimal NegativeOne;

-        static decimal System.IAdditiveIdentity<System.Decimal,System.Decimal>.AdditiveIdentity { get; }

-        static decimal System.IMinMaxValue<System.Decimal>.MaxValue { get; }

-        static decimal System.IMinMaxValue<System.Decimal>.MinValue { get; }

-        static decimal System.IMultiplicativeIdentity<System.Decimal,System.Decimal>.MultiplicativeIdentity { get; }

-        static decimal System.INumber<System.Decimal>.One { get; }

-        static decimal System.INumber<System.Decimal>.Zero { get; }

-        static decimal System.ISignedNumber<System.Decimal>.NegativeOne { get; }

+        static decimal System.Numerics.IAdditiveIdentity<System.Decimal,System.Decimal>.AdditiveIdentity { get; }
+        static decimal System.Numerics.IMinMaxValue<System.Decimal>.MaxValue { get; }
+        static decimal System.Numerics.IMinMaxValue<System.Decimal>.MinValue { get; }
+        static decimal System.Numerics.IMultiplicativeIdentity<System.Decimal,System.Decimal>.MultiplicativeIdentity { get; }
+        static decimal System.Numerics.INumberBase<System.Decimal>.One { get; }
+        static decimal System.Numerics.INumberBase<System.Decimal>.Zero { get; }
+        static decimal System.Numerics.ISignedNumber<System.Decimal>.NegativeOne { get; }
+        public static decimal CopySign(decimal value, decimal sign);
-        public static decimal Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static decimal CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static (decimal Quotient, decimal Remainder) DivRem(decimal left, decimal right);

+        public static bool IsNegative(decimal value);
+        public static decimal MaxMagnitude(decimal x, decimal y);
+        public static decimal MinMagnitude(decimal x, decimal y);
+        public static decimal operator checked *(decimal left, decimal right);
+        public static int Sign(decimal d);
-        static decimal INumber<decimal>.Sign(decimal value);

+        static decimal IAdditionOperators<decimal, decimal, decimal>.operator checked +(decimal left, decimal right);
+        static decimal IDecrementOperators<decimal>.operator checked --(decimal value);
+        static decimal IDivisionOperators<decimal, decimal, decimal>.operator checked /(decimal left, decimal right);
+        int IFloatingPoint<decimal>.GetExponentByteCount();
+        long IFloatingPoint<decimal>.GetExponentShortestBitLength();
+        long IFloatingPoint<decimal>.GetSignificandBitLength();
+        int IFloatingPoint<decimal>.GetSignificandByteCount();
+        bool IFloatingPoint<decimal>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<decimal>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static decimal IIncrementOperators<decimal>.operator checked ++(decimal value);
+        static decimal ISubtractionOperators<decimal, decimal, decimal>.operator checked -(decimal left, decimal right);
+        static decimal IUnaryNegationOperators<decimal, decimal>.operator checked -(decimal value);
     }
-    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPoint<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IFloatingPoint<double>, IFormattable, IIncrementOperators<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, IParseable<double>, ISignedNumber<double>, ISpanFormattable, ISpanParseable<double>, ISubtractionOperators<double, double, double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
-        public const double AdditiveIdentity = 0;

-        public const double MultiplicativeIdentity = 1;

-        public const double NegativeOne = -1;

-        public const double One = 1;

-        public const double Zero = 0;

-        static double System.IAdditiveIdentity<System.Double,System.Double>.AdditiveIdentity { get; }

-        static double System.IFloatingPoint<System.Double>.E { get; }

-        static double System.IFloatingPoint<System.Double>.Epsilon { get; }

-        static double System.IFloatingPoint<System.Double>.NaN { get; }

-        static double System.IFloatingPoint<System.Double>.NegativeInfinity { get; }

-        static double System.IFloatingPoint<System.Double>.NegativeZero { get; }

-        static double System.IFloatingPoint<System.Double>.Pi { get; }

-        static double System.IFloatingPoint<System.Double>.PositiveInfinity { get; }

-        static double System.IFloatingPoint<System.Double>.Tau { get; }

-        static double System.IMinMaxValue<System.Double>.MaxValue { get; }

-        static double System.IMinMaxValue<System.Double>.MinValue { get; }

-        static double System.IMultiplicativeIdentity<System.Double,System.Double>.MultiplicativeIdentity { get; }

-        static double System.INumber<System.Double>.One { get; }

-        static double System.INumber<System.Double>.Zero { get; }

-        static double System.ISignedNumber<System.Double>.NegativeOne { get; }

+        static double System.Numerics.IAdditiveIdentity<System.Double,System.Double>.AdditiveIdentity { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.E { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.Epsilon { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NaN { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NegativeInfinity { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.NegativeZero { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.Pi { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.PositiveInfinity { get; }
+        static double System.Numerics.IFloatingPointIeee754<System.Double>.Tau { get; }
+        static double System.Numerics.IMinMaxValue<System.Double>.MaxValue { get; }
+        static double System.Numerics.IMinMaxValue<System.Double>.MinValue { get; }
+        static double System.Numerics.IMultiplicativeIdentity<System.Double,System.Double>.MultiplicativeIdentity { get; }
+        static double System.Numerics.INumberBase<System.Double>.One { get; }
+        static double System.Numerics.INumberBase<System.Double>.Zero { get; }
+        static double System.Numerics.ISignedNumber<System.Double>.NegativeOne { get; }
-        public static double Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static double CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static (double Quotient, double Remainder) DivRem(double left, double right);

+        public static double Ieee754Remainder(double left, double right);
-        public static double IEEERemainder(double left, double right);

+        public static int ILogB(double x);
-        public static TInteger ILogB<TInteger>(double x) where TInteger : IBinaryInteger<TInteger>;

+        public static double ReciprocalEstimate(double x);
+        public static double ReciprocalSqrtEstimate(double x);
+        public static double Round(double x, int digits);
+        public static double Round(double x, int digits, MidpointRounding mode);
-        public static double Round<TInteger>(double x, TInteger digits) where TInteger : IBinaryInteger<TInteger>;

-        public static double Round<TInteger>(double x, TInteger digits, MidpointRounding mode) where TInteger : IBinaryInteger<TInteger>;

+        public static double ScaleB(double x, int n);
-        public static double ScaleB<TInteger>(double x, TInteger n) where TInteger : IBinaryInteger<TInteger>;

-        public static double Sign(double value);

+        public static int Sign(double value);
+        public static (double Sin, double Cos) SinCos(double x);
-        static double IAdditionOperators<double, double, double>.operator +(double left, double right);

-        static double IBitwiseOperators<double, double, double>.operator &(double left, double right);

-        static double IBitwiseOperators<double, double, double>.operator |(double left, double right);

-        static double IBitwiseOperators<double, double, double>.operator ^(double left, double right);

-        static double IBitwiseOperators<double, double, double>.operator ~(double value);

-        static double IDecrementOperators<double>.operator --(double value);

-        static double IDivisionOperators<double, double, double>.operator /(double left, double right);

-        static double IIncrementOperators<double>.operator ++(double value);

-        static double IModulusOperators<double, double, double>.operator %(double left, double right);

-        static double IMultiplyOperators<double, double, double>.operator *(double left, double right);

-        static double ISubtractionOperators<double, double, double>.operator -(double left, double right);

-        static double IUnaryNegationOperators<double, double>.operator -(double value);

-        static double IUnaryPlusOperators<double, double>.operator +(double value);

+        static double IAdditionOperators<double, double, double>.operator +(double left, double right);
+        static double IAdditionOperators<double, double, double>.operator checked +(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator &(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator |(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator ^(double left, double right);
+        static double IBitwiseOperators<double, double, double>.operator ~(double value);
+        static double IDecrementOperators<double>.operator checked --(double value);
+        static double IDecrementOperators<double>.operator --(double value);
+        static double IDivisionOperators<double, double, double>.operator checked /(double left, double right);
+        static double IDivisionOperators<double, double, double>.operator /(double left, double right);
+        int IFloatingPoint<double>.GetExponentByteCount();
+        long IFloatingPoint<double>.GetExponentShortestBitLength();
+        long IFloatingPoint<double>.GetSignificandBitLength();
+        int IFloatingPoint<double>.GetSignificandByteCount();
+        bool IFloatingPoint<double>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<double>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static double IIncrementOperators<double>.operator checked ++(double value);
+        static double IIncrementOperators<double>.operator ++(double value);
+        static double IModulusOperators<double, double, double>.operator %(double left, double right);
+        static double IMultiplyOperators<double, double, double>.operator checked *(double left, double right);
+        static double IMultiplyOperators<double, double, double>.operator *(double left, double right);
+        static double ISubtractionOperators<double, double, double>.operator checked -(double left, double right);
+        static double ISubtractionOperators<double, double, double>.operator -(double left, double right);
+        static double IUnaryNegationOperators<double, double>.operator checked -(double value);
+        static double IUnaryNegationOperators<double, double>.operator -(double value);
+        static double IUnaryPlusOperators<double, double>.operator +(double value);
     }
     public static class GC {
+        public static GCNotificationStatus WaitForFullGCApproach(TimeSpan timeout);
+        public static GCNotificationStatus WaitForFullGCComplete(TimeSpan timeout);
     }
-    public readonly struct Guid : IComparable, IComparable<Guid>, IComparisonOperators<Guid, Guid>, IEqualityOperators<Guid, Guid>, IEquatable<Guid>, IFormattable, IParseable<Guid>, ISpanFormattable, ISpanParseable<Guid>
+    public readonly struct Guid : IComparable, IComparable<Guid>, IComparisonOperators<Guid, Guid>, IEqualityOperators<Guid, Guid>, IEquatable<Guid>, IFormattable, IParsable<Guid>, ISpanFormattable, ISpanParsable<Guid>
-    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPoint<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IFloatingPoint<Half>, IFormattable, IIncrementOperators<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, IParseable<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParseable<Half>, ISubtractionOperators<Half, Half, Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
-        public static Half AdditiveIdentity { get; }

-        public static Half NegativeOne { get; }

-        public static Half One { get; }

+        static Half System.Numerics.IAdditiveIdentity<System.Half,System.Half>.AdditiveIdentity { get; }
+        static Half System.Numerics.INumberBase<System.Half>.One { get; }
+        static Half System.Numerics.INumberBase<System.Half>.Zero { get; }
+        static Half System.Numerics.ISignedNumber<System.Half>.NegativeOne { get; }
-        public static Half Zero { get; }

-        public static Half Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static Half CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static (Half Quotient, Half Remainder) DivRem(Half left, Half right);

+        public static Half Ieee754Remainder(Half left, Half right);
-        public static Half IEEERemainder(Half left, Half right);

+        public static int ILogB(Half x);
-        public static TInteger ILogB<TInteger>(Half x) where TInteger : IBinaryInteger<TInteger>;

+        public static Half ReciprocalEstimate(Half x);
+        public static Half ReciprocalSqrtEstimate(Half x);
+        public static Half Round(Half x, int digits);
+        public static Half Round(Half x, int digits, MidpointRounding mode);
-        public static Half Round<TInteger>(Half x, TInteger digits) where TInteger : IBinaryInteger<TInteger>;

-        public static Half Round<TInteger>(Half x, TInteger digits, MidpointRounding mode) where TInteger : IBinaryInteger<TInteger>;

+        public static Half ScaleB(Half x, int n);
-        public static Half ScaleB<TInteger>(Half x, TInteger n) where TInteger : IBinaryInteger<TInteger>;

-        public static Half Sign(Half value);

+        public static int Sign(Half value);
+        public static (Half Sin, Half Cos) SinCos(Half x);
-        static Half IBitwiseOperators<Half, Half, Half>.operator &(Half left, Half right);

-        static Half IBitwiseOperators<Half, Half, Half>.operator |(Half left, Half right);

-        static Half IBitwiseOperators<Half, Half, Half>.operator ^(Half left, Half right);

-        static Half IBitwiseOperators<Half, Half, Half>.operator ~(Half value);

+        static Half IAdditionOperators<Half, Half, Half>.operator checked +(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator &(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator |(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator ^(Half left, Half right);
+        static Half IBitwiseOperators<Half, Half, Half>.operator ~(Half value);
+        static Half IDecrementOperators<Half>.operator checked --(Half value);
+        static Half IDivisionOperators<Half, Half, Half>.operator checked /(Half left, Half right);
+        int IFloatingPoint<Half>.GetExponentByteCount();
+        long IFloatingPoint<Half>.GetExponentShortestBitLength();
+        long IFloatingPoint<Half>.GetSignificandBitLength();
+        int IFloatingPoint<Half>.GetSignificandByteCount();
+        bool IFloatingPoint<Half>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<Half>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static Half IIncrementOperators<Half>.operator checked ++(Half value);
+        static Half IMultiplyOperators<Half, Half, Half>.operator checked *(Half left, Half right);
+        static Half ISubtractionOperators<Half, Half, Half>.operator checked -(Half left, Half right);
+        static Half IUnaryNegationOperators<Half, Half>.operator checked -(Half value);
     }
-    public interface IAdditionOperators<TSelf, TOther, TResult> where TSelf : IAdditionOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator +(TSelf left, TOther right);

-    }
-    public interface IAdditiveIdentity<TSelf, TResult> where TSelf : IAdditiveIdentity<TSelf, TResult> {
 {
-        static abstract TResult AdditiveIdentity { get; }

-    }
-    public interface IBinaryFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFloatingPoint<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryFloatingPoint<TSelf>

-    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, IShiftOperators<TSelf, TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf> {
 {
-        static abstract TSelf LeadingZeroCount(TSelf value);

-        static abstract TSelf PopCount(TSelf value);

-        static abstract TSelf RotateLeft(TSelf value, int rotateAmount);

-        static abstract TSelf RotateRight(TSelf value, int rotateAmount);

-        static abstract TSelf TrailingZeroCount(TSelf value);

-    }
-    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryNumber<TSelf> {
 {
-        static abstract bool IsPow2(TSelf value);

-        static abstract TSelf Log2(TSelf value);

-    }
-    public interface IBitwiseOperators<TSelf, TOther, TResult> where TSelf : IBitwiseOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator &(TSelf left, TOther right);

-        static abstract TResult operator |(TSelf left, TOther right);

-        static abstract TResult operator ^(TSelf left, TOther right);

-        static abstract TResult operator ~(TSelf value);

-    }
-    public interface IComparisonOperators<TSelf, TOther> : IComparable, IComparable<TOther>, IEqualityOperators<TSelf, TOther>, IEquatable<TOther> where TSelf : IComparisonOperators<TSelf, TOther> {
 {
-        static abstract bool operator >(TSelf left, TOther right);

-        static abstract bool operator >=(TSelf left, TOther right);

-        static abstract bool operator <(TSelf left, TOther right);

-        static abstract bool operator <=(TSelf left, TOther right);

-    }
-    public interface IDecrementOperators<TSelf> where TSelf : IDecrementOperators<TSelf> {
 {
-        static abstract TSelf operator --(TSelf value);

-    }
-    public interface IDivisionOperators<TSelf, TOther, TResult> where TSelf : IDivisionOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator /(TSelf left, TOther right);

-    }
-    public interface IEqualityOperators<TSelf, TOther> : IEquatable<TOther> where TSelf : IEqualityOperators<TSelf, TOther> {
 {
-        static abstract bool operator ==(TSelf left, TOther right);

-        static abstract bool operator !=(TSelf left, TOther right);

-    }
-    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf> {
 {
-        static abstract TSelf E { get; }

-        static abstract TSelf Epsilon { get; }

-        static abstract TSelf NaN { get; }

-        static abstract TSelf NegativeInfinity { get; }

-        static abstract TSelf NegativeZero { get; }

-        static abstract TSelf Pi { get; }

-        static abstract TSelf PositiveInfinity { get; }

-        static abstract TSelf Tau { get; }

-        static abstract TSelf Acos(TSelf x);

-        static abstract TSelf Acosh(TSelf x);

-        static abstract TSelf Asin(TSelf x);

-        static abstract TSelf Asinh(TSelf x);

-        static abstract TSelf Atan(TSelf x);

-        static abstract TSelf Atan2(TSelf y, TSelf x);

-        static abstract TSelf Atanh(TSelf x);

-        static abstract TSelf BitDecrement(TSelf x);

-        static abstract TSelf BitIncrement(TSelf x);

-        static abstract TSelf Cbrt(TSelf x);

-        static abstract TSelf Ceiling(TSelf x);

-        static abstract TSelf CopySign(TSelf x, TSelf y);

-        static abstract TSelf Cos(TSelf x);

-        static abstract TSelf Cosh(TSelf x);

-        static abstract TSelf Exp(TSelf x);

-        static abstract TSelf Floor(TSelf x);

-        static abstract TSelf FusedMultiplyAdd(TSelf left, TSelf right, TSelf addend);

-        static abstract TSelf IEEERemainder(TSelf left, TSelf right);

-        static abstract TInteger ILogB<TInteger>(TSelf x);

-        static abstract bool IsFinite(TSelf value);

-        static abstract bool IsInfinity(TSelf value);

-        static abstract bool IsNaN(TSelf value);

-        static abstract bool IsNegative(TSelf value);

-        static abstract bool IsNegativeInfinity(TSelf value);

-        static abstract bool IsNormal(TSelf value);

-        static abstract bool IsPositiveInfinity(TSelf value);

-        static abstract bool IsSubnormal(TSelf value);

-        static abstract TSelf Log(TSelf x);

-        static abstract TSelf Log(TSelf x, TSelf newBase);

-        static abstract TSelf Log10(TSelf x);

-        static abstract TSelf Log2(TSelf x);

-        static abstract TSelf MaxMagnitude(TSelf x, TSelf y);

-        static abstract TSelf MinMagnitude(TSelf x, TSelf y);

-        static abstract TSelf Pow(TSelf x, TSelf y);

-        static abstract TSelf Round(TSelf x);

-        static abstract TSelf Round(TSelf x, MidpointRounding mode);

-        static abstract TSelf Round<TInteger>(TSelf x, TInteger digits);

-        static abstract TSelf Round<TInteger>(TSelf x, TInteger digits, MidpointRounding mode);

-        static abstract TSelf ScaleB<TInteger>(TSelf x, TInteger n);

-        static abstract TSelf Sin(TSelf x);

-        static abstract TSelf Sinh(TSelf x);

-        static abstract TSelf Sqrt(TSelf x);

-        static abstract TSelf Tan(TSelf x);

-        static abstract TSelf Tanh(TSelf x);

-        static abstract TSelf Truncate(TSelf x);

-    }
-    public interface IIncrementOperators<TSelf> where TSelf : IIncrementOperators<TSelf> {
 {
-        static abstract TSelf operator ++(TSelf value);

-    }
-    public interface IMinMaxValue<TSelf> where TSelf : IMinMaxValue<TSelf> {
 {
-        static abstract TSelf MaxValue { get; }

-        static abstract TSelf MinValue { get; }

-    }
-    public interface IModulusOperators<TSelf, TOther, TResult> where TSelf : IModulusOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator %(TSelf left, TOther right);

-    }
-    public interface IMultiplicativeIdentity<TSelf, TResult> where TSelf : IMultiplicativeIdentity<TSelf, TResult> {
 {
-        static abstract TResult MultiplicativeIdentity { get; }

-    }
-    public interface IMultiplyOperators<TSelf, TOther, TResult> where TSelf : IMultiplyOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator *(TSelf left, TOther right);

-    }
-    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, IParseable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParseable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
-        public const short AdditiveIdentity = (short)0;

-        public const short MultiplicativeIdentity = (short)1;

-        public const short NegativeOne = (short)-1;

-        public const short One = (short)1;

-        public const short Zero = (short)0;

-        static short System.IAdditiveIdentity<System.Int16,System.Int16>.AdditiveIdentity { get; }

-        static short System.IMinMaxValue<System.Int16>.MaxValue { get; }

-        static short System.IMinMaxValue<System.Int16>.MinValue { get; }

-        static short System.IMultiplicativeIdentity<System.Int16,System.Int16>.MultiplicativeIdentity { get; }

-        static short System.INumber<System.Int16>.One { get; }

-        static short System.INumber<System.Int16>.Zero { get; }

-        static short System.ISignedNumber<System.Int16>.NegativeOne { get; }

+        static short System.Numerics.IAdditiveIdentity<System.Int16,System.Int16>.AdditiveIdentity { get; }
+        static short System.Numerics.IMinMaxValue<System.Int16>.MaxValue { get; }
+        static short System.Numerics.IMinMaxValue<System.Int16>.MinValue { get; }
+        static short System.Numerics.IMultiplicativeIdentity<System.Int16,System.Int16>.MultiplicativeIdentity { get; }
+        static short System.Numerics.INumberBase<System.Int16>.One { get; }
+        static short System.Numerics.INumberBase<System.Int16>.Zero { get; }
+        static short System.Numerics.ISignedNumber<System.Int16>.NegativeOne { get; }
+        public static short CopySign(short value, short sign);
-        public static short Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static short CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsNegative(short value);
+        public static short MaxMagnitude(short x, short y);
+        public static short MinMagnitude(short x, short y);
-        public static short Sign(short value);

+        public static int Sign(short value);
-        static short IAdditionOperators<short, short, short>.operator +(short left, short right);

-        static short IBitwiseOperators<short, short, short>.operator &(short left, short right);

-        static short IBitwiseOperators<short, short, short>.operator |(short left, short right);

-        static short IBitwiseOperators<short, short, short>.operator ^(short left, short right);

-        static short IBitwiseOperators<short, short, short>.operator ~(short value);

-        static bool IComparisonOperators<short, short>.operator >(short left, short right);

-        static bool IComparisonOperators<short, short>.operator >=(short left, short right);

-        static bool IComparisonOperators<short, short>.operator <(short left, short right);

-        static bool IComparisonOperators<short, short>.operator <=(short left, short right);

-        static short IDecrementOperators<short>.operator --(short value);

-        static short IDivisionOperators<short, short, short>.operator /(short left, short right);

-        static bool IEqualityOperators<short, short>.operator ==(short left, short right);

-        static bool IEqualityOperators<short, short>.operator !=(short left, short right);

-        static short IIncrementOperators<short>.operator ++(short value);

-        static short IModulusOperators<short, short, short>.operator %(short left, short right);

-        static short IMultiplyOperators<short, short, short>.operator *(short left, short right);

-        static short IShiftOperators<short, short>.operator <<(short value, int shiftAmount);

-        static short IShiftOperators<short, short>.operator >>(short value, int shiftAmount);

-        static short ISubtractionOperators<short, short, short>.operator -(short left, short right);

-        static short IUnaryNegationOperators<short, short>.operator -(short value);

-        static short IUnaryPlusOperators<short, short>.operator +(short value);

+        static short IAdditionOperators<short, short, short>.operator +(short left, short right);
+        static short IAdditionOperators<short, short, short>.operator checked +(short left, short right);
+        int IBinaryInteger<short>.GetByteCount();
+        long IBinaryInteger<short>.GetShortestBitLength();
+        bool IBinaryInteger<short>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static short IBitwiseOperators<short, short, short>.operator &(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator |(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator ^(short left, short right);
+        static short IBitwiseOperators<short, short, short>.operator ~(short value);
+        static bool IComparisonOperators<short, short>.operator >(short left, short right);
+        static bool IComparisonOperators<short, short>.operator >=(short left, short right);
+        static bool IComparisonOperators<short, short>.operator <(short left, short right);
+        static bool IComparisonOperators<short, short>.operator <=(short left, short right);
+        static short IDecrementOperators<short>.operator checked --(short value);
+        static short IDecrementOperators<short>.operator --(short value);
+        static short IDivisionOperators<short, short, short>.operator checked /(short left, short right);
+        static short IDivisionOperators<short, short, short>.operator /(short left, short right);
+        static bool IEqualityOperators<short, short>.operator ==(short left, short right);
+        static bool IEqualityOperators<short, short>.operator !=(short left, short right);
+        static short IIncrementOperators<short>.operator checked ++(short value);
+        static short IIncrementOperators<short>.operator ++(short value);
+        static short IModulusOperators<short, short, short>.operator %(short left, short right);
+        static short IMultiplyOperators<short, short, short>.operator checked *(short left, short right);
+        static short IMultiplyOperators<short, short, short>.operator *(short left, short right);
+        static short IShiftOperators<short, short>.operator <<(short value, int shiftAmount);
+        static short IShiftOperators<short, short>.operator >>(short value, int shiftAmount);
+        static short IShiftOperators<short, short>.operator >>>(short value, int shiftAmount);
+        static short ISubtractionOperators<short, short, short>.operator checked -(short left, short right);
+        static short ISubtractionOperators<short, short, short>.operator -(short left, short right);
+        static short IUnaryNegationOperators<short, short>.operator checked -(short value);
+        static short IUnaryNegationOperators<short, short>.operator -(short value);
+        static short IUnaryPlusOperators<short, short>.operator +(short value);
     }
-    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, IParseable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParseable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
-        public const int AdditiveIdentity = 0;

-        public const int MultiplicativeIdentity = 1;

-        public const int NegativeOne = -1;

-        public const int One = 1;

-        public const int Zero = 0;

-        static int System.IAdditiveIdentity<System.Int32,System.Int32>.AdditiveIdentity { get; }

-        static int System.IMinMaxValue<System.Int32>.MaxValue { get; }

-        static int System.IMinMaxValue<System.Int32>.MinValue { get; }

-        static int System.IMultiplicativeIdentity<System.Int32,System.Int32>.MultiplicativeIdentity { get; }

-        static int System.INumber<System.Int32>.One { get; }

-        static int System.INumber<System.Int32>.Zero { get; }

-        static int System.ISignedNumber<System.Int32>.NegativeOne { get; }

+        static int System.Numerics.IAdditiveIdentity<System.Int32,System.Int32>.AdditiveIdentity { get; }
+        static int System.Numerics.IMinMaxValue<System.Int32>.MaxValue { get; }
+        static int System.Numerics.IMinMaxValue<System.Int32>.MinValue { get; }
+        static int System.Numerics.IMultiplicativeIdentity<System.Int32,System.Int32>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Int32>.One { get; }
+        static int System.Numerics.INumberBase<System.Int32>.Zero { get; }
+        static int System.Numerics.ISignedNumber<System.Int32>.NegativeOne { get; }
+        public static int CopySign(int value, int sign);
-        public static int Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static int CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsNegative(int value);
+        public static int MaxMagnitude(int x, int y);
+        public static int MinMagnitude(int x, int y);
-        static int IAdditionOperators<int, int, int>.operator +(int left, int right);

-        static int IBitwiseOperators<int, int, int>.operator &(int left, int right);

-        static int IBitwiseOperators<int, int, int>.operator |(int left, int right);

-        static int IBitwiseOperators<int, int, int>.operator ^(int left, int right);

-        static int IBitwiseOperators<int, int, int>.operator ~(int value);

-        static bool IComparisonOperators<int, int>.operator >(int left, int right);

-        static bool IComparisonOperators<int, int>.operator >=(int left, int right);

-        static bool IComparisonOperators<int, int>.operator <(int left, int right);

-        static bool IComparisonOperators<int, int>.operator <=(int left, int right);

-        static int IDecrementOperators<int>.operator --(int value);

-        static int IDivisionOperators<int, int, int>.operator /(int left, int right);

-        static bool IEqualityOperators<int, int>.operator ==(int left, int right);

-        static bool IEqualityOperators<int, int>.operator !=(int left, int right);

-        static int IIncrementOperators<int>.operator ++(int value);

-        static int IModulusOperators<int, int, int>.operator %(int left, int right);

-        static int IMultiplyOperators<int, int, int>.operator *(int left, int right);

-        static int IShiftOperators<int, int>.operator <<(int value, int shiftAmount);

-        static int IShiftOperators<int, int>.operator >>(int value, int shiftAmount);

-        static int ISubtractionOperators<int, int, int>.operator -(int left, int right);

-        static int IUnaryNegationOperators<int, int>.operator -(int value);

-        static int IUnaryPlusOperators<int, int>.operator +(int value);

+        static int IAdditionOperators<int, int, int>.operator +(int left, int right);
+        static int IAdditionOperators<int, int, int>.operator checked +(int left, int right);
+        int IBinaryInteger<int>.GetByteCount();
+        long IBinaryInteger<int>.GetShortestBitLength();
+        bool IBinaryInteger<int>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static int IBitwiseOperators<int, int, int>.operator &(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator |(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator ^(int left, int right);
+        static int IBitwiseOperators<int, int, int>.operator ~(int value);
+        static bool IComparisonOperators<int, int>.operator >(int left, int right);
+        static bool IComparisonOperators<int, int>.operator >=(int left, int right);
+        static bool IComparisonOperators<int, int>.operator <(int left, int right);
+        static bool IComparisonOperators<int, int>.operator <=(int left, int right);
+        static int IDecrementOperators<int>.operator checked --(int value);
+        static int IDecrementOperators<int>.operator --(int value);
+        static int IDivisionOperators<int, int, int>.operator checked /(int left, int right);
+        static int IDivisionOperators<int, int, int>.operator /(int left, int right);
+        static bool IEqualityOperators<int, int>.operator ==(int left, int right);
+        static bool IEqualityOperators<int, int>.operator !=(int left, int right);
+        static int IIncrementOperators<int>.operator checked ++(int value);
+        static int IIncrementOperators<int>.operator ++(int value);
+        static int IModulusOperators<int, int, int>.operator %(int left, int right);
+        static int IMultiplyOperators<int, int, int>.operator checked *(int left, int right);
+        static int IMultiplyOperators<int, int, int>.operator *(int left, int right);
+        static int IShiftOperators<int, int>.operator <<(int value, int shiftAmount);
+        static int IShiftOperators<int, int>.operator >>(int value, int shiftAmount);
+        static int IShiftOperators<int, int>.operator >>>(int value, int shiftAmount);
+        static int ISubtractionOperators<int, int, int>.operator checked -(int left, int right);
+        static int ISubtractionOperators<int, int, int>.operator -(int left, int right);
+        static int IUnaryNegationOperators<int, int>.operator checked -(int value);
+        static int IUnaryNegationOperators<int, int>.operator -(int value);
+        static int IUnaryPlusOperators<int, int>.operator +(int value);
     }
-    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, IParseable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParseable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
-        public const long AdditiveIdentity = (long)0;

-        public const long MultiplicativeIdentity = (long)1;

-        public const long NegativeOne = (long)-1;

-        public const long One = (long)1;

-        public const long Zero = (long)0;

-        static long System.IAdditiveIdentity<System.Int64,System.Int64>.AdditiveIdentity { get; }

-        static long System.IMinMaxValue<System.Int64>.MaxValue { get; }

-        static long System.IMinMaxValue<System.Int64>.MinValue { get; }

-        static long System.IMultiplicativeIdentity<System.Int64,System.Int64>.MultiplicativeIdentity { get; }

-        static long System.INumber<System.Int64>.One { get; }

-        static long System.INumber<System.Int64>.Zero { get; }

-        static long System.ISignedNumber<System.Int64>.NegativeOne { get; }

+        static long System.Numerics.IAdditiveIdentity<System.Int64,System.Int64>.AdditiveIdentity { get; }
+        static long System.Numerics.IMinMaxValue<System.Int64>.MaxValue { get; }
+        static long System.Numerics.IMinMaxValue<System.Int64>.MinValue { get; }
+        static long System.Numerics.IMultiplicativeIdentity<System.Int64,System.Int64>.MultiplicativeIdentity { get; }
+        static long System.Numerics.INumberBase<System.Int64>.One { get; }
+        static long System.Numerics.INumberBase<System.Int64>.Zero { get; }
+        static long System.Numerics.ISignedNumber<System.Int64>.NegativeOne { get; }
+        public static long CopySign(long value, long sign);
-        public static long Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static long CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsNegative(long value);
+        public static long MaxMagnitude(long x, long y);
+        public static long MinMagnitude(long x, long y);
-        public static long Sign(long value);

+        public static int Sign(long value);
-        static long IAdditionOperators<long, long, long>.operator +(long left, long right);

-        static long IBitwiseOperators<long, long, long>.operator &(long left, long right);

-        static long IBitwiseOperators<long, long, long>.operator |(long left, long right);

-        static long IBitwiseOperators<long, long, long>.operator ^(long left, long right);

-        static long IBitwiseOperators<long, long, long>.operator ~(long value);

-        static bool IComparisonOperators<long, long>.operator >(long left, long right);

-        static bool IComparisonOperators<long, long>.operator >=(long left, long right);

-        static bool IComparisonOperators<long, long>.operator <(long left, long right);

-        static bool IComparisonOperators<long, long>.operator <=(long left, long right);

-        static long IDecrementOperators<long>.operator --(long value);

-        static long IDivisionOperators<long, long, long>.operator /(long left, long right);

-        static bool IEqualityOperators<long, long>.operator ==(long left, long right);

-        static bool IEqualityOperators<long, long>.operator !=(long left, long right);

-        static long IIncrementOperators<long>.operator ++(long value);

-        static long IModulusOperators<long, long, long>.operator %(long left, long right);

-        static long IMultiplyOperators<long, long, long>.operator *(long left, long right);

-        static long IShiftOperators<long, long>.operator <<(long value, int shiftAmount);

-        static long IShiftOperators<long, long>.operator >>(long value, int shiftAmount);

-        static long ISubtractionOperators<long, long, long>.operator -(long left, long right);

-        static long IUnaryNegationOperators<long, long>.operator -(long value);

-        static long IUnaryPlusOperators<long, long>.operator +(long value);

+        static long IAdditionOperators<long, long, long>.operator +(long left, long right);
+        static long IAdditionOperators<long, long, long>.operator checked +(long left, long right);
+        int IBinaryInteger<long>.GetByteCount();
+        long IBinaryInteger<long>.GetShortestBitLength();
+        bool IBinaryInteger<long>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static long IBitwiseOperators<long, long, long>.operator &(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator |(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator ^(long left, long right);
+        static long IBitwiseOperators<long, long, long>.operator ~(long value);
+        static bool IComparisonOperators<long, long>.operator >(long left, long right);
+        static bool IComparisonOperators<long, long>.operator >=(long left, long right);
+        static bool IComparisonOperators<long, long>.operator <(long left, long right);
+        static bool IComparisonOperators<long, long>.operator <=(long left, long right);
+        static long IDecrementOperators<long>.operator checked --(long value);
+        static long IDecrementOperators<long>.operator --(long value);
+        static long IDivisionOperators<long, long, long>.operator checked /(long left, long right);
+        static long IDivisionOperators<long, long, long>.operator /(long left, long right);
+        static bool IEqualityOperators<long, long>.operator ==(long left, long right);
+        static bool IEqualityOperators<long, long>.operator !=(long left, long right);
+        static long IIncrementOperators<long>.operator checked ++(long value);
+        static long IIncrementOperators<long>.operator ++(long value);
+        static long IModulusOperators<long, long, long>.operator %(long left, long right);
+        static long IMultiplyOperators<long, long, long>.operator checked *(long left, long right);
+        static long IMultiplyOperators<long, long, long>.operator *(long left, long right);
+        static long IShiftOperators<long, long>.operator <<(long value, int shiftAmount);
+        static long IShiftOperators<long, long>.operator >>(long value, int shiftAmount);
+        static long IShiftOperators<long, long>.operator >>>(long value, int shiftAmount);
+        static long ISubtractionOperators<long, long, long>.operator checked -(long left, long right);
+        static long ISubtractionOperators<long, long, long>.operator -(long left, long right);
+        static long IUnaryNegationOperators<long, long>.operator checked -(long value);
+        static long IUnaryNegationOperators<long, long>.operator -(long value);
+        static long IUnaryPlusOperators<long, long>.operator +(long value);
     }
-    public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, IParseable<IntPtr>, ISerializable, IShiftOperators<IntPtr, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParseable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+    public readonly struct IntPtr : IAdditionOperators<nint, nint, nint>, IAdditiveIdentity<nint, nint>, IBinaryInteger<nint>, IBinaryNumber<nint>, IBitwiseOperators<nint, nint, nint>, IComparable, IComparable<nint>, IComparisonOperators<nint, nint>, IDecrementOperators<nint>, IDivisionOperators<nint, nint, nint>, IEqualityOperators<nint, nint>, IEquatable<nint>, IFormattable, IIncrementOperators<nint>, IMinMaxValue<nint>, IModulusOperators<nint, nint, nint>, IMultiplicativeIdentity<nint, nint>, IMultiplyOperators<nint, nint, nint>, INumber<nint>, INumberBase<nint>, IParsable<nint>, ISerializable, IShiftOperators<nint, nint>, ISignedNumber<nint>, ISpanFormattable, ISpanParsable<nint>, ISubtractionOperators<nint, nint, nint>, IUnaryNegationOperators<nint, nint>, IUnaryPlusOperators<nint, nint> {
-        static IntPtr System.IAdditiveIdentity<nint,nint>.AdditiveIdentity { get; }

-        static IntPtr System.IMinMaxValue<nint>.MaxValue { get; }

-        static IntPtr System.IMinMaxValue<nint>.MinValue { get; }

-        static IntPtr System.IMultiplicativeIdentity<nint,nint>.MultiplicativeIdentity { get; }

-        static IntPtr System.INumber<nint>.One { get; }

-        static IntPtr System.INumber<nint>.Zero { get; }

-        static IntPtr System.ISignedNumber<nint>.NegativeOne { get; }

+        static IntPtr System.Numerics.IAdditiveIdentity<nint,nint>.AdditiveIdentity { get; }
+        static IntPtr System.Numerics.IMinMaxValue<nint>.MaxValue { get; }
+        static IntPtr System.Numerics.IMinMaxValue<nint>.MinValue { get; }
+        static IntPtr System.Numerics.IMultiplicativeIdentity<nint,nint>.MultiplicativeIdentity { get; }
+        static IntPtr System.Numerics.INumberBase<nint>.One { get; }
+        static IntPtr System.Numerics.INumberBase<nint>.Zero { get; }
+        static IntPtr System.Numerics.ISignedNumber<nint>.NegativeOne { get; }
-        static IntPtr IAdditionOperators<IntPtr, IntPtr, IntPtr>.operator +(IntPtr left, IntPtr right);

-        static IntPtr IBinaryInteger<IntPtr>.LeadingZeroCount(IntPtr value);

-        static IntPtr IBinaryInteger<IntPtr>.PopCount(IntPtr value);

-        static IntPtr IBinaryInteger<IntPtr>.RotateLeft(IntPtr value, int rotateAmount);

-        static IntPtr IBinaryInteger<IntPtr>.RotateRight(IntPtr value, int rotateAmount);

-        static IntPtr IBinaryInteger<IntPtr>.TrailingZeroCount(IntPtr value);

-        static bool IBinaryNumber<IntPtr>.IsPow2(IntPtr value);

-        static IntPtr IBinaryNumber<IntPtr>.Log2(IntPtr value);

-        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator &(IntPtr left, IntPtr right);

-        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator |(IntPtr left, IntPtr right);

-        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ^(IntPtr left, IntPtr right);

-        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ~(IntPtr value);

-        static bool IComparisonOperators<IntPtr, IntPtr>.operator >(IntPtr left, IntPtr right);

-        static bool IComparisonOperators<IntPtr, IntPtr>.operator >=(IntPtr left, IntPtr right);

-        static bool IComparisonOperators<IntPtr, IntPtr>.operator <(IntPtr left, IntPtr right);

-        static bool IComparisonOperators<IntPtr, IntPtr>.operator <=(IntPtr left, IntPtr right);

-        static IntPtr IDecrementOperators<IntPtr>.operator --(IntPtr value);

-        static IntPtr IDivisionOperators<IntPtr, IntPtr, IntPtr>.operator /(IntPtr left, IntPtr right);

-        static IntPtr IIncrementOperators<IntPtr>.operator ++(IntPtr value);

-        static IntPtr IModulusOperators<IntPtr, IntPtr, IntPtr>.operator %(IntPtr left, IntPtr right);

-        static IntPtr IMultiplyOperators<IntPtr, IntPtr, IntPtr>.operator *(IntPtr left, IntPtr right);

-        static IntPtr INumber<IntPtr>.Abs(IntPtr value);

-        static IntPtr INumber<IntPtr>.Clamp(IntPtr value, IntPtr min, IntPtr max);

-        static IntPtr INumber<IntPtr>.Create<TOther>(TOther value);

-        static IntPtr INumber<IntPtr>.CreateSaturating<TOther>(TOther value);

-        static IntPtr INumber<IntPtr>.CreateTruncating<TOther>(TOther value);

-        static (IntPtr Quotient, IntPtr Remainder) INumber<IntPtr>.DivRem(IntPtr left, IntPtr right);

-        static IntPtr INumber<IntPtr>.Max(IntPtr x, IntPtr y);

-        static IntPtr INumber<IntPtr>.Min(IntPtr x, IntPtr y);

-        static IntPtr INumber<IntPtr>.Sign(IntPtr value);

-        static bool INumber<IntPtr>.TryCreate<TOther>(TOther value, out IntPtr result);

-        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator <<(IntPtr value, int shiftAmount);

-        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator >>(IntPtr value, int shiftAmount);

-        static IntPtr ISubtractionOperators<IntPtr, IntPtr, IntPtr>.operator -(IntPtr left, IntPtr right);

-        static IntPtr IUnaryNegationOperators<IntPtr, IntPtr>.operator -(IntPtr value);

-        static IntPtr IUnaryPlusOperators<IntPtr, IntPtr>.operator +(IntPtr value);

+        static IntPtr IAdditionOperators<IntPtr, IntPtr, IntPtr>.operator +(IntPtr left, IntPtr right);
+        static IntPtr IAdditionOperators<IntPtr, IntPtr, IntPtr>.operator checked +(IntPtr left, IntPtr right);
+        static (IntPtr Quotient, IntPtr Remainder) IBinaryInteger<IntPtr>.DivRem(IntPtr left, IntPtr right);
+        int IBinaryInteger<IntPtr>.GetByteCount();
+        long IBinaryInteger<IntPtr>.GetShortestBitLength();
+        static IntPtr IBinaryInteger<IntPtr>.LeadingZeroCount(IntPtr value);
+        static IntPtr IBinaryInteger<IntPtr>.PopCount(IntPtr value);
+        static IntPtr IBinaryInteger<IntPtr>.RotateLeft(IntPtr value, int rotateAmount);
+        static IntPtr IBinaryInteger<IntPtr>.RotateRight(IntPtr value, int rotateAmount);
+        static IntPtr IBinaryInteger<IntPtr>.TrailingZeroCount(IntPtr value);
+        bool IBinaryInteger<IntPtr>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static bool IBinaryNumber<IntPtr>.IsPow2(IntPtr value);
+        static IntPtr IBinaryNumber<IntPtr>.Log2(IntPtr value);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator &(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator |(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ^(IntPtr left, IntPtr right);
+        static IntPtr IBitwiseOperators<IntPtr, IntPtr, IntPtr>.operator ~(IntPtr value);
+        static bool IComparisonOperators<IntPtr, IntPtr>.operator >(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr>.operator >=(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr>.operator <(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr>.operator <=(IntPtr left, IntPtr right);
+        static IntPtr IDecrementOperators<IntPtr>.operator checked --(IntPtr value);
+        static IntPtr IDecrementOperators<IntPtr>.operator --(IntPtr value);
+        static IntPtr IDivisionOperators<IntPtr, IntPtr, IntPtr>.operator checked /(IntPtr left, IntPtr right);
+        static IntPtr IDivisionOperators<IntPtr, IntPtr, IntPtr>.operator /(IntPtr left, IntPtr right);
+        static IntPtr IIncrementOperators<IntPtr>.operator checked ++(IntPtr value);
+        static IntPtr IIncrementOperators<IntPtr>.operator ++(IntPtr value);
+        static IntPtr IModulusOperators<IntPtr, IntPtr, IntPtr>.operator %(IntPtr left, IntPtr right);
+        static IntPtr IMultiplyOperators<IntPtr, IntPtr, IntPtr>.operator checked *(IntPtr left, IntPtr right);
+        static IntPtr IMultiplyOperators<IntPtr, IntPtr, IntPtr>.operator *(IntPtr left, IntPtr right);
+        static IntPtr INumber<IntPtr>.Abs(IntPtr value);
+        static IntPtr INumber<IntPtr>.Clamp(IntPtr value, IntPtr min, IntPtr max);
+        static IntPtr INumber<IntPtr>.CopySign(IntPtr value, IntPtr sign);
+        static IntPtr INumber<IntPtr>.CreateChecked<TOther>(TOther value);
+        static IntPtr INumber<IntPtr>.CreateSaturating<TOther>(TOther value);
+        static IntPtr INumber<IntPtr>.CreateTruncating<TOther>(TOther value);
+        static bool INumber<IntPtr>.IsNegative(IntPtr value);
+        static IntPtr INumber<IntPtr>.Max(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.MaxMagnitude(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.Min(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.MinMagnitude(IntPtr x, IntPtr y);
+        static int INumber<IntPtr>.Sign(IntPtr value);
+        static bool INumber<IntPtr>.TryCreate<TOther>(TOther value, out IntPtr result);
+        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator <<(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator >>(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator >>>(IntPtr value, int shiftAmount);
+        static IntPtr ISubtractionOperators<IntPtr, IntPtr, IntPtr>.operator checked -(IntPtr left, IntPtr right);
+        static IntPtr ISubtractionOperators<IntPtr, IntPtr, IntPtr>.operator -(IntPtr left, IntPtr right);
+        static IntPtr IUnaryNegationOperators<IntPtr, IntPtr>.operator checked -(IntPtr value);
+        static IntPtr IUnaryNegationOperators<IntPtr, IntPtr>.operator -(IntPtr value);
+        static IntPtr IUnaryPlusOperators<IntPtr, IntPtr>.operator +(IntPtr value);
     }
-    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf> {
 {
-        static abstract TSelf One { get; }

-        static abstract TSelf Zero { get; }

-        static abstract TSelf Abs(TSelf value);

-        static abstract TSelf Clamp(TSelf value, TSelf min, TSelf max);

-        static abstract TSelf Create<TOther>(TOther value);

-        static abstract TSelf CreateSaturating<TOther>(TOther value);

-        static abstract TSelf CreateTruncating<TOther>(TOther value);

-        static abstract (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);

-        static abstract TSelf Max(TSelf x, TSelf y);

-        static abstract TSelf Min(TSelf x, TSelf y);

-        static abstract TSelf Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider);

-        static abstract TSelf Parse(string s, NumberStyles style, IFormatProvider? provider);

-        static abstract TSelf Sign(TSelf value);

-        static abstract bool TryCreate<TOther>(TOther value, out TSelf result);

-        static abstract bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out TSelf result);

-        static abstract bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out TSelf result);

-    }
+    public interface IParsable<TSelf> where TSelf : IParsable<TSelf> {
+        static abstract TSelf Parse(string s, IFormatProvider? provider);
+        static abstract bool TryParse(string? s, IFormatProvider? provider, out TSelf result);
+    }
-    public interface IParseable<TSelf> where TSelf : IParseable<TSelf> {
 {
-        static abstract TSelf Parse(string s, IFormatProvider? provider);

-        static abstract bool TryParse(string? s, IFormatProvider? provider, out TSelf result);

-    }
-    public interface IShiftOperators<TSelf, TResult> where TSelf : IShiftOperators<TSelf, TResult> {
 {
-        static abstract TResult operator <<(TSelf value, int shiftAmount);

-        static abstract TResult operator >>(TSelf value, int shiftAmount);

-    }
-    public interface ISignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ISignedNumber<TSelf> {
 {
-        static abstract TSelf NegativeOne { get; }

-    }
+    public interface ISpanParsable<TSelf> : IParsable<TSelf> where TSelf : ISpanParsable<TSelf> {
+        static abstract TSelf Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        static abstract bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out TSelf result);
+    }
-    public interface ISpanParseable<TSelf> : IParseable<TSelf> where TSelf : ISpanParseable<TSelf> {
 {
-        static abstract TSelf Parse(ReadOnlySpan<char> s, IFormatProvider? provider);

-        static abstract bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out TSelf result);

-    }
-    public interface ISubtractionOperators<TSelf, TOther, TResult> where TSelf : ISubtractionOperators<TSelf, TOther, TResult> {
 {
-        static abstract TResult operator -(TSelf left, TOther right);

-    }
-    public interface IUnaryNegationOperators<TSelf, TResult> where TSelf : IUnaryNegationOperators<TSelf, TResult> {
 {
-        static abstract TResult operator -(TSelf value);

-    }
-    public interface IUnaryPlusOperators<TSelf, TResult> where TSelf : IUnaryPlusOperators<TSelf, TResult> {
 {
-        static abstract TResult operator +(TSelf value);

-    }
-    public interface IUnsignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, IParseable<TSelf>, ISpanFormattable, ISpanParseable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IUnsignedNumber<TSelf>

     public static class MemoryExtensions {
+        public static int CommonPrefixLength<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other);
+        public static int CommonPrefixLength<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, IEqualityComparer<T>? comparer);
+        public static int CommonPrefixLength<T>(this Span<T> span, ReadOnlySpan<T> other);
+        public static int CommonPrefixLength<T>(this Span<T> span, ReadOnlySpan<T> other, IEqualityComparer<T>? comparer);
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, ReadOnlySpan<T> values) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value0, T value1) where T : IEquatable<T>;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, T value0, T value1, T value2) where T : IEquatable<T>;
     }
-    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, IParseable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParseable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
-        public const sbyte AdditiveIdentity = (sbyte)0;

-        public const sbyte MultiplicativeIdentity = (sbyte)1;

-        public const sbyte NegativeOne = (sbyte)-1;

-        public const sbyte One = (sbyte)1;

-        public const sbyte Zero = (sbyte)0;

-        static sbyte System.IAdditiveIdentity<System.SByte,System.SByte>.AdditiveIdentity { get; }

-        static sbyte System.IMinMaxValue<System.SByte>.MaxValue { get; }

-        static sbyte System.IMinMaxValue<System.SByte>.MinValue { get; }

-        static sbyte System.IMultiplicativeIdentity<System.SByte,System.SByte>.MultiplicativeIdentity { get; }

-        static sbyte System.INumber<System.SByte>.One { get; }

-        static sbyte System.INumber<System.SByte>.Zero { get; }

-        static sbyte System.ISignedNumber<System.SByte>.NegativeOne { get; }

+        static sbyte System.Numerics.IAdditiveIdentity<System.SByte,System.SByte>.AdditiveIdentity { get; }
+        static sbyte System.Numerics.IMinMaxValue<System.SByte>.MaxValue { get; }
+        static sbyte System.Numerics.IMinMaxValue<System.SByte>.MinValue { get; }
+        static sbyte System.Numerics.IMultiplicativeIdentity<System.SByte,System.SByte>.MultiplicativeIdentity { get; }
+        static sbyte System.Numerics.INumberBase<System.SByte>.One { get; }
+        static sbyte System.Numerics.INumberBase<System.SByte>.Zero { get; }
+        static sbyte System.Numerics.ISignedNumber<System.SByte>.NegativeOne { get; }
+        public static sbyte CopySign(sbyte value, sbyte sign);
-        public static sbyte Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static sbyte CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsNegative(sbyte value);
+        public static sbyte MaxMagnitude(sbyte x, sbyte y);
+        public static sbyte MinMagnitude(sbyte x, sbyte y);
-        public static sbyte Sign(sbyte value);

+        public static int Sign(sbyte value);
-        static sbyte IAdditionOperators<sbyte, sbyte, sbyte>.operator +(sbyte left, sbyte right);

-        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator &(sbyte left, sbyte right);

-        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator |(sbyte left, sbyte right);

-        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ^(sbyte left, sbyte right);

-        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ~(sbyte value);

-        static bool IComparisonOperators<sbyte, sbyte>.operator >(sbyte left, sbyte right);

-        static bool IComparisonOperators<sbyte, sbyte>.operator >=(sbyte left, sbyte right);

-        static bool IComparisonOperators<sbyte, sbyte>.operator <(sbyte left, sbyte right);

-        static bool IComparisonOperators<sbyte, sbyte>.operator <=(sbyte left, sbyte right);

-        static sbyte IDecrementOperators<sbyte>.operator --(sbyte value);

-        static sbyte IDivisionOperators<sbyte, sbyte, sbyte>.operator /(sbyte left, sbyte right);

-        static bool IEqualityOperators<sbyte, sbyte>.operator ==(sbyte left, sbyte right);

-        static bool IEqualityOperators<sbyte, sbyte>.operator !=(sbyte left, sbyte right);

-        static sbyte IIncrementOperators<sbyte>.operator ++(sbyte value);

-        static sbyte IModulusOperators<sbyte, sbyte, sbyte>.operator %(sbyte left, sbyte right);

-        static sbyte IMultiplyOperators<sbyte, sbyte, sbyte>.operator *(sbyte left, sbyte right);

-        static sbyte IShiftOperators<sbyte, sbyte>.operator <<(sbyte value, int shiftAmount);

-        static sbyte IShiftOperators<sbyte, sbyte>.operator >>(sbyte value, int shiftAmount);

-        static sbyte ISubtractionOperators<sbyte, sbyte, sbyte>.operator -(sbyte left, sbyte right);

-        static sbyte IUnaryNegationOperators<sbyte, sbyte>.operator -(sbyte value);

-        static sbyte IUnaryPlusOperators<sbyte, sbyte>.operator +(sbyte value);

+        static sbyte IAdditionOperators<sbyte, sbyte, sbyte>.operator +(sbyte left, sbyte right);
+        static sbyte IAdditionOperators<sbyte, sbyte, sbyte>.operator checked +(sbyte left, sbyte right);
+        int IBinaryInteger<sbyte>.GetByteCount();
+        long IBinaryInteger<sbyte>.GetShortestBitLength();
+        bool IBinaryInteger<sbyte>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator &(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator |(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ^(sbyte left, sbyte right);
+        static sbyte IBitwiseOperators<sbyte, sbyte, sbyte>.operator ~(sbyte value);
+        static bool IComparisonOperators<sbyte, sbyte>.operator >(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte>.operator >=(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte>.operator <(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte>.operator <=(sbyte left, sbyte right);
+        static sbyte IDecrementOperators<sbyte>.operator checked --(sbyte value);
+        static sbyte IDecrementOperators<sbyte>.operator --(sbyte value);
+        static sbyte IDivisionOperators<sbyte, sbyte, sbyte>.operator checked /(sbyte left, sbyte right);
+        static sbyte IDivisionOperators<sbyte, sbyte, sbyte>.operator /(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte>.operator ==(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte>.operator !=(sbyte left, sbyte right);
+        static sbyte IIncrementOperators<sbyte>.operator checked ++(sbyte value);
+        static sbyte IIncrementOperators<sbyte>.operator ++(sbyte value);
+        static sbyte IModulusOperators<sbyte, sbyte, sbyte>.operator %(sbyte left, sbyte right);
+        static sbyte IMultiplyOperators<sbyte, sbyte, sbyte>.operator checked *(sbyte left, sbyte right);
+        static sbyte IMultiplyOperators<sbyte, sbyte, sbyte>.operator *(sbyte left, sbyte right);
+        static sbyte IShiftOperators<sbyte, sbyte>.operator <<(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, sbyte>.operator >>(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, sbyte>.operator >>>(sbyte value, int shiftAmount);
+        static sbyte ISubtractionOperators<sbyte, sbyte, sbyte>.operator checked -(sbyte left, sbyte right);
+        static sbyte ISubtractionOperators<sbyte, sbyte, sbyte>.operator -(sbyte left, sbyte right);
+        static sbyte IUnaryNegationOperators<sbyte, sbyte>.operator checked -(sbyte value);
+        static sbyte IUnaryNegationOperators<sbyte, sbyte>.operator -(sbyte value);
+        static sbyte IUnaryPlusOperators<sbyte, sbyte>.operator +(sbyte value);
     }
-    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPoint<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IFloatingPoint<float>, IFormattable, IIncrementOperators<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, IParseable<float>, ISignedNumber<float>, ISpanFormattable, ISpanParseable<float>, ISubtractionOperators<float, float, float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
-        public const float AdditiveIdentity = 0f;

-        public const float MultiplicativeIdentity = 1f;

-        public const float NegativeOne = -1f;

-        public const float One = 1f;

-        public const float Zero = 0f;

-        static float System.IAdditiveIdentity<System.Single,System.Single>.AdditiveIdentity { get; }

-        static float System.IFloatingPoint<System.Single>.E { get; }

-        static float System.IFloatingPoint<System.Single>.Epsilon { get; }

-        static float System.IFloatingPoint<System.Single>.NaN { get; }

-        static float System.IFloatingPoint<System.Single>.NegativeInfinity { get; }

-        static float System.IFloatingPoint<System.Single>.NegativeZero { get; }

-        static float System.IFloatingPoint<System.Single>.Pi { get; }

-        static float System.IFloatingPoint<System.Single>.PositiveInfinity { get; }

-        static float System.IFloatingPoint<System.Single>.Tau { get; }

-        static float System.IMinMaxValue<System.Single>.MaxValue { get; }

-        static float System.IMinMaxValue<System.Single>.MinValue { get; }

-        static float System.IMultiplicativeIdentity<System.Single,System.Single>.MultiplicativeIdentity { get; }

-        static float System.INumber<System.Single>.One { get; }

-        static float System.INumber<System.Single>.Zero { get; }

-        static float System.ISignedNumber<System.Single>.NegativeOne { get; }

+        static float System.Numerics.IAdditiveIdentity<System.Single,System.Single>.AdditiveIdentity { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.E { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.Epsilon { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NaN { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NegativeInfinity { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.NegativeZero { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.Pi { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.PositiveInfinity { get; }
+        static float System.Numerics.IFloatingPointIeee754<System.Single>.Tau { get; }
+        static float System.Numerics.IMinMaxValue<System.Single>.MaxValue { get; }
+        static float System.Numerics.IMinMaxValue<System.Single>.MinValue { get; }
+        static float System.Numerics.IMultiplicativeIdentity<System.Single,System.Single>.MultiplicativeIdentity { get; }
+        static float System.Numerics.INumberBase<System.Single>.One { get; }
+        static float System.Numerics.INumberBase<System.Single>.Zero { get; }
+        static float System.Numerics.ISignedNumber<System.Single>.NegativeOne { get; }
-        public static float Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static float CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static (float Quotient, float Remainder) DivRem(float left, float right);

+        public static float Ieee754Remainder(float left, float right);
-        public static float IEEERemainder(float left, float right);

+        public static int ILogB(float x);
-        public static TInteger ILogB<TInteger>(float x) where TInteger : IBinaryInteger<TInteger>;

+        public static float ReciprocalEstimate(float x);
+        public static float ReciprocalSqrtEstimate(float x);
+        public static float Round(float x, int digits);
+        public static float Round(float x, int digits, MidpointRounding mode);
-        public static float Round<TInteger>(float x, TInteger digits) where TInteger : IBinaryInteger<TInteger>;

-        public static float Round<TInteger>(float x, TInteger digits, MidpointRounding mode) where TInteger : IBinaryInteger<TInteger>;

+        public static float ScaleB(float x, int n);
-        public static float ScaleB<TInteger>(float x, TInteger n) where TInteger : IBinaryInteger<TInteger>;

-        public static float Sign(float value);

+        public static int Sign(float value);
+        public static (float Sin, float Cos) SinCos(float x);
-        static float IAdditionOperators<float, float, float>.operator +(float left, float right);

-        static float IBitwiseOperators<float, float, float>.operator &(float left, float right);

-        static float IBitwiseOperators<float, float, float>.operator |(float left, float right);

-        static float IBitwiseOperators<float, float, float>.operator ^(float left, float right);

-        static float IBitwiseOperators<float, float, float>.operator ~(float value);

-        static float IDecrementOperators<float>.operator --(float value);

-        static float IDivisionOperators<float, float, float>.operator /(float left, float right);

-        static float IIncrementOperators<float>.operator ++(float value);

-        static float IModulusOperators<float, float, float>.operator %(float left, float right);

-        static float IMultiplyOperators<float, float, float>.operator *(float left, float right);

-        static float ISubtractionOperators<float, float, float>.operator -(float left, float right);

-        static float IUnaryNegationOperators<float, float>.operator -(float value);

-        static float IUnaryPlusOperators<float, float>.operator +(float value);

+        static float IAdditionOperators<float, float, float>.operator +(float left, float right);
+        static float IAdditionOperators<float, float, float>.operator checked +(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator &(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator |(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator ^(float left, float right);
+        static float IBitwiseOperators<float, float, float>.operator ~(float value);
+        static float IDecrementOperators<float>.operator checked --(float value);
+        static float IDecrementOperators<float>.operator --(float value);
+        static float IDivisionOperators<float, float, float>.operator checked /(float left, float right);
+        static float IDivisionOperators<float, float, float>.operator /(float left, float right);
+        int IFloatingPoint<float>.GetExponentByteCount();
+        long IFloatingPoint<float>.GetExponentShortestBitLength();
+        long IFloatingPoint<float>.GetSignificandBitLength();
+        int IFloatingPoint<float>.GetSignificandByteCount();
+        bool IFloatingPoint<float>.TryWriteExponentLittleEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<float>.TryWriteSignificandLittleEndian(Span<byte> destination, out int bytesWritten);
+        static float IIncrementOperators<float>.operator checked ++(float value);
+        static float IIncrementOperators<float>.operator ++(float value);
+        static float IModulusOperators<float, float, float>.operator %(float left, float right);
+        static float IMultiplyOperators<float, float, float>.operator checked *(float left, float right);
+        static float IMultiplyOperators<float, float, float>.operator *(float left, float right);
+        static float ISubtractionOperators<float, float, float>.operator checked -(float left, float right);
+        static float ISubtractionOperators<float, float, float>.operator -(float left, float right);
+        static float IUnaryNegationOperators<float, float>.operator checked -(float value);
+        static float IUnaryNegationOperators<float, float>.operator -(float value);
+        static float IUnaryPlusOperators<float, float>.operator +(float value);
     }
-    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IComparisonOperators<TimeOnly, TimeOnly>, IEqualityOperators<TimeOnly, TimeOnly>, IEquatable<TimeOnly>, IFormattable, IMinMaxValue<TimeOnly>, IParseable<TimeOnly>, ISpanFormattable, ISpanParseable<TimeOnly>, ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan> {
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IComparisonOperators<TimeOnly, TimeOnly>, IEqualityOperators<TimeOnly, TimeOnly>, IEquatable<TimeOnly>, IFormattable, IMinMaxValue<TimeOnly>, IParsable<TimeOnly>, ISpanFormattable, ISpanParsable<TimeOnly>, ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan> {
+        public TimeOnly(int hour, int minute, int second, int millisecond, int microsecond);
+        public int Microsecond { get; }
+        public int Nanosecond { get; }
-        static TimeOnly System.IMinMaxValue<System.TimeOnly>.MaxValue { get; }

-        static TimeOnly System.IMinMaxValue<System.TimeOnly>.MinValue { get; }

+        static TimeSpan ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan>.operator checked -(TimeOnly left, TimeOnly right);
     }
-    public readonly struct TimeSpan : IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>, IAdditiveIdentity<TimeSpan, TimeSpan>, IComparable, IComparable<TimeSpan>, IComparisonOperators<TimeSpan, TimeSpan>, IDivisionOperators<TimeSpan, double, TimeSpan>, IDivisionOperators<TimeSpan, TimeSpan, double>, IEqualityOperators<TimeSpan, TimeSpan>, IEquatable<TimeSpan>, IFormattable, IMinMaxValue<TimeSpan>, IMultiplicativeIdentity<TimeSpan, double>, IMultiplyOperators<TimeSpan, double, TimeSpan>, IParseable<TimeSpan>, ISpanFormattable, ISpanParseable<TimeSpan>, ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>, IUnaryNegationOperators<TimeSpan, TimeSpan>, IUnaryPlusOperators<TimeSpan, TimeSpan> {
+    public readonly struct TimeSpan : IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>, IAdditiveIdentity<TimeSpan, TimeSpan>, IComparable, IComparable<TimeSpan>, IComparisonOperators<TimeSpan, TimeSpan>, IDivisionOperators<TimeSpan, double, TimeSpan>, IDivisionOperators<TimeSpan, TimeSpan, double>, IEqualityOperators<TimeSpan, TimeSpan>, IEquatable<TimeSpan>, IFormattable, IMinMaxValue<TimeSpan>, IMultiplicativeIdentity<TimeSpan, double>, IMultiplyOperators<TimeSpan, double, TimeSpan>, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan>, ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>, IUnaryNegationOperators<TimeSpan, TimeSpan>, IUnaryPlusOperators<TimeSpan, TimeSpan> {
+        public const long NanosecondsPerTick = (long)100;
+        public const long TicksPerMicrosecond = (long)10;
+        public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds, int microseconds);
-        public static TimeSpan AdditiveIdentity { get; }

+        public int Microseconds { get; }
-        public static double MultiplicativeIdentity { get; }

+        public int Nanoseconds { get; }
-        static TimeSpan System.IMinMaxValue<System.TimeSpan>.MaxValue { get; }

-        static TimeSpan System.IMinMaxValue<System.TimeSpan>.MinValue { get; }

+        static TimeSpan System.Numerics.IAdditiveIdentity<System.TimeSpan,System.TimeSpan>.AdditiveIdentity { get; }
+        static TimeSpan System.Numerics.IMinMaxValue<System.TimeSpan>.MaxValue { get; }
+        static TimeSpan System.Numerics.IMinMaxValue<System.TimeSpan>.MinValue { get; }
+        static double System.Numerics.IMultiplicativeIdentity<System.TimeSpan,System.Double>.MultiplicativeIdentity { get; }
+        public double TotalMicroseconds { get; }
+        public double TotalNanoseconds { get; }
+        public static TimeSpan FromMicroseconds(double value);
+        static TimeSpan IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>.operator checked +(TimeSpan left, TimeSpan right);
+        static TimeSpan IDivisionOperators<TimeSpan, double, TimeSpan>.operator checked /(TimeSpan left, double right);
+        static double IDivisionOperators<TimeSpan, TimeSpan, double>.operator checked /(TimeSpan left, TimeSpan right);
+        static TimeSpan IMultiplyOperators<TimeSpan, double, TimeSpan>.operator checked *(TimeSpan left, double right);
+        static TimeSpan ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>.operator checked -(TimeSpan left, TimeSpan right);
+        static TimeSpan IUnaryNegationOperators<TimeSpan, TimeSpan>.operator checked -(TimeSpan value);
     }
-    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, IParseable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParseable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
-        public const ushort AdditiveIdentity = (ushort)0;

-        public const ushort MultiplicativeIdentity = (ushort)1;

-        public const ushort One = (ushort)1;

-        public const ushort Zero = (ushort)0;

-        static ushort System.IAdditiveIdentity<System.UInt16,System.UInt16>.AdditiveIdentity { get; }

-        static ushort System.IMinMaxValue<System.UInt16>.MaxValue { get; }

-        static ushort System.IMinMaxValue<System.UInt16>.MinValue { get; }

-        static ushort System.IMultiplicativeIdentity<System.UInt16,System.UInt16>.MultiplicativeIdentity { get; }

-        static ushort System.INumber<System.UInt16>.One { get; }

-        static ushort System.INumber<System.UInt16>.Zero { get; }

+        static ushort System.Numerics.IAdditiveIdentity<System.UInt16,System.UInt16>.AdditiveIdentity { get; }
+        static ushort System.Numerics.IMinMaxValue<System.UInt16>.MaxValue { get; }
+        static ushort System.Numerics.IMinMaxValue<System.UInt16>.MinValue { get; }
+        static ushort System.Numerics.IMultiplicativeIdentity<System.UInt16,System.UInt16>.MultiplicativeIdentity { get; }
+        static ushort System.Numerics.INumberBase<System.UInt16>.One { get; }
+        static ushort System.Numerics.INumberBase<System.UInt16>.Zero { get; }
-        public static ushort Abs(ushort value);

-        public static ushort Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static ushort CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ushort Sign(ushort value);

+        public static int Sign(ushort value);
-        static ushort IAdditionOperators<ushort, ushort, ushort>.operator +(ushort left, ushort right);

-        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator &(ushort left, ushort right);

-        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator |(ushort left, ushort right);

-        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ^(ushort left, ushort right);

-        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ~(ushort value);

-        static bool IComparisonOperators<ushort, ushort>.operator >(ushort left, ushort right);

-        static bool IComparisonOperators<ushort, ushort>.operator >=(ushort left, ushort right);

-        static bool IComparisonOperators<ushort, ushort>.operator <(ushort left, ushort right);

-        static bool IComparisonOperators<ushort, ushort>.operator <=(ushort left, ushort right);

-        static ushort IDecrementOperators<ushort>.operator --(ushort value);

-        static ushort IDivisionOperators<ushort, ushort, ushort>.operator /(ushort left, ushort right);

-        static bool IEqualityOperators<ushort, ushort>.operator ==(ushort left, ushort right);

-        static bool IEqualityOperators<ushort, ushort>.operator !=(ushort left, ushort right);

-        static ushort IIncrementOperators<ushort>.operator ++(ushort value);

-        static ushort IModulusOperators<ushort, ushort, ushort>.operator %(ushort left, ushort right);

-        static ushort IMultiplyOperators<ushort, ushort, ushort>.operator *(ushort left, ushort right);

-        static ushort IShiftOperators<ushort, ushort>.operator <<(ushort value, int shiftAmount);

-        static ushort IShiftOperators<ushort, ushort>.operator >>(ushort value, int shiftAmount);

-        static ushort ISubtractionOperators<ushort, ushort, ushort>.operator -(ushort left, ushort right);

-        static ushort IUnaryNegationOperators<ushort, ushort>.operator -(ushort value);

-        static ushort IUnaryPlusOperators<ushort, ushort>.operator +(ushort value);

+        static ushort IAdditionOperators<ushort, ushort, ushort>.operator +(ushort left, ushort right);
+        static ushort IAdditionOperators<ushort, ushort, ushort>.operator checked +(ushort left, ushort right);
+        int IBinaryInteger<ushort>.GetByteCount();
+        long IBinaryInteger<ushort>.GetShortestBitLength();
+        bool IBinaryInteger<ushort>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator &(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator |(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ^(ushort left, ushort right);
+        static ushort IBitwiseOperators<ushort, ushort, ushort>.operator ~(ushort value);
+        static bool IComparisonOperators<ushort, ushort>.operator >(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort>.operator >=(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort>.operator <(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort>.operator <=(ushort left, ushort right);
+        static ushort IDecrementOperators<ushort>.operator checked --(ushort value);
+        static ushort IDecrementOperators<ushort>.operator --(ushort value);
+        static ushort IDivisionOperators<ushort, ushort, ushort>.operator checked /(ushort left, ushort right);
+        static ushort IDivisionOperators<ushort, ushort, ushort>.operator /(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort>.operator ==(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort>.operator !=(ushort left, ushort right);
+        static ushort IIncrementOperators<ushort>.operator checked ++(ushort value);
+        static ushort IIncrementOperators<ushort>.operator ++(ushort value);
+        static ushort IModulusOperators<ushort, ushort, ushort>.operator %(ushort left, ushort right);
+        static ushort IMultiplyOperators<ushort, ushort, ushort>.operator checked *(ushort left, ushort right);
+        static ushort IMultiplyOperators<ushort, ushort, ushort>.operator *(ushort left, ushort right);
+        static ushort INumber<ushort>.Abs(ushort value);
+        static ushort INumber<ushort>.CopySign(ushort value, ushort sign);
+        static bool INumber<ushort>.IsNegative(ushort value);
+        static ushort INumber<ushort>.MaxMagnitude(ushort x, ushort y);
+        static ushort INumber<ushort>.MinMagnitude(ushort x, ushort y);
+        static ushort IShiftOperators<ushort, ushort>.operator <<(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, ushort>.operator >>(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, ushort>.operator >>>(ushort value, int shiftAmount);
+        static ushort ISubtractionOperators<ushort, ushort, ushort>.operator checked -(ushort left, ushort right);
+        static ushort ISubtractionOperators<ushort, ushort, ushort>.operator -(ushort left, ushort right);
+        static ushort IUnaryNegationOperators<ushort, ushort>.operator checked -(ushort value);
+        static ushort IUnaryNegationOperators<ushort, ushort>.operator -(ushort value);
+        static ushort IUnaryPlusOperators<ushort, ushort>.operator +(ushort value);
     }
-    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, IParseable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParseable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
-        public const uint AdditiveIdentity = (uint)0;

-        public const uint MultiplicativeIdentity = (uint)1;

-        public const uint One = (uint)1;

-        public const uint Zero = (uint)0;

-        static uint System.IAdditiveIdentity<System.UInt32,System.UInt32>.AdditiveIdentity { get; }

-        static uint System.IMinMaxValue<System.UInt32>.MaxValue { get; }

-        static uint System.IMinMaxValue<System.UInt32>.MinValue { get; }

-        static uint System.IMultiplicativeIdentity<System.UInt32,System.UInt32>.MultiplicativeIdentity { get; }

-        static uint System.INumber<System.UInt32>.One { get; }

-        static uint System.INumber<System.UInt32>.Zero { get; }

+        static uint System.Numerics.IAdditiveIdentity<System.UInt32,System.UInt32>.AdditiveIdentity { get; }
+        static uint System.Numerics.IMinMaxValue<System.UInt32>.MaxValue { get; }
+        static uint System.Numerics.IMinMaxValue<System.UInt32>.MinValue { get; }
+        static uint System.Numerics.IMultiplicativeIdentity<System.UInt32,System.UInt32>.MultiplicativeIdentity { get; }
+        static uint System.Numerics.INumberBase<System.UInt32>.One { get; }
+        static uint System.Numerics.INumberBase<System.UInt32>.Zero { get; }
-        public static uint Abs(uint value);

-        public static uint Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static uint CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static uint Sign(uint value);

+        public static int Sign(uint value);
-        static uint IAdditionOperators<uint, uint, uint>.operator +(uint left, uint right);

-        static uint IBitwiseOperators<uint, uint, uint>.operator &(uint left, uint right);

-        static uint IBitwiseOperators<uint, uint, uint>.operator |(uint left, uint right);

-        static uint IBitwiseOperators<uint, uint, uint>.operator ^(uint left, uint right);

-        static uint IBitwiseOperators<uint, uint, uint>.operator ~(uint value);

-        static bool IComparisonOperators<uint, uint>.operator >(uint left, uint right);

-        static bool IComparisonOperators<uint, uint>.operator >=(uint left, uint right);

-        static bool IComparisonOperators<uint, uint>.operator <(uint left, uint right);

-        static bool IComparisonOperators<uint, uint>.operator <=(uint left, uint right);

-        static uint IDecrementOperators<uint>.operator --(uint value);

-        static uint IDivisionOperators<uint, uint, uint>.operator /(uint left, uint right);

-        static bool IEqualityOperators<uint, uint>.operator ==(uint left, uint right);

-        static bool IEqualityOperators<uint, uint>.operator !=(uint left, uint right);

-        static uint IIncrementOperators<uint>.operator ++(uint value);

-        static uint IModulusOperators<uint, uint, uint>.operator %(uint left, uint right);

-        static uint IMultiplyOperators<uint, uint, uint>.operator *(uint left, uint right);

-        static uint IShiftOperators<uint, uint>.operator <<(uint value, int shiftAmount);

-        static uint IShiftOperators<uint, uint>.operator >>(uint value, int shiftAmount);

-        static uint ISubtractionOperators<uint, uint, uint>.operator -(uint left, uint right);

-        static uint IUnaryNegationOperators<uint, uint>.operator -(uint value);

-        static uint IUnaryPlusOperators<uint, uint>.operator +(uint value);

+        static uint IAdditionOperators<uint, uint, uint>.operator +(uint left, uint right);
+        static uint IAdditionOperators<uint, uint, uint>.operator checked +(uint left, uint right);
+        int IBinaryInteger<uint>.GetByteCount();
+        long IBinaryInteger<uint>.GetShortestBitLength();
+        bool IBinaryInteger<uint>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static uint IBitwiseOperators<uint, uint, uint>.operator &(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator |(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator ^(uint left, uint right);
+        static uint IBitwiseOperators<uint, uint, uint>.operator ~(uint value);
+        static bool IComparisonOperators<uint, uint>.operator >(uint left, uint right);
+        static bool IComparisonOperators<uint, uint>.operator >=(uint left, uint right);
+        static bool IComparisonOperators<uint, uint>.operator <(uint left, uint right);
+        static bool IComparisonOperators<uint, uint>.operator <=(uint left, uint right);
+        static uint IDecrementOperators<uint>.operator checked --(uint value);
+        static uint IDecrementOperators<uint>.operator --(uint value);
+        static uint IDivisionOperators<uint, uint, uint>.operator checked /(uint left, uint right);
+        static uint IDivisionOperators<uint, uint, uint>.operator /(uint left, uint right);
+        static bool IEqualityOperators<uint, uint>.operator ==(uint left, uint right);
+        static bool IEqualityOperators<uint, uint>.operator !=(uint left, uint right);
+        static uint IIncrementOperators<uint>.operator checked ++(uint value);
+        static uint IIncrementOperators<uint>.operator ++(uint value);
+        static uint IModulusOperators<uint, uint, uint>.operator %(uint left, uint right);
+        static uint IMultiplyOperators<uint, uint, uint>.operator checked *(uint left, uint right);
+        static uint IMultiplyOperators<uint, uint, uint>.operator *(uint left, uint right);
+        static uint INumber<uint>.Abs(uint value);
+        static uint INumber<uint>.CopySign(uint value, uint sign);
+        static bool INumber<uint>.IsNegative(uint value);
+        static uint INumber<uint>.MaxMagnitude(uint x, uint y);
+        static uint INumber<uint>.MinMagnitude(uint x, uint y);
+        static uint IShiftOperators<uint, uint>.operator <<(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, uint>.operator >>(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, uint>.operator >>>(uint value, int shiftAmount);
+        static uint ISubtractionOperators<uint, uint, uint>.operator checked -(uint left, uint right);
+        static uint ISubtractionOperators<uint, uint, uint>.operator -(uint left, uint right);
+        static uint IUnaryNegationOperators<uint, uint>.operator checked -(uint value);
+        static uint IUnaryNegationOperators<uint, uint>.operator -(uint value);
+        static uint IUnaryPlusOperators<uint, uint>.operator +(uint value);
     }
-    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, IParseable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParseable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
-        public const ulong AdditiveIdentity = (ulong)0;

-        public const ulong MultiplicativeIdentity = (ulong)1;

-        public const ulong One = (ulong)1;

-        public const ulong Zero = (ulong)0;

-        static ulong System.IAdditiveIdentity<System.UInt64,System.UInt64>.AdditiveIdentity { get; }

-        static ulong System.IMinMaxValue<System.UInt64>.MaxValue { get; }

-        static ulong System.IMinMaxValue<System.UInt64>.MinValue { get; }

-        static ulong System.IMultiplicativeIdentity<System.UInt64,System.UInt64>.MultiplicativeIdentity { get; }

-        static ulong System.INumber<System.UInt64>.One { get; }

-        static ulong System.INumber<System.UInt64>.Zero { get; }

+        static ulong System.Numerics.IAdditiveIdentity<System.UInt64,System.UInt64>.AdditiveIdentity { get; }
+        static ulong System.Numerics.IMinMaxValue<System.UInt64>.MaxValue { get; }
+        static ulong System.Numerics.IMinMaxValue<System.UInt64>.MinValue { get; }
+        static ulong System.Numerics.IMultiplicativeIdentity<System.UInt64,System.UInt64>.MultiplicativeIdentity { get; }
+        static ulong System.Numerics.INumberBase<System.UInt64>.One { get; }
+        static ulong System.Numerics.INumberBase<System.UInt64>.Zero { get; }
-        public static ulong Abs(ulong value);

-        public static ulong Create<TOther>(TOther value) where TOther : INumber<TOther>;

+        public static ulong CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ulong Sign(ulong value);

+        public static int Sign(ulong value);
-        static ulong IAdditionOperators<ulong, ulong, ulong>.operator +(ulong left, ulong right);

-        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator &(ulong left, ulong right);

-        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator |(ulong left, ulong right);

-        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ^(ulong left, ulong right);

-        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ~(ulong value);

-        static bool IComparisonOperators<ulong, ulong>.operator >(ulong left, ulong right);

-        static bool IComparisonOperators<ulong, ulong>.operator >=(ulong left, ulong right);

-        static bool IComparisonOperators<ulong, ulong>.operator <(ulong left, ulong right);

-        static bool IComparisonOperators<ulong, ulong>.operator <=(ulong left, ulong right);

-        static ulong IDecrementOperators<ulong>.operator --(ulong value);

-        static ulong IDivisionOperators<ulong, ulong, ulong>.operator /(ulong left, ulong right);

-        static bool IEqualityOperators<ulong, ulong>.operator ==(ulong left, ulong right);

-        static bool IEqualityOperators<ulong, ulong>.operator !=(ulong left, ulong right);

-        static ulong IIncrementOperators<ulong>.operator ++(ulong value);

-        static ulong IModulusOperators<ulong, ulong, ulong>.operator %(ulong left, ulong right);

-        static ulong IMultiplyOperators<ulong, ulong, ulong>.operator *(ulong left, ulong right);

-        static ulong IShiftOperators<ulong, ulong>.operator <<(ulong value, int shiftAmount);

-        static ulong IShiftOperators<ulong, ulong>.operator >>(ulong value, int shiftAmount);

-        static ulong ISubtractionOperators<ulong, ulong, ulong>.operator -(ulong left, ulong right);

-        static ulong IUnaryNegationOperators<ulong, ulong>.operator -(ulong value);

-        static ulong IUnaryPlusOperators<ulong, ulong>.operator +(ulong value);

+        static ulong IAdditionOperators<ulong, ulong, ulong>.operator +(ulong left, ulong right);
+        static ulong IAdditionOperators<ulong, ulong, ulong>.operator checked +(ulong left, ulong right);
+        int IBinaryInteger<ulong>.GetByteCount();
+        long IBinaryInteger<ulong>.GetShortestBitLength();
+        bool IBinaryInteger<ulong>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator &(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator |(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ^(ulong left, ulong right);
+        static ulong IBitwiseOperators<ulong, ulong, ulong>.operator ~(ulong value);
+        static bool IComparisonOperators<ulong, ulong>.operator >(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong>.operator >=(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong>.operator <(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong>.operator <=(ulong left, ulong right);
+        static ulong IDecrementOperators<ulong>.operator checked --(ulong value);
+        static ulong IDecrementOperators<ulong>.operator --(ulong value);
+        static ulong IDivisionOperators<ulong, ulong, ulong>.operator checked /(ulong left, ulong right);
+        static ulong IDivisionOperators<ulong, ulong, ulong>.operator /(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong>.operator ==(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong>.operator !=(ulong left, ulong right);
+        static ulong IIncrementOperators<ulong>.operator checked ++(ulong value);
+        static ulong IIncrementOperators<ulong>.operator ++(ulong value);
+        static ulong IModulusOperators<ulong, ulong, ulong>.operator %(ulong left, ulong right);
+        static ulong IMultiplyOperators<ulong, ulong, ulong>.operator checked *(ulong left, ulong right);
+        static ulong IMultiplyOperators<ulong, ulong, ulong>.operator *(ulong left, ulong right);
+        static ulong INumber<ulong>.Abs(ulong value);
+        static ulong INumber<ulong>.CopySign(ulong value, ulong sign);
+        static bool INumber<ulong>.IsNegative(ulong value);
+        static ulong INumber<ulong>.MaxMagnitude(ulong x, ulong y);
+        static ulong INumber<ulong>.MinMagnitude(ulong x, ulong y);
+        static ulong IShiftOperators<ulong, ulong>.operator <<(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, ulong>.operator >>(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, ulong>.operator >>>(ulong value, int shiftAmount);
+        static ulong ISubtractionOperators<ulong, ulong, ulong>.operator checked -(ulong left, ulong right);
+        static ulong ISubtractionOperators<ulong, ulong, ulong>.operator -(ulong left, ulong right);
+        static ulong IUnaryNegationOperators<ulong, ulong>.operator checked -(ulong value);
+        static ulong IUnaryNegationOperators<ulong, ulong>.operator -(ulong value);
+        static ulong IUnaryPlusOperators<ulong, ulong>.operator +(ulong value);
     }
-    public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, IParseable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, UIntPtr>, ISpanFormattable, ISpanParseable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+    public readonly struct UIntPtr : IAdditionOperators<nuint, nuint, nuint>, IAdditiveIdentity<nuint, nuint>, IBinaryInteger<nuint>, IBinaryNumber<nuint>, IBitwiseOperators<nuint, nuint, nuint>, IComparable, IComparable<nuint>, IComparisonOperators<nuint, nuint>, IDecrementOperators<nuint>, IDivisionOperators<nuint, nuint, nuint>, IEqualityOperators<nuint, nuint>, IEquatable<nuint>, IFormattable, IIncrementOperators<nuint>, IMinMaxValue<nuint>, IModulusOperators<nuint, nuint, nuint>, IMultiplicativeIdentity<nuint, nuint>, IMultiplyOperators<nuint, nuint, nuint>, INumber<nuint>, INumberBase<nuint>, IParsable<nuint>, ISerializable, IShiftOperators<nuint, nuint>, ISpanFormattable, ISpanParsable<nuint>, ISubtractionOperators<nuint, nuint, nuint>, IUnaryNegationOperators<nuint, nuint>, IUnaryPlusOperators<nuint, nuint>, IUnsignedNumber<nuint> {
-        static UIntPtr System.IAdditiveIdentity<nuint,nuint>.AdditiveIdentity { get; }

-        static UIntPtr System.IMinMaxValue<nuint>.MaxValue { get; }

-        static UIntPtr System.IMinMaxValue<nuint>.MinValue { get; }

-        static UIntPtr System.IMultiplicativeIdentity<nuint,nuint>.MultiplicativeIdentity { get; }

-        static UIntPtr System.INumber<nuint>.One { get; }

-        static UIntPtr System.INumber<nuint>.Zero { get; }

+        static UIntPtr System.Numerics.IAdditiveIdentity<nuint,nuint>.AdditiveIdentity { get; }
+        static UIntPtr System.Numerics.IMinMaxValue<nuint>.MaxValue { get; }
+        static UIntPtr System.Numerics.IMinMaxValue<nuint>.MinValue { get; }
+        static UIntPtr System.Numerics.IMultiplicativeIdentity<nuint,nuint>.MultiplicativeIdentity { get; }
+        static UIntPtr System.Numerics.INumberBase<nuint>.One { get; }
+        static UIntPtr System.Numerics.INumberBase<nuint>.Zero { get; }
-        static UIntPtr IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>.operator +(UIntPtr left, UIntPtr right);

-        static UIntPtr IBinaryInteger<UIntPtr>.LeadingZeroCount(UIntPtr value);

-        static UIntPtr IBinaryInteger<UIntPtr>.PopCount(UIntPtr value);

-        static UIntPtr IBinaryInteger<UIntPtr>.RotateLeft(UIntPtr value, int rotateAmount);

-        static UIntPtr IBinaryInteger<UIntPtr>.RotateRight(UIntPtr value, int rotateAmount);

-        static UIntPtr IBinaryInteger<UIntPtr>.TrailingZeroCount(UIntPtr value);

-        static bool IBinaryNumber<UIntPtr>.IsPow2(UIntPtr value);

-        static UIntPtr IBinaryNumber<UIntPtr>.Log2(UIntPtr value);

-        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator &(UIntPtr left, UIntPtr right);

-        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator |(UIntPtr left, UIntPtr right);

-        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ^(UIntPtr left, UIntPtr right);

-        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ~(UIntPtr value);

-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >(UIntPtr left, UIntPtr right);

-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >=(UIntPtr left, UIntPtr right);

-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <(UIntPtr left, UIntPtr right);

-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <=(UIntPtr left, UIntPtr right);

-        static UIntPtr IDecrementOperators<UIntPtr>.operator --(UIntPtr value);

-        static UIntPtr IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>.operator /(UIntPtr left, UIntPtr right);

-        static UIntPtr IIncrementOperators<UIntPtr>.operator ++(UIntPtr value);

-        static UIntPtr IModulusOperators<UIntPtr, UIntPtr, UIntPtr>.operator %(UIntPtr left, UIntPtr right);

-        static UIntPtr IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>.operator *(UIntPtr left, UIntPtr right);

-        static UIntPtr INumber<UIntPtr>.Abs(UIntPtr value);

-        static UIntPtr INumber<UIntPtr>.Clamp(UIntPtr value, UIntPtr min, UIntPtr max);

-        static UIntPtr INumber<UIntPtr>.Create<TOther>(TOther value);

-        static UIntPtr INumber<UIntPtr>.CreateSaturating<TOther>(TOther value);

-        static UIntPtr INumber<UIntPtr>.CreateTruncating<TOther>(TOther value);

-        static (UIntPtr Quotient, UIntPtr Remainder) INumber<UIntPtr>.DivRem(UIntPtr left, UIntPtr right);

-        static UIntPtr INumber<UIntPtr>.Max(UIntPtr x, UIntPtr y);

-        static UIntPtr INumber<UIntPtr>.Min(UIntPtr x, UIntPtr y);

-        static UIntPtr INumber<UIntPtr>.Sign(UIntPtr value);

-        static bool INumber<UIntPtr>.TryCreate<TOther>(TOther value, out UIntPtr result);

-        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator <<(UIntPtr value, int shiftAmount);

-        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator >>(UIntPtr value, int shiftAmount);

-        static UIntPtr ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>.operator -(UIntPtr left, UIntPtr right);

-        static UIntPtr IUnaryNegationOperators<UIntPtr, UIntPtr>.operator -(UIntPtr value);

-        static UIntPtr IUnaryPlusOperators<UIntPtr, UIntPtr>.operator +(UIntPtr value);

+        static UIntPtr IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>.operator +(UIntPtr left, UIntPtr right);
+        static UIntPtr IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked +(UIntPtr left, UIntPtr right);
+        static (UIntPtr Quotient, UIntPtr Remainder) IBinaryInteger<UIntPtr>.DivRem(UIntPtr left, UIntPtr right);
+        int IBinaryInteger<UIntPtr>.GetByteCount();
+        long IBinaryInteger<UIntPtr>.GetShortestBitLength();
+        static UIntPtr IBinaryInteger<UIntPtr>.LeadingZeroCount(UIntPtr value);
+        static UIntPtr IBinaryInteger<UIntPtr>.PopCount(UIntPtr value);
+        static UIntPtr IBinaryInteger<UIntPtr>.RotateLeft(UIntPtr value, int rotateAmount);
+        static UIntPtr IBinaryInteger<UIntPtr>.RotateRight(UIntPtr value, int rotateAmount);
+        static UIntPtr IBinaryInteger<UIntPtr>.TrailingZeroCount(UIntPtr value);
+        bool IBinaryInteger<UIntPtr>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static bool IBinaryNumber<UIntPtr>.IsPow2(UIntPtr value);
+        static UIntPtr IBinaryNumber<UIntPtr>.Log2(UIntPtr value);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator &(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator |(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ^(UIntPtr left, UIntPtr right);
+        static UIntPtr IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>.operator ~(UIntPtr value);
+        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >=(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <=(UIntPtr left, UIntPtr right);
+        static UIntPtr IDecrementOperators<UIntPtr>.operator checked --(UIntPtr value);
+        static UIntPtr IDecrementOperators<UIntPtr>.operator --(UIntPtr value);
+        static UIntPtr IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked /(UIntPtr left, UIntPtr right);
+        static UIntPtr IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>.operator /(UIntPtr left, UIntPtr right);
+        static UIntPtr IIncrementOperators<UIntPtr>.operator checked ++(UIntPtr value);
+        static UIntPtr IIncrementOperators<UIntPtr>.operator ++(UIntPtr value);
+        static UIntPtr IModulusOperators<UIntPtr, UIntPtr, UIntPtr>.operator %(UIntPtr left, UIntPtr right);
+        static UIntPtr IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked *(UIntPtr left, UIntPtr right);
+        static UIntPtr IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>.operator *(UIntPtr left, UIntPtr right);
+        static UIntPtr INumber<UIntPtr>.Abs(UIntPtr value);
+        static UIntPtr INumber<UIntPtr>.Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        static UIntPtr INumber<UIntPtr>.CopySign(UIntPtr value, UIntPtr sign);
+        static UIntPtr INumber<UIntPtr>.CreateChecked<TOther>(TOther value);
+        static UIntPtr INumber<UIntPtr>.CreateSaturating<TOther>(TOther value);
+        static UIntPtr INumber<UIntPtr>.CreateTruncating<TOther>(TOther value);
+        static bool INumber<UIntPtr>.IsNegative(UIntPtr value);
+        static UIntPtr INumber<UIntPtr>.Max(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.MaxMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.Min(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.MinMagnitude(UIntPtr x, UIntPtr y);
+        static int INumber<UIntPtr>.Sign(UIntPtr value);
+        static bool INumber<UIntPtr>.TryCreate<TOther>(TOther value, out UIntPtr result);
+        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator <<(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator >>(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator >>>(UIntPtr value, int shiftAmount);
+        static UIntPtr ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked -(UIntPtr left, UIntPtr right);
+        static UIntPtr ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>.operator -(UIntPtr left, UIntPtr right);
+        static UIntPtr IUnaryNegationOperators<UIntPtr, UIntPtr>.operator checked -(UIntPtr value);
+        static UIntPtr IUnaryNegationOperators<UIntPtr, UIntPtr>.operator -(UIntPtr value);
+        static UIntPtr IUnaryPlusOperators<UIntPtr, UIntPtr>.operator +(UIntPtr value);
     }
 }
```

