# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public sealed class AsParametersAttribute : Attribute {
+        public AsParametersAttribute();
+    }
+    public sealed class DefaultRouteHandlerInvocationContext : RouteHandlerInvocationContext {
+        public DefaultRouteHandlerInvocationContext(HttpContext httpContext, params object[] arguments);
+        public override IList<object?> Arguments { get; }
+        public override HttpContext HttpContext { get; }
+        public override T GetArgument<T>(int index);
+    }
     public static class Results {
-        public static IResult Content(string content, MediaTypeHeaderValue contentType);
+        public static IResult Content(string? content, MediaTypeHeaderValue contentType);
-        public static IResult Content(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static IResult Content(string? content, string? contentType, Encoding? contentEncoding);
+        public static IResult Content(string? content, string? contentType = null, Encoding? contentEncoding = null, int? statusCode = default(int?));
-        public static IResult Text(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static IResult Text(string? content, string? contentType, Encoding? contentEncoding);
+        public static IResult Text(string? content, string? contentType = null, Encoding? contentEncoding = null, int? statusCode = default(int?));
     }
-    public sealed class RouteHandlerInvocationContext {
+    public abstract class RouteHandlerInvocationContext {
+        protected RouteHandlerInvocationContext();
-        public RouteHandlerInvocationContext(HttpContext httpContext, params object[] parameters);
+        public abstract IList<object?> Arguments { get; }
-        public HttpContext HttpContext { get; }
+        public abstract HttpContext HttpContext { get; }
-        public IList<object?> Parameters { get; }
+        public abstract T GetArgument<T>(int index);
     }
     public static class TypedResults {
-        public static Accepted<TValue> Accepted<TValue>(string? uri, TValue? value);
+        public static Accepted<TValue> Accepted<TValue>(string uri, TValue value);
-        public static AcceptedAtRoute AcceptedAtRoute(string? routeName = null, object? routeValues = null);
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
-        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue? value, string? routeName = null, object? routeValues = null);
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
-        public static BadRequest<TValue> BadRequest<TValue>(TValue? error);
+        public static BadRequest<TValue> BadRequest<TValue>(TValue error);
-        public static FileContentHttpResult Bytes(byte[] contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileContentHttpResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static FileContentHttpResult Bytes(ReadOnlyMemory<byte> contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileContentHttpResult Bytes(ReadOnlyMemory<byte> contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static Conflict<TValue> Conflict<TValue>(TValue? error);
+        public static Conflict<TValue> Conflict<TValue>(TValue error);
-        public static ContentHttpResult Content(string content, MediaTypeHeaderValue contentType);
+        public static ContentHttpResult Content(string? content, MediaTypeHeaderValue contentType);
-        public static ContentHttpResult Content(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static ContentHttpResult Content(string content, string contentType, Encoding contentEncoding);
+        public static ContentHttpResult Content(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
-        public static CreatedAtRoute CreatedAtRoute(string? routeName = null, object? routeValues = null);
+        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
-        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue? value, string? routeName = null, object? routeValues = null);
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
-        public static FileContentHttpResult File(byte[] fileContents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static FileContentHttpResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static FileStreamHttpResult File(Stream fileStream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static FileStreamHttpResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static JsonHttpResult<TValue> Json<TValue>(TValue? data, JsonSerializerOptions? options = null, string? contentType = null, int? statusCode = default(int?));
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
-        public static NotFound<TValue> NotFound<TValue>(TValue? value);
+        public static NotFound<TValue> NotFound<TValue>(TValue value);
-        public static Ok<TValue> Ok<TValue>(TValue? value);
+        public static Ok<TValue> Ok<TValue>(TValue value);
-        public static PhysicalFileHttpResult PhysicalFile(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static PhysicalFileHttpResult PhysicalFile(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static ProblemHttpResult Problem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static ProblemHttpResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
-        public static RedirectToRouteHttpResult RedirectToRoute(string? routeName = null, object? routeValues = null, bool permanent = false, bool preserveMethod = false, string? fragment = null);
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
-        public static PushStreamHttpResult Stream(Func<Stream, Task> streamWriterCallback, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static PushStreamHttpResult Stream(Func<Stream, Task> streamWriterCallback, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static FileStreamHttpResult Stream(PipeReader pipeReader, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static FileStreamHttpResult Stream(PipeReader pipeReader, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static FileStreamHttpResult Stream(Stream stream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static FileStreamHttpResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static ContentHttpResult Text(string content, string? contentType = null, Encoding? contentEncoding = null);
+        public static ContentHttpResult Text(string content, string contentType, Encoding contentEncoding);
+        public static ContentHttpResult Text(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
-        public static UnprocessableEntity<TValue> UnprocessableEntity<TValue>(TValue? error);
+        public static UnprocessableEntity<TValue> UnprocessableEntity<TValue>(TValue error);
-        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string? detail = null, string? instance = null, string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static ValidationProblem ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, string title = null, string type = null, IDictionary<string, object?>? extensions = null);
-        public static VirtualFileHttpResult VirtualFile(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static VirtualFileHttpResult VirtualFile(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
     }
 }
```

