# System.IO

``` diff
 namespace System.IO {
     public static class File {
+        public static IAsyncEnumerable<string> ReadLinesAsync(string path, Encoding encoding, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<string> ReadLinesAsync(string path, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class FileStream : Stream {
         public virtual void Lock(long position, long length);
         public virtual void Unlock(long position, long length);
     }
     public abstract class Stream : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        public int ReadAtLeast(Span<byte> buffer, int minimumBytes, bool throwOnEndOfStream = true);
+        public ValueTask<int> ReadAtLeastAsync(Memory<byte> buffer, int minimumBytes, bool throwOnEndOfStream = true, CancellationToken cancellationToken = default(CancellationToken));
+        public void ReadExactly(byte[] buffer, int offset, int count);
+        public void ReadExactly(Span<byte> buffer);
+        public ValueTask ReadExactlyAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask ReadExactlyAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

