# System.Runtime.InteropServices.Marshalling

``` diff
+namespace System.Runtime.InteropServices.Marshalling {
+    public ref struct AnsiStringMarshaller {
+        public AnsiStringMarshaller(string? str);
+        public AnsiStringMarshaller(string? str, Span<byte> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public string? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public ref struct ArrayMarshaller<T> {
+        public ArrayMarshaller(int sizeOfNativeElement);
+        public ArrayMarshaller(T[]? array, int sizeOfNativeElement);
+        public ArrayMarshaller(T[]? array, Span<byte> buffer, int sizeOfNativeElement);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public Span<T> GetManagedValuesDestination(int length);
+        public ReadOnlySpan<T> GetManagedValuesSource();
+        public Span<byte> GetNativeValuesDestination();
+        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
+        public ref byte GetPinnableReference();
+        public T[]? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public ref struct BStrStringMarshaller {
+        public BStrStringMarshaller(string? str);
+        public BStrStringMarshaller(string? str, Span<ushort> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(void* value);
+        public string? ToManaged();
+        public unsafe void* ToNativeValue();
+    }
+    public sealed class CustomTypeMarshallerAttribute : Attribute {
+        public CustomTypeMarshallerAttribute(Type managedType, CustomTypeMarshallerKind marshallerKind = CustomTypeMarshallerKind.Value);
+        public int BufferSize { get; set; }
+        public CustomTypeMarshallerDirection Direction { get; set; }
+        public CustomTypeMarshallerFeatures Features { get; set; }
+        public Type ManagedType { get; }
+        public CustomTypeMarshallerKind MarshallerKind { get; }
+        public struct GenericPlaceholder
+    }
+    public enum CustomTypeMarshallerDirection {
+        In = 1,
+        None = 0,
+        Out = 2,
+        Ref = 3,
+    }
+    public enum CustomTypeMarshallerFeatures {
+        CallerAllocatedBuffer = 2,
+        None = 0,
+        TwoStageMarshalling = 4,
+        UnmanagedResources = 1,
+    }
+    public enum CustomTypeMarshallerKind {
+        LinearCollection = 1,
+        Value = 0,
+    }
+    public sealed class MarshalUsingAttribute : Attribute {
+        public const string ReturnsCountValue = "return-value";
+        public MarshalUsingAttribute();
+        public MarshalUsingAttribute(Type nativeType);
+        public int ConstantElementCount { get; set; }
+        public string CountElementName { get; set; }
+        public int ElementIndirectionDepth { get; set; }
+        public Type? NativeType { get; }
+    }
+    public sealed class NativeMarshallingAttribute : Attribute {
+        public NativeMarshallingAttribute(Type nativeType);
+        public Type NativeType { get; }
+    }
+    public ref struct PointerArrayMarshaller<T> where T : struct {
+        public PointerArrayMarshaller(int sizeOfNativeElement);
+        public PointerArrayMarshaller(T*[]? array, int sizeOfNativeElement);
+        public PointerArrayMarshaller(T*[]? array, Span<byte> buffer, int sizeOfNativeElement);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public Span<IntPtr> GetManagedValuesDestination(int length);
+        public ReadOnlySpan<IntPtr> GetManagedValuesSource();
+        public Span<byte> GetNativeValuesDestination();
+        public ReadOnlySpan<byte> GetNativeValuesSource(int length);
+        public ref byte GetPinnableReference();
+        public T*[]? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+    public ref struct Utf16StringMarshaller {
+        public Utf16StringMarshaller(string? str);
+        public void FreeNative();
+        public unsafe void FromNativeValue(void* value);
+        public string? ToManaged();
+        public unsafe void* ToNativeValue();
+    }
+    public ref struct Utf8StringMarshaller {
+        public Utf8StringMarshaller(string? str);
+        public Utf8StringMarshaller(string? str, Span<byte> buffer);
+        public void FreeNative();
+        public unsafe void FromNativeValue(byte* value);
+        public string? ToManaged();
+        public unsafe byte* ToNativeValue();
+    }
+}
```

