# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
     public class JsonDerivedTypeAttribute : JsonAttribute {
+        public JsonDerivedTypeAttribute(Type derivedType, int typeDiscriminator);
-        public JsonDerivedTypeAttribute(Type derivedType, string typeDiscriminatorId);
+        public JsonDerivedTypeAttribute(Type derivedType, string typeDiscriminator);
+        public object? TypeDiscriminator { get; }
-        public string? TypeDiscriminatorId { get; }
     }
     public sealed class JsonPolymorphicAttribute : JsonAttribute {
-        public string CustomTypeDiscriminatorPropertyName { get; set; }
+        public string TypeDiscriminatorPropertyName { get; set; }
     }
-    public class JsonPolymorphicTypeConfiguration : ICollection<(Type, string?)>, IEnumerable, IEnumerable<(Type, string?)> {
+    public class JsonPolymorphicTypeConfiguration : ICollection<(Type, object?)>, IEnumerable, IEnumerable<(Type, object?)> {
-        public string? CustomTypeDiscriminatorPropertyName { get; set; }
+        int ICollection<(Type, object?)>.Count { get; }
+        bool ICollection<(Type, object?)>.IsReadOnly { get; }
-        int ICollection<(Type, string?)>.Count { get; }
-        bool ICollection<(Type, string?)>.IsReadOnly { get; }
+        public string? TypeDiscriminatorPropertyName { get; set; }
+        void ICollection<(Type, object?)>.Add((Type DerivedType, object TypeDiscriminator) item);
+        void ICollection<(Type, object?)>.Clear();
+        bool ICollection<(Type, object?)>.Contains((Type DerivedType, object TypeDiscriminator) item);
+        void ICollection<(Type, object?)>.CopyTo((Type DerivedType, object TypeDiscriminator)[] array, int arrayIndex);
+        bool ICollection<(Type, object?)>.Remove((Type DerivedType, object TypeDiscriminator) item);
-        void ICollection<(Type, string?)>.Add((Type DerivedType, string TypeDiscriminatorId) item);
-        void ICollection<(Type, string?)>.Clear();
-        bool ICollection<(Type, string?)>.Contains((Type DerivedType, string TypeDiscriminatorId) item);
-        void ICollection<(Type, string?)>.CopyTo((Type DerivedType, string TypeDiscriminatorId)[] array, int arrayIndex);
-        bool ICollection<(Type, string?)>.Remove((Type DerivedType, string TypeDiscriminatorId) item);
+        IEnumerator<(Type DerivedType, object TypeDiscriminator)> IEnumerable<(Type, object?)>.GetEnumerator();
-        IEnumerator<(Type DerivedType, string TypeDiscriminatorId)> IEnumerable<(Type, string?)>.GetEnumerator();
+        public JsonPolymorphicTypeConfiguration WithDerivedType(Type derivedType);
+        public JsonPolymorphicTypeConfiguration WithDerivedType(Type derivedType, int typeDiscriminator);
-        public JsonPolymorphicTypeConfiguration WithDerivedType(Type derivedType, string? typeDiscriminatorId = null);
+        public JsonPolymorphicTypeConfiguration WithDerivedType(Type derivedType, string typeDiscriminator);
     }
     public class JsonPolymorphicTypeConfiguration<TBaseType> : JsonPolymorphicTypeConfiguration where TBaseType : class {
+        public JsonPolymorphicTypeConfiguration<TBaseType> WithDerivedType<TDerivedType>() where TDerivedType : TBaseType;
+        public JsonPolymorphicTypeConfiguration<TBaseType> WithDerivedType<TDerivedType>(int typeDiscriminator) where TDerivedType : TBaseType;
-        public JsonPolymorphicTypeConfiguration<TBaseType> WithDerivedType<TDerivedType>(string? typeDiscriminatorId = null) where TDerivedType : TBaseType;
+        public JsonPolymorphicTypeConfiguration<TBaseType> WithDerivedType<TDerivedType>(string typeDiscriminator) where TDerivedType : TBaseType;
     }
     public class JsonStringEnumConverter : JsonConverterFactory
     public enum JsonUnknownDerivedTypeHandling {
-        FallbackToBaseType = 1,
+        FallBackToBaseType = 1,
-        FallbackToNearestAncestor = 2,
+        FallBackToNearestAncestor = 2,
     }
 }
```

