# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public class CookieBuilder {
+        public IList<string> Extensions { get; }
     }
     public class CookieOptions {
+        public CookieOptions(CookieOptions options);
+        public IList<string> Extensions { get; }
+        public SetCookieHeaderValue CreateCookieHeader(string name, string value);
     }
     public static class HttpResponseJsonExtensions {
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonTypeInfo<TValue> jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public interface IBindableFromHttpContext<TSelf> where TSelf : class, IBindableFromHttpContext<TSelf> {
+        static abstract ValueTask<TSelf?> BindAsync(HttpContext context, ParameterInfo parameter);
+    }
     public interface IRequestCookieCollection : IEnumerable, IEnumerable<KeyValuePair<string, string>> {
-        bool TryGetValue(string key, [MaybeNullWhenAttribute(false)] out string? value);
+        bool TryGetValue(string key, [NotNullWhenAttribute(true)] out string? value);
     }
     public static class OpenApiRouteHandlerBuilderExtensions {
+        public static TBuilder ExcludeFromDescription<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
-        public static RouteHandlerBuilder WithDescription(this RouteHandlerBuilder builder, string description);
+        public static TBuilder WithDescription<TBuilder>(this TBuilder builder, string description) where TBuilder : IEndpointConventionBuilder;
-        public static RouteHandlerBuilder WithSummary(this RouteHandlerBuilder builder, string summary);
+        public static TBuilder WithSummary<TBuilder>(this TBuilder builder, string summary) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithTags<TBuilder>(this TBuilder builder, params string[] tags) where TBuilder : IEndpointConventionBuilder;
     }
     public sealed class RequestDelegateFactoryOptions {
+        public IList<object>? EndpointMetadata { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
-        public IEnumerable<object>? InitialEndpointMetadata { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
     }
     public static class Results {
-        public static IResult Accepted(string? uri = null, object? value = null);
+        public static IResult Accepted(string uri = null, object value = null);
+        public static IResult Accepted<TValue>(string uri = null, TValue value = null);
-        public static IResult AcceptedAtRoute(string? routeName = null, object? routeValues = null, object? value = null);
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        public static IResult BadRequest<TValue>(TValue error);
-        public static IResult Bytes(byte[] contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static IResult Bytes(ReadOnlyMemory<byte> contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Bytes(ReadOnlyMemory<byte> contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Conflict<TValue>(TValue error);
-        public static IResult Content(string? content, string? contentType, Encoding? contentEncoding);
+        public static IResult Content(string content, string contentType, Encoding contentEncoding);
-        public static IResult Content(string? content, string? contentType = null, Encoding? contentEncoding = null, int? statusCode = default(int?));
+        public static IResult Content(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static IResult Created<TValue>(string uri, TValue? value);
+        public static IResult Created<TValue>(Uri uri, TValue? value);
-        public static IResult CreatedAtRoute(string? routeName = null, object? routeValues = null, object? value = null);
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
-        public static IResult File(byte[] fileContents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static IResult File(Stream fileStream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult File(string path, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult Json(object? data, JsonSerializerOptions? options = null, string? contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult NotFound<TValue>(TValue value);
+        public static IResult Ok<TValue>(TValue value);
-        public static IResult Problem(string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
-        public static IResult RedirectToRoute(string? routeName = null, object? routeValues = null, bool permanent = false, bool preserveMethod = false, string? fragment = null);
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
-        public static IResult Stream(Func<Stream, Task> streamWriterCallback, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Stream(Func<Stream, Task> streamWriterCallback, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
-        public static IResult Stream(PipeReader pipeReader, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Stream(PipeReader pipeReader, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult Stream(Stream stream, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
-        public static IResult Text(string? content, string? contentType, Encoding? contentEncoding);
+        public static IResult Text(string content, string contentType, Encoding contentEncoding);
-        public static IResult Text(string? content, string? contentType = null, Encoding? contentEncoding = null, int? statusCode = default(int?));
+        public static IResult Text(string content, string contentType = null, Encoding contentEncoding = null, int? statusCode = default(int?));
+        public static IResult UnprocessableEntity<TValue>(TValue error);
-        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string? detail = null, string? instance = null, int? statusCode = default(int?), string? title = null, string? type = null, IDictionary<string, object?>? extensions = null);
+        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object?>? extensions = null);
     }
     public sealed class RouteHandlerContext {
-        public RouteHandlerContext(MethodInfo methodInfo, EndpointMetadataCollection endpointMetadata);
+        public RouteHandlerContext(MethodInfo methodInfo, IList<object> endpointMetadata, IServiceProvider applicationServices);
+        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; }
-        public EndpointMetadataCollection EndpointMetadata { [CompilerGeneratedAttribute] get; }
+        public IList<object> EndpointMetadata { [CompilerGeneratedAttribute] get; }
     }
     public static class RouteHandlerFilterExtensions {
-        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, IRouteHandlerFilter filter);
-        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate> filterFactory);
-        public static RouteHandlerBuilder AddFilter(this RouteHandlerBuilder builder, Func<RouteHandlerInvocationContext, RouteHandlerFilterDelegate, ValueTask<object?>> routeHandlerFilter);
-        public static RouteHandlerBuilder AddFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IRouteHandlerFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddRouteHandlerFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IRouteHandlerFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, IRouteHandlerFilter filter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, Func<RouteHandlerContext, RouteHandlerFilterDelegate, RouteHandlerFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static TBuilder AddRouteHandlerFilter<TBuilder>(this TBuilder builder, Func<RouteHandlerInvocationContext, RouteHandlerFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteHandlerBuilder AddRouteHandlerFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IRouteHandlerFilter;
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
+        public static RouteGroupBuilder AddRouteHandlerFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IRouteHandlerFilter;
     }
 }
```

