# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
+    public static class OutputCacheConventionBuilderExtensions {
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, IOutputCachePolicy policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, Action<OutputCachePolicyBuilder> policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder CacheOutput<TBuilder>(this TBuilder builder, string policyName) where TBuilder : IEndpointConventionBuilder;
+    }
+    public static class OutputCacheServiceCollectionExtensions {
+        public static IServiceCollection AddOutputCache(this IServiceCollection services);
+        public static IServiceCollection AddOutputCache(this IServiceCollection services, Action<OutputCacheOptions> configureOptions);
+    }
     public static class PageConventionCollectionExtensions {
-        public static PageConventionCollection AddAreaPageRoute(this PageConventionCollection conventions, string areaName, string pageName, string route);
+        public static PageConventionCollection AddAreaPageRoute(this PageConventionCollection conventions, string areaName, string pageName, [StringSyntaxAttribute("Route")] string route);
-        public static PageConventionCollection AddPageRoute(this PageConventionCollection conventions, string pageName, string route);
+        public static PageConventionCollection AddPageRoute(this PageConventionCollection conventions, string pageName, [StringSyntaxAttribute("Route")] string route);
     }
+    public static class RequestDecompressionServiceExtensions {
+        public static IServiceCollection AddRequestDecompression(this IServiceCollection services);
+        public static IServiceCollection AddRequestDecompression(this IServiceCollection services, Action<RequestDecompressionOptions> configureOptions);
+    }
 }
```

