# System.Text.Json.Serialization.Metadata

``` diff
 namespace System.Text.Json.Serialization.Metadata {
+    public class DefaultJsonTypeInfoResolver : IJsonTypeInfoResolver {
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public DefaultJsonTypeInfoResolver();
+        public IList<Action<JsonTypeInfo>> Modifiers { get; }
+        public virtual JsonTypeInfo GetTypeInfo(Type type, JsonSerializerOptions options);
+    }
+    public interface IJsonTypeInfoResolver {
+        JsonTypeInfo? GetTypeInfo(Type type, JsonSerializerOptions options);
+    }
     public static class JsonMetadataServices {
+        public static JsonConverter<T?> GetNullableConverter<T>(JsonSerializerOptions options) where T : struct;
     }
     public abstract class JsonPropertyInfo {
+        public JsonConverter? CustomConverter { get; set; }
+        public Func<object, object?>? Get { get; set; }
+        public string Name { get; set; }
+        public JsonNumberHandling? NumberHandling { get; set; }
+        public JsonSerializerOptions Options { get; }
+        public Type PropertyType { get; }
+        public Action<object, object?>? Set { get; set; }
+        public Func<object, object?, bool>? ShouldSerialize { get; set; }
     }
-    public class JsonTypeInfo {
+    public abstract class JsonTypeInfo {
+        public JsonConverter Converter { get; }
+        public Func<object>? CreateObject { get; set; }
+        public JsonTypeInfoKind Kind { get; }
+        public JsonNumberHandling? NumberHandling { get; set; }
+        public JsonSerializerOptions Options { get; }
+        public IList<JsonPropertyInfo> Properties { get; }
+        public Type Type { get; }
+        public JsonPropertyInfo CreateJsonPropertyInfo(Type propertyType, string name);
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo CreateJsonTypeInfo(Type type, JsonSerializerOptions options);
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo<T> CreateJsonTypeInfo<T>(JsonSerializerOptions options);
     }
     public abstract class JsonTypeInfo<T> : JsonTypeInfo {
+        public new Func<T>? CreateObject { get; set; }
     }
+    public enum JsonTypeInfoKind {
+        Dictionary = 3,
+        Enumerable = 2,
+        None = 0,
+        Object = 1,
+    }
+    public static class JsonTypeInfoResolver {
+        public static IJsonTypeInfoResolver Combine(params IJsonTypeInfoResolver[] resolvers);
+    }
 }
```

