# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
     [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public sealed class CompositeEndpointDataSource : EndpointDataSource, IDisposable {
-        public override IReadOnlyList<Endpoint> GetEndpointGroup(RouteGroupContext context);
+        public override IReadOnlyList<Endpoint> GetGroupedEndpoints(RouteGroupContext context);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class EndpointDataSource {
-        public virtual IReadOnlyList<Endpoint> GetEndpointGroup(RouteGroupContext context);
+        public virtual IReadOnlyList<Endpoint> GetGroupedEndpoints(RouteGroupContext context);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public sealed class RouteEndpointBuilder : EndpointBuilder {
-        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="We surface a RequireUnreferencedCode in AddRouteHandlerFilter which is required to call unreferenced code here. The trimmer is unable to infer this.")]
-        public override Endpoint Build();
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="We surface a RequireUnreferencedCode in AddEndpointFilter which is required to call unreferenced code here. The trimmer is unable to infer this.")]
+        public override Endpoint Build();
     }
 }
```

