# System.Formats.Tar

``` diff
 namespace System.Formats.Tar {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class TarEntry {
-        public TarFileMode Mode { get; set; }
+        public UnixFileMode Mode { get; set; }
+        public Task ExtractToFileAsync(string destinationFileName, bool overwrite, CancellationToken cancellationToken = default(CancellationToken));
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class TarFile {
+        public static Task CreateFromDirectoryAsync(string sourceDirectoryName, Stream destination, bool includeBaseDirectory, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task CreateFromDirectoryAsync(string sourceDirectoryName, string destinationFileName, bool includeBaseDirectory, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task ExtractToDirectoryAsync(Stream source, string destinationDirectoryName, bool overwriteFiles, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task ExtractToDirectoryAsync(string sourceFileName, string destinationDirectoryName, bool overwriteFiles, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [FlagsAttribute]
-    public enum TarFileMode {
-        GroupExecute = 8,
-        GroupRead = 32,
-        GroupSpecial = 1024,
-        GroupWrite = 16,
-        None = 0,
-        OtherExecute = 1,
-        OtherRead = 4,
-        OtherWrite = 2,
-        StickyBit = 512,
-        UserExecute = 64,
-        UserRead = 256,
-        UserSpecial = 2048,
-        UserWrite = 128,
-    }
-    public sealed class TarReader : IDisposable {
+    public sealed class TarReader : IAsyncDisposable, IDisposable {
+        public ValueTask DisposeAsync();
+        [return: NullableAttribute(new byte[]{ (byte)0, (byte)2})]
+        public ValueTask<TarEntry?> GetNextEntryAsync(bool copyData = false, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    public sealed class TarWriter : IDisposable {
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public sealed class TarWriter : IAsyncDisposable, IDisposable {
+        public ValueTask DisposeAsync();
+        public Task WriteEntryAsync(TarEntry entry, CancellationToken cancellationToken = default(CancellationToken));
+        public Task WriteEntryAsync(string fileName, [NullableAttribute((byte)2)] string? entryName, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

