# System.Linq

``` diff
 namespace System.Linq {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class Enumerable {
+        public static IOrderedEnumerable<T> Order<T>(this IEnumerable<T> source);
+        public static IOrderedEnumerable<T> Order<T>(this IEnumerable<T> source, [NullableAttribute(new byte[]{ (byte)2, (byte)1})] IComparer<T>? comparer);
+        public static IOrderedEnumerable<T> OrderDescending<T>(this IEnumerable<T> source);
+        public static IOrderedEnumerable<T> OrderDescending<T>(this IEnumerable<T> source, [NullableAttribute(new byte[]{ (byte)2, (byte)1})] IComparer<T>? comparer);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class Queryable {
+        public static IOrderedQueryable<T> Order<T>(this IQueryable<T> source);
+        public static IOrderedQueryable<T> Order<T>(this IQueryable<T> source, IComparer<T> comparer);
+        public static IOrderedQueryable<T> OrderDescending<T>(this IQueryable<T> source);
+        public static IOrderedQueryable<T> OrderDescending<T>(this IQueryable<T> source, IComparer<T> comparer);
     }
 }
```

