# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class Marshal {
-        public static IntPtr GetHINSTANCE(Module m);
+        [RequiresAssemblyFilesAttribute("Windows only assigns HINSTANCE to assemblies loaded from disk. This API will return -1 for modules without a file on disk.")]
+        public static IntPtr GetHINSTANCE(Module m);
+        public static string GetLastPInvokeErrorMessage();
+        public static string GetPInvokeErrorMessage(int error);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+        static NFloat System.Numerics.IBinaryNumber<System.Runtime.InteropServices.NFloat>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static NFloat CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static NFloat CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static NFloat CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
-        public static NFloat Root(NFloat x, int n);
+        public static NFloat RootN(NFloat x, int n);
+        public static (NFloat SinPi, NFloat CosPi) SinCosPi(NFloat x);
     }
 }
```

