# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class Aes : SymmetricAlgorithm {
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static new Aes Create();
+        public static new Aes Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new Aes? Create(string algorithmName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new Aes? Create(string algorithmName);
     }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public sealed class AesCryptoServiceProvider : Aes {
-        [UnsupportedOSPlatformAttribute("browser")]
-        public AesCryptoServiceProvider();
+        public AesCryptoServiceProvider();
     }
-    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public sealed class AesManaged : Aes
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public sealed class AesManaged : Aes
     public abstract class AsymmetricAlgorithm : IDisposable {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static AsymmetricAlgorithm? Create(string algName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static AsymmetricAlgorithm? Create(string algName);
     }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class DES : SymmetricAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new DES? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new DES? Create(string algName);
     }
     public abstract class DSA : AsymmetricAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new DSA? Create(string algName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new DSA? Create(string algName);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class ECDiffieHellman : ECAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new ECDiffieHellman? Create(string algorithm);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new ECDiffieHellman? Create(string algorithm);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class ECDsa : ECAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new ECDsa? Create(string algorithm);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new ECDsa? Create(string algorithm);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static HashAlgorithm? Create(string hashName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static HashAlgorithm? Create(string hashName);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
-    public static class HKDF
+    public static class HKDF
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class HMAC : KeyedHashAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new HMAC? Create(string algorithmName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new HMAC? Create(string algorithmName);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class KeyedHashAlgorithm : HashAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new KeyedHashAlgorithm? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new KeyedHashAlgorithm? Create(string algName);
     }
     [UnsupportedOSPlatformAttribute("browser")]
     public abstract class MD5 : HashAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new MD5? Create(string algName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new MD5? Create(string algName);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class RandomNumberGenerator : IDisposable {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static RandomNumberGenerator? Create(string rngName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static RandomNumberGenerator? Create(string rngName);
     }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class RC2 : SymmetricAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new RC2? Create(string AlgName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new RC2? Create(string AlgName);
     }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public class Rfc2898DeriveBytes : DeriveBytes
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public class Rfc2898DeriveBytes : DeriveBytes
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public abstract class Rijndael : SymmetricAlgorithm {
-        [UnsupportedOSPlatformAttribute("browser")]
-        public static new Rijndael Create();
+        public static new Rijndael Create();
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new Rijndael? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new Rijndael? Create(string algName);
     }
-    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-    [UnsupportedOSPlatformAttribute("browser")]
-    public sealed class RijndaelManaged : Rijndael
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public sealed class RijndaelManaged : Rijndael
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class RSA : AsymmetricAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new RSA? Create(string algName);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new RSA? Create(string algName);
     }
     public abstract class SHA1 : HashAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new SHA1? Create(string hashName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new SHA1? Create(string hashName);
     }
     public abstract class SHA256 : HashAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new SHA256? Create(string hashName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new SHA256? Create(string hashName);
     }
     public abstract class SHA384 : HashAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new SHA384? Create(string hashName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new SHA384? Create(string hashName);
     }
     public abstract class SHA512 : HashAlgorithm {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new SHA512? Create(string hashName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new SHA512? Create(string hashName);
     }
     public abstract class SymmetricAlgorithm : IDisposable {
-        [NullableContextAttribute((byte)1)]
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static SymmetricAlgorithm? Create(string algName);
+        [NullableContextAttribute((byte)1)]
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static SymmetricAlgorithm? Create(string algName);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class TripleDES : SymmetricAlgorithm {
-        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
-        [return: NullableAttribute((byte)2)]
-        public static new TripleDES? Create(string str);
+        [ObsoleteAttribute("Cryptographic factory methods accepting an algorithm name are obsolete. Use the parameterless Create factory method on the algorithm type instead.", DiagnosticId="SYSLIB0045", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        [RequiresUnreferencedCodeAttribute("The default algorithm implementations might be removed, use strong type references like 'RSA.Create()' instead.")]
+        [return: NullableAttribute((byte)2)]
+        public static new TripleDES? Create(string str);
     }
 }
```

