# Microsoft.Extensions.Configuration

``` diff
 namespace Microsoft.Extensions.Configuration {
     public static class ConfigurationBinder {
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, object? instance);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, object? instance);
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, object? instance, Action<BinderOptions>? configureOptions);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, object? instance, Action<BinderOptions>? configureOptions);
-        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
-        public static void Bind(this IConfiguration configuration, string key, object? instance);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("Cannot statically analyze the type of instance so its members may be trimmed")]
+        public static void Bind(this IConfiguration configuration, string key, object? instance);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object? Get(this IConfiguration configuration, Type type);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? Get(this IConfiguration configuration, Type type);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static object? Get(this IConfiguration configuration, [DynamicallyAccessedMembersAttribute(-1)] Type type, Action<BinderOptions>? configureOptions);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static object? Get(this IConfiguration configuration, [DynamicallyAccessedMembersAttribute(-1)] Type type, Action<BinderOptions>? configureOptions);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T? Get<T>(this IConfiguration configuration);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? Get<T>(this IConfiguration configuration);
-        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
-        public static T? Get<T>(this IConfiguration configuration, Action<BinderOptions>? configureOptions);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values requires generating dynamic code at runtime, for example instantiating generic types.")]
+        [RequiresUnreferencedCodeAttribute("In case the type is non-primitive, the trimmer cannot statically analyze the object's type so its members may be trimmed.")]
+        public static T? Get<T>(this IConfiguration configuration, Action<BinderOptions>? configureOptions);
     }
 }
```

