# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class Aes : SymmetricAlgorithm {
+        [UnsupportedOSPlatformAttribute("browser")]
         public static new Aes Create();
     }
     [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public sealed class AesCryptoServiceProvider : Aes {
+        [UnsupportedOSPlatformAttribute("browser")]
         public AesCryptoServiceProvider();
     }
     [ObsoleteAttribute("Derived cryptographic types are obsolete. Use the Create method on the base type instead.", DiagnosticId="SYSLIB0021", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    [UnsupportedOSPlatformAttribute("browser")]
     public sealed class AesManaged : Aes
     {
     }
     public abstract class ECDsa : ECAlgorithm {
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm);
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, DSASignatureFormat signatureFormat);
+        public byte[] SignHash(ReadOnlySpan<byte> hash);
+        public byte[] SignHash(ReadOnlySpan<byte> hash, DSASignatureFormat signatureFormat);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination, DSASignatureFormat signatureFormat);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
     public class HMACMD5 : HMAC {
+        [UnsupportedOSPlatformAttribute("browser")]
         public HMACMD5();
-        public HMACMD5(byte[] key);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public HMACMD5(byte[] key);
-        public static byte[] HashData(byte[] key, byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] key, byte[] source);
-        public static byte[] HashData(byte[] key, Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] key, Stream source);
-        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
-        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
-        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
-        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
-        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
-        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
-    [UnsupportedOSPlatformAttribute("browser")]
     public abstract class MD5 : HashAlgorithm {
-        public static new MD5 Create();
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static new MD5 Create();
-        public static byte[] HashData(byte[] source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(byte[] source);
-        public static byte[] HashData(Stream source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(Stream source);
-        public static int HashData(Stream source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(Stream source, Span<byte> destination);
-        public static byte[] HashData(ReadOnlySpan<byte> source);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static byte[] HashData(ReadOnlySpan<byte> source);
-        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
-        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
-        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
     }
     [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public abstract class Rijndael : SymmetricAlgorithm {
+        [UnsupportedOSPlatformAttribute("browser")]
         public static new Rijndael Create();
     }
     [ObsoleteAttribute("The Rijndael and RijndaelManaged types are obsolete. Use Aes instead.", DiagnosticId="SYSLIB0022", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    [UnsupportedOSPlatformAttribute("browser")]
     public sealed class RijndaelManaged : Rijndael
     public abstract class RSA : AsymmetricAlgorithm {
+        public byte[] Decrypt(ReadOnlySpan<byte> data, RSAEncryptionPadding padding);
+        public int Decrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding);
+        public byte[] Encrypt(ReadOnlySpan<byte> data, RSAEncryptionPadding padding);
+        public int Encrypt(ReadOnlySpan<byte> data, Span<byte> destination, RSAEncryptionPadding padding);
+        public byte[] SignData(ReadOnlySpan<byte> data, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public int SignData(ReadOnlySpan<byte> data, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public byte[] SignHash(ReadOnlySpan<byte> hash, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public int SignHash(ReadOnlySpan<byte> hash, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
 }
```

